/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import com.google.common.base.Preconditions;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NettyManagedBuffer;

public class TestManagedBuffer
extends ManagedBuffer {
    private final int len;
    private NettyManagedBuffer underlying;

    public TestManagedBuffer(int len) {
        Preconditions.checkArgument((len <= 127 ? 1 : 0) != 0);
        this.len = len;
        byte[] byteArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            byteArray[i] = (byte)i;
        }
        this.underlying = new NettyManagedBuffer(Unpooled.wrappedBuffer((byte[])byteArray));
    }

    public long size() {
        return this.underlying.size();
    }

    public ByteBuffer nioByteBuffer() throws IOException {
        return this.underlying.nioByteBuffer();
    }

    public InputStream createInputStream() throws IOException {
        return this.underlying.createInputStream();
    }

    public ManagedBuffer retain() {
        this.underlying.retain();
        return this;
    }

    public ManagedBuffer release() {
        this.underlying.release();
        return this;
    }

    public Object convertToNetty() throws IOException {
        return this.underlying.convertToNetty();
    }

    public boolean equals(Object other) {
        if (other instanceof ManagedBuffer) {
            try {
                ByteBuffer nioBuf = ((ManagedBuffer)other).nioByteBuffer();
                if (nioBuf.remaining() != this.len) {
                    return false;
                }
                for (int i = 0; i < this.len; ++i) {
                    if (nioBuf.get() == i) continue;
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

