/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.server.NoOpRpcHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransportClientFactorySuite {
    private TransportConf conf;
    private TransportContext context;
    private TransportServer server1;
    private TransportServer server2;

    @Before
    public void setUp() {
        this.conf = new TransportConf((ConfigProvider)new SystemPropertyConfigProvider());
        NoOpRpcHandler rpcHandler = new NoOpRpcHandler();
        this.context = new TransportContext(this.conf, (RpcHandler)rpcHandler);
        this.server1 = this.context.createServer();
        this.server2 = this.context.createServer();
    }

    @After
    public void tearDown() {
        JavaUtils.closeQuietly((Closeable)this.server1);
        JavaUtils.closeQuietly((Closeable)this.server2);
    }

    private void testClientReuse(final int maxConnections, boolean concurrent) throws IOException, InterruptedException {
        int i;
        TransportConf conf = new TransportConf(new ConfigProvider(){

            public String get(String name) {
                if (name.equals("spark.shuffle.io.numConnectionsPerPeer")) {
                    return Integer.toString(maxConnections);
                }
                throw new NoSuchElementException();
            }
        });
        NoOpRpcHandler rpcHandler = new NoOpRpcHandler();
        TransportContext context = new TransportContext(conf, (RpcHandler)rpcHandler);
        final TransportClientFactory factory = context.createClientFactory();
        final Set<TransportClient> clients = Collections.synchronizedSet(new HashSet());
        final AtomicInteger failed = new AtomicInteger();
        Thread[] attempts = new Thread[maxConnections * 10];
        for (i = 0; i < attempts.length; ++i) {
            attempts[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        TransportClient client = factory.createClient(TestUtils.getLocalHost(), TransportClientFactorySuite.this.server1.getPort());
                        assert (client.isActive());
                        clients.add(client);
                    }
                    catch (IOException e) {
                        failed.incrementAndGet();
                    }
                }
            };
            if (concurrent) {
                attempts[i].start();
                continue;
            }
            attempts[i].run();
        }
        for (i = 0; i < attempts.length; ++i) {
            attempts[i].join();
        }
        assert (failed.get() == 0);
        assert (clients.size() == maxConnections);
        for (TransportClient client : clients) {
            client.close();
        }
    }

    @Test
    public void reuseClientsUpToConfigVariable() throws Exception {
        this.testClientReuse(1, false);
        this.testClientReuse(2, false);
        this.testClientReuse(3, false);
        this.testClientReuse(4, false);
    }

    @Test
    public void reuseClientsUpToConfigVariableConcurrent() throws Exception {
        this.testClientReuse(1, true);
        this.testClientReuse(2, true);
        this.testClientReuse(3, true);
        this.testClientReuse(4, true);
    }

    @Test
    public void returnDifferentClientsForDifferentServers() throws IOException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server2.getPort());
        Assert.assertTrue((boolean)c1.isActive());
        Assert.assertTrue((boolean)c2.isActive());
        Assert.assertTrue((c1 != c2 ? 1 : 0) != 0);
        factory.close();
    }

    @Test
    public void neverReturnInactiveClients() throws IOException, InterruptedException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        c1.close();
        long start = System.currentTimeMillis();
        while (c1.isActive() && System.currentTimeMillis() - start < 3000L) {
            Thread.sleep(10L);
        }
        Assert.assertFalse((boolean)c1.isActive());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        Assert.assertFalse((c1 == c2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)c2.isActive());
        factory.close();
    }

    @Test
    public void closeBlockClientsWithFactory() throws IOException {
        TransportClientFactory factory = this.context.createClientFactory();
        TransportClient c1 = factory.createClient(TestUtils.getLocalHost(), this.server1.getPort());
        TransportClient c2 = factory.createClient(TestUtils.getLocalHost(), this.server2.getPort());
        Assert.assertTrue((boolean)c1.isActive());
        Assert.assertTrue((boolean)c2.isActive());
        factory.close();
        Assert.assertFalse((boolean)c1.isActive());
        Assert.assertFalse((boolean)c2.isActive());
    }
}

