/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import io.netty.channel.Channel;
import io.netty.channel.local.LocalChannel;
import org.apache.spark.network.TestManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.ChunkReceivedCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamChunkId;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TransportResponseHandlerSuite {
    @Test
    public void handleSuccessfulFetch() {
        StreamChunkId streamChunkId = new StreamChunkId(1L, 0);
        TransportResponseHandler handler = new TransportResponseHandler((Channel)new LocalChannel());
        ChunkReceivedCallback callback = (ChunkReceivedCallback)Mockito.mock(ChunkReceivedCallback.class);
        handler.addFetchRequest(streamChunkId, callback);
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new ChunkFetchSuccess(streamChunkId, (ManagedBuffer)new TestManagedBuffer(123)));
        ((ChunkReceivedCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((int)0), (ManagedBuffer)Matchers.any());
        Assert.assertEquals((long)0L, (long)handler.numOutstandingRequests());
    }

    @Test
    public void handleFailedFetch() {
        StreamChunkId streamChunkId = new StreamChunkId(1L, 0);
        TransportResponseHandler handler = new TransportResponseHandler((Channel)new LocalChannel());
        ChunkReceivedCallback callback = (ChunkReceivedCallback)Mockito.mock(ChunkReceivedCallback.class);
        handler.addFetchRequest(streamChunkId, callback);
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new ChunkFetchFailure(streamChunkId, "some error msg"));
        ((ChunkReceivedCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure(Matchers.eq((int)0), (Throwable)Matchers.any());
        Assert.assertEquals((long)0L, (long)handler.numOutstandingRequests());
    }

    @Test
    public void clearAllOutstandingRequests() {
        TransportResponseHandler handler = new TransportResponseHandler((Channel)new LocalChannel());
        ChunkReceivedCallback callback = (ChunkReceivedCallback)Mockito.mock(ChunkReceivedCallback.class);
        handler.addFetchRequest(new StreamChunkId(1L, 0), callback);
        handler.addFetchRequest(new StreamChunkId(1L, 1), callback);
        handler.addFetchRequest(new StreamChunkId(1L, 2), callback);
        Assert.assertEquals((long)3L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new ChunkFetchSuccess(new StreamChunkId(1L, 0), (ManagedBuffer)new TestManagedBuffer(12)));
        handler.exceptionCaught((Throwable)new Exception("duh duh duhhhh"));
        ((ChunkReceivedCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess(Matchers.eq((int)0), (ManagedBuffer)Matchers.any());
        ((ChunkReceivedCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure(Matchers.eq((int)1), (Throwable)Matchers.any());
        ((ChunkReceivedCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure(Matchers.eq((int)2), (Throwable)Matchers.any());
        Assert.assertEquals((long)0L, (long)handler.numOutstandingRequests());
    }

    @Test
    public void handleSuccessfulRPC() {
        TransportResponseHandler handler = new TransportResponseHandler((Channel)new LocalChannel());
        RpcResponseCallback callback = (RpcResponseCallback)Mockito.mock(RpcResponseCallback.class);
        handler.addRpcRequest(12345L, callback);
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new RpcResponse(54321L, new byte[7]));
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        byte[] arr = new byte[10];
        handler.handle((ResponseMessage)new RpcResponse(12345L, arr));
        ((RpcResponseCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onSuccess((byte[])Matchers.eq((Object)arr));
        Assert.assertEquals((long)0L, (long)handler.numOutstandingRequests());
    }

    @Test
    public void handleFailedRPC() {
        TransportResponseHandler handler = new TransportResponseHandler((Channel)new LocalChannel());
        RpcResponseCallback callback = (RpcResponseCallback)Mockito.mock(RpcResponseCallback.class);
        handler.addRpcRequest(12345L, callback);
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new RpcFailure(54321L, "uh-oh!"));
        Assert.assertEquals((long)1L, (long)handler.numOutstandingRequests());
        handler.handle((ResponseMessage)new RpcFailure(12345L, "oh no"));
        ((RpcResponseCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).onFailure((Throwable)Matchers.any());
        Assert.assertEquals((long)0L, (long)handler.numOutstandingRequests());
    }
}

