/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.LinkedList;
import org.spark_project.guava.base.Preconditions;

public class TransportFrameDecoder
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "frameDecoder";
    private static final int LENGTH_SIZE = 8;
    private static final int MAX_FRAME_SIZE = Integer.MAX_VALUE;
    private static final int UNKNOWN_FRAME_SIZE = -1;
    private final LinkedList<ByteBuf> buffers = new LinkedList();
    private final ByteBuf frameLenBuf = Unpooled.buffer((int)8, (int)8);
    private long totalSize = 0L;
    private long nextFrameSize = -1L;
    private volatile Interceptor interceptor;

    public void channelRead(ChannelHandlerContext ctx, Object data) throws Exception {
        ByteBuf in = (ByteBuf)data;
        this.buffers.add(in);
        this.totalSize += (long)in.readableBytes();
        while (!this.buffers.isEmpty()) {
            if (this.interceptor != null) {
                ByteBuf first = this.buffers.getFirst();
                int available = first.readableBytes();
                if (this.feedInterceptor(first)) assert (!first.isReadable()) : "Interceptor still active but buffer has data.";
                int read = available - first.readableBytes();
                if (read == available) {
                    this.buffers.removeFirst().release();
                }
                this.totalSize -= (long)read;
                continue;
            }
            ByteBuf frame = this.decodeNext();
            if (frame == null) break;
            ctx.fireChannelRead((Object)frame);
        }
    }

    private long decodeFrameSize() {
        if (this.nextFrameSize != -1L || this.totalSize < 8L) {
            return this.nextFrameSize;
        }
        ByteBuf first = this.buffers.getFirst();
        if (first.readableBytes() >= 8) {
            this.nextFrameSize = first.readLong() - 8L;
            this.totalSize -= 8L;
            if (!first.isReadable()) {
                this.buffers.removeFirst().release();
            }
            return this.nextFrameSize;
        }
        while (this.frameLenBuf.readableBytes() < 8) {
            ByteBuf next = this.buffers.getFirst();
            int toRead = Math.min(next.readableBytes(), 8 - this.frameLenBuf.readableBytes());
            this.frameLenBuf.writeBytes(next, toRead);
            if (next.isReadable()) continue;
            this.buffers.removeFirst().release();
        }
        this.nextFrameSize = this.frameLenBuf.readLong() - 8L;
        this.totalSize -= 8L;
        this.frameLenBuf.clear();
        return this.nextFrameSize;
    }

    private ByteBuf decodeNext() {
        ByteBuf next;
        int remaining;
        long frameSize = this.decodeFrameSize();
        if (frameSize == -1L || this.totalSize < frameSize) {
            return null;
        }
        this.nextFrameSize = -1L;
        Preconditions.checkArgument(frameSize < Integer.MAX_VALUE, "Too large frame: %s", frameSize);
        Preconditions.checkArgument(frameSize > 0L, "Frame length should be positive: %s", frameSize);
        if (this.buffers.getFirst().readableBytes() >= remaining) {
            return this.nextBufferForFrame(remaining);
        }
        CompositeByteBuf frame = this.buffers.getFirst().alloc().compositeBuffer(Integer.MAX_VALUE);
        for (remaining = (int)frameSize; remaining > 0; remaining -= next.readableBytes()) {
            next = this.nextBufferForFrame(remaining);
            frame.addComponent(next).writerIndex(frame.writerIndex() + next.readableBytes());
        }
        assert (remaining == 0);
        return frame;
    }

    private ByteBuf nextBufferForFrame(int bytesToRead) {
        ByteBuf frame;
        ByteBuf buf = this.buffers.getFirst();
        if (buf.readableBytes() > bytesToRead) {
            frame = buf.retain().readSlice(bytesToRead);
            this.totalSize -= (long)bytesToRead;
        } else {
            frame = buf;
            this.buffers.removeFirst();
            this.totalSize -= (long)frame.readableBytes();
        }
        return frame;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        for (ByteBuf b : this.buffers) {
            b.release();
        }
        if (this.interceptor != null) {
            this.interceptor.channelInactive();
        }
        this.frameLenBuf.release();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.interceptor != null) {
            this.interceptor.exceptionCaught(cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    public void setInterceptor(Interceptor interceptor) {
        Preconditions.checkState(this.interceptor == null, "Already have an interceptor.");
        this.interceptor = interceptor;
    }

    private boolean feedInterceptor(ByteBuf buf) throws Exception {
        if (this.interceptor != null && !this.interceptor.handle(buf)) {
            this.interceptor = null;
        }
        return this.interceptor != null;
    }

    public static interface Interceptor {
        public boolean handle(ByteBuf var1) throws Exception;

        public void exceptionCaught(Throwable var1) throws Exception;

        public void channelInactive() throws Exception;
    }
}

