/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.spark.network.crypto.AuthEngine;
import org.apache.spark.network.crypto.ClientChallenge;
import org.apache.spark.network.crypto.ServerResponse;
import org.apache.spark.network.crypto.TransportCipher;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class AuthEngineSuite {
    private static TransportConf conf;

    @BeforeClass
    public static void setUp() {
        conf = new TransportConf("rpc", (ConfigProvider)MapConfigProvider.EMPTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuthEngine() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            ClientChallenge clientChallenge = client.challenge();
            ServerResponse serverResponse = server.respond(clientChallenge);
            client.validate(serverResponse);
            TransportCipher serverCipher = server.sessionCipher();
            TransportCipher clientCipher = client.sessionCipher();
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getInputIv(), clientCipher.getOutputIv()));
            Assert.assertTrue((boolean)Arrays.equals(serverCipher.getOutputIv(), clientCipher.getInputIv()));
            Assert.assertEquals((Object)serverCipher.getKey(), (Object)clientCipher.getKey());
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test
    public void testMismatchedSecret() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "different_secret", conf);
        ClientChallenge clientChallenge = client.challenge();
        try {
            server.respond(clientChallenge);
            Assert.fail((String)"Should have failed to validate response.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongAppId() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = engine.challenge(new byte[]{0}, challenge.nonce, engine.rawResponse(engine.challenge));
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongNonce() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = engine.challenge(challenge.appId.getBytes(StandardCharsets.UTF_8), new byte[]{0}, engine.rawResponse(engine.challenge));
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadChallenge() throws Exception {
        AuthEngine engine = new AuthEngine("appId", "secret", conf);
        ClientChallenge challenge = engine.challenge();
        byte[] badChallenge = new byte[challenge.challenge.length];
        engine.respond(new ClientChallenge(challenge.appId, challenge.kdf, challenge.iterations, challenge.cipher, challenge.keyLength, challenge.nonce, badChallenge));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedMessage() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            ClientChallenge clientChallenge = client.challenge();
            ServerResponse serverResponse = server.respond(clientChallenge);
            client.validate(serverResponse);
            TransportCipher cipher = server.sessionCipher();
            TransportCipher.EncryptionHandler handler = new TransportCipher.EncryptionHandler(cipher);
            byte[] data = new byte[32769];
            new Random().nextBytes(data);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
            ByteArrayWritableChannel channel = new ByteArrayWritableChannel(data.length);
            TransportCipher.EncryptedMessage emsg = handler.createEncryptedMessage((Object)buf);
            while (emsg.transfered() < emsg.count()) {
                emsg.transferTo((WritableByteChannel)channel, emsg.transfered());
            }
            Assert.assertEquals((long)data.length, (long)channel.length());
        }
        finally {
            client.close();
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncryptedMessageWhenTransferringZeroBytes() throws Exception {
        AuthEngine client = new AuthEngine("appId", "secret", conf);
        AuthEngine server = new AuthEngine("appId", "secret", conf);
        try {
            ClientChallenge clientChallenge = client.challenge();
            ServerResponse serverResponse = server.respond(clientChallenge);
            client.validate(serverResponse);
            TransportCipher cipher = server.sessionCipher();
            TransportCipher.EncryptionHandler handler = new TransportCipher.EncryptionHandler(cipher);
            final int testDataLength = 4;
            FileRegion region = (FileRegion)Mockito.mock(FileRegion.class);
            Mockito.when((Object)region.count()).thenReturn((Object)testDataLength);
            Mockito.when((Object)region.transferTo((WritableByteChannel)Mockito.any(), Mockito.anyLong())).thenAnswer((Answer)new Answer<Long>(){
                private boolean firstTime = true;

                public Long answer(InvocationOnMock invocationOnMock) throws Throwable {
                    if (this.firstTime) {
                        this.firstTime = false;
                        return 0L;
                    }
                    WritableByteChannel channel = (WritableByteChannel)invocationOnMock.getArgumentAt(0, WritableByteChannel.class);
                    channel.write(ByteBuffer.wrap(new byte[testDataLength]));
                    return testDataLength;
                }
            });
            TransportCipher.EncryptedMessage emsg = handler.createEncryptedMessage((Object)region);
            ByteArrayWritableChannel channel = new ByteArrayWritableChannel(testDataLength);
            Assert.assertEquals((long)0L, (long)emsg.transferTo((WritableByteChannel)channel, emsg.transfered()));
            Assert.assertEquals((long)testDataLength, (long)emsg.transferTo((WritableByteChannel)channel, emsg.transfered()));
            Assert.assertEquals((long)emsg.transfered(), (long)emsg.count());
            Assert.assertEquals((long)4L, (long)channel.length());
        }
        finally {
            client.close();
            server.close();
        }
    }

    @Test(expected=InvalidKeyException.class)
    public void testBadKeySize() throws Exception {
        ImmutableMap mconf = ImmutableMap.of((Object)"spark.network.crypto.keyLength", (Object)"42");
        TransportConf conf = new TransportConf("rpc", (ConfigProvider)new MapConfigProvider((Map)mconf));
        try (AuthEngine engine = new AuthEngine("appId", "secret", conf);){
            engine.challenge();
            Assert.fail((String)"Should have failed to create challenge message.");
            engine.close();
        }
    }
}

