/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthRpcHandler;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.sasl.SaslRpcHandler;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AuthIntegrationSuite {
    private AuthTestCtx ctx;

    @After
    public void cleanUp() throws Exception {
        if (this.ctx != null) {
            this.ctx.close();
        }
        this.ctx = null;
    }

    @Test
    public void testNewAuth() throws Exception {
        this.ctx = new AuthTestCtx();
        this.ctx.createServer("secret");
        this.ctx.createClient("secret");
        ByteBuffer reply = this.ctx.client.sendRpcSync(JavaUtils.stringToBytes((String)"Ping"), 5000L);
        Assert.assertEquals((Object)"Pong", (Object)JavaUtils.bytesToString((ByteBuffer)reply));
        Assert.assertTrue((boolean)this.ctx.authRpcHandler.doDelegate);
        Assert.assertFalse((boolean)(this.ctx.authRpcHandler.delegate instanceof SaslRpcHandler));
    }

    @Test
    public void testAuthFailure() throws Exception {
        this.ctx = new AuthTestCtx();
        this.ctx.createServer("server");
        try {
            this.ctx.createClient("client");
            Assert.fail((String)"Should have failed to create client.");
        }
        catch (Exception e) {
            Assert.assertFalse((boolean)this.ctx.authRpcHandler.doDelegate);
            Assert.assertFalse((boolean)this.ctx.serverChannel.isActive());
        }
    }

    @Test
    public void testSaslServerFallback() throws Exception {
        this.ctx = new AuthTestCtx();
        this.ctx.createServer("secret", true);
        this.ctx.createClient("secret", false);
        ByteBuffer reply = this.ctx.client.sendRpcSync(JavaUtils.stringToBytes((String)"Ping"), 5000L);
        Assert.assertEquals((Object)"Pong", (Object)JavaUtils.bytesToString((ByteBuffer)reply));
    }

    @Test
    public void testSaslClientFallback() throws Exception {
        this.ctx = new AuthTestCtx();
        this.ctx.createServer("secret", false);
        this.ctx.createClient("secret", true);
        ByteBuffer reply = this.ctx.client.sendRpcSync(JavaUtils.stringToBytes((String)"Ping"), 5000L);
        Assert.assertEquals((Object)"Pong", (Object)JavaUtils.bytesToString((ByteBuffer)reply));
    }

    @Test
    public void testAuthReplay() throws Exception {
        this.ctx = new AuthTestCtx();
        this.ctx.createServer("secret");
        this.ctx.createClient("secret");
        Assert.assertNotNull((Object)this.ctx.client.getChannel().pipeline().remove("TransportEncryption"));
        try {
            this.ctx.client.sendRpcSync(JavaUtils.stringToBytes((String)"Ping"), 5000L);
            Assert.fail((String)"Should have failed unencrypted RPC.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)this.ctx.authRpcHandler.doDelegate);
        }
    }

    @Test
    public void testLargeMessageEncryption() throws Exception {
        int testErrorMessageLength = 32768;
        this.ctx = new AuthTestCtx(new RpcHandler(){

            public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
                char[] longMessage = new char[32768];
                Arrays.fill(longMessage, 'D');
                callback.onFailure((Throwable)new RuntimeException(new String(longMessage)));
            }

            public StreamManager getStreamManager() {
                return null;
            }
        });
        this.ctx.createServer("secret");
        this.ctx.createClient("secret");
        try {
            this.ctx.client.sendRpcSync(JavaUtils.stringToBytes((String)"Ping"), 5000L);
            Assert.fail((String)"Should have failed unencrypted RPC.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)this.ctx.authRpcHandler.doDelegate);
            Assert.assertTrue((String)(e.getMessage() + " is not an expected error"), (boolean)e.getMessage().contains("DDDDD"));
            int messageStart = e.getMessage().indexOf("DDDDD");
            int messageEnd = e.getMessage().lastIndexOf("DDDDD") + 5;
            Assert.assertEquals((long)32768L, (long)(messageEnd - messageStart));
        }
    }

    private class AuthTestCtx {
        private final String appId = "testAppId";
        private final TransportConf conf;
        private final TransportContext ctx;
        TransportClient client;
        TransportServer server;
        volatile Channel serverChannel;
        volatile AuthRpcHandler authRpcHandler;

        AuthTestCtx() throws Exception {
            this(new RpcHandler(){

                public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
                    Assert.assertEquals((Object)"Ping", (Object)JavaUtils.bytesToString((ByteBuffer)message));
                    callback.onSuccess(JavaUtils.stringToBytes((String)"Pong"));
                }

                public StreamManager getStreamManager() {
                    return null;
                }
            });
        }

        AuthTestCtx(RpcHandler rpcHandler) throws Exception {
            ImmutableMap testConf = ImmutableMap.of((Object)"spark.network.crypto.enabled", (Object)"true");
            this.conf = new TransportConf("rpc", (ConfigProvider)new MapConfigProvider((Map)testConf));
            this.ctx = new TransportContext(this.conf, rpcHandler);
        }

        void createServer(String secret) throws Exception {
            this.createServer(secret, true);
        }

        void createServer(String secret, boolean enableAes) throws Exception {
            TransportServerBootstrap introspector = (channel, rpcHandler) -> {
                this.serverChannel = channel;
                if (rpcHandler instanceof AuthRpcHandler) {
                    this.authRpcHandler = (AuthRpcHandler)rpcHandler;
                }
                return rpcHandler;
            };
            SecretKeyHolder keyHolder = this.createKeyHolder(secret);
            AuthServerBootstrap auth = enableAes ? new AuthServerBootstrap(this.conf, keyHolder) : new SaslServerBootstrap(this.conf, keyHolder);
            this.server = this.ctx.createServer(Arrays.asList(auth, introspector));
        }

        void createClient(String secret) throws Exception {
            this.createClient(secret, true);
        }

        void createClient(String secret, boolean enableAes) throws Exception {
            TransportConf clientConf = enableAes ? this.conf : new TransportConf("rpc", (ConfigProvider)MapConfigProvider.EMPTY);
            List<TransportClientBootstrap> bootstraps = Arrays.asList(new AuthClientBootstrap(clientConf, "testAppId", this.createKeyHolder(secret)));
            this.client = this.ctx.createClientFactory(bootstraps).createClient(TestUtils.getLocalHost(), this.server.getPort());
        }

        void close() {
            if (this.client != null) {
                this.client.close();
            }
            if (this.server != null) {
                this.server.close();
            }
        }

        private SecretKeyHolder createKeyHolder(String secret) {
            SecretKeyHolder keyHolder = (SecretKeyHolder)Mockito.mock(SecretKeyHolder.class);
            Mockito.when((Object)keyHolder.getSaslUser(Mockito.anyString())).thenReturn((Object)"testAppId");
            Mockito.when((Object)keyHolder.getSecretKey(Mockito.anyString())).thenReturn((Object)secret);
            return keyHolder;
        }
    }
}

