/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.spark.network.crypto.ClientChallenge;
import org.apache.spark.network.crypto.ServerResponse;
import org.apache.spark.network.protocol.Encodable;
import org.junit.Assert;
import org.junit.Test;

public class AuthMessagesSuite {
    private static int COUNTER = 0;

    private static String string() {
        return String.valueOf(COUNTER++);
    }

    private static byte[] byteArray() {
        byte[] bytes = new byte[COUNTER++];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)COUNTER;
        }
        return bytes;
    }

    private static int integer() {
        return COUNTER++;
    }

    @Test
    public void testClientChallenge() {
        ClientChallenge msg = new ClientChallenge(AuthMessagesSuite.string(), AuthMessagesSuite.string(), AuthMessagesSuite.integer(), AuthMessagesSuite.string(), AuthMessagesSuite.integer(), AuthMessagesSuite.byteArray(), AuthMessagesSuite.byteArray());
        ClientChallenge decoded = ClientChallenge.decodeMessage((ByteBuffer)this.encode((Encodable)msg));
        Assert.assertEquals((Object)msg.appId, (Object)decoded.appId);
        Assert.assertEquals((Object)msg.kdf, (Object)decoded.kdf);
        Assert.assertEquals((long)msg.iterations, (long)decoded.iterations);
        Assert.assertEquals((Object)msg.cipher, (Object)decoded.cipher);
        Assert.assertEquals((long)msg.keyLength, (long)decoded.keyLength);
        Assert.assertTrue((boolean)Arrays.equals(msg.nonce, decoded.nonce));
        Assert.assertTrue((boolean)Arrays.equals(msg.challenge, decoded.challenge));
    }

    @Test
    public void testServerResponse() {
        ServerResponse msg = new ServerResponse(AuthMessagesSuite.byteArray(), AuthMessagesSuite.byteArray(), AuthMessagesSuite.byteArray(), AuthMessagesSuite.byteArray());
        ServerResponse decoded = ServerResponse.decodeMessage((ByteBuffer)this.encode((Encodable)msg));
        Assert.assertTrue((boolean)Arrays.equals(msg.response, decoded.response));
        Assert.assertTrue((boolean)Arrays.equals(msg.nonce, decoded.nonce));
        Assert.assertTrue((boolean)Arrays.equals(msg.inputIv, decoded.inputIv));
        Assert.assertTrue((boolean)Arrays.equals(msg.outputIv, decoded.outputIv));
    }

    private ByteBuffer encode(Encodable msg) {
        ByteBuf buf = Unpooled.buffer();
        msg.encode(buf);
        return buf.nioBuffer();
    }
}

