/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import java.util.ArrayList;
import org.apache.spark.network.TestManagedBuffer;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class OneForOneStreamManagerSuite {
    @Test
    public void managedBuffersAreFeedWhenConnectionIsClosed() throws Exception {
        OneForOneStreamManager manager = new OneForOneStreamManager();
        ArrayList<TestManagedBuffer> buffers = new ArrayList<TestManagedBuffer>();
        TestManagedBuffer buffer1 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(10))));
        TestManagedBuffer buffer2 = (TestManagedBuffer)((Object)Mockito.spy((Object)((Object)new TestManagedBuffer(20))));
        buffers.add(buffer1);
        buffers.add(buffer2);
        Channel dummyChannel = (Channel)Mockito.mock(Channel.class, (Answer)Mockito.RETURNS_SMART_NULLS);
        manager.registerStream("appId", buffers.iterator(), dummyChannel);
        assert (manager.numStreamStates() == 1);
        manager.connectionTerminated(dummyChannel);
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer1), (VerificationMode)Mockito.times((int)1)))).release();
        ((TestManagedBuffer)((Object)Mockito.verify((Object)((Object)buffer2), (VerificationMode)Mockito.times((int)1)))).release();
        assert (manager.numStreamStates() == 0);
    }
}

