/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.network.util.TransportFrameDecoder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TransportFrameDecoderSuite {
    private static Random RND = new Random();

    @AfterClass
    public static void cleanup() {
        RND = null;
    }

    @Test
    public void testFrameDecoding() throws Exception {
        TransportFrameDecoder decoder = new TransportFrameDecoder();
        ChannelHandlerContext ctx = this.mockChannelHandlerContext();
        ByteBuf data = this.createAndFeedFrames(100, decoder, ctx);
        this.verifyAndCloseDecoder(decoder, ctx, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterception() throws Exception {
        int interceptedReads = 3;
        TransportFrameDecoder decoder = new TransportFrameDecoder();
        TransportFrameDecoder.Interceptor interceptor = (TransportFrameDecoder.Interceptor)Mockito.spy((Object)new MockInterceptor(interceptedReads));
        ChannelHandlerContext ctx = this.mockChannelHandlerContext();
        byte[] data = new byte[8];
        ByteBuf len = Unpooled.copyLong((long)(8 + data.length));
        ByteBuf dataBuf = Unpooled.wrappedBuffer((byte[])data);
        try {
            decoder.setInterceptor(interceptor);
            for (int i = 0; i < interceptedReads; ++i) {
                decoder.channelRead(ctx, (Object)dataBuf);
                Assert.assertEquals((long)0L, (long)dataBuf.refCnt());
                dataBuf = Unpooled.wrappedBuffer((byte[])data);
            }
            decoder.channelRead(ctx, (Object)len);
            decoder.channelRead(ctx, (Object)dataBuf);
            ((TransportFrameDecoder.Interceptor)Mockito.verify((Object)interceptor, (VerificationMode)Mockito.times((int)interceptedReads))).handle((ByteBuf)Mockito.any(ByteBuf.class));
            ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelRead(Mockito.any(ByteBuf.class));
            Assert.assertEquals((long)0L, (long)len.refCnt());
            Assert.assertEquals((long)0L, (long)dataBuf.refCnt());
        }
        finally {
            this.release(len);
            this.release(dataBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetainedFrames() throws Exception {
        TransportFrameDecoder decoder = new TransportFrameDecoder();
        AtomicInteger count = new AtomicInteger();
        ArrayList retained = new ArrayList();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.fireChannelRead(Mockito.any())).thenAnswer(in -> {
            ByteBuf buf = (ByteBuf)in.getArguments()[0];
            if (count.incrementAndGet() % 2 == 0) {
                retained.add(buf);
            } else {
                buf.release();
            }
            return null;
        });
        ByteBuf data = this.createAndFeedFrames(100, decoder, ctx);
        try {
            for (ByteBuf b : retained) {
                byte[] tmp = new byte[b.readableBytes()];
                b.readBytes(tmp);
                b.release();
            }
            this.verifyAndCloseDecoder(decoder, ctx, data);
        }
        finally {
            for (ByteBuf b : retained) {
                this.release(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitLengthField() throws Exception {
        byte[] frame = new byte[1024 * (RND.nextInt(31) + 1)];
        ByteBuf buf = Unpooled.buffer((int)(frame.length + 8));
        buf.writeLong((long)(frame.length + 8));
        buf.writeBytes(frame);
        TransportFrameDecoder decoder = new TransportFrameDecoder();
        ChannelHandlerContext ctx = this.mockChannelHandlerContext();
        try {
            decoder.channelRead(ctx, (Object)buf.readSlice(RND.nextInt(7)).retain());
            ((ChannelHandlerContext)Mockito.verify((Object)ctx, (VerificationMode)Mockito.never())).fireChannelRead(Mockito.any(ByteBuf.class));
            decoder.channelRead(ctx, (Object)buf);
            ((ChannelHandlerContext)Mockito.verify((Object)ctx)).fireChannelRead(Mockito.any(ByteBuf.class));
            Assert.assertEquals((long)0L, (long)buf.refCnt());
        }
        finally {
            decoder.channelInactive(ctx);
            this.release(buf);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeFrameSize() throws Exception {
        this.testInvalidFrame(-1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyFrame() throws Exception {
        this.testInvalidFrame(8L);
    }

    private ByteBuf createAndFeedFrames(int frameCount, TransportFrameDecoder decoder, ChannelHandlerContext ctx) throws Exception {
        ByteBuf data = Unpooled.buffer();
        for (int i = 0; i < frameCount; ++i) {
            byte[] frame = new byte[1024 * (RND.nextInt(31) + 1)];
            data.writeLong((long)(frame.length + 8));
            data.writeBytes(frame);
        }
        try {
            while (data.isReadable()) {
                int size = RND.nextInt(4096) + 256;
                decoder.channelRead(ctx, (Object)data.readSlice(Math.min(data.readableBytes(), size)).retain());
            }
            ((ChannelHandlerContext)Mockito.verify((Object)ctx, (VerificationMode)Mockito.times((int)frameCount))).fireChannelRead(Mockito.any(ByteBuf.class));
        }
        catch (Exception e) {
            this.release(data);
            throw e;
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAndCloseDecoder(TransportFrameDecoder decoder, ChannelHandlerContext ctx, ByteBuf data) throws Exception {
        try {
            decoder.channelInactive(ctx);
            Assert.assertTrue((String)"There shouldn't be dangling references to the data.", (boolean)data.release());
        }
        finally {
            this.release(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidFrame(long size) throws Exception {
        TransportFrameDecoder decoder = new TransportFrameDecoder();
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        ByteBuf frame = Unpooled.copyLong((long)size);
        try {
            decoder.channelRead(ctx, (Object)frame);
        }
        finally {
            this.release(frame);
        }
    }

    private ChannelHandlerContext mockChannelHandlerContext() {
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.fireChannelRead(Mockito.any())).thenAnswer(in -> {
            ByteBuf buf = (ByteBuf)in.getArguments()[0];
            buf.release();
            return null;
        });
        return ctx;
    }

    private void release(ByteBuf buf) {
        if (buf.refCnt() > 0) {
            buf.release(buf.refCnt());
        }
    }

    private static class MockInterceptor
    implements TransportFrameDecoder.Interceptor {
        private int remainingReads;

        MockInterceptor(int readCount) {
            this.remainingReads = readCount;
        }

        public boolean handle(ByteBuf data) throws Exception {
            data.readerIndex(data.readerIndex() + data.readableBytes());
            Assert.assertFalse((boolean)data.isReadable());
            --this.remainingReads;
            return this.remainingReads != 0;
        }

        public void exceptionCaught(Throwable cause) throws Exception {
        }

        public void channelInactive() throws Exception {
        }
    }
}

