/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network;

import com.codahale.metrics.Counter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.MessageDecoder;
import org.apache.spark.network.protocol.MessageEncoder;
import org.apache.spark.network.server.ChunkFetchRequestHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportChannelHandler;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private final TransportConf conf;
    private final RpcHandler rpcHandler;
    private final boolean closeIdleConnections;
    private Counter registeredConnections = new Counter();
    private static final MessageEncoder ENCODER = MessageEncoder.INSTANCE;
    private static final MessageDecoder DECODER = MessageDecoder.INSTANCE;
    private final EventLoopGroup chunkFetchWorkers;

    public TransportContext(TransportConf conf, RpcHandler rpcHandler) {
        this(conf, rpcHandler, false, false);
    }

    public TransportContext(TransportConf conf, RpcHandler rpcHandler, boolean closeIdleConnections) {
        this(conf, rpcHandler, closeIdleConnections, false);
    }

    public TransportContext(TransportConf conf, RpcHandler rpcHandler, boolean closeIdleConnections, boolean isClientOnly) {
        this.conf = conf;
        this.rpcHandler = rpcHandler;
        this.closeIdleConnections = closeIdleConnections;
        this.chunkFetchWorkers = conf.getModuleName() != null && conf.getModuleName().equalsIgnoreCase("shuffle") && !isClientOnly ? NettyUtils.createEventLoop(IOMode.valueOf(conf.ioMode()), conf.chunkFetchHandlerThreads(), "shuffle-chunk-fetch-handler") : null;
    }

    public TransportClientFactory createClientFactory(List<TransportClientBootstrap> bootstraps) {
        return new TransportClientFactory(this, bootstraps);
    }

    public TransportClientFactory createClientFactory() {
        return this.createClientFactory(new ArrayList<TransportClientBootstrap>());
    }

    public TransportServer createServer(int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, null, port, this.rpcHandler, bootstraps);
    }

    public TransportServer createServer(String host, int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, host, port, this.rpcHandler, bootstraps);
    }

    public TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return this.createServer(0, bootstraps);
    }

    public TransportServer createServer() {
        return this.createServer(0, new ArrayList<TransportServerBootstrap>());
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel) {
        return this.initializePipeline(channel, this.rpcHandler);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, RpcHandler channelRpcHandler) {
        try {
            TransportChannelHandler channelHandler = this.createChannelHandler((Channel)channel, channelRpcHandler);
            ChunkFetchRequestHandler chunkFetchHandler = this.createChunkFetchHandler(channelHandler, channelRpcHandler);
            ChannelPipeline pipeline = channel.pipeline().addLast("encoder", (ChannelHandler)ENCODER).addLast("frameDecoder", (ChannelHandler)NettyUtils.createFrameDecoder()).addLast("decoder", (ChannelHandler)DECODER).addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.conf.connectionTimeoutMs() / 1000)).addLast("handler", (ChannelHandler)channelHandler);
            if (this.chunkFetchWorkers != null) {
                pipeline.addLast((EventExecutorGroup)this.chunkFetchWorkers, "chunkFetchHandler", (ChannelHandler)chunkFetchHandler);
            }
            return channelHandler;
        }
        catch (RuntimeException e) {
            logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel, RpcHandler rpcHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, rpcHandler, this.conf.maxChunksBeingTransferred());
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.conf.connectionTimeoutMs(), this.closeIdleConnections, this);
    }

    private ChunkFetchRequestHandler createChunkFetchHandler(TransportChannelHandler channelHandler, RpcHandler rpcHandler) {
        return new ChunkFetchRequestHandler(channelHandler.getClient(), rpcHandler.getStreamManager(), this.conf.maxChunksBeingTransferred());
    }

    public TransportConf getConf() {
        return this.conf;
    }

    public Counter getRegisteredConnections() {
        return this.registeredConnections;
    }

    @Override
    public void close() {
        if (this.chunkFetchWorkers != null) {
            this.chunkFetchWorkers.shutdownGracefully();
        }
    }
}

