/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.protocol.StreamChunkId;
import org.sparkproject.guava.base.Objects;

public final class ChunkFetchFailure
extends AbstractMessage
implements ResponseMessage {
    public final StreamChunkId streamChunkId;
    public final String errorString;

    public ChunkFetchFailure(StreamChunkId streamChunkId, String errorString) {
        this.streamChunkId = streamChunkId;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.ChunkFetchFailure;
    }

    @Override
    public int encodedLength() {
        return this.streamChunkId.encodedLength() + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        this.streamChunkId.encode(buf);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static ChunkFetchFailure decode(ByteBuf buf) {
        StreamChunkId streamChunkId = StreamChunkId.decode(buf);
        String errorString = Encoders.Strings.decode(buf);
        return new ChunkFetchFailure(streamChunkId, errorString);
    }

    public int hashCode() {
        return Objects.hashCode(this.streamChunkId, this.errorString);
    }

    public boolean equals(Object other) {
        if (other instanceof ChunkFetchFailure) {
            ChunkFetchFailure o = (ChunkFetchFailure)other;
            return this.streamChunkId.equals(o.streamChunkId) && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("streamChunkId", this.streamChunkId).add("errorString", this.errorString).toString();
    }
}

