/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffledb;

import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.spark.network.shuffledb.DBIterator;
import org.sparkproject.guava.base.Throwables;

public class LevelDBIterator
implements DBIterator {
    private final org.iq80.leveldb.DBIterator it;
    private boolean checkedNext;
    private boolean closed;
    private Map.Entry<byte[], byte[]> next;

    public LevelDBIterator(org.iq80.leveldb.DBIterator it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        if (!this.checkedNext && !this.closed) {
            this.next = this.loadNext();
            this.checkedNext = true;
        }
        if (!this.closed && this.next == null) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                throw Throwables.propagate(ioe);
            }
        }
        return this.next != null;
    }

    @Override
    public Map.Entry<byte[], byte[]> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.checkedNext = false;
        Map.Entry<byte[], byte[]> ret = this.next;
        this.next = null;
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.it.close();
            this.closed = true;
            this.next = null;
        }
    }

    @Override
    public void seek(byte[] key) {
        this.it.seek(key);
    }

    private Map.Entry<byte[], byte[]> loadNext() {
        boolean hasNext = this.it.hasNext();
        if (!hasNext) {
            return null;
        }
        return (Map.Entry)this.it.next();
    }
}

