/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.io.IOException;
import java.util.Arrays;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleClient;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalShuffleSecuritySuite {
    TransportConf conf = new TransportConf((ConfigProvider)new SystemPropertyConfigProvider());
    TransportServer server;

    @Before
    public void beforeEach() {
        TransportContext context = new TransportContext(this.conf, (RpcHandler)new ExternalShuffleBlockHandler(this.conf));
        SaslServerBootstrap bootstrap = new SaslServerBootstrap(this.conf, (SecretKeyHolder)new TestSecretKeyHolder("my-app-id", "secret"));
        this.server = context.createServer(Arrays.asList(bootstrap));
    }

    @After
    public void afterEach() {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }

    @Test
    public void testValid() throws IOException {
        this.validate("my-app-id", "secret", false);
    }

    @Test
    public void testBadAppId() {
        try {
            this.validate("wrong-app-id", "secret", false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Wrong appId!"));
        }
    }

    @Test
    public void testBadSecret() {
        try {
            this.validate("my-app-id", "bad-secret", false);
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Mismatched response"));
        }
    }

    @Test
    public void testEncryption() throws IOException {
        this.validate("my-app-id", "secret", true);
    }

    private void validate(String appId, String secretKey, boolean encrypt) throws IOException {
        ExternalShuffleClient client = new ExternalShuffleClient(this.conf, (SecretKeyHolder)new TestSecretKeyHolder(appId, secretKey), true, encrypt);
        client.init(appId);
        client.registerWithShuffleServer(TestUtils.getLocalHost(), this.server.getPort(), "exec0", new ExecutorShuffleInfo(new String[0], 0, ""));
        client.close();
    }

    static class TestSecretKeyHolder
    implements SecretKeyHolder {
        private final String appId;
        private final String secretKey;

        TestSecretKeyHolder(String appId, String secretKey) {
            this.appId = appId;
            this.secretKey = secretKey;
        }

        public String getSaslUser(String appId) {
            return "user";
        }

        public String getSecretKey(String appId) {
            if (!appId.equals(this.appId)) {
                throw new IllegalArgumentException("Wrong appId!");
            }
            return this.secretKey;
        }
    }
}

