/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SaslIntegrationSuite {
    static ExternalShuffleBlockHandler handler;
    static TransportServer server;
    static TransportConf conf;
    static TransportContext context;
    TransportClientFactory clientFactory;

    @BeforeClass
    public static void beforeAll() throws IOException {
        TestSecretKeyHolder secretKeyHolder = new TestSecretKeyHolder("good-key");
        conf = new TransportConf((ConfigProvider)new SystemPropertyConfigProvider());
        context = new TransportContext(conf, (RpcHandler)new TestRpcHandler());
        SaslServerBootstrap bootstrap = new SaslServerBootstrap(conf, (SecretKeyHolder)secretKeyHolder);
        server = context.createServer(Arrays.asList(bootstrap));
    }

    @AfterClass
    public static void afterAll() {
        server.close();
    }

    @After
    public void afterEach() {
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }

    @Test
    public void testGoodClient() throws IOException {
        this.clientFactory = context.createClientFactory((List)Lists.newArrayList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(conf, "app-id", (SecretKeyHolder)new TestSecretKeyHolder("good-key"))}));
        TransportClient client = this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        String msg = "Hello, World!";
        byte[] resp = client.sendRpcSync(msg.getBytes(), 1000L);
        Assert.assertEquals((Object)msg, (Object)new String(resp));
    }

    @Test
    public void testBadClient() {
        this.clientFactory = context.createClientFactory((List)Lists.newArrayList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(conf, "app-id", (SecretKeyHolder)new TestSecretKeyHolder("bad-key"))}));
        try {
            this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Mismatched response"));
        }
    }

    @Test
    public void testNoSaslClient() throws IOException {
        this.clientFactory = context.createClientFactory((List)Lists.newArrayList());
        TransportClient client = this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        try {
            client.sendRpcSync(new byte[13], 1000L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Expected SaslMessage"));
        }
        try {
            client.sendRpcSync(new byte[]{-22}, 1000L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("java.lang.IndexOutOfBoundsException"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoSaslServer() {
        TestRpcHandler handler = new TestRpcHandler();
        TransportContext context = new TransportContext(conf, (RpcHandler)handler);
        this.clientFactory = context.createClientFactory((List)Lists.newArrayList((Object[])new TransportClientBootstrap[]{new SaslClientBootstrap(conf, "app-id", (SecretKeyHolder)new TestSecretKeyHolder("key"))}));
        try (TransportServer server = context.createServer();){
            this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        }
    }

    public static class TestRpcHandler
    extends RpcHandler {
        public void receive(TransportClient client, byte[] message, RpcResponseCallback callback) {
            callback.onSuccess(message);
        }

        public StreamManager getStreamManager() {
            return new OneForOneStreamManager();
        }
    }

    static class TestSecretKeyHolder
    implements SecretKeyHolder {
        private final String secretKey;

        TestSecretKeyHolder(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getSaslUser(String appId) {
            return "user";
        }

        public String getSecretKey(String appId) {
            return this.secretKey;
        }
    }
}

