/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExternalShuffleBlockResolverSuite {
    static String sortBlock0 = "Hello!";
    static String sortBlock1 = "World!";
    static String hashBlock0 = "Elementary";
    static String hashBlock1 = "Tabular";
    static TestShuffleDataContext dataContext;
    static TransportConf conf;

    @BeforeClass
    public static void beforeAll() throws IOException {
        dataContext = new TestShuffleDataContext(2, 5);
        dataContext.create();
        dataContext.insertSortShuffleData(0, 0, new byte[][]{sortBlock0.getBytes(), sortBlock1.getBytes()});
        dataContext.insertHashShuffleData(1, 0, new byte[][]{hashBlock0.getBytes(), hashBlock1.getBytes()});
    }

    @AfterClass
    public static void afterAll() {
        dataContext.cleanup();
    }

    @Test
    public void testBadRequests() {
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(conf);
        try {
            resolver.getBlockData("app0", "exec1", "shuffle_1_1_0");
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Bad error message: " + e), (boolean)e.getMessage().contains("not registered"));
        }
        resolver.registerExecutor("app0", "exec2", dataContext.createExecutorInfo("foobar"));
        try {
            resolver.getBlockData("app0", "exec2", "shuffle_1_1_0");
            Assert.fail((String)"Should have failed");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        resolver.registerExecutor("app0", "exec3", dataContext.createExecutorInfo("org.apache.spark.shuffle.sort.SortShuffleManager"));
        try {
            resolver.getBlockData("app0", "exec3", "shuffle_1_1_0");
            Assert.fail((String)"Should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSortShuffleBlocks() throws IOException {
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(conf);
        resolver.registerExecutor("app0", "exec0", dataContext.createExecutorInfo("org.apache.spark.shuffle.sort.SortShuffleManager"));
        InputStream block0Stream = resolver.getBlockData("app0", "exec0", "shuffle_0_0_0").createInputStream();
        String block0 = CharStreams.toString((Readable)new InputStreamReader(block0Stream));
        block0Stream.close();
        Assert.assertEquals((Object)sortBlock0, (Object)block0);
        InputStream block1Stream = resolver.getBlockData("app0", "exec0", "shuffle_0_0_1").createInputStream();
        String block1 = CharStreams.toString((Readable)new InputStreamReader(block1Stream));
        block1Stream.close();
        Assert.assertEquals((Object)sortBlock1, (Object)block1);
    }

    @Test
    public void testHashShuffleBlocks() throws IOException {
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(conf);
        resolver.registerExecutor("app0", "exec0", dataContext.createExecutorInfo("org.apache.spark.shuffle.hash.HashShuffleManager"));
        InputStream block0Stream = resolver.getBlockData("app0", "exec0", "shuffle_1_0_0").createInputStream();
        String block0 = CharStreams.toString((Readable)new InputStreamReader(block0Stream));
        block0Stream.close();
        Assert.assertEquals((Object)hashBlock0, (Object)block0);
        InputStream block1Stream = resolver.getBlockData("app0", "exec0", "shuffle_1_0_1").createInputStream();
        String block1 = CharStreams.toString((Readable)new InputStreamReader(block1Stream));
        block1Stream.close();
        Assert.assertEquals((Object)hashBlock1, (Object)block1);
    }

    static {
        conf = new TransportConf((ConfigProvider)new SystemPropertyConfigProvider());
    }
}

