/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.ChunkReceivedCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.sasl.SaslClientBootstrap;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.OneForOneStreamManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class SaslIntegrationSuite {
    private static final long TIMEOUT_MS = 10000L;
    static TransportServer server;
    static TransportConf conf;
    static TransportContext context;
    static SecretKeyHolder secretKeyHolder;
    TransportClientFactory clientFactory;

    @BeforeClass
    public static void beforeAll() throws IOException {
        conf = new TransportConf("shuffle", (ConfigProvider)MapConfigProvider.EMPTY);
        context = new TransportContext(conf, (RpcHandler)new TestRpcHandler());
        secretKeyHolder = (SecretKeyHolder)Mockito.mock(SecretKeyHolder.class);
        Mockito.when((Object)secretKeyHolder.getSaslUser((String)Mockito.eq((Object)"app-1"))).thenReturn((Object)"app-1");
        Mockito.when((Object)secretKeyHolder.getSecretKey((String)Mockito.eq((Object)"app-1"))).thenReturn((Object)"app-1");
        Mockito.when((Object)secretKeyHolder.getSaslUser((String)Mockito.eq((Object)"app-2"))).thenReturn((Object)"app-2");
        Mockito.when((Object)secretKeyHolder.getSecretKey((String)Mockito.eq((Object)"app-2"))).thenReturn((Object)"app-2");
        Mockito.when((Object)secretKeyHolder.getSaslUser(Mockito.anyString())).thenReturn((Object)"other-app");
        Mockito.when((Object)secretKeyHolder.getSecretKey(Mockito.anyString())).thenReturn((Object)"correct-password");
        SaslServerBootstrap bootstrap = new SaslServerBootstrap(conf, secretKeyHolder);
        server = context.createServer(Arrays.asList(bootstrap));
    }

    @AfterClass
    public static void afterAll() {
        server.close();
    }

    @After
    public void afterEach() {
        if (this.clientFactory != null) {
            this.clientFactory.close();
            this.clientFactory = null;
        }
    }

    @Test
    public void testGoodClient() throws IOException, InterruptedException {
        this.clientFactory = context.createClientFactory(Arrays.asList(new SaslClientBootstrap(conf, "app-1", secretKeyHolder)));
        TransportClient client = this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        String msg = "Hello, World!";
        ByteBuffer resp = client.sendRpcSync(JavaUtils.stringToBytes((String)msg), 10000L);
        Assert.assertEquals((Object)msg, (Object)JavaUtils.bytesToString((ByteBuffer)resp));
    }

    @Test
    public void testBadClient() {
        SecretKeyHolder badKeyHolder = (SecretKeyHolder)Mockito.mock(SecretKeyHolder.class);
        Mockito.when((Object)badKeyHolder.getSaslUser(Mockito.anyString())).thenReturn((Object)"other-app");
        Mockito.when((Object)badKeyHolder.getSecretKey(Mockito.anyString())).thenReturn((Object)"wrong-password");
        this.clientFactory = context.createClientFactory(Arrays.asList(new SaslClientBootstrap(conf, "unknown-app", badKeyHolder)));
        try {
            this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
            Assert.fail((String)"Connection should have failed.");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Mismatched response"));
        }
    }

    @Test
    public void testNoSaslClient() throws IOException, InterruptedException {
        this.clientFactory = context.createClientFactory(new ArrayList());
        TransportClient client = this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        try {
            client.sendRpcSync(ByteBuffer.allocate(13), 10000L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Expected SaslMessage"));
        }
        try {
            client.sendRpcSync(ByteBuffer.wrap(new byte[]{-22}), 10000L);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("java.lang.IndexOutOfBoundsException"));
        }
    }

    @Test
    public void testNoSaslServer() {
        TestRpcHandler handler = new TestRpcHandler();
        TransportContext context = new TransportContext(conf, (RpcHandler)handler);
        this.clientFactory = context.createClientFactory(Arrays.asList(new SaslClientBootstrap(conf, "app-1", secretKeyHolder)));
        try (TransportServer server = context.createServer();){
            this.clientFactory.createClient(TestUtils.getLocalHost(), server.getPort());
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Digest-challenge format violation"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppIsolation() throws Exception {
        ExternalShuffleBlockResolver blockResolver = (ExternalShuffleBlockResolver)Mockito.mock(ExternalShuffleBlockResolver.class);
        ExternalShuffleBlockHandler blockHandler = new ExternalShuffleBlockHandler(new OneForOneStreamManager(), blockResolver);
        SaslServerBootstrap bootstrap = new SaslServerBootstrap(conf, secretKeyHolder);
        TransportContext blockServerContext = new TransportContext(conf, (RpcHandler)blockHandler);
        TransportServer blockServer = blockServerContext.createServer(Arrays.asList(bootstrap));
        TransportClient client1 = null;
        TransportClient client2 = null;
        TransportClientFactory clientFactory2 = null;
        try {
            this.clientFactory = blockServerContext.createClientFactory(Arrays.asList(new SaslClientBootstrap(conf, "app-1", secretKeyHolder)));
            client1 = this.clientFactory.createClient(TestUtils.getLocalHost(), blockServer.getPort());
            final AtomicReference exception = new AtomicReference();
            final CountDownLatch blockFetchLatch = new CountDownLatch(1);
            BlockFetchingListener listener = new BlockFetchingListener(){

                public void onBlockFetchSuccess(String blockId, ManagedBuffer data) {
                    blockFetchLatch.countDown();
                }

                public void onBlockFetchFailure(String blockId, Throwable t) {
                    exception.set(t);
                    blockFetchLatch.countDown();
                }
            };
            String[] blockIds = new String[]{"shuffle_2_3_4", "shuffle_6_7_8"};
            OneForOneBlockFetcher fetcher = new OneForOneBlockFetcher(client1, "app-2", "0", blockIds, listener, conf);
            fetcher.start();
            blockFetchLatch.await();
            SaslIntegrationSuite.checkSecurityException((Throwable)exception.get());
            ExecutorShuffleInfo executorInfo = new ExecutorShuffleInfo(new String[]{System.getProperty("java.io.tmpdir")}, 1, "org.apache.spark.shuffle.sort.SortShuffleManager");
            RegisterExecutor regmsg = new RegisterExecutor("app-1", "0", executorInfo);
            client1.sendRpcSync(regmsg.toByteBuffer(), 10000L);
            OpenBlocks openMessage = new OpenBlocks("app-1", "0", blockIds);
            ByteBuffer response = client1.sendRpcSync(openMessage.toByteBuffer(), 10000L);
            StreamHandle stream = (StreamHandle)BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)response);
            long streamId = stream.streamId;
            clientFactory2 = blockServerContext.createClientFactory(Arrays.asList(new SaslClientBootstrap(conf, "app-2", secretKeyHolder)));
            client2 = clientFactory2.createClient(TestUtils.getLocalHost(), blockServer.getPort());
            final CountDownLatch chunkReceivedLatch = new CountDownLatch(1);
            ChunkReceivedCallback callback = new ChunkReceivedCallback(){

                public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
                    chunkReceivedLatch.countDown();
                }

                public void onFailure(int chunkIndex, Throwable t) {
                    exception.set(t);
                    chunkReceivedLatch.countDown();
                }
            };
            exception.set(null);
            client2.fetchChunk(streamId, 0, callback);
            chunkReceivedLatch.await();
            SaslIntegrationSuite.checkSecurityException((Throwable)exception.get());
        }
        finally {
            if (client1 != null) {
                client1.close();
            }
            if (client2 != null) {
                client2.close();
            }
            if (clientFactory2 != null) {
                clientFactory2.close();
            }
            blockServer.close();
        }
    }

    private static void checkSecurityException(Throwable t) {
        Assert.assertNotNull((String)"No exception was caught.", (Object)t);
        Assert.assertTrue((String)"Expected SecurityException.", (boolean)t.getMessage().contains(SecurityException.class.getName()));
    }

    public static class TestRpcHandler
    extends RpcHandler {
        public void receive(TransportClient client, ByteBuffer message, RpcResponseCallback callback) {
            callback.onSuccess(message);
        }

        public StreamManager getStreamManager() {
            return new OneForOneStreamManager();
        }
    }
}

