/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.nio.ByteBuffer;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.RegisterExecutor;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.junit.Assert;
import org.junit.Test;

public class BlockTransferMessagesSuite {
    @Test
    public void serializeOpenShuffleBlocks() {
        this.checkSerializeDeserialize((BlockTransferMessage)new OpenBlocks("app-1", "exec-2", new String[]{"b1", "b2"}));
        this.checkSerializeDeserialize((BlockTransferMessage)new RegisterExecutor("app-1", "exec-2", new ExecutorShuffleInfo(new String[]{"/local1", "/local2"}, 32, "MyShuffleManager")));
        this.checkSerializeDeserialize((BlockTransferMessage)new UploadBlock("app-1", "exec-2", "block-3", new byte[]{1, 2}, new byte[]{4, 5, 6, 7}));
        this.checkSerializeDeserialize((BlockTransferMessage)new StreamHandle(12345L, 16));
    }

    private void checkSerializeDeserialize(BlockTransferMessage msg) {
        BlockTransferMessage msg2 = BlockTransferMessage.Decoder.fromByteBuffer((ByteBuffer)msg.toByteBuffer());
        Assert.assertEquals((Object)msg, (Object)msg2);
        Assert.assertEquals((long)msg.hashCode(), (long)msg2.hashCode());
        Assert.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }
}

