/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.util.Arrays;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.ChunkReceivedCallback;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.apache.spark.network.shuffle.protocol.OpenBlocks;
import org.apache.spark.network.shuffle.protocol.StreamHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneForOneBlockFetcher {
    private final Logger logger = LoggerFactory.getLogger(OneForOneBlockFetcher.class);
    private final TransportClient client;
    private final OpenBlocks openMessage;
    private final String[] blockIds;
    private final BlockFetchingListener listener;
    private final ChunkReceivedCallback chunkCallback;
    private StreamHandle streamHandle = null;

    public OneForOneBlockFetcher(TransportClient client, String appId, String execId, String[] blockIds, BlockFetchingListener listener) {
        this.client = client;
        this.openMessage = new OpenBlocks(appId, execId, blockIds);
        this.blockIds = blockIds;
        this.listener = listener;
        this.chunkCallback = new ChunkCallback();
    }

    public void start() {
        if (this.blockIds.length == 0) {
            throw new IllegalArgumentException("Zero-sized blockIds array");
        }
        this.client.sendRpc(this.openMessage.toByteArray(), new RpcResponseCallback(){

            public void onSuccess(byte[] response) {
                try {
                    OneForOneBlockFetcher.this.streamHandle = (StreamHandle)BlockTransferMessage.Decoder.fromByteArray(response);
                    OneForOneBlockFetcher.this.logger.trace("Successfully opened blocks {}, preparing to fetch chunks.", (Object)OneForOneBlockFetcher.this.streamHandle);
                    for (int i = 0; i < ((OneForOneBlockFetcher)OneForOneBlockFetcher.this).streamHandle.numChunks; ++i) {
                        OneForOneBlockFetcher.this.client.fetchChunk(((OneForOneBlockFetcher)OneForOneBlockFetcher.this).streamHandle.streamId, i, OneForOneBlockFetcher.this.chunkCallback);
                    }
                }
                catch (Exception e) {
                    OneForOneBlockFetcher.this.logger.error("Failed while starting block fetches after success", (Throwable)e);
                    OneForOneBlockFetcher.this.failRemainingBlocks(OneForOneBlockFetcher.this.blockIds, e);
                }
            }

            public void onFailure(Throwable e) {
                OneForOneBlockFetcher.this.logger.error("Failed while starting block fetches", e);
                OneForOneBlockFetcher.this.failRemainingBlocks(OneForOneBlockFetcher.this.blockIds, e);
            }
        });
    }

    private void failRemainingBlocks(String[] failedBlockIds, Throwable e) {
        for (String blockId : failedBlockIds) {
            try {
                this.listener.onBlockFetchFailure(blockId, e);
            }
            catch (Exception e2) {
                this.logger.error("Error in block fetch failure callback", (Throwable)e2);
            }
        }
    }

    private class ChunkCallback
    implements ChunkReceivedCallback {
        private ChunkCallback() {
        }

        public void onSuccess(int chunkIndex, ManagedBuffer buffer) {
            OneForOneBlockFetcher.this.listener.onBlockFetchSuccess(OneForOneBlockFetcher.this.blockIds[chunkIndex], buffer);
        }

        public void onFailure(int chunkIndex, Throwable e) {
            String[] remainingBlockIds = Arrays.copyOfRange(OneForOneBlockFetcher.this.blockIds, chunkIndex, OneForOneBlockFetcher.this.blockIds.length);
            OneForOneBlockFetcher.this.failRemainingBlocks(remainingBlockIds, e);
        }
    }
}

