/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.Assert;
import org.junit.Test;

public class ExternalShuffleCleanupSuite {
    Executor sameThreadExecutor = MoreExecutors.sameThreadExecutor();
    TransportConf conf = new TransportConf("shuffle", (ConfigProvider)new SystemPropertyConfigProvider());

    @Test
    public void noCleanupAndCleanup() throws IOException {
        TestShuffleDataContext dataContext = this.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext.createExecutorInfo("shuffleMgr"));
        resolver.applicationRemoved("app", false);
        this.assertStillThere(dataContext);
        resolver.registerExecutor("app", "exec1", dataContext.createExecutorInfo("shuffleMgr"));
        resolver.applicationRemoved("app", true);
        this.assertCleanedUp(dataContext);
    }

    @Test
    public void cleanupUsesExecutor() throws IOException {
        TestShuffleDataContext dataContext = this.createSomeData();
        final AtomicBoolean cleanupCalled = new AtomicBoolean(false);
        Executor noThreadExecutor = new Executor(){

            @Override
            public void execute(Runnable runnable) {
                cleanupCalled.set(true);
            }
        };
        ExternalShuffleBlockResolver manager = new ExternalShuffleBlockResolver(this.conf, null, noThreadExecutor);
        manager.registerExecutor("app", "exec0", dataContext.createExecutorInfo("shuffleMgr"));
        manager.applicationRemoved("app", true);
        Assert.assertTrue((boolean)cleanupCalled.get());
        this.assertStillThere(dataContext);
        dataContext.cleanup();
        this.assertCleanedUp(dataContext);
    }

    @Test
    public void cleanupMultipleExecutors() throws IOException {
        TestShuffleDataContext dataContext0 = this.createSomeData();
        TestShuffleDataContext dataContext1 = this.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app", "exec0", dataContext0.createExecutorInfo("shuffleMgr"));
        resolver.registerExecutor("app", "exec1", dataContext1.createExecutorInfo("shuffleMgr"));
        resolver.applicationRemoved("app", true);
        this.assertCleanedUp(dataContext0);
        this.assertCleanedUp(dataContext1);
    }

    @Test
    public void cleanupOnlyRemovedApp() throws IOException {
        TestShuffleDataContext dataContext0 = this.createSomeData();
        TestShuffleDataContext dataContext1 = this.createSomeData();
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(this.conf, null, this.sameThreadExecutor);
        resolver.registerExecutor("app-0", "exec0", dataContext0.createExecutorInfo("shuffleMgr"));
        resolver.registerExecutor("app-1", "exec0", dataContext1.createExecutorInfo("shuffleMgr"));
        resolver.applicationRemoved("app-nonexistent", true);
        this.assertStillThere(dataContext0);
        this.assertStillThere(dataContext1);
        resolver.applicationRemoved("app-0", true);
        this.assertCleanedUp(dataContext0);
        this.assertStillThere(dataContext1);
        resolver.applicationRemoved("app-1", true);
        this.assertCleanedUp(dataContext0);
        this.assertCleanedUp(dataContext1);
        resolver.applicationRemoved("app-1", true);
        this.assertCleanedUp(dataContext0);
        this.assertCleanedUp(dataContext1);
    }

    private void assertStillThere(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            Assert.assertTrue((String)(localDir + " was cleaned up prematurely"), (boolean)new File(localDir).exists());
        }
    }

    private void assertCleanedUp(TestShuffleDataContext dataContext) {
        for (String localDir : dataContext.localDirs) {
            Assert.assertFalse((String)(localDir + " wasn't cleaned up"), (boolean)new File(localDir).exists());
        }
    }

    private TestShuffleDataContext createSomeData() throws IOException {
        Random rand = new Random(123L);
        TestShuffleDataContext dataContext = new TestShuffleDataContext(10, 5);
        dataContext.create();
        dataContext.insertSortShuffleData(rand.nextInt(1000), rand.nextInt(1000), new byte[][]{"ABC".getBytes(), "DEF".getBytes()});
        dataContext.insertHashShuffleData(rand.nextInt(1000), rand.nextInt(1000) + 1000, new byte[][]{"GHI".getBytes(), "JKLMNOPQRSTUVWXYZ".getBytes()});
        return dataContext;
    }
}

