/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.spark.network.TestUtils;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.shuffle.ExternalShuffleClient;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExternalShuffleIntegrationSuite {
    static String APP_ID = "app-id";
    static String SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";
    static String HASH_MANAGER = "org.apache.spark.shuffle.hash.HashShuffleManager";
    static TestShuffleDataContext dataContext0;
    static TestShuffleDataContext dataContext1;
    static ExternalShuffleBlockHandler handler;
    static TransportServer server;
    static TransportConf conf;
    static byte[][] exec0Blocks;
    static byte[][] exec1Blocks;

    @BeforeClass
    public static void beforeAll() throws IOException {
        Random rand = new Random();
        for (byte[] block : exec0Blocks) {
            rand.nextBytes(block);
        }
        for (byte[] block : exec1Blocks) {
            rand.nextBytes(block);
        }
        dataContext0 = new TestShuffleDataContext(2, 5);
        dataContext0.create();
        dataContext0.insertSortShuffleData(0, 0, exec0Blocks);
        dataContext1 = new TestShuffleDataContext(6, 2);
        dataContext1.create();
        dataContext1.insertHashShuffleData(1, 0, exec1Blocks);
        conf = new TransportConf("shuffle", (ConfigProvider)new SystemPropertyConfigProvider());
        handler = new ExternalShuffleBlockHandler(conf, null);
        TransportContext transportContext = new TransportContext(conf, (RpcHandler)handler);
        server = transportContext.createServer();
    }

    @AfterClass
    public static void afterAll() {
        dataContext0.cleanup();
        dataContext1.cleanup();
        server.close();
    }

    @After
    public void afterEach() {
        handler.applicationRemoved(APP_ID, false);
    }

    private FetchResult fetchBlocks(String execId, String[] blockIds) throws Exception {
        return this.fetchBlocks(execId, blockIds, server.getPort());
    }

    private FetchResult fetchBlocks(String execId, String[] blockIds, int port) throws Exception {
        final FetchResult res = new FetchResult();
        res.successBlocks = Collections.synchronizedSet(new HashSet());
        res.failedBlocks = Collections.synchronizedSet(new HashSet());
        res.buffers = Collections.synchronizedList(new LinkedList());
        final Semaphore requestsRemaining = new Semaphore(0);
        ExternalShuffleClient client = new ExternalShuffleClient(conf, null, false, false);
        client.init(APP_ID);
        client.fetchBlocks(TestUtils.getLocalHost(), port, execId, blockIds, new BlockFetchingListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onBlockFetchSuccess(String blockId, ManagedBuffer data) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (!res.successBlocks.contains(blockId) && !res.failedBlocks.contains(blockId)) {
                        data.retain();
                        res.successBlocks.add(blockId);
                        res.buffers.add(data);
                        requestsRemaining.release();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onBlockFetchFailure(String blockId, Throwable exception) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (!res.successBlocks.contains(blockId) && !res.failedBlocks.contains(blockId)) {
                        res.failedBlocks.add(blockId);
                        requestsRemaining.release();
                    }
                }
            }
        });
        if (!requestsRemaining.tryAcquire(blockIds.length, 5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Timeout getting response from the server");
        }
        client.close();
        return res;
    }

    @Test
    public void testFetchOneSort() throws Exception {
        this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
        FetchResult exec0Fetch = this.fetchBlocks("exec-0", new String[]{"shuffle_0_0_0"});
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_0_0_0"}), exec0Fetch.successBlocks);
        Assert.assertTrue((boolean)exec0Fetch.failedBlocks.isEmpty());
        this.assertBufferListsEqual(exec0Fetch.buffers, Lists.newArrayList((Object[])new byte[][]{exec0Blocks[0]}));
        exec0Fetch.releaseBuffers();
    }

    @Test
    public void testFetchThreeSort() throws Exception {
        this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
        FetchResult exec0Fetch = this.fetchBlocks("exec-0", new String[]{"shuffle_0_0_0", "shuffle_0_0_1", "shuffle_0_0_2"});
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_0_0_0", "shuffle_0_0_1", "shuffle_0_0_2"}), exec0Fetch.successBlocks);
        Assert.assertTrue((boolean)exec0Fetch.failedBlocks.isEmpty());
        this.assertBufferListsEqual(exec0Fetch.buffers, Lists.newArrayList((Object[])exec0Blocks));
        exec0Fetch.releaseBuffers();
    }

    @Test
    public void testFetchHash() throws Exception {
        this.registerExecutor("exec-1", dataContext1.createExecutorInfo(HASH_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-1", new String[]{"shuffle_1_0_0", "shuffle_1_0_1"});
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_1_0_0", "shuffle_1_0_1"}), execFetch.successBlocks);
        Assert.assertTrue((boolean)execFetch.failedBlocks.isEmpty());
        this.assertBufferListsEqual(execFetch.buffers, Lists.newArrayList((Object[])exec1Blocks));
        execFetch.releaseBuffers();
    }

    @Test
    public void testFetchWrongShuffle() throws Exception {
        this.registerExecutor("exec-1", dataContext1.createExecutorInfo(SORT_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-1", new String[]{"shuffle_1_0_0", "shuffle_1_0_1"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_1_0_0", "shuffle_1_0_1"}), execFetch.failedBlocks);
    }

    @Test
    public void testFetchInvalidShuffle() throws Exception {
        this.registerExecutor("exec-1", dataContext1.createExecutorInfo("unknown sort manager"));
        FetchResult execFetch = this.fetchBlocks("exec-1", new String[]{"shuffle_1_0_0"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_1_0_0"}), execFetch.failedBlocks);
    }

    @Test
    public void testFetchWrongBlockId() throws Exception {
        this.registerExecutor("exec-1", dataContext1.createExecutorInfo(SORT_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-1", new String[]{"rdd_1_0_0"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"rdd_1_0_0"}), execFetch.failedBlocks);
    }

    @Test
    public void testFetchNonexistent() throws Exception {
        this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-0", new String[]{"shuffle_2_0_0"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_2_0_0"}), execFetch.failedBlocks);
    }

    @Test
    public void testFetchWrongExecutor() throws Exception {
        this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-0", new String[]{"shuffle_0_0_0", "shuffle_1_0_0"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_0_0_0", "shuffle_1_0_0"}), execFetch.failedBlocks);
    }

    @Test
    public void testFetchUnregisteredExecutor() throws Exception {
        this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
        FetchResult execFetch = this.fetchBlocks("exec-2", new String[]{"shuffle_0_0_0", "shuffle_1_0_0"});
        Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_0_0_0", "shuffle_1_0_0"}), execFetch.failedBlocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFetchNoServer() throws Exception {
        System.setProperty("spark.shuffle.io.maxRetries", "0");
        try {
            this.registerExecutor("exec-0", dataContext0.createExecutorInfo(SORT_MANAGER));
            FetchResult execFetch = this.fetchBlocks("exec-0", new String[]{"shuffle_1_0_0", "shuffle_1_0_1"}, 1);
            Assert.assertTrue((boolean)execFetch.successBlocks.isEmpty());
            Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"shuffle_1_0_0", "shuffle_1_0_1"}), execFetch.failedBlocks);
        }
        finally {
            System.clearProperty("spark.shuffle.io.maxRetries");
        }
    }

    private void registerExecutor(String executorId, ExecutorShuffleInfo executorInfo) throws IOException {
        ExternalShuffleClient client = new ExternalShuffleClient(conf, null, false, false);
        client.init(APP_ID);
        client.registerWithShuffleServer(TestUtils.getLocalHost(), server.getPort(), executorId, executorInfo);
    }

    private void assertBufferListsEqual(List<ManagedBuffer> list0, List<byte[]> list1) throws Exception {
        Assert.assertEquals((long)list0.size(), (long)list1.size());
        for (int i = 0; i < list0.size(); ++i) {
            this.assertBuffersEqual(list0.get(i), (ManagedBuffer)new NioManagedBuffer(ByteBuffer.wrap(list1.get(i))));
        }
    }

    private void assertBuffersEqual(ManagedBuffer buffer0, ManagedBuffer buffer1) throws Exception {
        ByteBuffer nio0 = buffer0.nioByteBuffer();
        ByteBuffer nio1 = buffer1.nioByteBuffer();
        int len = nio0.remaining();
        Assert.assertEquals((long)nio0.remaining(), (long)nio1.remaining());
        for (int i = 0; i < len; ++i) {
            Assert.assertEquals((long)nio0.get(), (long)nio1.get());
        }
    }

    static {
        exec0Blocks = new byte[][]{new byte[123], new byte[12345], new byte[1234567]};
        exec1Blocks = new byte[][]{new byte[321], new byte[54321]};
    }

    class FetchResult {
        public Set<String> successBlocks;
        public Set<String> failedBlocks;
        public List<ManagedBuffer> buffers;

        FetchResult() {
        }

        public void releaseBuffers() {
            for (ManagedBuffer buffer : this.buffers) {
                buffer.release();
            }
        }
    }
}

