/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.RetryingBlockFetcher;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.SystemPropertyConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationMode;

public class RetryingBlockFetcherSuite {
    ManagedBuffer block0 = new NioManagedBuffer(ByteBuffer.wrap(new byte[13]));
    ManagedBuffer block1 = new NioManagedBuffer(ByteBuffer.wrap(new byte[7]));
    ManagedBuffer block2 = new NioManagedBuffer(ByteBuffer.wrap(new byte[19]));

    @Before
    public void beforeEach() {
        System.setProperty("spark.shuffle.io.maxRetries", "2");
        System.setProperty("spark.shuffle.io.retryWait", "0");
    }

    @After
    public void afterEach() {
        System.clearProperty("spark.shuffle.io.maxRetries");
        System.clearProperty("spark.shuffle.io.retryWait");
    }

    @Test
    public void testNoFailures() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener)).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener)).onBlockFetchSuccess("b1", this.block1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testUnrecoverableFailure() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)new RuntimeException("Ouch!")).put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener)).onBlockFetchFailure((String)Mockito.eq((Object)"b0"), (Throwable)Mockito.any());
        ((BlockFetchingListener)Mockito.verify((Object)listener)).onBlockFetchSuccess("b1", this.block1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testSingleIOExceptionOnFirst() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)new IOException("Connection failed or something")).put((Object)"b1", (Object)this.block1).build(), ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b1", this.block1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testSingleIOExceptionOnSecond() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)new IOException("Connection failed or something")).build(), ImmutableMap.builder().put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b1", this.block1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testTwoIOExceptions() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)new IOException()).put((Object)"b1", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b1", this.block1);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testThreeIOExceptions() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)new IOException()).put((Object)"b1", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b1", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b1", (Object)this.block1).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchFailure((String)Mockito.eq((Object)"b1"), (Throwable)Mockito.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void testRetryAndUnrecoverable() throws IOException {
        BlockFetchingListener listener = (BlockFetchingListener)Mockito.mock(BlockFetchingListener.class);
        List<ImmutableMap> interactions = Arrays.asList(ImmutableMap.builder().put((Object)"b0", (Object)new IOException()).put((Object)"b1", (Object)new RuntimeException()).put((Object)"b2", (Object)this.block2).build(), ImmutableMap.builder().put((Object)"b0", (Object)this.block0).put((Object)"b1", (Object)new RuntimeException()).put((Object)"b2", (Object)new IOException()).build(), ImmutableMap.builder().put((Object)"b2", (Object)this.block2).build());
        RetryingBlockFetcherSuite.performInteractions(interactions, listener);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b0", this.block0);
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchFailure((String)Mockito.eq((Object)"b1"), (Throwable)Mockito.any());
        ((BlockFetchingListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((int)5000))).onBlockFetchSuccess("b2", this.block2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    private static void performInteractions(List<? extends Map<String, Object>> interactions, BlockFetchingListener listener) throws IOException {
        TransportConf conf = new TransportConf("shuffle", (ConfigProvider)new SystemPropertyConfigProvider());
        RetryingBlockFetcher.BlockFetchStarter fetchStarter = (RetryingBlockFetcher.BlockFetchStarter)Mockito.mock(RetryingBlockFetcher.BlockFetchStarter.class);
        Stubber stub = null;
        LinkedHashSet blockIds = Sets.newLinkedHashSet();
        for (final Map<String, Object> map : interactions) {
            blockIds.addAll(map.keySet());
            Answer<Void> answer = new Answer<Void>(){

                public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                    try {
                        Object[] requestedBlockIds = (String[])invocationOnMock.getArguments()[0];
                        Object[] desiredBlockIds = map.keySet().toArray(new String[map.size()]);
                        Assert.assertArrayEquals((Object[])desiredBlockIds, (Object[])requestedBlockIds);
                        BlockFetchingListener retryListener = (BlockFetchingListener)invocationOnMock.getArguments()[1];
                        for (Map.Entry block : map.entrySet()) {
                            String blockId = (String)block.getKey();
                            Object blockValue = block.getValue();
                            if (blockValue instanceof ManagedBuffer) {
                                retryListener.onBlockFetchSuccess(blockId, (ManagedBuffer)blockValue);
                                continue;
                            }
                            if (blockValue instanceof Exception) {
                                retryListener.onBlockFetchFailure(blockId, (Throwable)((Exception)blockValue));
                                continue;
                            }
                            Assert.fail((String)("Can only handle ManagedBuffers and Exceptions, got " + blockValue));
                        }
                        return null;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw e;
                    }
                }
            };
            if (stub == null) {
                stub = Mockito.doAnswer((Answer)answer);
                continue;
            }
            stub.doAnswer((Answer)answer);
        }
        assert (stub != null);
        ((RetryingBlockFetcher.BlockFetchStarter)stub.when((Object)fetchStarter)).createAndStart((String[])Mockito.any(), (BlockFetchingListener)Mockito.anyObject());
        String[] blockIdArray = blockIds.toArray(new String[blockIds.size()]);
        new RetryingBlockFetcher(conf, fetchStarter, blockIdArray, listener).start();
    }
}

