/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;

public class TestShuffleDataContext {
    public final String[] localDirs;
    public final int subDirsPerLocalDir;

    public TestShuffleDataContext(int numLocalDirs, int subDirsPerLocalDir) {
        this.localDirs = new String[numLocalDirs];
        this.subDirsPerLocalDir = subDirsPerLocalDir;
    }

    public void create() {
        for (int i = 0; i < this.localDirs.length; ++i) {
            this.localDirs[i] = Files.createTempDir().getAbsolutePath();
            for (int p = 0; p < this.subDirsPerLocalDir; ++p) {
                new File(this.localDirs[i], String.format("%02x", p)).mkdirs();
            }
        }
    }

    public void cleanup() {
        for (String localDir : this.localDirs) {
            TestShuffleDataContext.deleteRecursively(new File(localDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSortShuffleData(int shuffleId, int mapId, byte[][] blocks) throws IOException {
        String blockId = "shuffle_" + shuffleId + "_" + mapId + "_0";
        FileOutputStream dataStream = null;
        DataOutputStream indexStream = null;
        boolean suppressExceptionsDuringClose = true;
        try {
            dataStream = new FileOutputStream(ExternalShuffleBlockResolver.getFile((String[])this.localDirs, (int)this.subDirsPerLocalDir, (String)(blockId + ".data")));
            indexStream = new DataOutputStream(new FileOutputStream(ExternalShuffleBlockResolver.getFile((String[])this.localDirs, (int)this.subDirsPerLocalDir, (String)(blockId + ".index"))));
            long offset = 0L;
            indexStream.writeLong(offset);
            for (byte[] block : blocks) {
                ((OutputStream)dataStream).write(block);
                indexStream.writeLong(offset += (long)block.length);
            }
            suppressExceptionsDuringClose = false;
        }
        catch (Throwable throwable) {
            Closeables.close(dataStream, (boolean)suppressExceptionsDuringClose);
            Closeables.close(indexStream, (boolean)suppressExceptionsDuringClose);
            throw throwable;
        }
        Closeables.close((Closeable)dataStream, (boolean)suppressExceptionsDuringClose);
        Closeables.close((Closeable)indexStream, (boolean)suppressExceptionsDuringClose);
    }

    public void insertHashShuffleData(int shuffleId, int mapId, byte[][] blocks) throws IOException {
        for (int i = 0; i < blocks.length; ++i) {
            String blockId = "shuffle_" + shuffleId + "_" + mapId + "_" + i;
            Files.write((byte[])blocks[i], (File)ExternalShuffleBlockResolver.getFile((String[])this.localDirs, (int)this.subDirsPerLocalDir, (String)blockId));
        }
    }

    public ExecutorShuffleInfo createExecutorInfo(String shuffleManager) {
        return new ExecutorShuffleInfo(this.localDirs, this.subDirsPerLocalDir, shuffleManager);
    }

    private static void deleteRecursively(File f) {
        File[] children;
        assert (f != null);
        if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File child : children) {
                TestShuffleDataContext.deleteRecursively(child);
            }
        }
        f.delete();
    }
}

