/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import java.nio.ByteBuffer;
import org.apache.spark.network.sasl.ShuffleSecretManager;
import org.junit.Assert;
import org.junit.Test;

public class ShuffleSecretManagerSuite {
    static String app1 = "app1";
    static String app2 = "app2";
    static String pw1 = "password1";
    static String pw2 = "password2";
    static String pw1update = "password1update";
    static String pw2update = "password2update";

    @Test
    public void testMultipleRegisters() {
        ShuffleSecretManager secretManager = new ShuffleSecretManager();
        secretManager.registerApp(app1, pw1);
        Assert.assertEquals((Object)pw1, (Object)secretManager.getSecretKey(app1));
        secretManager.registerApp(app2, ByteBuffer.wrap(pw2.getBytes()));
        Assert.assertEquals((Object)pw2, (Object)secretManager.getSecretKey(app2));
        secretManager.registerApp(app1, pw1update);
        Assert.assertEquals((Object)pw1update, (Object)secretManager.getSecretKey(app1));
        secretManager.registerApp(app2, ByteBuffer.wrap(pw2update.getBytes()));
        Assert.assertEquals((Object)pw2update, (Object)secretManager.getSecretKey(app2));
        secretManager.unregisterApp(app1);
        Assert.assertNull((Object)secretManager.getSecretKey(app1));
        Assert.assertEquals((Object)pw2update, (Object)secretManager.getSecretKey(app2));
        secretManager.unregisterApp(app2);
        Assert.assertNull((Object)secretManager.getSecretKey(app2));
        Assert.assertNull((Object)secretManager.getSecretKey(app1));
    }
}

