/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.spark.network.shuffle.ExternalShuffleBlockResolver;
import org.apache.spark.network.shuffle.TestShuffleDataContext;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.MapConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExternalShuffleBlockResolverSuite {
    private static final String sortBlock0 = "Hello!";
    private static final String sortBlock1 = "World!";
    private static final String SORT_MANAGER = "org.apache.spark.shuffle.sort.SortShuffleManager";
    private static TestShuffleDataContext dataContext;
    private static final TransportConf conf;

    @BeforeClass
    public static void beforeAll() throws IOException {
        dataContext = new TestShuffleDataContext(2, 5);
        dataContext.create();
        dataContext.insertSortShuffleData(0, 0, new byte[][]{sortBlock0.getBytes(StandardCharsets.UTF_8), sortBlock1.getBytes(StandardCharsets.UTF_8)});
    }

    @AfterClass
    public static void afterAll() {
        dataContext.cleanup();
    }

    @Test
    public void testBadRequests() throws IOException {
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(conf, null);
        try {
            resolver.getBlockData("app0", "exec1", 1, 1, 0);
            Assert.fail((String)"Should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)("Bad error message: " + e), (boolean)e.getMessage().contains("not registered"));
        }
        try {
            resolver.registerExecutor("app0", "exec2", dataContext.createExecutorInfo("foobar"));
            resolver.getBlockData("app0", "exec2", 1, 1, 0);
            Assert.fail((String)"Should have failed");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        resolver.registerExecutor("app0", "exec3", dataContext.createExecutorInfo(SORT_MANAGER));
        try {
            resolver.getBlockData("app0", "exec3", 1, 1, 0);
            Assert.fail((String)"Should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSortShuffleBlocks() throws IOException {
        ExternalShuffleBlockResolver resolver = new ExternalShuffleBlockResolver(conf, null);
        resolver.registerExecutor("app0", "exec0", dataContext.createExecutorInfo(SORT_MANAGER));
        InputStream block0Stream = resolver.getBlockData("app0", "exec0", 0, 0, 0).createInputStream();
        String block0 = CharStreams.toString((Readable)new InputStreamReader(block0Stream, StandardCharsets.UTF_8));
        block0Stream.close();
        Assert.assertEquals((Object)sortBlock0, (Object)block0);
        InputStream block1Stream = resolver.getBlockData("app0", "exec0", 0, 0, 1).createInputStream();
        String block1 = CharStreams.toString((Readable)new InputStreamReader(block1Stream, StandardCharsets.UTF_8));
        block1Stream.close();
        Assert.assertEquals((Object)sortBlock1, (Object)block1);
    }

    @Test
    public void jsonSerializationOfExecutorRegistration() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ExternalShuffleBlockResolver.AppExecId appId = new ExternalShuffleBlockResolver.AppExecId("foo", "bar");
        String appIdJson = mapper.writeValueAsString((Object)appId);
        ExternalShuffleBlockResolver.AppExecId parsedAppId = (ExternalShuffleBlockResolver.AppExecId)mapper.readValue(appIdJson, ExternalShuffleBlockResolver.AppExecId.class);
        Assert.assertEquals((Object)parsedAppId, (Object)appId);
        ExecutorShuffleInfo shuffleInfo = new ExecutorShuffleInfo(new String[]{"/bippy", "/flippy"}, 7, SORT_MANAGER);
        String shuffleJson = mapper.writeValueAsString((Object)shuffleInfo);
        ExecutorShuffleInfo parsedShuffleInfo = (ExecutorShuffleInfo)mapper.readValue(shuffleJson, ExecutorShuffleInfo.class);
        Assert.assertEquals((Object)parsedShuffleInfo, (Object)shuffleInfo);
        String legacyAppIdJson = "{\"appId\":\"foo\", \"execId\":\"bar\"}";
        Assert.assertEquals((Object)appId, (Object)mapper.readValue(legacyAppIdJson, ExternalShuffleBlockResolver.AppExecId.class));
        String legacyShuffleJson = "{\"localDirs\": [\"/bippy\", \"/flippy\"], \"subDirsPerLocalDir\": 7, \"shuffleManager\": \"org.apache.spark.shuffle.sort.SortShuffleManager\"}";
        Assert.assertEquals((Object)shuffleInfo, (Object)mapper.readValue(legacyShuffleJson, ExecutorShuffleInfo.class));
    }

    static {
        conf = new TransportConf("shuffle", (ConfigProvider)MapConfigProvider.EMPTY);
    }
}

