/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.Request$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.KafkaTestUtils$;
import org.apache.spark.sql.kafka010.KafkaTestUtils$$anonfun$org$apache$spark$sql$kafka010$KafkaTestUtils$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.scalactic.source.Position;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.SpanSugar$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\rue\u0001B\u0001\u0003\u00015\u0011abS1gW\u0006$Vm\u001d;Vi&d7O\u0003\u0002\u0004\t\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017BA\r\u0017\u0005\u001daunZ4j]\u001eD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0010o&$\bN\u0011:pW\u0016\u0014\bK]8qgB!Q\u0004I\u0012'\u001d\tya$\u0003\u0002 !\u00051\u0001K]3eK\u001aL!!\t\u0012\u0003\u00075\u000b\u0007O\u0003\u0002 !A\u0011Q\u0004J\u0005\u0003K\t\u0012aa\u0015;sS:<\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007\u001f\nTWm\u0019;\t\u000b=\u0002A\u0011\u0001\u0019\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t!\u0001C\u0004\u001c]A\u0005\t\u0019\u0001\u000f\t\u000fU\u0002!\u0019!C\u0005m\u00051!p\u001b%pgR,\u0012a\u000e\t\u0003OaJ!!\n\u0015\t\ri\u0002\u0001\u0015!\u00038\u0003\u001dQ8\u000eS8ti\u0002Bq\u0001\u0010\u0001A\u0002\u0013%Q(\u0001\u0004{WB{'\u000f^\u000b\u0002}A\u0011qbP\u0005\u0003\u0001B\u00111!\u00138u\u0011\u001d\u0011\u0005\u00011A\u0005\n\r\u000b!B_6Q_J$x\fJ3r)\t!u\t\u0005\u0002\u0010\u000b&\u0011a\t\u0005\u0002\u0005+:LG\u000fC\u0004I\u0003\u0006\u0005\t\u0019\u0001 \u0002\u0007a$\u0013\u0007\u0003\u0004K\u0001\u0001\u0006KAP\u0001\bu.\u0004vN\u001d;!\u0011\u001da\u0005A1A\u0005\nu\n1C_6D_:tWm\u0019;j_:$\u0016.\\3pkRDaA\u0014\u0001!\u0002\u0013q\u0014\u0001\u0006>l\u0007>tg.Z2uS>tG+[7f_V$\b\u0005C\u0004Q\u0001\t\u0007I\u0011B\u001f\u0002!i\\7+Z:tS>tG+[7f_V$\bB\u0002*\u0001A\u0003%a(A\t{WN+7o]5p]RKW.Z8vi\u0002B\u0011\u0002\u0016\u0001A\u0002\u0003\u0007I\u0011B+\u0002\u0013i|wn[3fa\u0016\u0014X#\u0001,\u0011\u0005]CV\"\u0001\u0001\u0007\te\u0003AA\u0017\u0002\u0012\u000b6\u0014W\r\u001a3fIj{wn[3fa\u0016\u00148C\u0001-\u000f\u0011!a\u0006L!b\u0001\n\u0003i\u0016!\u0003>l\u0007>tg.Z2u+\u0005\u0019\u0003\u0002C0Y\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u0015i\\7i\u001c8oK\u000e$\b\u0005C\u000301\u0012\u0005\u0011\r\u0006\u0002WE\")A\f\u0019a\u0001G!9A\r\u0017b\u0001\n\u0003)\u0017aC:oCB\u001c\bn\u001c;ESJ,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S*\n!![8\n\u0005-D'\u0001\u0002$jY\u0016Da!\u001c-!\u0002\u00131\u0017\u0001D:oCB\u001c\bn\u001c;ESJ\u0004\u0003bB8Y\u0005\u0004%\t!Z\u0001\u0007Y><G)\u001b:\t\rED\u0006\u0015!\u0003g\u0003\u001dawn\u001a#je\u0002Bq\u0001\u0016-C\u0002\u0013\u00051/F\u0001u!\t)\u00180D\u0001w\u0015\t9\b0\u0001\u0004tKJ4XM\u001d\u0006\u0003)\"I!A\u001f<\u0003\u001fi{wnS3fa\u0016\u00148+\u001a:wKJDa\u0001 -!\u0002\u0013!\u0018A\u0003>p_.,W\r]3sA!Qa\u0010\u0017I\u0001\u0002\u0007\u0005\u000b\u0011B@\u0002\u0007a$C\u0007E\u0003\u0010\u0003\u00039d(C\u0002\u0002\u0004A\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CA\u00041\n\u0007I\u0011\u0001\u001c\u0002\u0005%\u0004\bbBA\u00061\u0002\u0006IaN\u0001\u0004SB\u0004\u0003\u0002CA\b1\n\u0007I\u0011A\u001f\u0002\tA|'\u000f\u001e\u0005\b\u0003'A\u0006\u0015!\u0003?\u0003\u0015\u0001xN\u001d;!\u0011%\t9\u0002\u0017b\u0001\n\u0003\tI\"A\u0004gC\u000e$xN]=\u0016\u0005\u0005m\u0001cA;\u0002\u001e%\u0019\u0011q\u0004<\u0003)9KujU3sm\u0016\u00148I\u001c=o\r\u0006\u001cGo\u001c:z\u0011!\t\u0019\u0003\u0017Q\u0001\n\u0005m\u0011\u0001\u00034bGR|'/\u001f\u0011\t\u0011\u0005\u001d\u0002L1A\u0005\u0002u\n!\"Y2uk\u0006d\u0007k\u001c:u\u0011\u001d\tY\u0003\u0017Q\u0001\ny\n1\"Y2uk\u0006d\u0007k\u001c:uA!9\u0011q\u0006-\u0005\u0002\u0005E\u0012\u0001C:ikR$wn\u001e8\u0015\u0003\u0011C1\"!\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00028\u0005i!p\\8lK\u0016\u0004XM]0%KF$2\u0001RA\u001d\u0011!A\u00151GA\u0001\u0002\u00041\u0006B\u0002?\u0001A\u0003&a\u000bC\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0013a\u0002>l+RLGn]\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0003vi&d7O\u0003\u0002\u0002N\u0005)1.\u00194lC&!\u0011\u0011KA$\u0005\u001dQ6.\u0016;jYND1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\u0005Y!p[+uS2\u001cx\fJ3r)\r!\u0015\u0011\f\u0005\n\u0011\u0006M\u0013\u0011!a\u0001\u0003\u0007B\u0001\"!\u0018\u0001A\u0003&\u00111I\u0001\tu.,F/\u001b7tA!I\u0011\u0011\r\u0001A\u0002\u0013%\u00111M\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/\u0006\u0002\u0002fA!\u0011qMA:\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!B1e[&t'\u0002BA8\u0003c\nqa\u00197jK:$8OC\u0002\u0002N!IA!!\u001e\u0002j\tY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0011%\tI\b\u0001a\u0001\n\u0013\tY(A\bbI6Lgn\u00117jK:$x\fJ3r)\r!\u0015Q\u0010\u0005\n\u0011\u0006]\u0014\u0011!a\u0001\u0003KB\u0001\"!!\u0001A\u0003&\u0011QM\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000f\t\u0005\t\u0003\u000b\u0003!\u0019!C\u0005m\u0005Q!M]8lKJDun\u001d;\t\u000f\u0005%\u0005\u0001)A\u0005o\u0005Y!M]8lKJDun\u001d;!\u0011!\ti\t\u0001a\u0001\n\u0013i\u0014A\u00032s_.,'\u000fU8si\"I\u0011\u0011\u0013\u0001A\u0002\u0013%\u00111S\u0001\u000fEJ|7.\u001a:Q_J$x\fJ3r)\r!\u0015Q\u0013\u0005\t\u0011\u0006=\u0015\u0011!a\u0001}!9\u0011\u0011\u0014\u0001!B\u0013q\u0014a\u00032s_.,'\u000fU8si\u0002B1\"!(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 \u0006Q!M]8lKJ\u001cuN\u001c4\u0016\u0005\u0005\u0005\u0006\u0003BAR\u0003Ok!!!*\u000b\u0007]\fY%\u0003\u0003\u0002*\u0006\u0015&aC&bM.\f7i\u001c8gS\u001eD1\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\u0006q!M]8lKJ\u001cuN\u001c4`I\u0015\fHc\u0001#\u00022\"I\u0001*a+\u0002\u0002\u0003\u0007\u0011\u0011\u0015\u0005\t\u0003k\u0003\u0001\u0015)\u0003\u0002\"\u0006Y!M]8lKJ\u001cuN\u001c4!\u0011)9\b\u00011AA\u0002\u0013%\u0011\u0011X\u000b\u0003\u0003w\u0003B!a)\u0002>&!\u0011qXAS\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u0017\u0005\r\u0007\u00011AA\u0002\u0013%\u0011QY\u0001\u000bg\u0016\u0014h/\u001a:`I\u0015\fHc\u0001#\u0002H\"I\u0001*!1\u0002\u0002\u0003\u0007\u00111\u0018\u0005\t\u0003\u0017\u0004\u0001\u0015)\u0003\u0002<\u000691/\u001a:wKJ\u0004\u0003bCAh\u0001\u0001\u0007\t\u0019!C\u0005\u0003#\f\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0003\u0003'\u0004b!!6\u0002Z\u000e\u001aSBAAl\u0015\u0011\ty-!\u001c\n\t\u0005m\u0017q\u001b\u0002\t!J|G-^2fe\"Y\u0011q\u001c\u0001A\u0002\u0003\u0007I\u0011BAq\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\r!\u00151\u001d\u0005\n\u0011\u0006u\u0017\u0011!a\u0001\u0003'D\u0001\"a:\u0001A\u0003&\u00111[\u0001\naJ|G-^2fe\u0002B\u0011\"a;\u0001\u0001\u0004%I!!<\u0002\u000fi\\'+Z1esV\u0011\u0011q\u001e\t\u0004\u001f\u0005E\u0018bAAz!\t9!i\\8mK\u0006t\u0007\"CA|\u0001\u0001\u0007I\u0011BA}\u0003-Q8NU3bIf|F%Z9\u0015\u0007\u0011\u000bY\u0010C\u0005I\u0003k\f\t\u00111\u0001\u0002p\"A\u0011q \u0001!B\u0013\ty/\u0001\u0005{WJ+\u0017\rZ=!\u0011%\u0011\u0019\u0001\u0001a\u0001\n\u0013\ti/A\u0006ce>\\WM\u001d*fC\u0012L\b\"\u0003B\u0004\u0001\u0001\u0007I\u0011\u0002B\u0005\u0003=\u0011'o\\6feJ+\u0017\rZ=`I\u0015\fHc\u0001#\u0003\f!I\u0001J!\u0002\u0002\u0002\u0003\u0007\u0011q\u001e\u0005\t\u0005\u001f\u0001\u0001\u0015)\u0003\u0002p\u0006a!M]8lKJ\u0014V-\u00193zA!I!1\u0003\u0001A\u0002\u0013%!QC\u0001\rY\u0016\f7\u000eR3uK\u000e$xN]\u000b\u0002\u001d!I!\u0011\u0004\u0001A\u0002\u0013%!1D\u0001\u0011Y\u0016\f7\u000eR3uK\u000e$xN]0%KF$2\u0001\u0012B\u000f\u0011!A%qCA\u0001\u0002\u0004q\u0001b\u0002B\u0011\u0001\u0001\u0006KAD\u0001\u000eY\u0016\f7\u000eR3uK\u000e$xN\u001d\u0011\t\r\t\u0015\u0002\u0001\"\u0001^\u0003%Q8.\u00113ee\u0016\u001c8\u000f\u0003\u0004\u0003*\u0001!\t!X\u0001\u000eEJ|7.\u001a:BI\u0012\u0014Xm]:\t\u000f\t5\u0002\u0001\"\u0001\u0002B\u0005y!p\\8lK\u0016\u0004XM]\"mS\u0016tG\u000fC\u0004\u00032\u0001!I!!\r\u0002-M,G/\u001e9F[\n,G\rZ3e5>|7.Z3qKJDqA!\u000e\u0001\t\u0013\t\t$\u0001\rtKR,\b/R7cK\u0012$W\rZ&bM.\f7+\u001a:wKJDqA!\u000f\u0001\t\u0003\t\t$A\u0003tKR,\b\u000fC\u0004\u0003>\u0001!\t!!\r\u0002\u0011Q,\u0017M\u001d3po:DqA!\u0011\u0001\t\u0003\u0011\u0019%A\u0006de\u0016\fG/\u001a+pa&\u001cGc\u0002#\u0003F\t%#Q\n\u0005\b\u0005\u000f\u0012y\u00041\u0001$\u0003\u0015!x\u000e]5d\u0011\u001d\u0011YEa\u0010A\u0002y\n!\u0002]1si&$\u0018n\u001c8t\u0011)\u0011yEa\u0010\u0011\u0002\u0003\u0007\u0011q^\u0001\n_Z,'o\u001e:ji\u0016DqAa\u0015\u0001\t\u0003\u0011)&\u0001\u000fhKR\fE\u000e\u001c+pa&\u001c7/\u00118e!\u0006\u0014H/\u001b;j_:\u001c\u0016N_3\u0015\u0005\t]\u0003C\u0002B-\u0005S\u0012yG\u0004\u0003\u0003\\\t\u0015d\u0002\u0002B/\u0005Gj!Aa\u0018\u000b\u0007\t\u0005D\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0019!q\r\t\u0002\u000fA\f7m[1hK&!!1\u000eB7\u0005\r\u0019V-\u001d\u0006\u0004\u0005O\u0002\u0002#B\b\u0002\u0002\rr\u0004b\u0002B!\u0001\u0011\u0005!1\u000f\u000b\u0004\t\nU\u0004b\u0002B$\u0005c\u0002\ra\t\u0005\b\u0005s\u0002A\u0011\u0001B>\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007\u0011\u0013i\bC\u0004\u0003H\t]\u0004\u0019A\u0012\t\u000f\t\u0005\u0005\u0001\"\u0001\u0003\u0004\u0006i\u0011\r\u001a3QCJ$\u0018\u000e^5p]N$R\u0001\u0012BC\u0005\u000fCqAa\u0012\u0003\u0000\u0001\u00071\u0005C\u0004\u0003L\t}\u0004\u0019\u0001 \t\u000f\t-\u0005\u0001\"\u0001\u0003\u000e\u0006a1/\u001a8e\u001b\u0016\u001c8/Y4fgR)AIa$\u0003\u0012\"9!q\tBE\u0001\u0004\u0019\u0003\u0002\u0003BJ\u0005\u0013\u0003\rA!&\u0002\u001b5,7o]1hKR{gI]3r!\u001d\u00119J!($\u0005?k!A!'\u000b\u0007\tm%&\u0001\u0003vi&d\u0017bA\u0011\u0003\u001aB\u0019qE!)\n\u0007\t\r\u0006FA\u0004J]R,w-\u001a:\t\u000f\t-\u0005\u0001\"\u0001\u0003(R)AI!+\u0003,\"9!q\tBS\u0001\u0004\u0019\u0003\u0002\u0003BJ\u0005K\u0003\rA!,\u0011\tu\u00013E\u0010\u0005\b\u0005\u0017\u0003A\u0011\u0001BY)\u0019\u0011\u0019L!0\u0003@B1!\u0011\fB5\u0005k\u0003baDA\u0001G\t]\u0006\u0003BAk\u0005sKAAa/\u0002X\nq!+Z2pe\u0012lU\r^1eCR\f\u0007b\u0002B$\u0005_\u0003\ra\t\u0005\t\u0005\u0003\u0014y\u000b1\u0001\u0003D\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0010\u0005\u000b\u001c\u0013b\u0001Bd!\t)\u0011I\u001d:bs\"9!1\u0012\u0001\u0005\u0002\t-G\u0003\u0003BZ\u0005\u001b\u0014yM!5\t\u000f\t\u001d#\u0011\u001aa\u0001G!A!\u0011\u0019Be\u0001\u0004\u0011\u0019\r\u0003\u0005\u0003T\n%\u0007\u0019\u0001Bk\u0003%\u0001\u0018M\u001d;ji&|g\u000e\u0005\u0003\u0010\u0005/t\u0014b\u0001Bm!\t1q\n\u001d;j_:DqA!8\u0001\t\u0003\t\t$A\u0006dY\u0016\fg.\u001e9M_\u001e\u001c\bb\u0002Bq\u0001\u0011\u0005!1]\u0001\u0013O\u0016$X)\u0019:mS\u0016\u001cHo\u00144gg\u0016$8\u000f\u0006\u0003\u0003f\ne\bCB\u000f!\u0005O\u0014\u0019\u0010\u0005\u0003\u0003j\n=XB\u0001Bv\u0015\u0011\u0011i/!\u001d\u0002\r\r|W.\\8o\u0013\u0011\u0011\tPa;\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0019qB!>\n\u0007\t]\bC\u0001\u0003M_:<\u0007\u0002\u0003B~\u0005?\u0004\rA!@\u0002\rQ|\u0007/[2t!\u0011i\"q`\u0012\n\u0007\r\u0005!EA\u0002TKRDqa!\u0002\u0001\t\u0003\u00199!\u0001\thKRd\u0015\r^3ti>3gm]3ugR!!Q]B\u0005\u0011!\u0011Ypa\u0001A\u0002\tu\bbBB\u0007\u0001\u0011E1qB\u0001\u0014EJ|7.\u001a:D_:4\u0017nZ;sCRLwN\\\u000b\u0003\u0007#\u0001BAa&\u0004\u0014%!1Q\u0003BM\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u00073\u0001A\u0011BB\b\u0003U\u0001(o\u001c3vG\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:Dqa!\b\u0001\t\u0003\u0019y\"A\rxSRDGK]1og\u000e\fG/[8oC2\u0004&o\u001c3vG\u0016\u0014Hc\u0001#\u0004\"!A11EB\u000e\u0001\u0004\u0019)#A\u0001g!\u0019y1qEB\u0016\t&\u00191\u0011\u0006\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBAk\u0007[\u00193%\u0003\u0003\u00040\u0005]'!D&bM.\f\u0007K]8ek\u000e,'\u000fC\u0004\u00044\u0001!Iaa\u0004\u0002+\r|gn];nKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"91q\u0007\u0001\u0005\n\re\u0012a\u0005<fe&4\u0017\u0010V8qS\u000e$U\r\\3uS>tGc\u0002#\u0004<\ru2\u0011\t\u0005\b\u0005\u000f\u001a)\u00041\u0001$\u0011\u001d\u0019yd!\u000eA\u0002y\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0002CB\"\u0007k\u0001\ra!\u0012\u0002\u000fM,'O^3sgB1!\u0011\fB5\u0003wCqa!\u0013\u0001\t\u0013\u0019Y%\u0001\u0010wKJLg-\u001f+pa&\u001cG)\u001a7fi&|gnV5uQJ+GO]5fgRIAi!\u0014\u0004P\rE31\u000b\u0005\t\u0003\u007f\u00199\u00051\u0001\u0002D!9!qIB$\u0001\u0004\u0019\u0003bBB \u0007\u000f\u0002\rA\u0010\u0005\t\u0007\u0007\u001a9\u00051\u0001\u0004F!91q\u000b\u0001\u0005\n\re\u0013!H<bSR,f\u000e^5m\u001b\u0016$\u0018\rZ1uC&\u001b\bK]8qC\u001e\fG/\u001a3\u0015\u000b\u0011\u001bYf!\u0018\t\u000f\t\u001d3Q\u000ba\u0001G!9!1[B+\u0001\u0004q\u0004bBB1\u0001\u0011\u000511M\u0001\u0017o\u0006LG/\u00168uS2|eMZ:fi\u0006\u0003\b/Z1sgR)Ai!\u001a\u0004j!A1qMB0\u0001\u0004\u00119/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u0011\r-4q\fa\u0001\u0005g\faa\u001c4gg\u0016$\b\"CB8\u0001E\u0005I\u0011AB9\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIM*\"aa\u001d+\t\u0005=8QO\u0016\u0003\u0007o\u0002Ba!\u001f\u0004\u00046\u001111\u0010\u0006\u0005\u0007{\u001ay(A\u0005v]\u000eDWmY6fI*\u00191\u0011\u0011\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0006\u000em$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI1\u0011\u0012\u0002\u0002\u0002#\u000511R\u0001\u000f\u0017\u000647.\u0019+fgR,F/\u001b7t!\r\u00114Q\u0012\u0004\t\u0003\t\t\t\u0011#\u0001\u0004\u0010N\u00191Q\u0012\b\t\u000f=\u001ai\t\"\u0001\u0004\u0014R\u001111\u0012\u0005\u000b\u0007/\u001bi)%A\u0005\u0002\re\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u001c*\u001aAd!\u001e")
public class KafkaTestUtils
implements Logging {
    private final scala.collection.immutable.Map<String, Object> withBrokerProps;
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkUtils org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils;
    private AdminClient adminClient;
    private final String brokerHost;
    private int org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$sql$kafka010$KafkaTestUtils$$server;
    private Producer<String, String> org$apache$spark$sql$kafka010$KafkaTestUtils$$producer;
    private boolean zkReady;
    private boolean brokerReady;
    private Object leakDetector;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static scala.collection.immutable.Map<String, Object> $lessinit$greater$default$1() {
        return KafkaTestUtils$.MODULE$.$lessinit$greater$default$1();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    public ZkUtils org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils;
    }

    private void org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils_$eq(ZkUtils x$1) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils = x$1;
    }

    private AdminClient adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$sql$kafka010$KafkaTestUtils$$server() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server;
    }

    public void org$apache$spark$sql$kafka010$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server = x$1;
    }

    public Producer<String, String> org$apache$spark$sql$kafka010$KafkaTestUtils$$producer() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer;
    }

    private void org$apache$spark$sql$kafka010$KafkaTestUtils$$producer_$eq(Producer<String, String> x$1) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    private Object leakDetector() {
        return this.leakDetector;
    }

    private void leakDetector_$eq(Object x$1) {
        this.leakDetector = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort())}));
    }

    public ZkUtils zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkUtils)Option$.MODULE$.apply((Object)this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils_$eq(ZkUtils$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), false));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig((java.util.Map)this.$outer.brokerConfiguration(), false));
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4()));
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().startup();
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort_$eq(this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().boundPort(new ListenerName("PLAINTEXT")));
                return new Tuple2((Object)this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
        Properties props = new Properties();
        props.put("bootstrap.servers", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort())})));
        this.adminClient_$eq(AdminClient.create((Properties)props));
    }

    public void setup() {
        SparkException exception = new SparkException("It was created at: ");
        this.leakDetector_$eq(ShutdownHookManager$.MODULE$.addShutdownHook((Function0)new Serializable(this, exception){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final SparkException exception$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.logError((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Found a leak KafkaTestUtils.";
                    }
                }, (Throwable)this.exception$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.exception$1 = exception$1;
            }
        }));
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getAllBrokersInCluster().nonEmpty(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Broker was not up in 60 seconds";
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Eventually$.MODULE$.patienceConfig(), new Position("KafkaTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
    }

    public void teardown() {
        Object object = this.leakDetector() == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.leakDetector()));
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer() != null) {
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer().close();
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer_$eq(null);
        }
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
        if (this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().awaitShutdown();
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final void apply(String f) {
                Throwable throwable2;
                block2: {
                    try {
                        Utils$.MODULE$.deleteRecursively(new File(f));
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        if (!(throwable3 instanceof IOException)) break block2;
                        IOException iOException = (IOException)throwable3;
                        if (!Utils$.MODULE$.isWindows()) break block2;
                        this.$outer.logWarning((Function0<String>)new Serializable(this, iOException){
                            public static final long serialVersionUID = 0L;
                            private final IOException x5$1;

                            public final String apply() {
                                return this.x5$1.getMessage();
                            }
                            {
                                this.x5$1 = x5$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils() != null) {
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().close();
            this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createTopic(String topic, int partitions, boolean overwrite) {
        created = false;
        while (true) {
            if (!created) ** GOTO lbl-1000
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaTestUtils $outer;
                private final String topic$1;

                public final void apply(int p) {
                    this.apply$mcVI$sp(p);
                }

                public void apply$mcVI$sp(int p) {
                    this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                }
            });
            return;
lbl-1000:
            // 1 sources

            {
                AdminUtils$.MODULE$.createTopic(this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
                var4_4 = true;
                continue;
            }
            break;
        }
    }

    public Seq<Tuple2<String, Object>> getAllTopicsAndPartitionSize() {
        return this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getPartitionsForTopics(this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getAllTopics()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$1) {
                return x$1.size();
            }
        }).toSeq();
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1, this.createTopic$default$3());
    }

    public boolean createTopic$default$3() {
        return false;
    }

    public void deleteTopic(String topic) {
        int partitions = ((SeqLike)this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getPartitionsForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).apply((Object)topic)).size();
        AdminUtils$.MODULE$.deleteTopic(this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils(), topic);
        this.verifyTopicDeletionWithRetries(this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils(), topic, partitions, (Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server()})));
    }

    public void addPartitions(String topic, int partitions) {
        this.adminClient().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)NewPartitions.increaseTo((int)partitions))}))).asJava(), new CreatePartitionsOptions());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$3;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$3, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$3 = topic$3;
            }
        });
    }

    public void sendMessages(String topic, java.util.Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$2) {
                return x$2;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public Seq<Tuple2<String, RecordMetadata>> sendMessages(String topic, String[] messages) {
        return this.sendMessages(topic, messages, (Option<Object>)None$.MODULE$);
    }

    public Seq<Tuple2<String, RecordMetadata>> sendMessages(String topic, String[] messages, Option<Object> partition) {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer_$eq((Producer<String, String>)new KafkaProducer(this.producerConfiguration()));
        Tuple2[] offsets = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$2;
            private final Option partition$1;

            public final Tuple2<String, RecordMetadata> apply(String m) {
                Option option;
                block4: {
                    ProducerRecord producerRecord;
                    block3: {
                        block2: {
                            option = this.partition$1;
                            if (!(option instanceof Some)) break block2;
                            Some some = (Some)option;
                            int p = BoxesRunTime.unboxToInt((Object)some.x());
                            producerRecord = new ProducerRecord(this.topic$2, Predef$.MODULE$.int2Integer(p), null, (Object)m);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option)) break block4;
                        producerRecord = new ProducerRecord(this.topic$2, (Object)m);
                    }
                    ProducerRecord record = producerRecord;
                    RecordMetadata metadata = (RecordMetadata)this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer().send(record).get(10L, TimeUnit.SECONDS);
                    this.$outer.logInfo((Function0<String>)new Serializable(this, metadata, m){
                        public static final long serialVersionUID = 0L;
                        private final RecordMetadata metadata$1;
                        private final String m$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tSent ", " to partition ", ", offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.m$1, BoxesRunTime.boxToInteger((int)this.metadata$1.partition()), BoxesRunTime.boxToLong((long)this.metadata$1.offset())}));
                        }
                        {
                            this.metadata$1 = metadata$1;
                            this.m$1 = m$1;
                        }
                    });
                    return new Tuple2((Object)m, (Object)metadata);
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])offsets);
        finally {
            if (this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer() != null) {
                this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer().close();
                this.org$apache$spark$sql$kafka010$KafkaTestUtils$$producer_$eq(null);
            }
        }
    }

    public void cleanupLogs() {
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().logManager().cleanupLogs();
    }

    public scala.collection.immutable.Map<TopicPartition, Object> getEarliestOffsets(scala.collection.immutable.Set<String> topics) {
        KafkaConsumer kc = new KafkaConsumer(this.consumerConfiguration());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Created consumer to get earliest offsets";
            }
        });
        kc.subscribe(JavaConverters$.MODULE$.asJavaCollectionConverter(topics).asJavaCollection());
        kc.poll(0L);
        Set partitions = kc.assignment();
        kc.pause((Collection)partitions);
        kc.seekToBeginning((Collection)partitions);
        scala.collection.immutable.Map offsets = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1)new Serializable(this, kc){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer kc$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)BoxesRunTime.boxToLong((long)this.kc$1.position(p)));
            }
            {
                this.kc$1 = kc$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        kc.close();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Closed consumer to get earliest offsets";
            }
        });
        return offsets;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> getLatestOffsets(scala.collection.immutable.Set<String> topics) {
        KafkaConsumer kc = new KafkaConsumer(this.consumerConfiguration());
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Created consumer to get latest offsets";
            }
        });
        kc.subscribe(JavaConverters$.MODULE$.asJavaCollectionConverter(topics).asJavaCollection());
        kc.poll(0L);
        Set partitions = kc.assignment();
        kc.pause((Collection)partitions);
        kc.seekToEnd((Collection)partitions);
        scala.collection.immutable.Map offsets = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).map((Function1)new Serializable(this, kc){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer kc$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition p) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p), (Object)BoxesRunTime.boxToLong((long)this.kc$2.position(p)));
            }
            {
                this.kc$2 = kc$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        kc.close();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Closed consumer to get latest offsets";
            }
        });
        return offsets;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "127.0.0.1");
        props.put("advertised.host.name", "127.0.0.1");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("zookeeper.connection.timeout.ms", "60000");
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        props.put("delete.topic.enable", "true");
        props.put("group.initial.rebalance.delay.ms", "10");
        props.put("offsets.topic.num.partitions", "1");
        props.put("offsets.topic.replication.factor", "1");
        props.put("transaction.state.log.replication.factor", "1");
        props.put("transaction.state.log.min.isr", "1");
        this.withBrokerProps.foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Object object = this.props$1.put(k, v);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerAddress());
        props.put("value.serializer", StringSerializer.class.getName());
        props.put("key.serializer", StringSerializer.class.getName());
        props.put("acks", "all");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void withTranscationalProducer(Function1<KafkaProducer<String, String>, BoxedUnit> f) {
        Properties props = this.producerConfiguration();
        props.put("transactional.id", UUID.randomUUID().toString());
        KafkaProducer producer = new KafkaProducer(props);
        try {
            producer.initTransactions();
            f.apply((Object)producer);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    private Properties consumerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerAddress());
        props.put("group.id", new StringBuilder().append((Object)"group-KafkaTestUtils-").append((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt())).toString());
        props.put("value.deserializer", StringDeserializer.class.getName());
        props.put("key.deserializer", StringDeserializer.class.getName());
        props.put("enable.auto.commit", "false");
        return var1_1;
    }

    public void org$apache$spark$sql$kafka010$KafkaTestUtils$$verifyTopicDeletion(String topic, int numPartitions, Seq<KafkaServer> servers) {
        IndexedSeq topicAndPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final TopicPartition apply(int x$3) {
                return new TopicPartition(this.topic$6, x$3);
            }
            {
                this.topic$6 = topic$6;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Predef$.MODULE$.assert(!this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().pathExists(ZkUtils$.MODULE$.getDeleteTopicPath(topic)), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " still exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getDeleteTopicPath(this.topic$6)}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
        Predef$.MODULE$.assert(!this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " still exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ZkUtils$.MODULE$.getTopicPath(this.topic$6)}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
        Predef$.MODULE$.assert(servers.forall((Function1)new Serializable(this, topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicAndPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$1;

                    public final boolean apply(TopicPartition tp) {
                        Option option = this.server$1.replicaManager().getPartition(tp);
                        None$ none$ = None$.MODULE$;
                        return !(option != null ? !option.equals(none$) : none$ != null);
                    }
                    {
                        this.server$1 = server$1;
                    }
                });
            }
            {
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic ", " still exists in the replica manager"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
        Predef$.MODULE$.assert(servers.forall((Function1)new Serializable(this, topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicAndPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$2;

                    public final boolean apply(TopicPartition tp) {
                        LogManager qual$1 = this.server$2.getLogManager();
                        TopicPartition x$5 = tp;
                        boolean x$6 = qual$1.getLog$default$2();
                        return qual$1.getLog(x$5, x$6).isEmpty();
                    }
                    {
                        this.server$2 = server$2;
                    }
                });
            }
            {
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic ", " still exists in log mananger"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
        Predef$.MODULE$.assert(servers.forall((Function1)new Serializable(this, topicAndPartitions){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq topicAndPartitions$1;

            public final boolean apply(KafkaServer server) {
                return this.topicAndPartitions$1.forall((Function1)new Serializable(this, server){
                    public static final long serialVersionUID = 0L;
                    private final KafkaServer server$3;

                    public final boolean apply(TopicPartition tp) {
                        Seq checkpoints = (Seq)this.server$3.getLogManager().liveLogDirs().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Map<TopicPartition, Object> apply(File logDir) {
                                return new OffsetCheckpointFile(new File(logDir, "cleaner-offset-checkpoint"), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2()).read();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return checkpoints.forall((Function1)new Serializable(this, tp){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition tp$1;

                            public final boolean apply(Map<TopicPartition, Object> checkpointsPerLogDir) {
                                return !checkpointsPerLogDir.contains((Object)this.tp$1);
                            }
                            {
                                this.tp$1 = tp$1;
                            }
                        });
                    }
                    {
                        this.server$3 = server$3;
                    }
                });
            }
            {
                this.topicAndPartitions$1 = topicAndPartitions$1;
            }
        }), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"checkpoint for topic ", " still exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
        Predef$.MODULE$.assert(!this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getAllTopics().contains((Object)topic), (Function0)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$6;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic ", " still exists on zookeeper"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$6}));
            }
            {
                this.topic$6 = topic$6;
            }
        });
    }

    private void verifyTopicDeletionWithRetries(ZkUtils zkUtils, String topic, int numPartitions, Seq<KafkaServer> servers) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), Eventually$.MODULE$.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(200).millis()), (Function0)new Serializable(this, zkUtils, topic, numPartitions, servers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final ZkUtils zkUtils$1;
            private final String topic$5;
            private final int numPartitions$1;
            private final Seq servers$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$verifyTopicDeletion(this.topic$5, this.numPartitions$1, (Seq<KafkaServer>)this.servers$1);
                    return;
                }
                catch (Throwable throwable) {
                    AdminUtils$.MODULE$.deleteTopic(this.zkUtils$1, this.topic$5);
                    throw throwable;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.zkUtils$1 = zkUtils$1;
                this.topic$5 = topic$5;
                this.numPartitions$1 = numPartitions$1;
                this.servers$1 = servers$1;
            }
        }, new Position("KafkaTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
    }

    public void org$apache$spark$sql$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$4;
            public final int partition$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$sql$kafka010$KafkaTestUtils$$isPropagated$1(this.topic$4, this.partition$2), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$kafka010$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$4, BoxesRunTime.boxToInteger((int)this.$outer.partition$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$4 = topic$4;
                this.partition$2 = partition$2;
            }
        }, Eventually$.MODULE$.patienceConfig(), new Position("KafkaTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
    }

    public void waitUntilOffsetAppears(TopicPartition topicPartition, long offset) {
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), (Function0)new Serializable(this, topicPartition, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final TopicPartition topicPartition$1;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option currentOffset = this.$outer.getLatestOffsets((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicPartition$1.topic()})))).get((Object)this.topicPartition$1);
                Predef$.MODULE$.assert(currentOffset.nonEmpty() && BoxesRunTime.unboxToLong((Object)currentOffset.get()) >= this.offset$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.offset$1 = offset$1;
            }
        }, Eventually$.MODULE$.patienceConfig(), new Position("KafkaTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
    }

    public final boolean org$apache$spark$sql$kafka010$KafkaTestUtils$$isPropagated$1(String topic$4, int partition$2) {
        boolean bl;
        Option option = this.org$apache$spark$sql$kafka010$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$4, partition$2);
        if (option instanceof Some) {
            Some some = (Some)option;
            UpdateMetadataRequest.PartitionState partitionState = (UpdateMetadataRequest.PartitionState)some.x();
            bl = this.org$apache$spark$sql$kafka010$KafkaTestUtils$$zkUtils().getLeaderForPartition(topic$4, partition$2).isDefined() && Request$.MODULE$.isValidBrokerId(partitionState.basePartitionState.leader) && !partitionState.basePartitionState.replicas.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils(scala.collection.immutable.Map<String, Object> withBrokerProps) {
        this.withBrokerProps = withBrokerProps;
        Logging.class.$init$((Logging)this);
        this.zkHost = "127.0.0.1";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 10000;
        this.adminClient = null;
        this.brokerHost = "127.0.0.1";
        this.org$apache$spark$sql$kafka010$KafkaTestUtils$$brokerPort = 0;
        this.zkReady = false;
        this.brokerReady = false;
        this.leakDetector = null;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$4;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            Throwable throwable4;
            block5: {
                Throwable throwable22;
                block4: {
                    this.factory().shutdown();
                    try {
                        Utils$.MODULE$.deleteRecursively(this.snapshotDir());
                    }
                    catch (Throwable throwable22) {
                        Throwable throwable3 = throwable22;
                        if (!(throwable3 instanceof IOException)) break block4;
                        IOException iOException = (IOException)throwable3;
                        if (!Utils$.MODULE$.isWindows()) break block4;
                        this.org$apache$spark$sql$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)new Serializable(this, iOException){
                            public static final long serialVersionUID = 0L;
                            private final IOException x5$2;

                            public final String apply() {
                                return this.x5$2.getMessage();
                            }
                            {
                                this.x5$2 = x5$2;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    try {
                        Utils$.MODULE$.deleteRecursively(this.logDir());
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable5 = throwable4;
                        if (!(throwable5 instanceof IOException)) break block5;
                        IOException iOException = (IOException)throwable5;
                        if (!Utils$.MODULE$.isWindows()) break block5;
                        this.org$apache$spark$sql$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer().logWarning((Function0<String>)new Serializable(this, iOException){
                            public static final long serialVersionUID = 0L;
                            private final IOException x5$3;

                            public final String apply() {
                                return this.x5$3.getMessage();
                            }
                            {
                                this.x5$3 = x5$3;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                throw throwable22;
                return;
            }
            throw throwable4;
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$sql$kafka010$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$4 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$4._1();
                this.port = this.x$4._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

