/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer$;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer$FetchedData$;
import org.apache.spark.sql.kafka010.InternalKafkaConsumer$FetchedRecord$;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.util.UninterruptibleThread;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc!B\u0001\u0003\u0001\na!!F%oi\u0016\u0014h.\u00197LC\u001a\\\u0017mQ8ogVlWM\u001d\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7#\u0002\u0001\u000e'ea\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0019+\t9Aj\\4hS:<\u0007C\u0001\b\u001b\u0013\tYrBA\u0004Qe>$Wo\u0019;\u0011\u00059i\u0012B\u0001\u0010\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!\u0001\u0003A!f\u0001\n\u0003\u0011\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0002\u0001+\u0005\u0019\u0003C\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0019\u0019w.\\7p]*\u0011\u0001\u0006C\u0001\u0006W\u000647.Y\u0005\u0003U\u0015\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005-\u0001\tE\t\u0015!\u0003$\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0003\u0002\u0003\u0018\u0001\u0005+\u0007I\u0011A\u0018\u0002\u0017-\fgm[1QCJ\fWn]\u000b\u0002aA!\u0011G\u000e\u001dD\u001b\u0005\u0011$BA\u001a5\u0003\u0011)H/\u001b7\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\u0004\u001b\u0006\u0004\bCA\u001dA\u001d\tQd\b\u0005\u0002<\u001f5\tAH\u0003\u0002>C\u00051AH]8pizJ!aP\b\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007f=\u0001\"\u0001R$\u000e\u0003\u0015S!A\u0012\u001b\u0002\t1\fgnZ\u0005\u0003\u0011\u0016\u0013aa\u00142kK\u000e$\b\u0002\u0003&\u0001\u0005#\u0005\u000b\u0011\u0002\u0019\u0002\u0019-\fgm[1QCJ\fWn\u001d\u0011\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\rq\u0005+\u0015\t\u0003\u001f\u0002i\u0011A\u0001\u0005\u0006A-\u0003\ra\t\u0005\u0006]-\u0003\r\u0001\r\u0004\u0005'\u0002!EKA\u0006GKR\u001c\u0007.\u001a3ECR\f7\u0003\u0002*\u000e3qA\u0001B\u0016*\u0003\u0002\u0004%IaV\u0001\t?J,7m\u001c:egV\t\u0001\fE\u000223nK!A\u0017\u001a\u0003\u00191K7\u000f^%uKJ\fGo\u001c:\u0011\tq\u000b7mY\u0007\u0002;*\u0011alX\u0001\tG>t7/^7fe*\u0011\u0001mJ\u0001\bG2LWM\u001c;t\u0013\t\u0011WL\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\u0011\u00079!g-\u0003\u0002f\u001f\t)\u0011I\u001d:bsB\u0011abZ\u0005\u0003Q>\u0011AAQ=uK\"A!N\u0015BA\u0002\u0013%1.\u0001\u0007`e\u0016\u001cwN\u001d3t?\u0012*\u0017\u000f\u0006\u0002m_B\u0011a\"\\\u0005\u0003]>\u0011A!\u00168ji\"9\u0001/[A\u0001\u0002\u0004A\u0016a\u0001=%c!A!O\u0015B\tB\u0003&\u0001,A\u0005`e\u0016\u001cwN\u001d3tA!AAO\u0015BA\u0002\u0013%Q/\u0001\r`]\u0016DHo\u00144gg\u0016$\u0018J\u001c$fi\u000eDW\r\u001a#bi\u0006,\u0012A\u001e\t\u0003\u001d]L!\u0001_\b\u0003\t1{gn\u001a\u0005\tuJ\u0013\t\u0019!C\u0005w\u0006arL\\3yi>3gm]3u\u0013:4U\r^2iK\u0012$\u0015\r^1`I\u0015\fHC\u00017}\u0011\u001d\u0001\u00180!AA\u0002YD\u0001B *\u0003\u0012\u0003\u0006KA^\u0001\u001a?:,\u0007\u0010^(gMN,G/\u00138GKR\u001c\u0007.\u001a3ECR\f\u0007\u0005C\u0005\u0002\u0002I\u0013\t\u0019!C\u0005k\u0006\u0001rl\u001c4gg\u0016$\u0018I\u001a;feB{G\u000e\u001c\u0005\u000b\u0003\u000b\u0011&\u00111A\u0005\n\u0005\u001d\u0011\u0001F0pM\u001a\u001cX\r^!gi\u0016\u0014\bk\u001c7m?\u0012*\u0017\u000fF\u0002m\u0003\u0013A\u0001\u0002]A\u0002\u0003\u0003\u0005\rA\u001e\u0005\n\u0003\u001b\u0011&\u0011#Q!\nY\f\u0011cX8gMN,G/\u00114uKJ\u0004v\u000e\u001c7!\u0011\u0019a%\u000b\"\u0001\u0002\u0012QA\u00111CA\f\u00033\tY\u0002E\u0002\u0002\u0016Ik\u0011\u0001\u0001\u0005\u0007-\u0006=\u0001\u0019\u0001-\t\rQ\fy\u00011\u0001w\u0011\u001d\t\t!a\u0004A\u0002YDq!a\bS\t\u0003\t\t#A\u0006xSRDg*Z<Q_2dGCBA\n\u0003G\t9\u0003C\u0004\u0002&\u0005u\u0001\u0019\u0001-\u0002\u000fI,7m\u001c:eg\"9\u0011\u0011FA\u000f\u0001\u00041\u0018aD8gMN,G/\u00114uKJ\u0004v\u000e\u001c7\t\u000f\u00055\"\u000b\"\u0001\u00020\u00059\u0001.Y:OKb$XCAA\u0019!\rq\u00111G\u0005\u0004\u0003ky!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003s\u0011F\u0011AA\u001e\u0003\u0011qW\r\u001f;\u0015\u0003mCq!a\u0010S\t\u0003\tY$\u0001\u0005qe\u00164\u0018n\\;t\u0011\u001d\t\u0019E\u0015C\u0001\u0003\u000b\nQA]3tKR$\u0012\u0001\u001c\u0005\u0007\u0003\u0013\u0012F\u0011A;\u0002/9,\u0007\u0010^(gMN,G/\u00138GKR\u001c\u0007.\u001a3ECR\f\u0007BBA\u0015%\u0012\u0005Q\u000fC\u0005\u0002PI\u000b\t\u0011\"\u0001\u0002R\u0005!1m\u001c9z)!\t\u0019\"a\u0015\u0002V\u0005]\u0003\u0002\u0003,\u0002NA\u0005\t\u0019\u0001-\t\u0011Q\fi\u0005%AA\u0002YD\u0011\"!\u0001\u0002NA\u0005\t\u0019\u0001<\t\u0013\u0005m#+%A\u0005\u0002\u0005u\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003?R3\u0001WA1W\t\t\u0019\u0007\u0005\u0003\u0002f\u0005=TBAA4\u0015\u0011\tI'a\u001b\u0002\u0013Ut7\r[3dW\u0016$'bAA7\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0014q\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA;%F\u0005I\u0011AA<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u001f+\u0007Y\f\t\u0007C\u0005\u0002~I\u000b\n\u0011\"\u0001\u0002x\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\u0002CAA%&\u0005I\u0011A,\u0002#}\u0013XmY8sIN$\u0013mY2fgN$\u0003\u0007\u0003\u0005\u0002\u0006JK\t\u0011\"\u0001v\u0003\u0005zf.\u001a=u\u001f\u001a47/\u001a;J]\u001a+Go\u00195fI\u0012\u000bG/\u0019\u0013bG\u000e,7o\u001d\u00132\u0011!\tIIUE\u0001\n\u0003)\u0018!G0pM\u001a\u001cX\r^!gi\u0016\u0014\bk\u001c7mI\u0005\u001c7-Z:tIIB\u0011\"!$S\u0003\u0003%\t%a$\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\nE\u0002E\u0003'K!!Q#\t\u0013\u0005]%+!A\u0005\u0002\u0005e\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAN!\rq\u0011QT\u0005\u0004\u0003?{!aA%oi\"I\u00111\u0015*\u0002\u0002\u0013\u0005\u0011QU\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u00079\tI+C\u0002\u0002,>\u00111!\u00118z\u0011%\u0001\u0018\u0011UA\u0001\u0002\u0004\tY\nC\u0005\u00022J\u000b\t\u0011\"\u0011\u00024\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026B1\u0011qWA_\u0003Ok!!!/\u000b\u0007\u0005mv\"\u0001\u0006d_2dWm\u0019;j_:LA!a0\u0002:\nA\u0011\n^3sCR|'\u000fC\u0005\u0002DJ\u000b\t\u0011\"\u0001\u0002F\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00022\u0005\u001d\u0007\"\u00039\u0002B\u0006\u0005\t\u0019AAT\u0011%\tYMUA\u0001\n\u0003\ni-\u0001\u0005iCND7i\u001c3f)\t\tY\nC\u0005\u0002RJ\u000b\t\u0011\"\u0011\u0002T\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u0012\"I\u0011q\u001b*\u0002\u0002\u0013\u0005\u0013\u0011\\\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E\u00121\u001c\u0005\na\u0006U\u0017\u0011!a\u0001\u0003O;\u0011\"a8\u0001\u0003\u0003EI!!9\u0002\u0017\u0019+Go\u00195fI\u0012\u000bG/\u0019\t\u0005\u0003+\t\u0019O\u0002\u0005T\u0001\u0005\u0005\t\u0012BAs'\u0015\t\u0019/a:\u001d!%\tI/a<YmZ\f\u0019\"\u0004\u0002\u0002l*\u0019\u0011Q^\b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011_Av\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b\u0019\u0006\rH\u0011AA{)\t\t\t\u000f\u0003\u0006\u0002R\u0006\r\u0018\u0011!C#\u0003'D!\"a?\u0002d\u0006\u0005I\u0011QA\u007f\u0003\u0015\t\u0007\u000f\u001d7z)!\t\u0019\"a@\u0003\u0002\t\r\u0001B\u0002,\u0002z\u0002\u0007\u0001\f\u0003\u0004u\u0003s\u0004\rA\u001e\u0005\b\u0003\u0003\tI\u00101\u0001w\u0011)\u00119!a9\u0002\u0002\u0013\u0005%\u0011B\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YAa\u0006\u0011\u000b9\u0011iA!\u0005\n\u0007\t=qB\u0001\u0004PaRLwN\u001c\t\u0007\u001d\tM\u0001L\u001e<\n\u0007\tUqB\u0001\u0004UkBdWm\r\u0005\u000b\u00053\u0011)!!AA\u0002\u0005M\u0011a\u0001=%a\u00191!Q\u0004\u0001E\u0005?\u0011QBR3uG\",GMU3d_J$7#\u0002B\u000e\u001bea\u0002b\u0003B\u0012\u00057\u0011\t\u001a!C\u0001\u0005K\taA]3d_J$W#A.\t\u0017\t%\"1\u0004BA\u0002\u0013\u0005!1F\u0001\u000be\u0016\u001cwN\u001d3`I\u0015\fHc\u00017\u0003.!A\u0001Oa\n\u0002\u0002\u0003\u00071\f\u0003\u0006\u00032\tm!\u0011#Q!\nm\u000bqA]3d_J$\u0007\u0005\u0003\u0006\u00036\tm!\u00113A\u0005\u0002U\f\u0011C\\3yi>3gm]3u)>4U\r^2i\u0011-\u0011IDa\u0007\u0003\u0002\u0004%\tAa\u000f\u0002+9,\u0007\u0010^(gMN,G\u000fV8GKR\u001c\u0007n\u0018\u0013fcR\u0019AN!\u0010\t\u0011A\u00149$!AA\u0002YD!B!\u0011\u0003\u001c\tE\t\u0015)\u0003w\u0003IqW\r\u001f;PM\u001a\u001cX\r\u001e+p\r\u0016$8\r\u001b\u0011\t\u000f1\u0013Y\u0002\"\u0001\u0003FQ1!q\tB%\u0005\u0017\u0002B!!\u0006\u0003\u001c!9!1\u0005B\"\u0001\u0004Y\u0006b\u0002B\u001b\u0005\u0007\u0002\rA\u001e\u0005\t\u0005\u001f\u0012Y\u0002\"\u0001\u0003R\u0005Qq/\u001b;i%\u0016\u001cwN\u001d3\u0015\r\t\u001d#1\u000bB+\u0011\u001d\u0011\u0019C!\u0014A\u0002mCqA!\u000e\u0003N\u0001\u0007a\u000f\u0003\u0006\u0002P\tm\u0011\u0011!C\u0001\u00053\"bAa\u0012\u0003\\\tu\u0003\"\u0003B\u0012\u0005/\u0002\n\u00111\u0001\\\u0011%\u0011)Da\u0016\u0011\u0002\u0003\u0007a\u000f\u0003\u0006\u0002\\\tm\u0011\u0013!C\u0001\u0005C*\"Aa\u0019+\u0007m\u000b\t\u0007\u0003\u0006\u0002v\tm\u0011\u0013!C\u0001\u0003oB!\"!$\u0003\u001c\u0005\u0005I\u0011IAH\u0011)\t9Ja\u0007\u0002\u0002\u0013\u0005\u0011\u0011\u0014\u0005\u000b\u0003G\u0013Y\"!A\u0005\u0002\t5D\u0003BAT\u0005_B\u0011\u0002\u001dB6\u0003\u0003\u0005\r!a'\t\u0015\u0005E&1DA\u0001\n\u0003\n\u0019\f\u0003\u0006\u0002D\nm\u0011\u0011!C\u0001\u0005k\"B!!\r\u0003x!I\u0001Oa\u001d\u0002\u0002\u0003\u0007\u0011q\u0015\u0005\u000b\u0003\u0017\u0014Y\"!A\u0005B\u00055\u0007BCAi\u00057\t\t\u0011\"\u0011\u0002T\"Q\u0011q\u001bB\u000e\u0003\u0003%\tEa \u0015\t\u0005E\"\u0011\u0011\u0005\na\nu\u0014\u0011!a\u0001\u0003O;\u0011B!\"\u0001\u0003\u0003EIAa\"\u0002\u001b\u0019+Go\u00195fIJ+7m\u001c:e!\u0011\t)B!#\u0007\u0013\tu\u0001!!A\t\n\t-5#\u0002BE\u0005\u001bc\u0002\u0003CAu\u0005\u001f[fOa\u0012\n\t\tE\u00151\u001e\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002'\u0003\n\u0012\u0005!Q\u0013\u000b\u0003\u0005\u000fC!\"!5\u0003\n\u0006\u0005IQIAj\u0011)\tYP!#\u0002\u0002\u0013\u0005%1\u0014\u000b\u0007\u0005\u000f\u0012iJa(\t\u000f\t\r\"\u0011\u0014a\u00017\"9!Q\u0007BM\u0001\u00041\bB\u0003B\u0004\u0005\u0013\u000b\t\u0011\"!\u0003$R!!Q\u0015BW!\u0015q!Q\u0002BT!\u0015q!\u0011V.w\u0013\r\u0011Yk\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\te!\u0011UA\u0001\u0002\u0004\u00119\u0005C\u0005\u00032\u0002\u0011\r\u0011\"\u0003\u00034\u00069qM]8va&#W#\u0001\u001d\t\u000f\t]\u0006\u0001)A\u0005q\u0005AqM]8va&#\u0007\u0005\u0003\u0005_\u0001\u0001\u0007I\u0011\u0002B^+\t\u0011i\fE\u0003]\u0005\u007f\u001b7-C\u0002\u0003Bv\u0013QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b\"\u0003Bc\u0001\u0001\u0007I\u0011\u0002Bd\u00031\u0019wN\\:v[\u0016\u0014x\fJ3r)\ra'\u0011\u001a\u0005\na\n\r\u0017\u0011!a\u0001\u0005{C\u0001B!4\u0001A\u0003&!QX\u0001\nG>t7/^7fe\u0002BCAa3\u0003RB\u0019aBa5\n\u0007\tUwB\u0001\u0005w_2\fG/\u001b7f\u0011%\u0011I\u000e\u0001a\u0001\n\u0003\ty#A\u0003j]V\u001bX\rC\u0005\u0003^\u0002\u0001\r\u0011\"\u0001\u0003`\u0006I\u0011N\\+tK~#S-\u001d\u000b\u0004Y\n\u0005\b\"\u00039\u0003\\\u0006\u0005\t\u0019AA\u0019\u0011!\u0011)\u000f\u0001Q!\n\u0005E\u0012AB5o+N,\u0007\u0005\u000b\u0003\u0003d\nE\u0007\"\u0003Bv\u0001\u0001\u0007I\u0011AA\u0018\u00039i\u0017M]6fI\u001a{'o\u00117pg\u0016D\u0011Ba<\u0001\u0001\u0004%\tA!=\u0002%5\f'o[3e\r>\u00148\t\\8tK~#S-\u001d\u000b\u0004Y\nM\b\"\u00039\u0003n\u0006\u0005\t\u0019AA\u0019\u0011!\u00119\u0010\u0001Q!\n\u0005E\u0012aD7be.,GMR8s\u00072|7/\u001a\u0011)\t\tU(\u0011\u001b\u0005\n\u0005{\u0004!\u0019!C\u0005\u0005\u007f\f1BZ3uG\",G\rR1uCV\u0011\u00111\u0003\u0005\t\u0007\u0007\u0001\u0001\u0015!\u0003\u0002\u0014\u0005aa-\u001a;dQ\u0016$G)\u0019;bA!I1q\u0001\u0001C\u0002\u0013%1\u0011B\u0001\u000eM\u0016$8\r[3e%\u0016\u001cwN\u001d3\u0016\u0005\t\u001d\u0003\u0002CB\u0007\u0001\u0001\u0006IAa\u0012\u0002\u001d\u0019,Go\u00195fIJ+7m\u001c:eA!91\u0011\u0003\u0001\u0005\n\tm\u0016AD2sK\u0006$XmQ8ogVlWM\u001d\u0005\b\u0007+\u0001A\u0011BB\f\u0003q\u0011XO\\+oS:$XM\u001d:vaRL'\r\\=JMB{7o]5cY\u0016,Ba!\u0007\u0004 Q!11DB\u0016!\u0011\u0019iba\b\r\u0001\u0011A1\u0011EB\n\u0005\u0004\u0019\u0019CA\u0001U#\u0011\u0019)#a*\u0011\u00079\u00199#C\u0002\u0004*=\u0011qAT8uQ&tw\rC\u0005\u0004.\rMA\u00111\u0001\u00040\u0005!!m\u001c3z!\u0015q1\u0011GB\u000e\u0013\r\u0019\u0019d\u0004\u0002\ty\tLh.Y7f}!91q\u0007\u0001\u0005\u0002\re\u0012aF4fi\u00063\u0018-\u001b7bE2,wJ\u001a4tKR\u0014\u0016M\\4f)\t\u0019Y\u0004\u0005\u0003\u0004>\r]c\u0002BB \u0007'rAa!\u0011\u0004R9!11IB(\u001d\u0011\u0019)e!\u0014\u000f\t\r\u001d31\n\b\u0004w\r%\u0013\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t%\u00191Q\u000b\u0002\u0002#-\u000bgm[1ECR\f7i\u001c8tk6,'/\u0003\u0003\u0004Z\rm#\u0001F!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;SC:<WMC\u0002\u0004V\tAqaa\u0018\u0001\t\u0003\u0019\t'A\u0002hKR$\u0012bWB2\u0007O\u001aYga\u001c\t\u000f\r\u00154Q\fa\u0001m\u00061qN\u001a4tKRDqa!\u001b\u0004^\u0001\u0007a/A\u0006v]RLGn\u00144gg\u0016$\bbBB7\u0007;\u0002\rA^\u0001\u000ea>dG\u000eV5nK>,H/T:\t\u0011\rE4Q\fa\u0001\u0003c\taBZ1jY>sG)\u0019;b\u0019>\u001c8\u000fC\u0004\u0004v\u0001!Iaa\u001e\u0002C\u001d,G/R1sY&,7\u000f^!wC&d\u0017M\u00197f\u001f\u001a47/\u001a;CKR<X-\u001a8\u0015\u000bY\u001cIha\u001f\t\u000f\r\u001541\u000fa\u0001m\"91\u0011NB:\u0001\u00041\bbBB@\u0001\u0011%1\u0011Q\u0001\fM\u0016$8\r\u001b*fG>\u0014H\r\u0006\u0006\u0003H\r\r5QQBD\u0007\u0013Cqa!\u001a\u0004~\u0001\u0007a\u000fC\u0004\u0004j\ru\u0004\u0019\u0001<\t\u000f\r54Q\u0010a\u0001m\"A1\u0011OB?\u0001\u0004\t\t\u0004C\u0004\u0004\u000e\u0002!I!!\u0012\u0002\u001bI,7/\u001a;D_:\u001cX/\\3s\u0011\u001d\u0019\t\n\u0001C\u0005\u0007'\u000b\u0011#\u00193eSRLwN\\1m\u001b\u0016\u001c8/Y4f)\rA4Q\u0013\u0005\t\u0007c\u001ay\t1\u0001\u00022!91\u0011\u0014\u0001\u0005\n\rm\u0015A\u0004:fa>\u0014H\u000fR1uC2{7o\u001d\u000b\bY\u000eu5qTBR\u0011!\u0019\tha&A\u0002\u0005E\u0002bBBQ\u0007/\u0003\r\u0001O\u0001\b[\u0016\u001c8/Y4f\u0011)\u0019)ka&\u0011\u0002\u0003\u00071qU\u0001\u0006G\u0006,8/\u001a\t\u0005\u0007S\u001b\u0019L\u0004\u0003\u0004,\u000e=fbA\u001e\u0004.&\t\u0001#C\u0002\u00042>\tq\u0001]1dW\u0006<W-\u0003\u0003\u00046\u000e]&!\u0003+ie><\u0018M\u00197f\u0015\r\u0019\tl\u0004\u0005\b\u0007w\u0003A\u0011AA#\u0003\u0015\u0019Gn\\:f\u0011\u001d\u0019y\f\u0001C\u0005\u0007\u0003\fAa]3fWR\u0019Ana1\t\u000f\r\u00154Q\u0018a\u0001m\"91q\u0019\u0001\u0005\n\r%\u0017!\u00034fi\u000eDG)\u0019;b)\u0015a71ZBg\u0011\u001d\u0019)g!2A\u0002YDqa!\u001c\u0004F\u0002\u0007a\u000fC\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0004RR)aja5\u0004V\"A\u0001ea4\u0011\u0002\u0003\u00071\u0005\u0003\u0005/\u0007\u001f\u0004\n\u00111\u00011\u0011%\u0019I\u000eAI\u0001\n\u0013\u0019Y.\u0001\rsKB|'\u000f\u001e#bi\u0006dun]:%I\u00164\u0017-\u001e7uIM*\"a!8+\t\r\u001d\u0016\u0011\r\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0007C,\"aa9+\u0007\r\n\t\u0007C\u0005\u0002v\u0001\t\n\u0011\"\u0001\u0004hV\u00111\u0011\u001e\u0016\u0004a\u0005\u0005\u0004\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\t9\nAA\u0001\n\u0003\tI\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0004rR!\u0011qUBz\u0011%\u00018q^A\u0001\u0002\u0004\tY\nC\u0005\u00022\u0002\t\t\u0011\"\u0011\u00024\"I\u00111\u0019\u0001\u0002\u0002\u0013\u00051\u0011 \u000b\u0005\u0003c\u0019Y\u0010C\u0005q\u0007o\f\t\u00111\u0001\u0002(\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\n\u0003#\u0004\u0011\u0011!C!\u0003'D\u0011\"a6\u0001\u0003\u0003%\t\u0005b\u0001\u0015\t\u0005EBQ\u0001\u0005\na\u0012\u0005\u0011\u0011!a\u0001\u0003O;\u0001\u0002\"\u0003\u0003\u0011\u0003\u0011A1B\u0001\u0016\u0013:$XM\u001d8bY.\u000bgm[1D_:\u001cX/\\3s!\ryEQ\u0002\u0004\b\u0003\tA\tA\u0001C\b'\u0015!i!D\n\u001d\u0011\u001daEQ\u0002C\u0001\t'!\"\u0001b\u0003\t\u0013\u0011]AQ\u0002b\u0001\n\u0013)\u0018AD+O\u0017:{uKT0P\r\u001a\u001bV\t\u0016\u0005\t\t7!i\u0001)A\u0005m\u0006yQKT&O\u001f^sul\u0014$G'\u0016#\u0006\u0005\u0003\u0005\u0005 \u00115A\u0011\u0002C\u0011\u0003=\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004Dc\u00027\u0005$\u0011\u0015B\u0011\u0006\u0005\t\u0007c\"i\u00021\u0001\u00022!9Aq\u0005C\u000f\u0001\u0004A\u0014\u0001\u00044j]\u0006dW*Z:tC\u001e,\u0007BCBS\t;\u0001\n\u00111\u0001\u0004(\"Q\u00111 C\u0007\u0003\u0003%\t\t\"\f\u0015\u000b9#y\u0003\"\r\t\r\u0001\"Y\u00031\u0001$\u0011\u0019qC1\u0006a\u0001a!Q!q\u0001C\u0007\u0003\u0003%\t\t\"\u000e\u0015\t\u0011]B1\b\t\u0006\u001d\t5A\u0011\b\t\u0006\u001d\t%6\u0005\r\u0005\n\u00053!\u0019$!AA\u00029C!\u0002b\u0010\u0005\u000eE\u0005I\u0011BBn\u0003e\u0011X\r]8si\u0012\u000bG/\u0019'pgN\u0004D\u0005Z3gCVdG\u000fJ\u001a\t\u0015\u0011\rCQBA\u0001\n\u0013!)%A\u0006sK\u0006$'+Z:pYZ,G#A\"")
public class InternalKafkaConsumer
implements Logging,
Product,
scala.Serializable {
    private volatile InternalKafkaConsumer$FetchedData$ FetchedData$module;
    private volatile InternalKafkaConsumer$FetchedRecord$ FetchedRecord$module;
    private final TopicPartition topicPartition;
    private final java.util.Map<String, Object> kafkaParams;
    private final String groupId;
    private volatile KafkaConsumer<byte[], byte[]> consumer;
    private volatile boolean inUse;
    private volatile boolean markedForClose;
    private final FetchedData fetchedData;
    private final FetchedRecord fetchedRecord;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Tuple2<TopicPartition, java.util.Map<String, Object>>> unapply(InternalKafkaConsumer internalKafkaConsumer) {
        return InternalKafkaConsumer$.MODULE$.unapply(internalKafkaConsumer);
    }

    public static InternalKafkaConsumer apply(TopicPartition topicPartition, java.util.Map<String, Object> map) {
        return InternalKafkaConsumer$.MODULE$.apply(topicPartition, map);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    private InternalKafkaConsumer$FetchedData$ FetchedData() {
        if (this.FetchedData$module == null) {
            this.FetchedData$lzycompute$1();
        }
        return this.FetchedData$module;
    }

    private InternalKafkaConsumer$FetchedRecord$ FetchedRecord() {
        if (this.FetchedRecord$module == null) {
            this.FetchedRecord$lzycompute$1();
        }
        return this.FetchedRecord$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public java.util.Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    private String groupId() {
        return this.groupId;
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void inUse_$eq(boolean x$1) {
        this.inUse = x$1;
    }

    public boolean markedForClose() {
        return this.markedForClose;
    }

    public void markedForClose_$eq(boolean x$1) {
        this.markedForClose = x$1;
    }

    private FetchedData fetchedData() {
        return this.fetchedData;
    }

    private FetchedRecord fetchedRecord() {
        return this.fetchedRecord;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer() {
        void var1_1;
        KafkaConsumer c = new KafkaConsumer(this.kafkaParams());
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        tps.add(this.topicPartition());
        c.assign(tps);
        return var1_1;
    }

    private <T> T runUninterruptiblyIfPossible(Function0<T> body) {
        Object object;
        Thread thread = Thread.currentThread();
        if (thread instanceof UninterruptibleThread) {
            UninterruptibleThread uninterruptibleThread = (UninterruptibleThread)thread;
            object = uninterruptibleThread.runUninterruptibly(body);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "CachedKafkaConsumer is not running in UninterruptibleThread. It may hang when CachedKafkaConsumer's methods are interrupted because of KAFKA-1894");
            object = body.apply();
        }
        return (T)object;
    }

    public KafkaDataConsumer.AvailableOffsetRange getAvailableOffsetRange() {
        return (KafkaDataConsumer.AvailableOffsetRange)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            this.consumer().seekToBeginning((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
            long earliestOffset = this.consumer().position(this.topicPartition());
            this.consumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
            long latestOffset = this.consumer().position(this.topicPartition());
            return new KafkaDataConsumer.AvailableOffsetRange(earliestOffset, latestOffset);
        });
    }

    public ConsumerRecord<byte[], byte[]> get(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        return (ConsumerRecord)this.runUninterruptiblyIfPossible((Function0 & Serializable & scala.Serializable)() -> {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            Predef$.MODULE$.require(offset < untilOffset, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("offset must always be less than untilOffset [offset: ").append(offset).append(", untilOffset: ").append(untilOffset).append("]").toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Get ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" nextOffset ").append(this.fetchedData().nextOffsetInFetchedData()).append(" ").append(new StringBuilder(10).append("requested ").append(offset).toString()).toString());
            LongRef toFetchOffset = LongRef.create((long)offset);
            FetchedRecord fetchedRecord = null;
            boolean isFetchComplete = false;
            while (toFetchOffset.elem != InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET() && !isFetchComplete) {
                try {
                    fetchedRecord = this.fetchRecord(toFetchOffset.elem, untilOffset, pollTimeoutMs, failOnDataLoss);
                    if (fetchedRecord.record() != null) {
                        isFetchComplete = true;
                        continue;
                    }
                    toFetchOffset.elem = fetchedRecord.nextOffsetToFetch();
                    if (toFetchOffset.elem >= untilOffset) {
                        this.fetchedData().reset();
                        toFetchOffset.elem = InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET();
                        continue;
                    }
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Skipped offsets [").append(offset).append(", ").append(toFetchOffset$1.elem).append("]").toString());
                }
                catch (OffsetOutOfRangeException e) {
                    this.resetConsumer();
                    this.reportDataLoss(failOnDataLoss, new StringBuilder(20).append("Cannot fetch offset ").append(toFetchOffset.elem).toString(), e);
                    toFetchOffset.elem = this.getEarliestAvailableOffsetBetween(toFetchOffset.elem, untilOffset);
                }
            }
            if (isFetchComplete) {
                consumerRecord = fetchedRecord.record();
            } else {
                this.fetchedData().reset();
                consumerRecord = null;
            }
            return consumerRecord;
        });
    }

    private long getEarliestAvailableOffsetBetween(long offset, long untilOffset) {
        long l;
        KafkaDataConsumer.AvailableOffsetRange range = this.getAvailableOffsetRange();
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Some data may be lost. Recovering from the earliest offset: ").append(range.earliest()).toString());
        if (offset >= range.latest() || range.earliest() >= untilOffset) {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n          |The current available offset range is ").append(range).append(".\n          | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(untilOffset).append(") will be\n          | skipped ").append(this.additionalMessage(false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET();
        } else if (offset >= range.earliest()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Found a disappeared offset ").append(offset).append(". ").append(new StringBuilder(22).append("Some data may be lost ").append(this.additionalMessage(false)).toString()).toString());
            l = offset;
        } else {
            String warningMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(149).append("\n           |The current available offset range is ").append(range).append(".\n           | Offset ").append(offset).append(" is out of range, and records in [").append(offset).append(", ").append(range.earliest()).append(") will be\n           | skipped ").append(this.additionalMessage(false)).append("\n        ").toString())).stripMargin();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
            l = range.earliest();
        }
        return l;
    }

    private FetchedRecord fetchRecord(long offset, long untilOffset, long pollTimeoutMs, boolean failOnDataLoss) {
        FetchedRecord fetchedRecord;
        if (offset != this.fetchedData().nextOffsetInFetchedData()) {
            this.fetchData(offset, pollTimeoutMs);
        } else if (!this.fetchedData().hasNext()) {
            if (offset < this.fetchedData().offsetAfterPoll()) {
                long nextOffsetToFetch = this.fetchedData().offsetAfterPoll();
                this.fetchedData().reset();
                return this.fetchedRecord().withRecord(null, nextOffsetToFetch);
            }
            this.fetchData(offset, pollTimeoutMs);
        }
        if (!this.fetchedData().hasNext()) {
            Predef$.MODULE$.assert(offset <= this.fetchedData().offsetAfterPoll(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("seek to ").append(offset).append(" and poll but the offset was reset to ").append(this.fetchedData().offsetAfterPoll()).toString());
            fetchedRecord = this.fetchedRecord().withRecord(null, this.fetchedData().offsetAfterPoll());
        } else {
            ConsumerRecord<byte[], byte[]> record = this.fetchedData().next();
            if (record.offset() > offset) {
                KafkaDataConsumer.AvailableOffsetRange range = this.getAvailableOffsetRange();
                if (range.earliest() <= offset) {
                    this.fetchedData().previous();
                    return this.fetchedRecord().withRecord(null, record.offset());
                }
                if (failOnDataLoss) {
                    this.reportDataLoss(true, new StringBuilder(28).append("Cannot fetch records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$3());
                    throw new IllegalStateException("reportDataLoss didn't throw an exception when 'failOnDataLoss' is true");
                }
                if (record.offset() >= untilOffset) {
                    this.reportDataLoss(false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(untilOffset).append(")").toString(), this.reportDataLoss$default$3());
                    fetchedRecord = this.fetchedRecord().withRecord(null, untilOffset);
                } else {
                    this.reportDataLoss(false, new StringBuilder(28).append("Skip missing records in [").append(offset).append(", ").append(record.offset()).append(")").toString(), this.reportDataLoss$default$3());
                    fetchedRecord = this.fetchedRecord().withRecord(record, this.fetchedData().nextOffsetInFetchedData());
                }
            } else {
                if (record.offset() < offset) {
                    throw new IllegalStateException(new StringBuilder(51).append("Tried to fetch ").append(offset).append(" but the returned record offset was ").append(record.offset()).toString());
                }
                fetchedRecord = this.fetchedRecord().withRecord(record, this.fetchedData().nextOffsetInFetchedData());
            }
        }
        return fetchedRecord;
    }

    private void resetConsumer() {
        this.consumer().close();
        this.consumer_$eq(this.createConsumer());
        this.fetchedData().reset();
    }

    private String additionalMessage(boolean failOnDataLoss) {
        return failOnDataLoss ? new StringBuilder(31).append("(GroupId: ").append(this.groupId()).append(", TopicPartition: ").append(this.topicPartition()).append("). ").append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_TRUE())).toString() : new StringBuilder(31).append("(GroupId: ").append(this.groupId()).append(", TopicPartition: ").append(this.topicPartition()).append("). ").append(String.valueOf(KafkaSourceProvider$.MODULE$.INSTRUCTION_FOR_FAIL_ON_DATA_LOSS_FALSE())).toString();
    }

    private void reportDataLoss(boolean failOnDataLoss, String message, Throwable cause) {
        String finalMessage = new StringBuilder(1).append(message).append(" ").append(this.additionalMessage(failOnDataLoss)).toString();
        InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$reportDataLoss0(failOnDataLoss, finalMessage, cause);
    }

    private Throwable reportDataLoss$default$3() {
        return null;
    }

    public void close() {
        this.consumer().close();
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Seeking to ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    private void fetchData(long offset, long pollTimeoutMs) {
        this.seek(offset);
        ConsumerRecords p = this.consumer().poll(pollTimeoutMs);
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Polled ").append(this.groupId()).append(" ").append(p.partitions()).append("  ").append(r.size()).toString());
        long offsetAfterPoll = this.consumer().position(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Offset changed from ").append(offset).append(" to ").append(offsetAfterPoll).append(" after polling").toString());
        this.fetchedData().withNewPoll(r.listIterator(), offsetAfterPoll);
        if (!this.fetchedData().hasNext()) {
            KafkaDataConsumer.AvailableOffsetRange range = this.getAvailableOffsetRange();
            if (offset < range.earliest() || offset >= range.latest()) {
                throw new OffsetOutOfRangeException((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)offset)}))).asJava());
            }
            if (offset == offsetAfterPoll) {
                throw new TimeoutException(new StringBuilder(48).append("Cannot fetch record for offset ").append(offset).append(" in ").append(pollTimeoutMs).append(" milliseconds").toString());
            }
        }
    }

    public InternalKafkaConsumer copy(TopicPartition topicPartition, java.util.Map<String, Object> kafkaParams) {
        return new InternalKafkaConsumer(topicPartition, kafkaParams);
    }

    public TopicPartition copy$default$1() {
        return this.topicPartition();
    }

    public java.util.Map<String, Object> copy$default$2() {
        return this.kafkaParams();
    }

    public String productPrefix() {
        return "InternalKafkaConsumer";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.topicPartition();
                break;
            }
            case 1: {
                object = this.kafkaParams();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InternalKafkaConsumer;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InternalKafkaConsumer)) return false;
        boolean bl = true;
        if (!bl) return false;
        InternalKafkaConsumer internalKafkaConsumer = (InternalKafkaConsumer)x$1;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = internalKafkaConsumer.topicPartition();
        if (topicPartition == null) {
            if (topicPartition2 != null) {
                return false;
            }
        } else if (!topicPartition.equals(topicPartition2)) return false;
        java.util.Map<String, Object> map = this.kafkaParams();
        java.util.Map<String, Object> map2 = internalKafkaConsumer.kafkaParams();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!((Object)map).equals(map2)) return false;
        if (!internalKafkaConsumer.canEqual(this)) return false;
        return true;
    }

    private final void FetchedData$lzycompute$1() {
        InternalKafkaConsumer internalKafkaConsumer = this;
        synchronized (internalKafkaConsumer) {
            if (this.FetchedData$module == null) {
                this.FetchedData$module = new InternalKafkaConsumer$FetchedData$(this);
            }
        }
    }

    private final void FetchedRecord$lzycompute$1() {
        InternalKafkaConsumer internalKafkaConsumer = this;
        synchronized (internalKafkaConsumer) {
            if (this.FetchedRecord$module == null) {
                this.FetchedRecord$module = new InternalKafkaConsumer$FetchedRecord$(this);
            }
        }
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, java.util.Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.consumer = this.createConsumer();
        this.inUse = true;
        this.markedForClose = false;
        this.fetchedData = new FetchedData(this, Collections.emptyListIterator(), InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET(), InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET());
        this.fetchedRecord = new FetchedRecord(this, null, InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET());
    }

    public class FetchedData
    implements Product,
    scala.Serializable {
        private ListIterator<ConsumerRecord<byte[], byte[]>> _records;
        private long _nextOffsetInFetchedData;
        private long _offsetAfterPoll;
        public final /* synthetic */ InternalKafkaConsumer $outer;

        public ListIterator<ConsumerRecord<byte[], byte[]>> _records$access$0() {
            return this._records;
        }

        public long _nextOffsetInFetchedData$access$1() {
            return this._nextOffsetInFetchedData;
        }

        public long _offsetAfterPoll$access$2() {
            return this._offsetAfterPoll;
        }

        private ListIterator<ConsumerRecord<byte[], byte[]>> _records() {
            return this._records;
        }

        private void _records_$eq(ListIterator<ConsumerRecord<byte[], byte[]>> x$1) {
            this._records = x$1;
        }

        private long _nextOffsetInFetchedData() {
            return this._nextOffsetInFetchedData;
        }

        private void _nextOffsetInFetchedData_$eq(long x$1) {
            this._nextOffsetInFetchedData = x$1;
        }

        private long _offsetAfterPoll() {
            return this._offsetAfterPoll;
        }

        private void _offsetAfterPoll_$eq(long x$1) {
            this._offsetAfterPoll = x$1;
        }

        public FetchedData withNewPoll(ListIterator<ConsumerRecord<byte[], byte[]>> records, long offsetAfterPoll) {
            this._records_$eq(records);
            this._nextOffsetInFetchedData_$eq(InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET());
            this._offsetAfterPoll_$eq(offsetAfterPoll);
            return this;
        }

        public boolean hasNext() {
            return this._records().hasNext();
        }

        /*
         * WARNING - void declaration
         */
        public ConsumerRecord<byte[], byte[]> next() {
            void var1_1;
            ConsumerRecord<byte[], byte[]> record = this._records().next();
            this._nextOffsetInFetchedData_$eq(record.offset() + 1L);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public ConsumerRecord<byte[], byte[]> previous() {
            void var1_1;
            Predef$.MODULE$.assert(this._records().hasPrevious(), (Function0 & Serializable & scala.Serializable)() -> "fetchedData cannot move back");
            ConsumerRecord<byte[], byte[]> record = this._records().previous();
            this._nextOffsetInFetchedData_$eq(record.offset());
            return var1_1;
        }

        public void reset() {
            this._records_$eq(Collections.emptyListIterator());
            this._nextOffsetInFetchedData_$eq(InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET());
            this._offsetAfterPoll_$eq(InternalKafkaConsumer$.MODULE$.org$apache$spark$sql$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET());
        }

        public long nextOffsetInFetchedData() {
            return this._nextOffsetInFetchedData();
        }

        public long offsetAfterPoll() {
            return this._offsetAfterPoll();
        }

        public FetchedData copy(ListIterator<ConsumerRecord<byte[], byte[]>> _records, long _nextOffsetInFetchedData, long _offsetAfterPoll) {
            return new FetchedData(this.org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedData$$$outer(), _records, _nextOffsetInFetchedData, _offsetAfterPoll);
        }

        public ListIterator<ConsumerRecord<byte[], byte[]>> copy$default$1() {
            return this._records();
        }

        public long copy$default$2() {
            return this._nextOffsetInFetchedData();
        }

        public long copy$default$3() {
            return this._offsetAfterPoll();
        }

        public String productPrefix() {
            return "FetchedData";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this._records$access$0();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this._nextOffsetInFetchedData$access$1());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this._offsetAfterPoll$access$2());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedData;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this._records$access$0()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this._nextOffsetInFetchedData$access$1()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this._offsetAfterPoll$access$2()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FetchedData)) return false;
            if (((FetchedData)object).org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedData$$$outer() != this.org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedData$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FetchedData fetchedData = (FetchedData)x$1;
            ListIterator<ConsumerRecord<byte[], byte[]>> listIterator = this._records$access$0();
            ListIterator<ConsumerRecord<byte[], byte[]>> listIterator2 = fetchedData._records$access$0();
            if (listIterator == null) {
                if (listIterator2 != null) {
                    return false;
                }
            } else if (!listIterator.equals(listIterator2)) return false;
            if (this._nextOffsetInFetchedData$access$1() != fetchedData._nextOffsetInFetchedData$access$1()) return false;
            if (this._offsetAfterPoll$access$2() != fetchedData._offsetAfterPoll$access$2()) return false;
            if (!fetchedData.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InternalKafkaConsumer org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedData$$$outer() {
            return this.$outer;
        }

        public FetchedData(InternalKafkaConsumer $outer, ListIterator<ConsumerRecord<byte[], byte[]>> _records, long _nextOffsetInFetchedData, long _offsetAfterPoll) {
            this._records = _records;
            this._nextOffsetInFetchedData = _nextOffsetInFetchedData;
            this._offsetAfterPoll = _offsetAfterPoll;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class FetchedRecord
    implements Product,
    scala.Serializable {
        private ConsumerRecord<byte[], byte[]> record;
        private long nextOffsetToFetch;
        public final /* synthetic */ InternalKafkaConsumer $outer;

        public ConsumerRecord<byte[], byte[]> record() {
            return this.record;
        }

        public void record_$eq(ConsumerRecord<byte[], byte[]> x$1) {
            this.record = x$1;
        }

        public long nextOffsetToFetch() {
            return this.nextOffsetToFetch;
        }

        public void nextOffsetToFetch_$eq(long x$1) {
            this.nextOffsetToFetch = x$1;
        }

        public FetchedRecord withRecord(ConsumerRecord<byte[], byte[]> record, long nextOffsetToFetch) {
            this.record_$eq(record);
            this.nextOffsetToFetch_$eq(nextOffsetToFetch);
            return this;
        }

        public FetchedRecord copy(ConsumerRecord<byte[], byte[]> record, long nextOffsetToFetch) {
            return new FetchedRecord(this.org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedRecord$$$outer(), record, nextOffsetToFetch);
        }

        public ConsumerRecord<byte[], byte[]> copy$default$1() {
            return this.record();
        }

        public long copy$default$2() {
            return this.nextOffsetToFetch();
        }

        public String productPrefix() {
            return "FetchedRecord";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.record();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.nextOffsetToFetch());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedRecord;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.record()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nextOffsetToFetch()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FetchedRecord)) return false;
            if (((FetchedRecord)object).org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedRecord$$$outer() != this.org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedRecord$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FetchedRecord fetchedRecord = (FetchedRecord)x$1;
            ConsumerRecord<byte[], byte[]> consumerRecord = this.record();
            ConsumerRecord<byte[], byte[]> consumerRecord2 = fetchedRecord.record();
            if (consumerRecord == null) {
                if (consumerRecord2 != null) {
                    return false;
                }
            } else if (!consumerRecord.equals(consumerRecord2)) return false;
            if (this.nextOffsetToFetch() != fetchedRecord.nextOffsetToFetch()) return false;
            if (!fetchedRecord.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ InternalKafkaConsumer org$apache$spark$sql$kafka010$InternalKafkaConsumer$FetchedRecord$$$outer() {
            return this.$outer;
        }

        public FetchedRecord(InternalKafkaConsumer $outer, ConsumerRecord<byte[], byte[]> record, long nextOffsetToFetch) {
            this.record = record;
            this.nextOffsetToFetch = nextOffsetToFetch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

