/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.kafka010.KafkaDataConsumer;
import org.apache.spark.sql.kafka010.KafkaDataConsumer$;
import org.apache.spark.sql.kafka010.KafkaRecordToUnsafeRowConverter;
import org.apache.spark.sql.kafka010.KafkaSourcePartitionOffset;
import org.apache.spark.sql.sources.v2.reader.streaming.ContinuousInputPartitionReader;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u00111eS1gW\u0006\u001cuN\u001c;j]V|Wo]%oaV$\b+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002\u0004\t\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0004/\u0001\u0012S\"\u0001\r\u000b\u0005eQ\u0012!C:ue\u0016\fW.\u001b8h\u0015\tYB$\u0001\u0004sK\u0006$WM\u001d\u0006\u0003;y\t!A\u001e\u001a\u000b\u0005}!\u0011aB:pkJ\u001cWm]\u0005\u0003Ca\u0011adQ8oi&tWo\\;t\u0013:\u0004X\u000f\u001e)beRLG/[8o%\u0016\fG-\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005\u001d\"#aC%oi\u0016\u0014h.\u00197S_^D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\tY\u0003'D\u0001-\u0015\tic&\u0001\u0004d_6lwN\u001c\u0006\u0003_!\tQa[1gW\u0006L!!\r\u0017\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A1\u0007\u0001B\u0001B\u0003%A'A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\bCA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$\u0001\u0002'p]\u001eD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001P\u0001\fW\u000647.\u0019)be\u0006l7\u000f\u0005\u0003>\u0001\nsQ\"\u0001 \u000b\u0005}\u0012\u0012\u0001B;uS2L!!\u0011 \u0003\u00075\u000b\u0007\u000f\u0005\u0002D\u0015:\u0011A\t\u0013\t\u0003\u000bZj\u0011A\u0012\u0006\u0003\u000f2\ta\u0001\u0010:p_Rt\u0014BA%7\u0003\u0019\u0001&/\u001a3fM&\u00111\n\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%3\u0004\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0016A\u00044bS2|e\u000eR1uC2{7o\u001d\t\u0003kIK!a\u0015\u001c\u0003\u000f\t{w\u000e\\3b]\")Q\u000b\u0001C\u0001-\u00061A(\u001b8jiz\"baV-[7rk\u0006C\u0001-\u0001\u001b\u0005\u0011\u0001\"B\u0015U\u0001\u0004Q\u0003\"B\u001aU\u0001\u0004!\u0004\"B\u001eU\u0001\u0004a\u0004\"\u0002(U\u0001\u0004!\u0004\"\u0002)U\u0001\u0004\t\u0006bB0\u0001\u0005\u0004%I\u0001Y\u0001\tG>t7/^7feV\t\u0011\r\u0005\u0002YE&\u00111M\u0001\u0002\u0012\u0017\u000647.\u0019#bi\u0006\u001cuN\\:v[\u0016\u0014\bBB3\u0001A\u0003%\u0011-A\u0005d_:\u001cX/\\3sA!9q\r\u0001b\u0001\n\u0013A\u0017!C2p]Z,'\u000f^3s+\u0005I\u0007C\u0001-k\u0013\tY'AA\u0010LC\u001a\\\u0017MU3d_J$Gk\\+og\u00064WMU8x\u0007>tg/\u001a:uKJDa!\u001c\u0001!\u0002\u0013I\u0017AC2p]Z,'\u000f^3sA!9q\u000e\u0001a\u0001\n\u0013\u0001\u0018a\u00048fqR\\\u0015MZ6b\u001f\u001a47/\u001a;\u0016\u0003QBqA\u001d\u0001A\u0002\u0013%1/A\noKb$8*\u00194lC>3gm]3u?\u0012*\u0017\u000f\u0006\u0002uoB\u0011Q'^\u0005\u0003mZ\u0012A!\u00168ji\"9\u00010]A\u0001\u0002\u0004!\u0014a\u0001=%c!1!\u0010\u0001Q!\nQ\n\u0001C\\3yi.\u000bgm[1PM\u001a\u001cX\r\u001e\u0011\t\u0013q\u0004\u0001\u0019!a\u0001\n\u0013i\u0018!D2veJ,g\u000e\u001e*fG>\u0014H-F\u0001\u007f!\u001dy\u0018qAA\u0006\u0003\u0017i!!!\u0001\u000b\u0007}\u000b\u0019AC\u0002\u0002\u00069\nqa\u00197jK:$8/\u0003\u0003\u0002\n\u0005\u0005!AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\t\u0006k\u00055\u0011\u0011C\u0005\u0004\u0003\u001f1$!B!se\u0006L\bcA\u001b\u0002\u0014%\u0019\u0011Q\u0003\u001c\u0003\t\tKH/\u001a\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0013\tY\"A\tdkJ\u0014XM\u001c;SK\u000e|'\u000fZ0%KF$2\u0001^A\u000f\u0011!A\u0018qCA\u0001\u0002\u0004q\bBCA\u0011\u0001\u0001\u0007\t\u0011)Q\u0005}\u0006q1-\u001e:sK:$(+Z2pe\u0012\u0004\u0003bBA\u0013\u0001\u0011\u0005\u0013qE\u0001\u0005]\u0016DH\u000fF\u0001R\u0011\u001d\tY\u0003\u0001C!\u0003[\t1aZ3u)\t\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004J\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002:\u0005M\"!C+og\u00064WMU8x\u0011\u001d\ti\u0004\u0001C!\u0003\u007f\t\u0011bZ3u\u001f\u001a47/\u001a;\u0015\u0005\u0005\u0005\u0003c\u0001-\u0002D%\u0019\u0011Q\t\u0002\u00035-\u000bgm[1T_V\u00148-\u001a)beRLG/[8o\u001f\u001a47/\u001a;\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L\u0005)1\r\\8tKR\tA\u000f")
public class KafkaContinuousInputPartitionReader
implements ContinuousInputPartitionReader<InternalRow> {
    private final TopicPartition topicPartition;
    private final long pollTimeoutMs;
    private final boolean failOnDataLoss;
    private final KafkaDataConsumer consumer;
    private final KafkaRecordToUnsafeRowConverter converter;
    private long nextKafkaOffset;
    private ConsumerRecord<byte[], byte[]> currentRecord;

    private KafkaDataConsumer consumer() {
        return this.consumer;
    }

    private KafkaRecordToUnsafeRowConverter converter() {
        return this.converter;
    }

    private long nextKafkaOffset() {
        return this.nextKafkaOffset;
    }

    private void nextKafkaOffset_$eq(long x$1) {
        this.nextKafkaOffset = x$1;
    }

    private ConsumerRecord<byte[], byte[]> currentRecord() {
        return this.currentRecord;
    }

    private void currentRecord_$eq(ConsumerRecord<byte[], byte[]> x$1) {
        this.currentRecord = x$1;
    }

    public boolean next() {
        ConsumerRecord<byte[], byte[]> r = null;
        while (r == null) {
            if (TaskContext$.MODULE$.get().isInterrupted() || TaskContext$.MODULE$.get().isCompleted()) {
                return false;
            }
            try {
                r = this.consumer().get(this.nextKafkaOffset(), Long.MAX_VALUE, this.pollTimeoutMs, this.failOnDataLoss);
            }
            catch (Throwable throwable) {
                IllegalStateException illegalStateException;
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof java.util.concurrent.TimeoutException ? true : throwable2 instanceof TimeoutException;
                if (bl) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof IllegalStateException && (illegalStateException = (IllegalStateException)throwable2).getCause() instanceof OffsetOutOfRangeException) {
                    KafkaDataConsumer.AvailableOffsetRange range = this.consumer().getAvailableOffsetRange();
                    if (range.latest() < this.nextKafkaOffset() || range.earliest() > this.nextKafkaOffset()) {
                        throw illegalStateException;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw throwable;
            }
        }
        this.nextKafkaOffset_$eq(r.offset() + 1L);
        this.currentRecord_$eq(r);
        return true;
    }

    public UnsafeRow get() {
        return this.converter().toUnsafeRow(this.currentRecord());
    }

    public KafkaSourcePartitionOffset getOffset() {
        return new KafkaSourcePartitionOffset(this.topicPartition, this.nextKafkaOffset());
    }

    public void close() {
        this.consumer().release();
    }

    public KafkaContinuousInputPartitionReader(TopicPartition topicPartition, long startOffset, Map<String, Object> kafkaParams, long pollTimeoutMs, boolean failOnDataLoss) {
        this.topicPartition = topicPartition;
        this.pollTimeoutMs = pollTimeoutMs;
        this.failOnDataLoss = failOnDataLoss;
        this.consumer = KafkaDataConsumer$.MODULE$.acquire(topicPartition, kafkaParams, false);
        this.converter = new KafkaRecordToUnsafeRowConverter();
        this.nextKafkaOffset = startOffset;
    }
}

