/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.sql.kafka010.KafkaOffsetRange;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeCalculator$;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001q4Q!\u0001\u0002\u0001\u00051\u0011!dS1gW\u0006|eMZ:fiJ\u000bgnZ3DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0011-\fgm[11cAR!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\t\u0001Q\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005iQ.\u001b8QCJ$\u0018\u000e^5p]N\u001c\u0001!F\u0001\u0018!\rq\u0001DG\u0005\u00033=\u0011aa\u00149uS>t\u0007C\u0001\b\u001c\u0013\tarBA\u0002J]RD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaF\u0001\u000f[&t\u0007+\u0019:uSRLwN\\:!\u0011\u0015\u0001\u0003\u0001\"\u0001\"\u0003\u0019a\u0014N\\5u}Q\u0011!\u0005\n\t\u0003G\u0001i\u0011A\u0001\u0005\u0006)}\u0001\ra\u0006\u0005\u0006M\u0001!\taJ\u0001\nO\u0016$(+\u00198hKN$B\u0001K\u001c@\u0003B\u0019\u0011&\r\u001b\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017\u0016\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u00021\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u0005\r\u0019V-\u001d\u0006\u0003a=\u0001\"aI\u001b\n\u0005Y\u0012!\u0001E&bM.\fwJ\u001a4tKR\u0014\u0016M\\4f\u0011\u0015AT\u00051\u0001:\u0003-1'o\\7PM\u001a\u001cX\r^:\u0011\u0005ibdBA\u0012<\u0013\t\u0001$!\u0003\u0002>}\t\u0011\u0002+\u0019:uSRLwN\\(gMN,G/T1q\u0015\t\u0001$\u0001C\u0003AK\u0001\u0007\u0011(\u0001\u0007v]RLGn\u00144gg\u0016$8\u000fC\u0004CKA\u0005\t\u0019A\"\u0002#\u0015DXmY;u_JdunY1uS>t7\u000fE\u0002*c\u0011\u0003\"!R%\u000f\u0005\u0019;\u0005CA\u0016\u0010\u0013\tAu\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0010\u0011\u0015i\u0005\u0001\"\u0003O\u0003-9W\r\u001e'pG\u0006$\u0018n\u001c8\u0015\u0007=\u0003&\fE\u0002\u000f1\u0011CQ!\u0015'A\u0002I\u000b!\u0001\u001e9\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016AB2p[6|gN\u0003\u0002X\u0011\u0005)1.\u00194lC&\u0011\u0011\f\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015\u0011E\n1\u0001D\u0011\u001da\u0006!%A\u0005\u0002u\u000b1cZ3u%\u0006tw-Z:%I\u00164\u0017-\u001e7uIM*\u0012A\u0018\u0016\u0003\u0007~[\u0013\u0001\u0019\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0015|\u0011AC1o]>$\u0018\r^5p]&\u0011qM\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,wAB5\u0003\u0011\u0003\u0011!.\u0001\u000eLC\u001a\\\u0017m\u00144gg\u0016$(+\u00198hK\u000e\u000bGnY;mCR|'\u000f\u0005\u0002$W\u001a1\u0011A\u0001E\u0001\u00051\u001c\"a[\u0007\t\u000b\u0001ZG\u0011\u00018\u0015\u0003)DQ\u0001]6\u0005\u0002E\fQ!\u00199qYf$\"A\t:\t\u000bM|\u0007\u0019\u0001;\u0002\u000f=\u0004H/[8ogB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0003mJR!!\u001f\u0003\u0002\u000fM|WO]2fg&\u00111P\u001e\u0002\u0012\t\u0006$\u0018mU8ve\u000e,w\n\u001d;j_:\u001c\b")
public class KafkaOffsetRangeCalculator {
    private final Option<Object> minPartitions;

    public static KafkaOffsetRangeCalculator apply(DataSourceOptions dataSourceOptions) {
        return KafkaOffsetRangeCalculator$.MODULE$.apply(dataSourceOptions);
    }

    public Option<Object> minPartitions() {
        return this.minPartitions;
    }

    public Seq<KafkaOffsetRange> getRanges(Map<TopicPartition, Object> fromOffsets, Map<TopicPartition, Object> untilOffsets, Seq<String> executorLocations) {
        Seq seq;
        Set partitionsToRead = (Set)untilOffsets.keySet().intersect((GenSet)fromOffsets.keySet());
        Seq offsetRanges = (Seq)((TraversableLike)partitionsToRead.toSeq().map((Function1 & Serializable & scala.Serializable)tp -> new KafkaOffsetRange((TopicPartition)tp, BoxesRunTime.unboxToLong((Object)fromOffsets.apply(tp)), BoxesRunTime.unboxToLong((Object)untilOffsets.apply(tp)), (Option<String>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaOffsetRangeCalculator.$anonfun$getRanges$2(x$1)));
        if (this.minPartitions().isEmpty() || offsetRanges.size() > BoxesRunTime.unboxToInt((Object)this.minPartitions().get())) {
            seq = (Seq)offsetRanges.map((Function1 & Serializable & scala.Serializable)range -> {
                Option<String> x$4 = this.getLocation(range.topicPartition(), executorLocations);
                TopicPartition x$5 = range.copy$default$1();
                long x$6 = range.copy$default$2();
                long x$7 = range.copy$default$3();
                return range.copy(x$5, x$6, x$7, x$4);
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            long totalSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)offsetRanges.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            double idealRangeSize = (double)totalSize / (double)BoxesRunTime.unboxToInt((Object)this.minPartitions().get());
            seq = (Seq)offsetRanges.flatMap((Function1 & Serializable & scala.Serializable)range -> {
                int numSplitsInRange = (int)package$.MODULE$.round((double)range.size() / idealRangeSize);
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSplitsInRange).map((Function1 & Serializable & scala.Serializable)i -> KafkaOffsetRangeCalculator.$anonfun$getRanges$6(numSplitsInRange, range, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<String> getRanges$default$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> getLocation(TopicPartition tp, Seq<String> executorLocations) {
        int numExecutors = executorLocations.length();
        return numExecutors > 0 ? new Some(executorLocations.apply(KafkaOffsetRangeCalculator.floorMod$1(tp.hashCode(), numExecutors))) : None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getRanges$2(KafkaOffsetRange x$1) {
        return x$1.size() > 0L;
    }

    public static final /* synthetic */ KafkaOffsetRange $anonfun$getRanges$6(int numSplitsInRange$1, KafkaOffsetRange range$1, int i) {
        double splitStart = (double)range$1.fromOffset() + (double)range$1.size() * ((double)i / (double)numSplitsInRange$1);
        double splitEnd = (double)range$1.fromOffset() + (double)range$1.size() * (((double)i + 1.0) / (double)numSplitsInRange$1);
        return new KafkaOffsetRange(range$1.topicPartition(), (long)splitStart, (long)splitEnd, (Option<String>)None$.MODULE$);
    }

    private static final int floorMod$1(long a, int b) {
        return ((int)(a % (long)b) + b) % b;
    }

    public KafkaOffsetRangeCalculator(Option<Object> minPartitions) {
        this.minPartitions = minPartitions;
        Predef$.MODULE$.require(minPartitions.isEmpty() || BoxesRunTime.unboxToInt((Object)minPartitions.get()) > 0);
    }
}

