/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.kafka010.ConsumerStrategy;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaOffsetReader$;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0001\ta!!D&bM.\f'+\u001a7bi&|gN\u0003\u0002\u0004\t\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014-A\u0011a\"E\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\bg>,(oY3t\u0013\t\u0011rB\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\n)\u0006\u0014G.Z*dC:\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001BC\u0002\u0013\u0005s$\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u0001!!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\fgFd7i\u001c8uKb$\b\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003!\u0019HO]1uK\u001eL\bCA\u0015+\u001b\u0005\u0011\u0011BA\u0016\u0003\u0005A\u0019uN\\:v[\u0016\u00148\u000b\u001e:bi\u0016<\u0017\u0010\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u00035\u0019x.\u001e:dK>\u0003H/[8ogB!q\u0006O\u001e<\u001d\t\u0001d\u0007\u0005\u00022i5\t!G\u0003\u00024=\u00051AH]8pizR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\ri\u0015\r\u001d\u0006\u0003oQ\u0002\"a\f\u001f\n\u0005uR$AB*ue&tw\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003/\u0003Q\u0019\b/Z2jM&,GmS1gW\u0006\u0004\u0016M]1ng\"A\u0011\t\u0001B\u0001B\u0003%!)\u0001\bgC&dwJ\u001c#bi\u0006dun]:\u0011\u0005\r#U\"\u0001\u001b\n\u0005\u0015#$a\u0002\"p_2,\u0017M\u001c\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\u0006y1\u000f^1si&twm\u00144gg\u0016$8\u000f\u0005\u0002*\u0013&\u0011!J\u0001\u0002\u0016\u0017\u000647.Y(gMN,GOU1oO\u0016d\u0015.\\5u\u0011!a\u0005A!A!\u0002\u0013A\u0015!D3oI&twm\u00144gg\u0016$8\u000fC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\t!F\u00136\u000bV+W/B\u0011\u0011\u0006\u0001\u0005\u0006;5\u0003\r\u0001\t\u0005\u0006O5\u0003\r\u0001\u000b\u0005\u0006[5\u0003\rA\f\u0005\u0006\u007f5\u0003\rA\f\u0005\u0006\u00036\u0003\rA\u0011\u0005\u0006\u000f6\u0003\r\u0001\u0013\u0005\u0006\u00196\u0003\r\u0001\u0013\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u00035\u0001x\u000e\u001c7US6,w.\u001e;NgV\t1\f\u0005\u0002D9&\u0011Q\f\u000e\u0002\u0005\u0019>tw\r\u0003\u0004`\u0001\u0001\u0006IaW\u0001\u000fa>dG\u000eV5nK>,H/T:!\u0011\u0015\t\u0007\u0001\"\u0011c\u0003\u0019\u00198\r[3nCV\t1\r\u0005\u0002eO6\tQM\u0003\u0002g\t\u0005)A/\u001f9fg&\u0011\u0001.\u001a\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u00026\u0001\t\u0003Z\u0017!\u00032vS2$7kY1o)\u0005a\u0007cA7qe6\taN\u0003\u0002p\r\u0005\u0019!\u000f\u001a3\n\u0005Et'a\u0001*E\tB\u0011\u0011e]\u0005\u0003i\u0012\u00111AU8x\u0011\u00151\b\u0001\"\u0003x\u0003M9W\r\u001e)beRLG/[8o\u001f\u001a47/\u001a;t)\u0015A\u00181AA\u0007!\u0011y\u0003(_.\u0011\u0005i|X\"A>\u000b\u0005ql\u0018AB2p[6|gN\u0003\u0002\u007f\u0011\u0005)1.\u00194lC&\u0019\u0011\u0011A>\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011QA;A\u0002\u0005\u001d\u0011aC6bM.\f'+Z1eKJ\u00042!KA\u0005\u0013\r\tYA\u0001\u0002\u0012\u0017\u000647.Y(gMN,GOU3bI\u0016\u0014\bBBA\bk\u0002\u0007\u0001*\u0001\u0007lC\u001a\\\u0017m\u00144gg\u0016$8\u000fC\u0004\u0002\u0014\u0001!\t%!\u0006\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u000f")
public class KafkaRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final ConsumerStrategy strategy;
    private final scala.collection.immutable.Map<String, String> sourceOptions;
    private final scala.collection.immutable.Map<String, String> specifiedKafkaParams;
    private final boolean failOnDataLoss;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public StructType schema() {
        return KafkaOffsetReader$.MODULE$.kafkaSchema();
    }

    public RDD<Row> buildScan() {
        Tuple2 tuple2;
        String uniqueGroupId = new StringBuilder(21).append("spark-kafka-relation-").append(UUID.randomUUID()).toString();
        try (KafkaOffsetReader kafkaOffsetReader = new KafkaOffsetReader(this.strategy, KafkaSourceProvider$.MODULE$.kafkaParamsForDriver(this.specifiedKafkaParams), this.sourceOptions, new StringBuilder(7).append(uniqueGroupId).append("-driver").toString());){
            tuple2 = new Tuple2(this.getPartitionOffsets(kafkaOffsetReader, this.startingOffsets), this.getPartitionOffsets(kafkaOffsetReader, this.endingOffsets));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        scala.collection.immutable.Map fromPartitionOffsets = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map untilPartitionOffsets = (scala.collection.immutable.Map)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)fromPartitionOffsets, (Object)untilPartitionOffsets);
        Tuple2 tuple24 = tuple23;
        scala.collection.immutable.Map fromPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._1();
        scala.collection.immutable.Map untilPartitionOffsets2 = (scala.collection.immutable.Map)tuple24._2();
        Set set = fromPartitionOffsets2.keySet();
        Set set2 = untilPartitionOffsets2.keySet();
        if (set == null ? set2 != null : !set.equals(set2)) {
            Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)t -> t.topic(), (Ordering)Ordering.String$.MODULE$);
            String fromTopics = ((TraversableOnce)fromPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            String untilTopics = ((TraversableOnce)untilPartitionOffsets2.keySet().toList().sorted(topicOrdering)).mkString(",");
            throw new IllegalStateException(new StringBuilder(27).append("different topic partitions ").append(new StringBuilder(34).append("for starting offsets topics[").append(fromTopics).append("] and ").toString()).append(new StringBuilder(23).append("ending offsets topics[").append(untilTopics).append("]").toString()).toString());
        }
        KafkaSourceRDDOffsetRange[] offsetRanges = (KafkaSourceRDDOffsetRange[])((TraversableOnce)untilPartitionOffsets2.keySet().map((Function1 & Serializable & scala.Serializable)tp -> {
            long fromOffset = BoxesRunTime.unboxToLong((Object)fromPartitionOffsets2.get(tp).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(27).append(tp).append(" doesn't have a from offset").toString());
            }));
            long untilOffset = BoxesRunTime.unboxToLong((Object)untilPartitionOffsets2.apply(tp));
            return new KafkaSourceRDDOffsetRange((TopicPartition)tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaSourceRDDOffsetRange.class));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("GetBatch generating RDD of offset range: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsetRanges)).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.topicPartition().toString(), (Ordering)Ordering.String$.MODULE$))).mkString(", ")).toString());
        Map<String, Object> executorKafkaParams = KafkaSourceProvider$.MODULE$.kafkaParamsForExecutors(this.specifiedKafkaParams, uniqueGroupId);
        RDD rdd = new KafkaSourceRDD(this.sqlContext().sparkContext(), executorKafkaParams, (Seq<KafkaSourceRDDOffsetRange>)Predef$.MODULE$.wrapRefArray((Object[])offsetRanges), this.pollTimeoutMs(), this.failOnDataLoss, false).map((Function1 & Serializable & scala.Serializable)cr -> InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cr.key(), cr.value(), UTF8String.fromString((String)cr.topic()), BoxesRunTime.boxToInteger((int)cr.partition()), BoxesRunTime.boxToLong((long)cr.offset()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.timestamp()))), BoxesRunTime.boxToInteger((int)cr.timestampType().id)})), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sqlContext().internalCreateDataFrame(rdd.setName("kafka"), this.schema(), this.sqlContext().internalCreateDataFrame$default$3()).rdd();
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getPartitionOffsets(KafkaOffsetReader kafkaReader, KafkaOffsetRangeLimit kafkaOffsets) {
        scala.collection.immutable.Map map;
        Set<TopicPartition> partitions = kafkaReader.fetchTopicPartitions();
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = kafkaOffsets;
        if (EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TopicPartition topicPartition = x0$1;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) {
            map = ((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TopicPartition topicPartition = x0$2;
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                return tuple2;
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else if (kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit) {
            SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
            scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets = specificOffsetRangeLimit.partitionOffsets();
            map = this.validateTopicPartitions$1(partitions, partitionOffsets);
        } else {
            throw new MatchError((Object)kafkaOffsetRangeLimit);
        }
        return map;
    }

    public String toString() {
        return new StringBuilder(38).append("KafkaRelation(strategy=").append(this.strategy).append(", start=").append(this.startingOffsets).append(", end=").append(this.endingOffsets).append(")").toString();
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(Set partitions, scala.collection.immutable.Map partitionOffsets) {
        Set set = partitions;
        Set set2 = partitionOffsets.keySet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(139).append("If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append(new StringBuilder(22).append("Specified: ").append(partitionOffsets.keySet()).append(" Assigned: ").append(partitions).toString()).toString());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Partitions assigned to consumer: ").append(partitions).append(". Seeking to ").append(partitionOffsets).toString());
        return partitionOffsets;
    }

    public KafkaRelation(SQLContext sqlContext, ConsumerStrategy strategy, scala.collection.immutable.Map<String, String> sourceOptions, scala.collection.immutable.Map<String, String> specifiedKafkaParams, boolean failOnDataLoss, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.strategy = strategy;
        this.sourceOptions = sourceOptions;
        this.specifiedKafkaParams = specifiedKafkaParams;
        this.failOnDataLoss = failOnDataLoss;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit == null ? latestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Starting offset not allowed to be set to latest offsets.");
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 == null ? earliestOffsetRangeLimit$ != null : !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$), (Function0 & Serializable & scala.Serializable)() -> "Ending offset not allowed to be set to earliest offsets.");
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)"kafkaConsumer.pollTimeoutMs", (Function0 & Serializable & scala.Serializable)() -> ((Object)BoxesRunTime.boxToLong((long)(this.sqlContext().sparkContext().conf().getTimeAsSeconds("spark.network.timeout", "120s") * 1000L))).toString()))).toLong();
    }
}

