/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.kafka010.KafkaWriter$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eaAB\u0001\u0003\u0003\u0003\u0011AB\u0001\bLC\u001a\\\u0017MU8x/JLG/\u001a:\u000b\u0005\r!\u0011\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u00151\u0011aA:rY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001aD\u0001\u0002\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\fS:\u0004X\u000f^*dQ\u0016l\u0017m\u0001\u0001\u0011\u0007]y\"E\u0004\u0002\u0019;9\u0011\u0011\u0004H\u0007\u00025)\u00111$F\u0001\u0007yI|w\u000e\u001e \n\u0003AI!AH\b\u0002\u000fA\f7m[1hK&\u0011\u0001%\t\u0002\u0004'\u0016\f(B\u0001\u0010\u0010!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015%\u0005%\tE\u000f\u001e:jEV$X\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u0015!x\u000e]5d!\rqQfL\u0005\u0003]=\u0011aa\u00149uS>t\u0007C\u0001\u00195\u001d\t\t$\u0007\u0005\u0002\u001a\u001f%\u00111gD\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024\u001f!)\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u0003\u0011\u0015!r\u00071\u0001\u0017\u0011\u0015Ys\u00071\u0001-\u0011%y\u0004\u00011AA\u0002\u0013E\u0001)A\u0006gC&dW\rZ,sSR,W#A!\u0011\u0005]\u0011\u0015BA\"\"\u0005%)\u0005pY3qi&|g\u000eC\u0005F\u0001\u0001\u0007\t\u0019!C\t\r\u0006ya-Y5mK\u0012<&/\u001b;f?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011a\u0002S\u0005\u0003\u0013>\u0011A!\u00168ji\"91\nRA\u0001\u0002\u0004\t\u0015a\u0001=%c!IQ\n\u0001a\u0001\u0002\u0003\u0006K!Q\u0001\rM\u0006LG.\u001a3Xe&$X\r\t\u0015\u0003\u0019>\u0003\"A\u0004)\n\u0005E{!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fM\u0003!\u0019!C\t)\u0006Q\u0001O]8kK\u000e$\u0018n\u001c8\u0016\u0003U\u0003\"a\t,\n\u0005]##\u0001E+og\u00064W\r\u0015:pU\u0016\u001cG/[8o\u0011\u0019I\u0006\u0001)A\u0005+\u0006Y\u0001O]8kK\u000e$\u0018n\u001c8!\u0011\u001dY\u0006A1A\u0005\nq\u000b\u0001bY1mY\n\f7m[\u000b\u0002;J\u0019aL\u00196\u0007\t}\u0003\u0007!\u0018\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\u0007C\u0002\u0001\u000b\u0011B/\u0002\u0013\r\fG\u000e\u001c2bG.\u0004\u0003CA2i\u001b\u0005!'BA3g\u0003\u0011a\u0017M\\4\u000b\u0003\u001d\fAA[1wC&\u0011\u0011\u000e\u001a\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017\u0001\u00039s_\u0012,8-\u001a:\u000b\u0005=\u0004\u0018aB2mS\u0016tGo\u001d\u0006\u0003c\"\tQa[1gW\u0006L!a\u001d7\u0003\u0011\r\u000bG\u000e\u001c2bG.DQ!\u001e\u0001\u0005\u0012Y\fqa]3oIJ{w\u000fF\u0002HovDQ\u0001\u001f;A\u0002e\f1A]8x!\tQ80D\u0001'\u0013\tahEA\u0006J]R,'O\\1m%><\b\"B7u\u0001\u0004q\bCB6\u0000\u0003\u0007\t\u0019!C\u0002\u0002\u00021\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#\u0002\b\u0002\u0006\u0005%\u0011bAA\u0004\u001f\t)\u0011I\u001d:bsB\u0019a\"a\u0003\n\u0007\u00055qB\u0001\u0003CsR,\u0007bBA\t\u0001\u0011E\u00111C\u0001\u000fG\",7m\u001b$pe\u0016\u0013(o\u001c:t)\u00059\u0005BBA\f\u0001\u0011%A+\u0001\tde\u0016\fG/\u001a)s_*,7\r^5p]\u0002")
public abstract class KafkaRowWriter {
    private final Seq<Attribute> inputSchema;
    private final Option<String> topic;
    private volatile Exception failedWrite;
    private final UnsafeProjection projection;
    private final Callback callback;

    public Exception failedWrite() {
        return this.failedWrite;
    }

    public void failedWrite_$eq(Exception x$1) {
        this.failedWrite = x$1;
    }

    public UnsafeProjection projection() {
        return this.projection;
    }

    private Callback callback() {
        return this.callback;
    }

    public void sendRow(InternalRow row, KafkaProducer<byte[], byte[]> producer) {
        UnsafeRow projectedRow = this.projection().apply(row);
        UTF8String topic = projectedRow.getUTF8String(0);
        byte[] key = projectedRow.getBinary(1);
        byte[] value = projectedRow.getBinary(2);
        if (topic == null) {
            throw new NullPointerException(new StringBuilder(40).append("null topic present in the data. Use the ").append(new StringBuilder(36).append(KafkaSourceProvider$.MODULE$.TOPIC_OPTION_KEY()).append(" option for setting a default topic.").toString()).toString());
        }
        ProducerRecord record = new ProducerRecord(topic.toString(), (Object)key, (Object)value);
        producer.send(record, this.callback());
    }

    public void checkForErrors() {
        if (this.failedWrite() != null) {
            throw this.failedWrite();
        }
    }

    private UnsafeProjection createProjection() {
        LeafExpression topicExpression = (LeafExpression)this.topic.map((Function1 & Serializable & scala.Serializable)x$1 -> Literal$.MODULE$.apply(x$1)).orElse((Function0 & Serializable & scala.Serializable)() -> $this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KafkaRowWriter.$anonfun$createProjection$3(x$2)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(30).append("topic option required when no ").append(new StringBuilder(23).append("'").append(KafkaWriter$.MODULE$.TOPIC_ATTRIBUTE_NAME()).append("' attribute is present").toString()).toString());
        });
        DataType dataType = topicExpression.dataType();
        if (!StringType$.MODULE$.equals(dataType)) {
            throw new IllegalStateException(new StringBuilder(1).append(KafkaWriter$.MODULE$.TOPIC_ATTRIBUTE_NAME()).append(" ").append(new StringBuilder(30).append("attribute unsupported type ").append(dataType).append(". ").append(KafkaWriter$.MODULE$.TOPIC_ATTRIBUTE_NAME()).append(" ").toString()).append(new StringBuilder(10).append("must be a ").append(StringType$.MODULE$.catalogString()).toString()).toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        LeafExpression keyExpression = (LeafExpression)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaRowWriter.$anonfun$createProjection$5(x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Literal(null, (DataType)BinaryType$.MODULE$));
        DataType dataType2 = keyExpression.dataType();
        boolean bl = StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2);
        if (!bl) {
            throw new IllegalStateException(new StringBuilder(1).append(KafkaWriter$.MODULE$.KEY_ATTRIBUTE_NAME()).append(" ").append(new StringBuilder(27).append("attribute unsupported type ").append(dataType2.catalogString()).toString()).toString());
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        Attribute valueExpression = (Attribute)this.inputSchema.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaRowWriter.$anonfun$createProjection$7(x$4))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(19).append("Required attribute ").append(new StringBuilder(12).append("'").append(KafkaWriter$.MODULE$.VALUE_ATTRIBUTE_NAME()).append("' not found").toString()).toString());
        });
        DataType dataType3 = valueExpression.dataType();
        boolean bl2 = StringType$.MODULE$.equals(dataType3) ? true : BinaryType$.MODULE$.equals(dataType3);
        if (!bl2) {
            throw new IllegalStateException(new StringBuilder(1).append(KafkaWriter$.MODULE$.VALUE_ATTRIBUTE_NAME()).append(" ").append(new StringBuilder(27).append("attribute unsupported type ").append(dataType3.catalogString()).toString()).toString());
        }
        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        return UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{topicExpression, new Cast((Expression)keyExpression, (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3()), new Cast((Expression)valueExpression, (DataType)BinaryType$.MODULE$, Cast$.MODULE$.apply$default$3())})), this.inputSchema);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$3(Attribute x$2) {
        String string = x$2.name();
        String string2 = KafkaWriter$.MODULE$.TOPIC_ATTRIBUTE_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$5(Attribute x$3) {
        String string = x$3.name();
        String string2 = KafkaWriter$.MODULE$.KEY_ATTRIBUTE_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createProjection$7(Attribute x$4) {
        String string = x$4.name();
        String string2 = KafkaWriter$.MODULE$.VALUE_ATTRIBUTE_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public KafkaRowWriter(Seq<Attribute> inputSchema, Option<String> topic) {
        this.inputSchema = inputSchema;
        this.topic = topic;
        this.projection = this.createProjection();
        this.callback = new Callback(this){
            private final /* synthetic */ KafkaRowWriter $outer;

            public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                block0: {
                    if (this.$outer.failedWrite() != null || e == null) break block0;
                    this.$outer.failedWrite_$eq(e);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

