/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public final class DataSourceV2Utils$
implements Logging {
    public static final DataSourceV2Utils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSourceV2Utils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Map<String, String> extractSessionConfigs(DataSourceV2 ds, SQLConf conf) {
        Map map2;
        DataSourceV2 dataSourceV2 = ds;
        if (dataSourceV2 instanceof SessionConfigSupport) {
            SessionConfigSupport sessionConfigSupport = (SessionConfigSupport)dataSourceV2;
            String keyPrefix = sessionConfigSupport.keyPrefix();
            Predef$.MODULE$.require(keyPrefix != null, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The data source config key prefix can't be null.";
                }
            });
            Pattern pattern = Pattern.compile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^spark\\\\.datasource\\\\.", "\\\\.(.+)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyPrefix})));
            map2 = (Map)conf.getAllConfs().flatMap((Function1)new Serializable(pattern){
                public static final long serialVersionUID = 0L;
                private final Pattern pattern$1;

                public final Seq<Tuple2<String, String>> apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Matcher m = this.pattern$1.matcher(key);
                        Seq seq = m.matches() && m.groupCount() > 0 ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)m.group(1), (Object)value)})) : (Seq)Seq$.MODULE$.empty();
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.pattern$1 = pattern$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        } else {
            map2 = Predef$.MODULE$.Map().empty();
        }
        return map2;
    }

    private DataSourceV2Utils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

