/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.MultiLineCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;

public final class CSVDataSource$
implements Logging,
scala.Serializable {
    public static CSVDataSource$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CSVDataSource$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CSVDataSource apply(CSVOptions options) {
        return options.multiLine() ? MultiLineCSVDataSource$.MODULE$ : TextInputCSVDataSource$.MODULE$;
    }

    public void checkHeaderColumnNames(StructType schema, String[] columnNames, String fileName, boolean enforceSchema, boolean caseSensitive) {
        block6: {
            if (columnNames == null) break block6;
            IndexedSeq fieldNames = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnNames)).size(), fieldNames.length());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int headerLen = sp2._1$mcI$sp();
            int schemaSize = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(headerLen, schemaSize);
            Tuple2.mcII.sp sp4 = sp3;
            int headerLen2 = sp4._1$mcI$sp();
            int schemaSize2 = sp4._2$mcI$sp();
            None$ errorMessage = None$.MODULE$;
            if (headerLen2 == schemaSize2) {
                for (int i = 0; errorMessage.isEmpty() && i < headerLen2; ++i) {
                    Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), (Object)columnNames[i]);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String nameInSchema = (String)tuple2._1();
                    String nameInHeader = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)nameInSchema, (Object)nameInHeader);
                    Tuple2 tuple23 = tuple22;
                    String nameInSchema2 = (String)tuple23._1();
                    String nameInHeader2 = (String)tuple23._2();
                    if (!caseSensitive) {
                        nameInSchema2 = nameInSchema2.toLowerCase();
                        nameInHeader2 = nameInHeader2.toLowerCase();
                    }
                    String string = nameInHeader2;
                    String string2 = nameInSchema2;
                    if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                    errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(173).append("|CSV header does not conform to the schema.\n                  | Header: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnNames)).mkString(", ")).append("\n                  | Schema: ").append(fieldNames.mkString(", ")).append("\n                  |Expected: ").append(fieldNames.apply(i)).append(" but found: ").append(columnNames[i]).append("\n                  |CSV file: ").append(fileName).toString())).stripMargin());
                }
            } else {
                errorMessage = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(152).append("|Number of column in CSV header is not equal to number of fields in the schema:\n              | Header length: ").append(headerLen2).append(", schema size: ").append(schemaSize2).append("\n              |CSV file: ").append(fileName).toString())).stripMargin());
            }
            errorMessage.foreach((Function1 & Serializable & scala.Serializable)msg -> {
                CSVDataSource$.$anonfun$checkHeaderColumnNames$2(enforceSchema, msg);
                return BoxedUnit.UNIT;
            });
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$checkHeaderColumnNames$2(boolean enforceSchema$1, String msg) {
        if (!enforceSchema$1) {
            throw new IllegalArgumentException(msg);
        }
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
    }

    private CSVDataSource$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

