/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.FutureAction;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.exchange.ExchangeCoordinator$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)\u0001\b\u0001C\u0001s!1a\b\u0001Q\u0001\n}B\u0001B\u0013\u0001\t\u0006\u0004&Ia\u0013\u0005\t\u0019\u0002A)\u0019)C\u0005\u001b\"1!\f\u0001Q!\nmCQA\u0019\u0001\u0005\u0002\rDQA\u001e\u0001\u0005\u0002]DQ\u0001\u001f\u0001\u0005\u0002eDq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018\u001dI\u0011qF\n\u0002\u0002#\u0005\u0011\u0011\u0007\u0004\t%M\t\t\u0011#\u0001\u00024!1\u0001h\u0004C\u0001\u0003kA\u0011\"a\u000e\u0010#\u0003%\t!!\u000f\u0003'\u0015C8\r[1oO\u0016\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005Q)\u0012\u0001C3yG\"\fgnZ3\u000b\u0005Y9\u0012!C3yK\u000e,H/[8o\u0015\tA\u0012$A\u0002tc2T!AG\u000e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!ZS\"A\u0015\u000b\u0005)J\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u00051J#a\u0002'pO\u001eLgnZ\u0001#C\u00124\u0018n]8ssR\u000b'oZ3u!>\u001cHo\u00155vM\u001adW-\u00138qkR\u001c\u0016N_3\u0011\u0005\tz\u0013B\u0001\u0019$\u0005\u0011auN\\4\u000275LgNT;n!>\u001cHo\u00155vM\u001adW\rU1si&$\u0018n\u001c8t!\r\u00113'N\u0005\u0003i\r\u0012aa\u00149uS>t\u0007C\u0001\u00127\u0013\t94EA\u0002J]R\fa\u0001P5oSRtDc\u0001\u001e={A\u00111\bA\u0007\u0002'!)Qf\u0001a\u0001]!9\u0011g\u0001I\u0001\u0002\u0004\u0011\u0014!C3yG\"\fgnZ3t!\r\u0001UiR\u0007\u0002\u0003*\u0011!iQ\u0001\b[V$\u0018M\u00197f\u0015\t!5%\u0001\u0006d_2dWm\u0019;j_:L!AR!\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003w!K!!S\n\u0003'MCWO\u001a4mK\u0016C8\r[1oO\u0016,\u00050Z2\u0002\u00199,X.\u0012=dQ\u0006tw-Z:\u0016\u0003U\nq\u0002]8tiNCWO\u001a4mKJ#Ei]\u000b\u0002\u001dB!q\nV$W\u001b\u0005\u0001&BA)S\u0003\u0011)H/\u001b7\u000b\u0003M\u000bAA[1wC&\u0011Q\u000b\u0015\u0002\u0004\u001b\u0006\u0004\bCA,Y\u001b\u0005)\u0012BA-\u0016\u00059\u0019\u0006.\u001e4gY\u0016$'k\\<S\t\u0012\u000b\u0011\"Z:uS6\fG/\u001a3\u0011\u0005\tb\u0016BA/$\u0005\u001d\u0011un\u001c7fC:D#aB0\u0011\u0005\t\u0002\u0017BA1$\u0005!1x\u000e\\1uS2,\u0017\u0001\u0005:fO&\u001cH/\u001a:Fq\u000eD\u0017M\\4f)\t!w\r\u0005\u0002#K&\u0011am\t\u0002\u0005+:LG\u000fC\u0003\u0015\u0011\u0001\u0007q\t\u000b\u0003\tSN$\bC\u00016r\u001b\u0005Y'B\u00017n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003]>\f!\"\u00198o_R\fG/[8o\u0015\u0005\u0001\u0018!\u00026bm\u0006D\u0018B\u0001:l\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-I\u0001v\u0003\u0011!\b.[:\u0002\u0017%\u001cXi\u001d;j[\u0006$X\rZ\u000b\u00027\u0006iRm\u001d;j[\u0006$X\rU1si&$\u0018n\u001c8Ti\u0006\u0014H/\u00138eS\u000e,7\u000f\u0006\u0002{{B\u0019!e_\u001b\n\u0005q\u001c#!B!se\u0006L\b\"\u0002@\u000b\u0001\u0004y\u0018aE7ba>+H\u000f];u'R\fG/[:uS\u000e\u001c\b\u0003\u0002\u0012|\u0003\u0003\u0001B!a\u0001\u0002\u00065\t\u0011$C\u0002\u0002\be\u00111#T1q\u001fV$\b/\u001e;Ti\u0006$\u0018n\u001d;jGN\fq\u0003Z8FgRLW.\u0019;j_:LeMT3dKN\u001c\u0018M]=\u0015\u0003\u0011DCaC5ti\u0006q\u0001o\\:u'\",hM\u001a7f%\u0012#Ec\u0001,\u0002\u0014!)A\u0003\u0004a\u0001\u000f\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\u001aA!\u00111DA\u0015\u001d\u0011\ti\"!\n\u0011\u0007\u0005}1%\u0004\u0002\u0002\")\u0019\u00111E\u0010\u0002\rq\u0012xn\u001c;?\u0013\r\t9cI\u0001\u0007!J,G-\u001a4\n\t\u0005-\u0012Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u001d2%A\nFq\u000eD\u0017M\\4f\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0002<\u001fM\u0011q\"\t\u000b\u0003\u0003c\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA\u001eU\r\u0011\u0014QH\u0016\u0003\u0003\u007f\u0001B!!\u0011\u0002J5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0005v]\u000eDWmY6fI*\u0011anI\u0005\u0005\u0003\u0017\n\u0019EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ExchangeCoordinator
implements Logging {
    private int numExchanges;
    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs;
    private final long advisoryTargetPostShuffleInputSize;
    private final Option<Object> minNumPostShufflePartitions;
    private final ArrayBuffer<ShuffleExchangeExec> exchanges;
    private volatile boolean estimated;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return ExchangeCoordinator$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numExchanges$lzycompute() {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numExchanges = this.exchanges.size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numExchanges;
    }

    private int numExchanges() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numExchanges$lzycompute() : this.numExchanges;
    }

    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs$lzycompute() {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.postShuffleRDDs = new HashMap<ShuffleExchangeExec, ShuffledRowRDD>(this.numExchanges());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.postShuffleRDDs;
    }

    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.postShuffleRDDs$lzycompute() : this.postShuffleRDDs;
    }

    @GuardedBy(value="this")
    public void registerExchange(ShuffleExchangeExec exchange) {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            this.exchanges.$plus$eq((Object)exchange);
        }
    }

    public boolean isEstimated() {
        return this.estimated;
    }

    public int[] estimatePartitionStartIndices(MapOutputStatistics[] mapOutputStatistics) {
        long l;
        Option<Object> option = this.minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ExchangeCoordinator.$anonfun$estimatePartitionStartIndices$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long maxPostShuffleInputSize = package$.MODULE$.max((long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)numPartitions), 16L);
            l = package$.MODULE$.min(maxPostShuffleInputSize, this.advisoryTargetPostShuffleInputSize);
        } else if (None$.MODULE$.equals(option)) {
            l = this.advisoryTargetPostShuffleInputSize;
        } else {
            throw new MatchError(option);
        }
        long targetPostShuffleInputSize = l;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("advisoryTargetPostShuffleInputSize: ").append($this.advisoryTargetPostShuffleInputSize).append(", ").append(new StringBuilder(28).append("targetPostShuffleInputSize ").append(targetPostShuffleInputSize).append(".").toString()).toString());
        int[] distinctNumPreShufflePartitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ExchangeCoordinator.$anonfun$estimatePartitionStartIndices$3(stats)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct();
        Predef$.MODULE$.assert(distinctNumPreShufflePartitions.length == 1, (Function0 & Serializable & scala.Serializable)() -> "There should be only one distinct value of the number pre-shuffle partitions among registered Exchange operator.");
        int numPreShufflePartitions = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(distinctNumPreShufflePartitions)).head());
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        long postShuffleInputSize = 0L;
        for (int i = 0; i < numPreShufflePartitions; ++i) {
            long nextShuffleInputSize = 0L;
            for (int j = 0; j < mapOutputStatistics.length; ++j) {
                nextShuffleInputSize += mapOutputStatistics[j].bytesByPartitionId()[i];
            }
            if (i > 0 && postShuffleInputSize + nextShuffleInputSize > targetPostShuffleInputSize) {
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                postShuffleInputSize = nextShuffleInputSize;
                continue;
            }
            postShuffleInputSize += nextShuffleInputSize;
        }
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    @GuardedBy(value="this")
    private synchronized void doEstimationIfNecessary() {
        block3: {
            if (this.estimated) break block3;
            Predef$.MODULE$.assert(this.exchanges.length() == this.numExchanges());
            HashMap<ShuffleExchangeExec, ShuffledRowRDD> newPostShuffleRDDs = new HashMap<ShuffleExchangeExec, ShuffledRowRDD>(this.numExchanges());
            ArrayBuffer shuffleDependencies = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ArrayBuffer submittedStageFutures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            for (int i = 0; i < this.numExchanges(); ++i) {
                ShuffleExchangeExec exchange = (ShuffleExchangeExec)this.exchanges.apply(i);
                ShuffleDependency<Object, InternalRow, InternalRow> shuffleDependency = exchange.prepareShuffleDependency();
                shuffleDependencies.$plus$eq(shuffleDependency);
                Object object = shuffleDependency.rdd().partitions().length != 0 ? submittedStageFutures.$plus$eq((Object)exchange.sqlContext().sparkContext().submitMapStage(shuffleDependency)) : BoxedUnit.UNIT;
            }
            MapOutputStatistics[] mapOutputStatistics = new MapOutputStatistics[submittedStageFutures.length()];
            for (int j = 0; j < submittedStageFutures.length(); ++j) {
                mapOutputStatistics[j] = (MapOutputStatistics)((FutureAction)submittedStageFutures.apply(j)).get();
            }
            Predef$.MODULE$.assert(mapOutputStatistics.length <= this.numExchanges());
            int[] partitionStartIndices = mapOutputStatistics.length == 0 ? (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()) : this.estimatePartitionStartIndices(mapOutputStatistics);
            for (int k = 0; k < this.numExchanges(); ++k) {
                ShuffleExchangeExec exchange = (ShuffleExchangeExec)this.exchanges.apply(k);
                ShuffledRowRDD rdd = exchange.preparePostShuffleRDD((ShuffleDependency<Object, InternalRow, InternalRow>)((ShuffleDependency)shuffleDependencies.apply(k)), (Option<int[]>)new Some((Object)partitionStartIndices));
                newPostShuffleRDDs.put(exchange, rdd);
            }
            Predef$.MODULE$.assert(this.postShuffleRDDs().isEmpty());
            Predef$.MODULE$.assert(newPostShuffleRDDs.size() == this.numExchanges());
            this.postShuffleRDDs().putAll(newPostShuffleRDDs);
            this.estimated = true;
        }
    }

    public ShuffledRowRDD postShuffleRDD(ShuffleExchangeExec exchange) {
        this.doEstimationIfNecessary();
        if (!this.postShuffleRDDs().containsKey(exchange)) {
            throw new IllegalStateException(new StringBuilder(49).append("The given ").append(exchange).append(" is not registered in this coordinator.").toString());
        }
        return this.postShuffleRDDs().get(exchange);
    }

    public String toString() {
        return new StringBuilder(49).append("coordinator[target post-shuffle partition size: ").append(this.advisoryTargetPostShuffleInputSize).append("]").toString();
    }

    public static final /* synthetic */ long $anonfun$estimatePartitionStartIndices$1(MapOutputStatistics x$1) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$1.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$estimatePartitionStartIndices$3(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public ExchangeCoordinator(long advisoryTargetPostShuffleInputSize, Option<Object> minNumPostShufflePartitions) {
        this.advisoryTargetPostShuffleInputSize = advisoryTargetPostShuffleInputSize;
        this.minNumPostShufflePartitions = minNumPostShufflePartitions;
        Logging.$init$((Logging)this);
        this.exchanges = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.estimated = false;
    }
}

