/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution$;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousWriteRDD;
import org.apache.spark.sql.execution.streaming.continuous.EpochCoordinatorRef$;
import org.apache.spark.sql.execution.streaming.continuous.SetWriterPartitions;
import org.apache.spark.sql.execution.streaming.continuous.WriteToContinuousDataSourceExec$;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\r\u001b\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u007f!A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005M\u0001\tE\t\u0015!\u0003+\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015a\u0007\u0001\"\u0015n\u0011\u001dA\b!!A\u0005\u0002eDq\u0001 \u0001\u0012\u0002\u0013\u0005Q\u0010C\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001\u0002\u0014!I\u0011q\u0003\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0004\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"!\u000e\u0001\u0003\u0003%\t!a\u000e\t\u0013\u0005\r\u0003!!A\u0005B\u0005\u0015\u0003\"CA*\u0001\u0005\u0005I\u0011AA+\u0011%\ty\u0006AA\u0001\n\u0003\n\tgB\u0005\u0002fi\t\t\u0011#\u0001\u0002h\u0019A\u0011DGA\u0001\u0012\u0003\tI\u0007\u0003\u0004N'\u0011\u0005\u0011q\u000f\u0005\n\u0003s\u001a\u0012\u0011!C#\u0003wB\u0011\"! \u0014\u0003\u0003%\t)a \t\u0013\u0005\u00155#!A\u0005\u0002\u0006\u001d\u0005\"CAM'\u0005\u0005I\u0011BAN\u0005}9&/\u001b;f)>\u001cuN\u001c;j]V|Wo\u001d#bi\u0006\u001cv.\u001e:dK\u0016CXm\u0019\u0006\u00037q\t!bY8oi&tWo\\;t\u0015\tib$A\u0005tiJ,\u0017-\\5oO*\u0011q\u0004I\u0001\nKb,7-\u001e;j_:T!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u0016/ii\u0002\"a\u000b\u0017\u000e\u0003yI!!\f\u0010\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007CA\u00183\u001b\u0005\u0001$BA\u0019#\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001a1\u0005\u001daunZ4j]\u001e\u0004\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00026w%\u0011AH\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007oJLG/\u001a:\u0016\u0003}\u0002\"\u0001Q$\u000e\u0003\u0005S!!\b\"\u000b\u0005u\u001a%B\u0001#F\u0003\t1(G\u0003\u0002GA\u000591o\\;sG\u0016\u001c\u0018B\u0001%B\u00051\u0019FO]3b[^\u0013\u0018\u000e^3s\u0003\u001d9(/\u001b;fe\u0002\nQ!];fef,\u0012AK\u0001\u0007cV,'/\u001f\u0011\u0002\rqJg.\u001b;?)\ry\u0015K\u0015\t\u0003!\u0002i\u0011A\u0007\u0005\u0006{\u0015\u0001\ra\u0010\u0005\u0006\u0015\u0016\u0001\rAK\u0001\tG\"LG\u000e\u001a:f]V\tQ\u000bE\u0002W=*r!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005iC\u0013A\u0002\u001fs_>$h(C\u00018\u0013\tif'A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011QLN\u0001\u0007_V$\b/\u001e;\u0016\u0003\r\u00042A\u00160e!\t)'.D\u0001g\u0015\t9\u0007.A\u0006fqB\u0014Xm]:j_:\u001c(BA5!\u0003!\u0019\u0017\r^1msN$\u0018BA6g\u0005%\tE\u000f\u001e:jEV$X-A\u0005e_\u0016CXmY;uKR\ta\u000eE\u0002peRl\u0011\u0001\u001d\u0006\u0003c\n\n1A\u001d3e\u0013\t\u0019\bOA\u0002S\t\u0012\u0003\"!\u001e<\u000e\u0003!L!a\u001e5\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0005G>\u0004\u0018\u0010F\u0002PunDq!P\u0005\u0011\u0002\u0003\u0007q\bC\u0004K\u0013A\u0005\t\u0019\u0001\u0016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\taP\u000b\u0002@\u007f.\u0012\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0002\fY\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U!F\u0001\u0016\u0000\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u0004\t\u0005\u0003;\t9#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0012\u0001\u00026bm\u0006LA!!\u000b\u0002 \t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\f\u0011\u0007U\n\t$C\u0002\u00024Y\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000f\u0002@A\u0019Q'a\u000f\n\u0007\u0005ubGA\u0002B]fD\u0011\"!\u0011\u000f\u0003\u0003\u0005\r!a\f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u0005\u0005\u0004\u0002J\u0005=\u0013\u0011H\u0007\u0003\u0003\u0017R1!!\u00147\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\nYE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA,\u0003;\u00022!NA-\u0013\r\tYF\u000e\u0002\b\u0005>|G.Z1o\u0011%\t\t\u0005EA\u0001\u0002\u0004\tI$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003/\n\u0019\u0007C\u0005\u0002BE\t\t\u00111\u0001\u0002:\u0005yrK]5uKR{7i\u001c8uS:,x.^:ECR\f7k\\;sG\u0016,\u00050Z2\u0011\u0005A\u001b2\u0003B\n\u0002li\u0002r!!\u001c\u0002t}Rs*\u0004\u0002\u0002p)\u0019\u0011\u0011\u000f\u001c\u0002\u000fI,h\u000e^5nK&!\u0011QOA8\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003O\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037\tQ!\u00199qYf$RaTAA\u0003\u0007CQ!\u0010\fA\u0002}BQA\u0013\fA\u0002)\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\n\u0006U\u0005#B\u001b\u0002\f\u0006=\u0015bAAGm\t1q\n\u001d;j_:\u0004R!NAI\u007f)J1!a%7\u0005\u0019!V\u000f\u001d7fe!A\u0011qS\f\u0002\u0002\u0003\u0007q*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0014\t\u0005\u0003;\ty*\u0003\u0003\u0002\"\u0006}!AB(cU\u0016\u001cG\u000f")
public class WriteToContinuousDataSourceExec
extends SparkPlan {
    private final StreamWriter writer;
    private final SparkPlan query;

    public static Option<Tuple2<StreamWriter, SparkPlan>> unapply(WriteToContinuousDataSourceExec writeToContinuousDataSourceExec) {
        return WriteToContinuousDataSourceExec$.MODULE$.unapply(writeToContinuousDataSourceExec);
    }

    public static Function1<Tuple2<StreamWriter, SparkPlan>, WriteToContinuousDataSourceExec> tupled() {
        return WriteToContinuousDataSourceExec$.MODULE$.tupled();
    }

    public static Function1<StreamWriter, Function1<SparkPlan, WriteToContinuousDataSourceExec>> curried() {
        return WriteToContinuousDataSourceExec$.MODULE$.curried();
    }

    public StreamWriter writer() {
        return this.writer;
    }

    public SparkPlan query() {
        return this.query;
    }

    public Seq<SparkPlan> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SparkPlan[]{this.query()}));
    }

    public Seq<Attribute> output() {
        return Nil$.MODULE$;
    }

    @Override
    public RDD<InternalRow> doExecute() {
        Object object;
        DataWriterFactory<InternalRow> writerFactory = this.writer().createWriterFactory();
        ContinuousWriteRDD rdd = new ContinuousWriteRDD(this.query().execute(), writerFactory);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Start processing data source writer: ").append(this.writer()).append(". ").append(new StringBuilder(30).append("The input RDD has ").append(rdd.partitions().length).append(" partitions.").toString()).toString());
        EpochCoordinatorRef$.MODULE$.get(this.sparkContext().getLocalProperty(ContinuousExecution$.MODULE$.EPOCH_COORDINATOR_ID_KEY()), this.sparkContext().env()).askSync((Object)new SetWriterPartitions(rdd.getNumPartitions()), ClassTag$.MODULE$.Unit());
        try {
            object = rdd.collect();
        }
        catch (InterruptedException interruptedException) {
            object = BoxedUnit.UNIT;
        }
        catch (Throwable cause) {
            Throwable throwable = cause;
            if (StreamExecution$.MODULE$.isInterruptionException(cause)) {
                throw cause;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw new SparkException("Writing job aborted.", e);
            }
            throw cause;
        }
        return this.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public WriteToContinuousDataSourceExec copy(StreamWriter writer, SparkPlan query) {
        return new WriteToContinuousDataSourceExec(writer, query);
    }

    public StreamWriter copy$default$1() {
        return this.writer();
    }

    public SparkPlan copy$default$2() {
        return this.query();
    }

    public String productPrefix() {
        return "WriteToContinuousDataSourceExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.writer();
                break;
            }
            case 1: {
                object = this.query();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WriteToContinuousDataSourceExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WriteToContinuousDataSourceExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        WriteToContinuousDataSourceExec writeToContinuousDataSourceExec = (WriteToContinuousDataSourceExec)((Object)x$1);
        StreamWriter streamWriter = this.writer();
        StreamWriter streamWriter2 = writeToContinuousDataSourceExec.writer();
        if (streamWriter == null) {
            if (streamWriter2 != null) {
                return false;
            }
        } else if (!streamWriter.equals(streamWriter2)) return false;
        SparkPlan sparkPlan = this.query();
        SparkPlan sparkPlan2 = writeToContinuousDataSourceExec.query();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!writeToContinuousDataSourceExec.canEqual((Object)this)) return false;
        return true;
    }

    public WriteToContinuousDataSourceExec(StreamWriter writer, SparkPlan query) {
        this.writer = writer;
        this.query = query;
    }
}

