/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.HashMap;
import org.apache.spark.TestUtils$;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.sql.IntegratedUDFTestUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.SystemProperties;
import scala.sys.package$;
import scala.sys.process.Process$;
import scala.util.Try$;

public final class IntegratedUDFTestUtils$
implements SQLHelper {
    public static IntegratedUDFTestUtils$ MODULE$;
    private String pythonPath;
    private String sparkHome;
    private Path sourcePath;
    private Path py4jPath;
    private String pysparkPythonPath;
    private boolean isPythonAvailable;
    private boolean isPySparkAvailable;
    private boolean isPandasAvailable;
    private boolean isPyArrowAvailable;
    private String pythonVer;
    private String pandasVer;
    private String pyarrowVer;
    private byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    private byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    private String pythonExec;
    private boolean shouldTestPythonUDFs;
    private boolean shouldTestScalarPandasUDFs;
    private final HashMap<String, String> org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv;
    private volatile int bitmap$0;

    static {
        new IntegratedUDFTestUtils$();
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String pythonPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.pythonPath = (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable & scala.Serializable)() -> "");
                this.bitmap$0 |= 1;
            }
        }
        return this.pythonPath;
    }

    private String pythonPath() {
        return (this.bitmap$0 & 1) == 0 ? this.pythonPath$lzycompute() : this.pythonPath;
    }

    private String sparkHome$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 2) == 0) {
                String string;
                if (package$.MODULE$.props().contains(Tests$.MODULE$.IS_TESTING().key())) {
                    Bool bool;
                    String $org_scalatest_assert_macro_right;
                    SystemProperties $org_scalatest_assert_macro_left = package$.MODULE$.props();
                    Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)($org_scalatest_assert_macro_right = "spark.test.home"), $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left2.value()) {
                        bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                    } else {
                        Map $org_scalatest_assert_macro_left3 = package$.MODULE$.env();
                        String $org_scalatest_assert_macro_right2 = "SPARK_HOME";
                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"spark.test.home or SPARK_HOME is not set.", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                    string = (String)package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable & scala.Serializable)() -> (String)package$.MODULE$.env().apply((Object)"SPARK_HOME"));
                } else {
                    Map $org_scalatest_assert_macro_left = package$.MODULE$.env();
                    String $org_scalatest_assert_macro_right = "SPARK_HOME";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"SPARK_HOME is not set.", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                    string = (String)package$.MODULE$.env().apply((Object)"SPARK_HOME");
                }
                this.sparkHome = string;
                this.bitmap$0 |= 2;
            }
        }
        return this.sparkHome;
    }

    private String sparkHome() {
        return (this.bitmap$0 & 2) == 0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private Path sourcePath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 4) == 0) {
                this.sourcePath = Paths.get(this.sparkHome(), "python").toAbsolutePath();
                this.bitmap$0 |= 4;
            }
        }
        return this.sourcePath;
    }

    private Path sourcePath() {
        return (this.bitmap$0 & 4) == 0 ? this.sourcePath$lzycompute() : this.sourcePath;
    }

    private Path py4jPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 8) == 0) {
                this.py4jPath = Paths.get(this.sparkHome(), "python", "lib", PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toAbsolutePath();
                this.bitmap$0 |= 8;
            }
        }
        return this.py4jPath;
    }

    private Path py4jPath() {
        return (this.bitmap$0 & 8) == 0 ? this.py4jPath$lzycompute() : this.py4jPath;
    }

    private String pysparkPythonPath$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.pysparkPythonPath = new StringBuilder(1).append(this.py4jPath()).append(":").append(this.sourcePath()).toString();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.pysparkPythonPath;
    }

    private String pysparkPythonPath() {
        return (this.bitmap$0 & 0x10) == 0 ? this.pysparkPythonPath$lzycompute() : this.pysparkPythonPath;
    }

    private boolean isPythonAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.isPythonAvailable = TestUtils$.MODULE$.testCommandAvailable(this.pythonExec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.isPythonAvailable;
    }

    private boolean isPythonAvailable() {
        return (this.bitmap$0 & 0x20) == 0 ? this.isPythonAvailable$lzycompute() : this.isPythonAvailable;
    }

    private boolean isPySparkAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.isPySparkAvailable = this.isPythonAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.pythonExec(), "-c", "import pyspark"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(MODULE$.pysparkPythonPath()).append(":").append(MODULE$.pythonPath()).toString())})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.isPySparkAvailable;
    }

    private boolean isPySparkAvailable() {
        return (this.bitmap$0 & 0x40) == 0 ? this.isPySparkAvailable$lzycompute() : this.isPySparkAvailable;
    }

    private boolean isPandasAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.isPandasAvailable = this.isPythonAvailable() && this.isPySparkAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.pythonExec(), "-c", "from pyspark.sql.pandas.utils import require_minimum_pandas_version;require_minimum_pandas_version()"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(MODULE$.pysparkPythonPath()).append(":").append(MODULE$.pythonPath()).toString())})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 |= 0x80;
            }
        }
        return this.isPandasAvailable;
    }

    private boolean isPandasAvailable() {
        return (this.bitmap$0 & 0x80) == 0 ? this.isPandasAvailable$lzycompute() : this.isPandasAvailable;
    }

    private boolean isPyArrowAvailable$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.isPyArrowAvailable = this.isPythonAvailable() && this.isPySparkAvailable() && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.pythonExec(), "-c", "from pyspark.sql.pandas.utils import require_minimum_pyarrow_version;require_minimum_pyarrow_version()"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(MODULE$.pysparkPythonPath()).append(":").append(MODULE$.pythonPath()).toString())})).$bang$bang();
                    return true;
                }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                this.bitmap$0 |= 0x100;
            }
        }
        return this.isPyArrowAvailable;
    }

    private boolean isPyArrowAvailable() {
        return (this.bitmap$0 & 0x100) == 0 ? this.isPyArrowAvailable$lzycompute() : this.isPyArrowAvailable;
    }

    private String pythonVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x200) == 0) {
                if (!this.isPythonAvailable()) {
                    throw new RuntimeException(new StringBuilder(36).append("Python executable [").append(this.pythonExec()).append("] is unavailable.").toString());
                }
                this.pythonVer = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.pythonExec(), "-c", "import sys; print('%d.%d' % sys.version_info[:2])"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(this.pysparkPythonPath()).append(":").append(this.pythonPath()).toString())})).$bang$bang().trim();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.pythonVer;
    }

    public String pythonVer() {
        return (this.bitmap$0 & 0x200) == 0 ? this.pythonVer$lzycompute() : this.pythonVer;
    }

    private String pandasVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x400) == 0) {
                if (!this.isPandasAvailable()) {
                    throw new RuntimeException("Pandas is unavailable.");
                }
                this.pandasVer = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.pythonExec(), "-c", "import pandas; print(pandas.__version__)"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(this.pysparkPythonPath()).append(":").append(this.pythonPath()).toString())})).$bang$bang().trim();
                this.bitmap$0 |= 0x400;
            }
        }
        return this.pandasVer;
    }

    public String pandasVer() {
        return (this.bitmap$0 & 0x400) == 0 ? this.pandasVer$lzycompute() : this.pandasVer;
    }

    private String pyarrowVer$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x800) == 0) {
                if (!this.isPyArrowAvailable()) {
                    throw new RuntimeException("PyArrow is unavailable.");
                }
                this.pyarrowVer = Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.pythonExec(), "-c", "import pyarrow; print(pyarrow.__version__)"})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(this.pysparkPythonPath()).append(":").append(this.pythonPath()).toString())})).$bang$bang().trim();
                this.bitmap$0 |= 0x800;
            }
        }
        return this.pyarrowVer;
    }

    public String pyarrowVer() {
        return (this.bitmap$0 & 0x800) == 0 ? this.pyarrowVer$lzycompute() : this.pyarrowVer;
    }

    private byte[] pythonFunc$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                if (!this.shouldTestPythonUDFs()) {
                    throw new RuntimeException(new StringBuilder(52).append("Python executable [").append(this.pythonExec()).append("] and/or pyspark are unavailable.").toString());
                }
                ObjectRef binaryPythonFunc = ObjectRef.create(null);
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                    IntegratedUDFTestUtils$.$anonfun$pythonFunc$1(binaryPythonFunc, path);
                    return BoxedUnit.UNIT;
                });
                byte[] $org_scalatest_assert_macro_left = (byte[])binaryPythonFunc.elem;
                Object $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                this.org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc = (byte[])binaryPythonFunc.elem;
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.pythonFunc$lzycompute() : this.org$apache$spark$sql$IntegratedUDFTestUtils$$pythonFunc;
    }

    private byte[] pandasFunc$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                if (!this.shouldTestScalarPandasUDFs()) {
                    throw new RuntimeException(new StringBuilder(52).append("Python executable [").append(this.pythonExec()).append("] and/or pyspark are unavailable.").toString());
                }
                ObjectRef binaryPandasFunc = ObjectRef.create(null);
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                    IntegratedUDFTestUtils$.$anonfun$pandasFunc$1(binaryPandasFunc, path);
                    return BoxedUnit.UNIT;
                });
                byte[] $org_scalatest_assert_macro_left = (byte[])binaryPandasFunc.elem;
                Object $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, $org_scalatest_assert_macro_left != null, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntegratedUDFTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
                this.org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc = (byte[])binaryPandasFunc.elem;
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    }

    public byte[] org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.pandasFunc$lzycompute() : this.org$apache$spark$sql$IntegratedUDFTestUtils$$pandasFunc;
    }

    public HashMap<String, String> org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv() {
        return this.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv;
    }

    private String pythonExec$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                String pythonExec = (String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable & scala.Serializable)() -> (String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable & scala.Serializable)() -> "python3.6"));
                this.pythonExec = TestUtils$.MODULE$.testCommandAvailable(pythonExec) ? pythonExec : "python";
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.pythonExec;
    }

    public String pythonExec() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.pythonExec$lzycompute() : this.pythonExec;
    }

    private boolean shouldTestPythonUDFs$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.shouldTestPythonUDFs = this.isPythonAvailable() && this.isPySparkAvailable();
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.shouldTestPythonUDFs;
    }

    public boolean shouldTestPythonUDFs() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.shouldTestPythonUDFs$lzycompute() : this.shouldTestPythonUDFs;
    }

    private boolean shouldTestScalarPandasUDFs$lzycompute() {
        IntegratedUDFTestUtils$ integratedUDFTestUtils$ = this;
        synchronized (integratedUDFTestUtils$) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.shouldTestScalarPandasUDFs = this.isPythonAvailable() && this.isPandasAvailable() && this.isPyArrowAvailable();
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.shouldTestScalarPandasUDFs;
    }

    public boolean shouldTestScalarPandasUDFs() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.shouldTestScalarPandasUDFs$lzycompute() : this.shouldTestScalarPandasUDFs;
    }

    public void registerTestUDF(IntegratedUDFTestUtils.TestUDF testUDF, SparkSession session) {
        IntegratedUDFTestUtils.TestUDF testUDF2 = testUDF;
        if (testUDF2 instanceof IntegratedUDFTestUtils.TestPythonUDF) {
            IntegratedUDFTestUtils.TestPythonUDF testPythonUDF = (IntegratedUDFTestUtils.TestPythonUDF)testUDF2;
            session.udf().registerPython(testPythonUDF.name(), testPythonUDF.udf());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (testUDF2 instanceof IntegratedUDFTestUtils.TestScalarPandasUDF) {
            IntegratedUDFTestUtils.TestScalarPandasUDF testScalarPandasUDF = (IntegratedUDFTestUtils.TestScalarPandasUDF)testUDF2;
            session.udf().registerPython(testScalarPandasUDF.name(), testScalarPandasUDF.udf());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (testUDF2 instanceof IntegratedUDFTestUtils.TestScalaUDF) {
            IntegratedUDFTestUtils.TestScalaUDF testScalaUDF = (IntegratedUDFTestUtils.TestScalaUDF)testUDF2;
            session.udf().register(testScalaUDF.name(), (UserDefinedFunction)testScalaUDF.udf());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new RuntimeException(new StringBuilder(20).append("Unknown UDF class [").append(testUDF2.getClass()).append("]").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$pythonFunc$1(ObjectRef binaryPythonFunc$1, File path) {
        Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.pythonExec(), "-c", new StringBuilder(211).append("from pyspark.sql.types import StringType; from pyspark.serializers import CloudPickleSerializer; ").append("f = open('").append(path).append("', 'wb');").append("f.write(CloudPickleSerializer().dumps((").append("lambda x: None if x is None else str(x), StringType())))").toString()})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(MODULE$.pysparkPythonPath()).append(":").append(MODULE$.pythonPath()).toString())})).$bang$bang();
        binaryPythonFunc$1.elem = Files.readAllBytes(path.toPath());
    }

    public static final /* synthetic */ void $anonfun$pandasFunc$1(ObjectRef binaryPandasFunc$1, File path) {
        Process$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.pythonExec(), "-c", new StringBuilder(230).append("from pyspark.sql.types import StringType; from pyspark.serializers import CloudPickleSerializer; ").append("f = open('").append(path).append("', 'wb');").append("f.write(CloudPickleSerializer().dumps((").append("lambda x: x.apply(").append("lambda v: None if v is None else str(v)), StringType())))").toString()})), (Option)None$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PYTHONPATH"), (Object)new StringBuilder(1).append(MODULE$.pysparkPythonPath()).append(":").append(MODULE$.pythonPath()).toString())})).$bang$bang();
        binaryPandasFunc$1.elem = Files.readAllBytes(path.toPath());
    }

    private IntegratedUDFTestUtils$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        this.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv = new HashMap();
        this.org$apache$spark$sql$IntegratedUDFTestUtils$$workerEnv().put("PYTHONPATH", new StringBuilder(1).append(this.pysparkPythonPath()).append(":").append(this.pythonPath()).toString());
    }
}

