/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.InMemoryTable;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.InsertIntoTests;
import org.apache.spark.sql.connector.SessionCatalogTest;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001]3AAB\u0004\u0001%!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C)I!)q\n\u0001C)!\"9A\u000b\u0001b\u0001\n#*\u0006B\u0002,\u0001A\u0003%QF\u0001\u0015ECR\f7k\\;sG\u00164&\u0007R1uC\u001a\u0013\u0018-\\3TKN\u001c\u0018n\u001c8DCR\fGn\\4Tk&$XM\u0003\u0002\t\u0013\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0004\u0001M9\u0002C\u0001\u000b\u0016\u001b\u00059\u0011B\u0001\f\b\u0005=Ien]3si&sGo\u001c+fgR\u001c\b\u0003\u0002\u000b\u00195uI!!G\u0004\u0003%M+7o]5p]\u000e\u000bG/\u00197pOR+7\u000f\u001e\t\u0003)mI!\u0001H\u0004\u0003\u001b%sW*Z7pef$\u0016M\u00197f!\t!b$\u0003\u0002 \u000f\tY\u0012J\\'f[>\u0014\u0018\u0010V1cY\u0016\u001cVm]:j_:\u001c\u0015\r^1m_\u001e\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005Q\u0001\u0011\u0001\u00033p\u0013:\u001cXM\u001d;\u0015\t\u0015Z\u0003(\u0013\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0005+:LG\u000fC\u0003-\u0005\u0001\u0007Q&A\u0005uC\ndWMT1nKB\u0011a&\u000e\b\u0003_M\u0002\"\u0001M\u0014\u000e\u0003ER!AM\t\u0002\rq\u0012xn\u001c;?\u0013\t!t%\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b(\u0011\u0015I$\u00011\u0001;\u0003\u0019Ign]3siB\u00111H\u0012\b\u0003y\u0011s!!P\"\u000f\u0005y\u0012eBA B\u001d\t\u0001\u0004)C\u0001\u0011\u0013\tqq\"\u0003\u0002\r\u001b%\u0011!bC\u0005\u0003\u000b&\tq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\nIA)\u0019;b\rJ\fW.\u001a\u0006\u0003\u000b&AqA\u0013\u0002\u0011\u0002\u0003\u00071*\u0001\u0003n_\u0012,\u0007C\u0001'N\u001b\u0005I\u0011B\u0001(\n\u0005!\u0019\u0016M^3N_\u0012,\u0017a\u0003<fe&4\u0017\u0010V1cY\u0016$2!J)S\u0011\u0015a3\u00011\u0001.\u0011\u0015\u00196\u00011\u0001;\u0003!)\u0007\u0010]3di\u0016$\u0017aE2bi\u0006dwnZ!oI:\u000bW.Z:qC\u000e,W#A\u0017\u0002)\r\fG/\u00197pO\u0006sGMT1nKN\u0004\u0018mY3!\u0001")
public class DataSourceV2DataFrameSessionCatalogSuite
extends InsertIntoTests
implements SessionCatalogTest<InMemoryTable, InMemoryTableSessionCatalog> {
    private final String catalogAndNamespace;
    private final String v2Format;
    private final String catalogClassName;

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$SessionCatalogTest$$super$afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public CatalogPlugin catalog(String name) {
        return SessionCatalogTest.catalog$(this, name);
    }

    @Override
    public void afterEach() {
        SessionCatalogTest.afterEach$(this);
    }

    @Override
    public String v2Format() {
        return this.v2Format;
    }

    @Override
    public String catalogClassName() {
        return this.catalogClassName;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$v2Format_$eq(String x$1) {
        this.v2Format = x$1;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$catalogClassName_$eq(String x$1) {
        this.catalogClassName = x$1;
    }

    @Override
    public void doInsert(String tableName, Dataset<Row> insert, SaveMode mode) {
        DataFrameWriter dfw = insert.write().format(this.v2Format());
        Object object = mode != null ? dfw.mode(mode) : BoxedUnit.UNIT;
        dfw.insertInto(tableName);
    }

    @Override
    public void verifyTable(String tableName, Dataset<Row> expected) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tableName), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT * FROM default.").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(tableName).toString()), expected);
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    public DataSourceV2DataFrameSessionCatalogSuite() {
        super(true, false);
        SessionCatalogTest.$init$(this);
        this.catalogAndNamespace = "";
        this.test("saveAsTable: Append mode should not fail if the table already exists and a same-name temp view exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String format = this.spark().sessionState().conf().defaultDataSourceName();
            this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE same_name(id LONG) USING ").append(format).toString());
            this.spark().range(10L).createTempView("same_name");
            this.spark().range(20L).write().format(this.v2Format()).mode(SaveMode.Append).saveAsTable("same_name");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("same_name"), (Dataset<Row>)this.spark().range(10L).toDF());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("default.same_name"), (Dataset<Row>)this.spark().range(20L).toDF());
        })), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("saveAsTable with mode Overwrite should not fail if the table already exists and a same-name temp view exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"same_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE same_name(id LONG) USING ").append(this.v2Format()).toString());
            this.spark().range(10L).createTempView("same_name");
            this.spark().range(20L).write().format(this.v2Format()).mode(SaveMode.Overwrite).saveAsTable("same_name");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("same_name"), (Dataset<Row>)this.spark().range(10L).toDF());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("default.same_name"), (Dataset<Row>)this.spark().range(20L).toDF());
        })), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("saveAsTable passes path and provider information properly", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "prop_table";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(20L).write().format(this.v2Format()).option("path", "abc").saveAsTable(t1);
                TableCatalog cat = (TableCatalog)this.spark().sessionState().catalogManager().currentCatalog();
                Table tableInfo = cat.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)t1));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(tableInfo.properties().get("location"));
                String $org_scalatest_assert_macro_right = "abc";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(tableInfo.properties().get("provider"));
                String $org_scalatest_assert_macro_right2 = this.v2Format();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
            });
        }, new Position("DataSourceV2DataFrameSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
    }
}

