/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.connector.AlterTableTests;
import org.apache.spark.sql.connector.InMemoryTable;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog$;
import org.apache.spark.sql.connector.InsertIntoTests;
import org.apache.spark.sql.connector.SessionCatalogTest;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-4Aa\u0002\u0005\u0001'!)A\u0005\u0001C\u0001K!9q\u0005\u0001b\u0001\n#B\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00033\u0001\u0011E3\u0007C\u0003^\u0001\u0011Ec\fC\u0003c\u0001\u0011\u00053M\u0001\u0012ECR\f7k\\;sG\u00164&gU)M'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h'VLG/\u001a\u0006\u0003\u0013)\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\u0002d\u0007\t\u0003+Yi\u0011\u0001C\u0005\u0003/!\u0011q\"\u00138tKJ$\u0018J\u001c;p)\u0016\u001cHo\u001d\t\u0003+eI!A\u0007\u0005\u0003\u001f\u0005cG/\u001a:UC\ndW\rV3tiN\u0004B!\u0006\u000f\u001fC%\u0011Q\u0004\u0003\u0002\u0013'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h)\u0016\u001cH\u000f\u0005\u0002\u0016?%\u0011\u0001\u0005\u0003\u0002\u000e\u0013:lU-\\8ssR\u000b'\r\\3\u0011\u0005U\u0011\u0013BA\u0012\t\u0005mIe.T3n_JLH+\u00192mKN+7o]5p]\u000e\u000bG/\u00197pO\u00061A(\u001b8jiz\"\u0012A\n\t\u0003+\u0001\t1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u0006!2-\u0019;bY><\u0017I\u001c3OC6,7\u000f]1dK\u0002\n\u0001\u0002Z8J]N,'\u000f\u001e\u000b\u0005ii2u\u000b\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0003V]&$\b\"B\u001e\u0005\u0001\u0004a\u0014!\u0003;bE2,g*Y7f!\tiDI\u0004\u0002?\u0005B\u0011qHN\u0007\u0002\u0001*\u0011\u0011IE\u0001\u0007yI|w\u000e\u001e \n\u0005\r3\u0014A\u0002)sK\u0012,g-\u0003\u00021\u000b*\u00111I\u000e\u0005\u0006\u000f\u0012\u0001\r\u0001S\u0001\u0007S:\u001cXM\u001d;\u0011\u0005%#fB\u0001&S\u001d\tY\u0015K\u0004\u0002M!:\u0011Qj\u0014\b\u0003\u007f9K\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA*\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0016,\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA*\u000b\u0011\u001dAF\u0001%AA\u0002e\u000bA!\\8eKB\u0011!lW\u0007\u0002\u0015%\u0011AL\u0003\u0002\t'\u00064X-T8eK\u0006Ya/\u001a:jMf$\u0016M\u00197f)\r!t\f\u0019\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0005\u0006C\u0016\u0001\r\u0001S\u0001\tKb\u0004Xm\u0019;fI\u0006\u0001r-\u001a;UC\ndW-T3uC\u0012\fG/\u0019\u000b\u0003I*\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u0005\u0002\u000f\r\fG/\u00197pO&\u0011\u0011N\u001a\u0002\u0006)\u0006\u0014G.\u001a\u0005\u0006w\u0019\u0001\r\u0001\u0010")
public class DataSourceV2SQLSessionCatalogSuite
extends InsertIntoTests
implements AlterTableTests,
SessionCatalogTest<InMemoryTable, InMemoryTableSessionCatalog> {
    private final String catalogAndNamespace;
    private final String v2Format;
    private final String catalogClassName;

    @Override
    public /* synthetic */ void org$apache$spark$sql$connector$SessionCatalogTest$$super$afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public CatalogPlugin catalog(String name) {
        return SessionCatalogTest.catalog$(this, name);
    }

    @Override
    public void afterEach() {
        SessionCatalogTest.afterEach$(this);
    }

    @Override
    public String v2Format() {
        return this.v2Format;
    }

    @Override
    public String catalogClassName() {
        return this.catalogClassName;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$v2Format_$eq(String x$1) {
        this.v2Format = x$1;
    }

    @Override
    public void org$apache$spark$sql$connector$SessionCatalogTest$_setter_$catalogClassName_$eq(String x$1) {
        this.catalogClassName = x$1;
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    @Override
    public void doInsert(String tableName, Dataset<Row> insert, SaveMode mode) {
        String tmpView = "tmp_view";
        this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tmpView}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            insert.createOrReplaceTempView(tmpView);
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            String overwrite = !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) ? "OVERWRITE" : "INTO";
            this.sql().apply((Object)new StringBuilder(29).append("INSERT ").append(overwrite).append(" TABLE ").append(tableName).append(" SELECT * FROM ").append(tmpView).toString());
        });
    }

    @Override
    public void verifyTable(String tableName, Dataset<Row> expected) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tableName), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT * FROM default.").append(tableName).toString()), expected);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(tableName).toString()), expected);
    }

    @Override
    public Table getTableMetadata(String tableName) {
        CatalogPlugin v2Catalog = this.spark().sessionState().catalogManager().currentCatalog();
        Seq nameParts = this.spark().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        return ((TableCatalog)v2Catalog).loadTable(Identifier.of((String[])((String[])((TraversableOnce)nameParts.init()).toArray(ClassTag$.MODULE$.apply(String.class))), (String)((String)nameParts.last())));
    }

    private static final Identifier idResolver$1(Identifier id) {
        return Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)id.name());
    }

    public DataSourceV2SQLSessionCatalogSuite() {
        super(true, true);
        AlterTableTests.$init$(this);
        SessionCatalogTest.$init$(this);
        this.catalogAndNamespace = "";
        this.test("SPARK-30697: catalog.isView doesn't throw an error for specialized identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(45).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).toString());
                InMemoryTableSessionCatalog$.MODULE$.withCustomIdentifierResolver((Function1<Identifier, Identifier>)(Function1 & Serializable & scala.Serializable)id -> DataSourceV2SQLSessionCatalogSuite.idResolver$1(id), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.sql().apply((Object)new StringBuilder(23).append("DESCRIBE TABLE ignored.").append(t1).toString()));
            });
        }, new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("SPARK-31624: SHOW TBLPROPERTIES working with V2 tables and the session catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" TBLPROPERTIES ").append("(key='v', key2='v2')").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(19).append("SHOW TBLPROPERTIES ").append(t1).toString()), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key", "v"})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key2", "v2"}))}))));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(26).append("SHOW TBLPROPERTIES ").append(t1).append("('key')").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"key", "v"})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(27).append("SHOW TBLPROPERTIES ").append(t1).append("('keyX')").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"keyX", new StringBuilder(43).append("Table default.").append(t1).append(" does not have property: keyX").toString()})));
            });
        }, new Position("DataSourceV2SQLSessionCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }
}

