/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryTestingUtils$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ExternalAppendOnlyUnsafeRowArrayBenchmark$
extends BenchmarkBase {
    public static ExternalAppendOnlyUnsafeRowArrayBenchmark$ MODULE$;
    private final SparkConf conf;

    static {
        new ExternalAppendOnlyUnsafeRowArrayBenchmark$();
    }

    private SparkConf conf() {
        return this.conf;
    }

    private void withFakeTaskContext(Function0<BoxedUnit> f) {
        SparkContext sc = new SparkContext("local", "test", this.conf());
        TaskContext taskContext = MemoryTestingUtils$.MODULE$.fakeTaskContext(SparkEnv$.MODULE$.get());
        TaskContext$.MODULE$.setTaskContext(taskContext);
        f.apply$mcV$sp();
        sc.stop();
    }

    private Seq<UnsafeRow> testRows(int numRows) {
        Random random = new Random();
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> ExternalAppendOnlyUnsafeRowArrayBenchmark$.$anonfun$testRows$1(random, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public void testAgainstRawArrayBuffer(int numSpillThreshold, int numRows, int iterations) {
        Seq<UnsafeRow> rows = this.testRows(numRows);
        String x$1 = new StringBuilder(16).append("Array with ").append(numRows).append(" rows").toString();
        long x$22 = iterations * numRows;
        Option x$32 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$22, x$4, x$5, x$6, x$7, x$32);
        int initialSize = Math.min(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), numSpillThreshold);
        benchmark.addCase("ArrayBuffer", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ArrayBuffer array = new ArrayBuffer(initialSize);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> array.$plus$eq((Object)x.copy()));
                int n = array.length();
                for (int i = 0; i < n; ++i) {
                    sum$1.elem += ((UnsafeRow)array.apply(i)).getLong(0);
                }
                array.clear();
            });
        });
        benchmark.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(ExternalAppendOnlyUnsafeRowArray$.MODULE$.DefaultInitialSizeOfInMemoryBuffer(), numSpillThreshold);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.add(x);
                    return BoxedUnit.UNIT;
                });
                Iterator iterator = array.generateIterator();
                while (iterator.hasNext()) {
                    sum$2.elem += ((UnsafeRow)iterator.next()).getLong(0);
                }
                array.clear();
            });
        });
        this.withFakeTaskContext((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> benchmark.run());
    }

    public void testAgainstRawUnsafeExternalSorter(int numSpillThreshold, int numRows, int iterations) {
        Seq<UnsafeRow> rows = this.testRows(numRows);
        String x$1 = new StringBuilder(19).append("Spilling with ").append(numRows).append(" rows").toString();
        long x$2 = iterations * numRows;
        Option x$3 = this.output();
        int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$42, x$52, x$6, x$7, x$3);
        benchmark.addCase("UnsafeExternalSorter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                UnsafeExternalSorter array = UnsafeExternalSorter.create((TaskMemoryManager)TaskContext$.MODULE$.get().taskMemoryManager(), (BlockManager)SparkEnv$.MODULE$.get().blockManager(), (SerializerManager)SparkEnv$.MODULE$.get().serializerManager(), (TaskContext)TaskContext$.MODULE$.get(), null, null, (int)1024, (long)SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes(), (int)numSpillThreshold, (boolean)false);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.insertRecord(x.getBaseObject(), x.getBaseOffset(), x.getSizeInBytes(), 0L, false);
                    return BoxedUnit.UNIT;
                });
                UnsafeRow unsafeRow = new UnsafeRow(1);
                UnsafeSorterIterator iter = array.getIterator(0);
                while (iter.hasNext()) {
                    iter.loadNext();
                    unsafeRow.pointTo(iter.getBaseObject(), iter.getBaseOffset(), iter.getRecordLength());
                    sum$3.elem += unsafeRow.getLong(0);
                }
                array.cleanupResources();
            });
        });
        benchmark.addCase("ExternalAppendOnlyUnsafeRowArray", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iterations)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                ExternalAppendOnlyUnsafeRowArray array = new ExternalAppendOnlyUnsafeRowArray(numSpillThreshold, numSpillThreshold);
                rows.foreach((Function1 & Serializable & scala.Serializable)x -> {
                    array.add(x);
                    return BoxedUnit.UNIT;
                });
                Iterator iterator = array.generateIterator();
                while (iterator.hasNext()) {
                    sum$4.elem += ((UnsafeRow)iterator.next()).getLong(0);
                }
                array.clear();
            });
        });
        this.withFakeTaskContext((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> benchmark.run());
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("WITHOUT SPILL", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int spillThreshold = 100000;
            MODULE$.testAgainstRawArrayBuffer(spillThreshold, 100000, 1024);
            MODULE$.testAgainstRawArrayBuffer(spillThreshold, 1000, 262144);
            MODULE$.testAgainstRawArrayBuffer(spillThreshold, 30000, 16384);
        });
        this.runBenchmark("WITH SPILL", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.testAgainstRawUnsafeExternalSorter(100000, 1000, 262144);
            MODULE$.testAgainstRawUnsafeExternalSorter(BoxesRunTime.unboxToInt((Object)package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD().defaultValue().get()), 10000, 16);
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ UnsafeRow $anonfun$testRows$1(Random random$1, int x$1) {
        void var2_2;
        UnsafeRow row = new UnsafeRow(1);
        row.pointTo(new byte[64], 16);
        row.setLong(0, random$1.nextLong());
        return var2_2;
    }

    private ExternalAppendOnlyUnsafeRowArrayBenchmark$() {
        MODULE$ = this;
        this.conf = new SparkConf(false).set(package$.MODULE$.SERIALIZER_OBJECT_STREAM_RESET(), (Object)BoxesRunTime.boxToInteger((int)1)).set(package$.MODULE$.SERIALIZER(), (Object)"org.apache.spark.serializer.JavaSerializer");
    }
}

