/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.adaptive.ShufflePartitionsUtil$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193A\u0001B\u0003\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00055!9!\tAI\u0001\n\u0013\u0019%AG*ik\u001a4G.\u001a)beRLG/[8ogV#\u0018\u000e\\*vSR,'B\u0001\u0004\b\u0003%)\u00070Z2vi&|gN\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001#A\u0011!cE\u0007\u0002\u0013%\u0011A#\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005)\u0011aD2iK\u000e\\Wi\u001d;j[\u0006$\u0018n\u001c8\u0015\u000bm\t#fO\u001f\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006E\t\u0001\raI\u0001\u0018Ef$Xm\u001d\"z!\u0006\u0014H/\u001b;j_:LE-\u0011:sCf\u00042\u0001\b\u0013'\u0013\t)SDA\u0003BeJ\f\u0017\u0010E\u0002\u001dI\u001d\u0002\"\u0001\b\u0015\n\u0005%j\"\u0001\u0002'p]\u001eDQa\u000b\u0002A\u00021\nQ$\u001a=qK\u000e$X\r\u001a)beRLG/[8o'R\f'\u000f^%oI&\u001cWm\u001d\t\u0004[UBdB\u0001\u00184\u001d\ty#'D\u00011\u0015\t\tt\"\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A'H\u0001\ba\u0006\u001c7.Y4f\u0013\t1tGA\u0002TKFT!\u0001N\u000f\u0011\u0005aI\u0014B\u0001\u001e\u0006\u0005Y\u0019u.\u00197fg\u000e,G\rU1si&$\u0018n\u001c8Ta\u0016\u001c\u0007\"\u0002\u001f\u0003\u0001\u00049\u0013A\u0003;be\u001e,GoU5{K\"9aH\u0001I\u0001\u0002\u0004y\u0014\u0001E7j]:+X\u000eU1si&$\u0018n\u001c8t!\ta\u0002)\u0003\u0002B;\t\u0019\u0011J\u001c;\u00023\rDWmY6FgRLW.\u0019;j_:$C-\u001a4bk2$H\u0005N\u000b\u0002\t*\u0012q(R\u0016\u0002\rB\u0011q\tT\u0007\u0002\u0011*\u0011\u0011JS\u0001\nk:\u001c\u0007.Z2lK\u0012T!aS\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002N\u0011\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ShufflePartitionsUtilSuite
extends SparkFunSuite {
    private void checkEstimation(long[][] bytesByPartitionIdArray, Seq<CoalescedPartitionSpec> expectedPartitionStartIndices, long targetSize, int minNumPartitions) {
        MapOutputStatistics[] mapOutputStatistics = (MapOutputStatistics[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bytesByPartitionIdArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long[] bytesByPartitionId = (long[])tuple2._1();
            int index = tuple2._2$mcI$sp();
            MapOutputStatistics mapOutputStatistics = new MapOutputStatistics(index, bytesByPartitionId);
            return mapOutputStatistics;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MapOutputStatistics.class)));
        Seq estimatedPartitionStartIndices = ShufflePartitionsUtil$.MODULE$.coalescePartitions(mapOutputStatistics, targetSize, minNumPartitions);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(estimatedPartitionStartIndices);
        Seq<CoalescedPartitionSpec> $org_scalatest_assert_macro_right = expectedPartitionStartIndices;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
    }

    private int checkEstimation$default$4() {
        return 1;
    }

    public ShufflePartitionsUtilSuite() {
        this.test("1 shuffle", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int targetSize = 100;
            long[] bytesByPartitionId = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 0L, 20L, 0L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId2}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs2, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId3 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 0L, 90L, 20L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 3), new CoalescedPartitionSpec(3, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId3}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs3, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId4 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{110L, 10L, 100L, 110L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 3), new CoalescedPartitionSpec(3, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId4}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs4, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId5 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{100L, 110L, 100L, 110L, 110L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 3), new CoalescedPartitionSpec(3, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId5}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs5, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId6 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 30L, 0L, 40L, 110L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId6}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs6, targetSize, this.checkEstimation$default$4());
        }, new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("2 shuffles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int targetSize = 100;
            long[] bytesByPartitionId1 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId1, bytesByPartitionId2}), (Seq<CoalescedPartitionSpec>)((Seq)Seq$.MODULE$.empty()), targetSize, this.checkEstimation$default$4()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            long[] bytesByPartitionId12 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId22 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId12, bytesByPartitionId22}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId13 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 10L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId23 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 20L, 0L, 20L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId13, bytesByPartitionId23}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs2, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId14 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 10L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId24 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 2), new CoalescedPartitionSpec(2, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId14, bytesByPartitionId24}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs3, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId15 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 99L, 0L, 20L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId25 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId15, bytesByPartitionId25}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs4, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId16 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 100L, 0L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId26 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 70L, 0L, 30L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId16, bytesByPartitionId26}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs5, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId17 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 100L, 40L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId27 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 60L, 0L, 110L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 3), new CoalescedPartitionSpec(3, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId17, bytesByPartitionId27}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs6, targetSize, this.checkEstimation$default$4());
            long[] bytesByPartitionId18 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{100L, 100L, 40L, 30L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId28 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 0L, 60L, 70L, 110L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs7 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 2), new CoalescedPartitionSpec(2, 3), new CoalescedPartitionSpec(3, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId18, bytesByPartitionId28}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs7, targetSize, this.checkEstimation$default$4());
        }, new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.test("enforce minimal number of coalesced partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int targetSize = 100;
            int minNumPartitions = 2;
            long[] bytesByPartitionId1 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId2 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 0L, 0L, 0L, 0L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId1, bytesByPartitionId2}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs, targetSize, minNumPartitions);
            long[] bytesByPartitionId12 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 5L, 5L, 0L, 20L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId22 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L, 10L, 0L, 10L, 5L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 3), new CoalescedPartitionSpec(3, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId12, bytesByPartitionId22}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs2, targetSize, minNumPartitions);
            long[] bytesByPartitionId13 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{10L, 50L, 20L, 80L, 20L}), ClassTag$.MODULE$.Long());
            long[] bytesByPartitionId23 = (long[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{40L, 10L, 0L, 10L, 30L}), ClassTag$.MODULE$.Long());
            Seq expectedPartitionSpecs3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{new CoalescedPartitionSpec(0, 1), new CoalescedPartitionSpec(1, 3), new CoalescedPartitionSpec(3, 4), new CoalescedPartitionSpec(4, 5)}));
            this.checkEstimation((long[][])((Object[])new long[][]{bytesByPartitionId13, bytesByPartitionId23}), (Seq<CoalescedPartitionSpec>)expectedPartitionSpecs3, targetSize, minNumPartitions);
        }, new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        this.test("splitSizeListByTargetSize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int targetSize = 100;
            Seq sizeList1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{15L, 90L, 15L, 15L, 15L, 90L, 15L}));
            Seq $org_scalatest_assert_macro_left = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ShufflePartitionsUtil$.MODULE$.splitSizeListByTargetSize(sizeList1, (long)targetSize))).toSeq();
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 5}));
            Seq seq = $org_scalatest_assert_macro_left;
            Seq seq2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            Seq sizeList2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{30L, 15L, 90L, 10L, 90L, 15L, 30L}));
            Seq $org_scalatest_assert_macro_left2 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ShufflePartitionsUtil$.MODULE$.splitSizeListByTargetSize(sizeList2, (long)targetSize))).toSeq();
            Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 5}));
            Seq seq3 = $org_scalatest_assert_macro_left2;
            Seq seq4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            Seq sizeList3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{15L, 1000L, 15L, 1000L}));
            Seq $org_scalatest_assert_macro_left3 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ShufflePartitionsUtil$.MODULE$.splitSizeListByTargetSize(sizeList3, (long)targetSize))).toSeq();
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3}));
            Seq seq5 = $org_scalatest_assert_macro_left3;
            Seq seq6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq5 != null ? !seq5.equals(seq6) : seq6 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
            Seq sizeList4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{35L, 75L, 90L, 20L, 35L, 25L, 35L}));
            Seq $org_scalatest_assert_macro_left4 = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ShufflePartitionsUtil$.MODULE$.splitSizeListByTargetSize(sizeList4, (long)targetSize))).toSeq();
            Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
            Seq seq7 = $org_scalatest_assert_macro_left4;
            Seq seq8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(seq7 != null ? !seq7.equals(seq8) : seq8 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        }, new Position("ShufflePartitionsUtilSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
    }
}

