/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DateTimeBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static DateTimeBenchmark$ MODULE$;
    private final SparkSession spark;

    static {
        new DateTimeBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private void doBenchmark(int cardinality, Seq<String> exprs) {
        this.DatasetToBenchmark(this.spark().range((long)cardinality).selectExpr(exprs)).noop();
    }

    private void run(int cardinality, String name, Seq<String> exprs) {
        this.codegenBenchmark(name, cardinality, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.doBenchmark(cardinality, exprs));
    }

    private void run(int cardinality, String func) {
        this.codegenBenchmark(new StringBuilder(13).append(func).append(" of timestamp").toString(), cardinality, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.doBenchmark(cardinality, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(23).append(func).append("(cast(id as timestamp))").toString()})));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)DateTimeTestUtils$.MODULE$.LA().getId())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int N = 10000000;
            MODULE$.runBenchmark("datetime +/- interval", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String x$13 = "datetime +/- interval";
                long x$22 = N;
                Option x$32 = MODULE$.output();
                int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$62 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$72 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$13, x$22, x$42, x$52, x$62, x$72, x$32);
                String ts = "cast(id as timestamp)";
                String dt = new StringBuilder(14).append("cast(").append(ts).append(" as date)").toString();
                benchmark.addCase("date + interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(19).append(dt).append(" + interval 1 month").toString()})));
                benchmark.addCase("date + interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append(dt).append(" + interval 1 month 2 day").toString()})));
                benchmark.addCase("date + interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(32).append(dt).append(" + interval 1 month 2 day 5 hour").toString()})));
                benchmark.addCase("date - interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(19).append(dt).append(" - interval 1 month").toString()})));
                benchmark.addCase("date - interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append(dt).append(" - interval 1 month 2 day").toString()})));
                benchmark.addCase("date - interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(32).append(dt).append(" - interval 1 month 2 day 5 hour").toString()})));
                benchmark.addCase("timestamp + interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(19).append(ts).append(" + interval 1 month").toString()})));
                benchmark.addCase("timestamp + interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append(ts).append(" + interval 1 month 2 day").toString()})));
                benchmark.addCase("timestamp + interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(32).append(ts).append(" + interval 1 month 2 day 5 hour").toString()})));
                benchmark.addCase("timestamp - interval(m)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(19).append(ts).append(" - interval 1 month").toString()})));
                benchmark.addCase("timestamp - interval(m, d)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append(ts).append(" - interval 1 month 2 day").toString()})));
                benchmark.addCase("timestamp - interval(m, d, ms)", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$12 -> MODULE$.doBenchmark(N, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(32).append(ts).append(" - interval 1 month 2 day 5 hour").toString()})));
                benchmark.run();
            });
            MODULE$.runBenchmark("Extract components", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MODULE$.run(N, "cast to timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cast(id as timestamp)"}));
                MODULE$.run(N, "year");
                MODULE$.run(N, "quarter");
                MODULE$.run(N, "month");
                MODULE$.run(N, "weekofyear");
                MODULE$.run(N, "day");
                MODULE$.run(N, "dayofyear");
                MODULE$.run(N, "dayofmonth");
                MODULE$.run(N, "dayofweek");
                MODULE$.run(N, "weekday");
                MODULE$.run(N, "hour");
                MODULE$.run(N, "minute");
                MODULE$.run(N, "second");
            });
            MODULE$.runBenchmark("Current date and time", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                MODULE$.run(N, "current_date", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_date"}));
                MODULE$.run(N, "current_timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current_timestamp"}));
            });
            MODULE$.runBenchmark("Date arithmetic", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String dateExpr = "cast(cast(id as timestamp) as date)";
                MODULE$.run(N, "cast to date", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dateExpr}));
                MODULE$.run(N, "last_day", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("last_day(").append(dateExpr).append(")").toString()}));
                MODULE$.run(N, "next_day", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("next_day(").append(dateExpr).append(", 'TU')").toString()}));
                MODULE$.run(N, "date_add", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(14).append("date_add(").append(dateExpr).append(", 10)").toString()}));
                MODULE$.run(N, "date_sub", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(14).append("date_sub(").append(dateExpr).append(", 10)").toString()}));
                MODULE$.run(N, "add_months", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("add_months(").append(dateExpr).append(", 10)").toString()}));
            });
            MODULE$.runBenchmark("Formatting dates", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String dateExpr = "cast(cast(id as timestamp) as date)";
                MODULE$.run(N, "format date", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append("date_format(").append(dateExpr).append(", 'MMM yyyy')").toString()}));
            });
            MODULE$.runBenchmark("Formatting timestamps", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.run(N, "from_unixtime", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"from_unixtime(id, 'yyyy-MM-dd HH:mm:ss.SSSSSS')"})));
            MODULE$.runBenchmark("Convert timestamps", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String timestampExpr = "cast(id as timestamp)";
                MODULE$.run(N, "from_utc_timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(27).append("from_utc_timestamp(").append(timestampExpr).append(", 'CET')").toString()}));
                MODULE$.run(N, "to_utc_timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(25).append("to_utc_timestamp(").append(timestampExpr).append(", 'CET')").toString()}));
            });
            MODULE$.runBenchmark("Intervals", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2 = new Tuple2((Object)"cast(id as timestamp)", (Object)"cast((id+8640000) as timestamp)");
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String start = (String)tuple2._1();
                String end = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
                Tuple2 tuple23 = tuple22;
                String start2 = (String)tuple23._1();
                String end2 = (String)tuple23._2();
                MODULE$.run(N, "cast interval", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{start2, end2}));
                MODULE$.run(N, "datediff", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("datediff(").append(start2).append(", ").append(end2).append(")").toString()}));
                MODULE$.run(N, "months_between", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("months_between(").append(start2).append(", ").append(end2).append(")").toString()}));
                MODULE$.run(1000000, "window", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(20).append("window(").append(start2).append(", 100, 10, 1)").toString()}));
            });
            MODULE$.runBenchmark("Truncation", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String timestampExpr = "cast(id as timestamp)";
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"YEAR", "YYYY", "YY", "MON", "MONTH", "MM", "DAY", "DD", "HOUR", "MINUTE", "SECOND", "WEEK", "QUARTER"}))).foreach((Function1 & Serializable & scala.Serializable)level -> {
                    DateTimeBenchmark$.MODULE$.run(N, new StringBuilder(11).append("date_trunc ").append(level).toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("date_trunc('").append(level).append("', ").append(timestampExpr).append(")").toString()}));
                    return BoxedUnit.UNIT;
                });
                String dateExpr = "cast(cast(id as timestamp) as date)";
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"year", "yyyy", "yy", "mon", "month", "mm"}))).foreach((Function1 & Serializable & scala.Serializable)level -> {
                    DateTimeBenchmark$.MODULE$.run(N, new StringBuilder(6).append("trunc ").append(level).toString(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(11).append("trunc('").append(level).append("', ").append(dateExpr).append(")").toString()}));
                    return BoxedUnit.UNIT;
                });
            });
            MODULE$.runBenchmark("Parsing", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int n = 1000000;
                String timestampStrExpr = "concat('2019-01-27 11:02:01.', cast(mod(id, 1000) as string))";
                String pattern = "'yyyy-MM-dd HH:mm:ss.SSS'";
                MODULE$.run(n, "to timestamp str", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{timestampStrExpr}));
                MODULE$.run(n, "to_timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(16).append("to_timestamp(").append(timestampStrExpr).append(", ").append(pattern).append(")").toString()}));
                MODULE$.run(n, "to_unix_timestamp", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(21).append("to_unix_timestamp(").append(timestampStrExpr).append(", ").append(pattern).append(")").toString()}));
                String dateStrExpr = "concat('2019-01-', lpad(mod(id, 25), 2, '0'))";
                MODULE$.run(n, "to date str", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dateStrExpr}));
                MODULE$.run(n, "to_date", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(23).append("to_date(").append(dateStrExpr).append(", 'yyyy-MM-dd')").toString()}));
            });
            MODULE$.runBenchmark("Conversion from/to external types", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int rowsNum = 5000000;
                int numIters = 3;
                String x$8 = "To/from Java's date-time";
                long x$9 = rowsNum;
                Option x$10 = MODULE$.output();
                int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
                FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
                FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
                boolean x$142 = Benchmark$.MODULE$.$lessinit$greater$default$6();
                Benchmark benchmark = new Benchmark(x$8, x$9, x$11, x$12, x$13, x$142, x$10);
                benchmark.addCase("From java.sql.Date", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$14 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable & scala.Serializable)millis -> new Date(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newDateEncoder())).noop());
                benchmark.addCase("From java.time.LocalDate", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$15 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable & scala.Serializable)millis -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(millis) / 86400000L), MODULE$.spark().implicits().newLocalDateEncoder())).noop());
                benchmark.addCase("Collect java.sql.Date", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).map((Function1 & Serializable & scala.Serializable)millis -> new Date(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newDateEncoder()).collect());
                benchmark.addCase("Collect java.time.LocalDate", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).map((Function1 & Serializable & scala.Serializable)millis -> LocalDate.ofEpochDay(Predef$.MODULE$.Long2long(millis) / 86400000L), MODULE$.spark().implicits().newLocalDateEncoder()).collect()));
                benchmark.addCase("From java.sql.Timestamp", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$18 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable & scala.Serializable)millis -> new Timestamp(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newTimeStampEncoder())).noop());
                benchmark.addCase("From java.time.Instant", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$19 -> MODULE$.DatasetToBenchmark(MODULE$.spark().range((long)rowsNum).map((Function1 & Serializable & scala.Serializable)millis -> Instant.ofEpochMilli(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newInstantEncoder())).noop());
                benchmark.addCase("Collect longs", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$20 -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).collect());
                benchmark.addCase("Collect java.sql.Timestamp", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$21 -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).map((Function1 & Serializable & scala.Serializable)millis -> new Timestamp(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newTimeStampEncoder()).collect());
                benchmark.addCase("Collect java.time.Instant", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$22 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.DATETIME_JAVA8API_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.spark().range(0L, (long)rowsNum, 1L, 1).map((Function1 & Serializable & scala.Serializable)millis -> Instant.ofEpochMilli(Predef$.MODULE$.Long2long(millis)), MODULE$.spark().implicits().newInstantEncoder()).collect()));
                benchmark.run();
            });
        }));
    }

    private DateTimeBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

