/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ParquetNestedPredicatePushDownBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static ParquetNestedPredicatePushDownBenchmark$ MODULE$;
    private final int N;
    private final int NUMBER_OF_ITER;
    private final Dataset<Row> df;
    private final SparkSession spark;

    static {
        new ParquetNestedPredicatePushDownBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int N() {
        return this.N;
    }

    private int NUMBER_OF_ITER() {
        return this.NUMBER_OF_ITER;
    }

    private Dataset<Row> df() {
        return this.df;
    }

    private void addCase(Benchmark benchmark, String inputPath, String enableNestedPD, String name, Function1<Dataset<Row>, Dataset<Row>> withFilter) {
        Dataset loadDF = this.spark().read().parquet(inputPath);
        benchmark.addCase(name, benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST().key(), (Object)enableNestedPD)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark((Dataset)withFilter.apply((Object)loadDF)).noop()));
    }

    private void createAndRunBenchmark(String name, Function1<Dataset<Row>, Dataset<Row>> withFilter) {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tempDir -> {
            ParquetNestedPredicatePushDownBenchmark$.$anonfun$createAndRunBenchmark$1(name, withFilter, tempDir);
            return BoxedUnit.UNIT;
        });
    }

    public void runLoadNoRowGroupWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip all row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable & scala.Serializable)x$2 -> x$2.filter("nested.x < 0"));
    }

    public void runLoadSomeRowGroupWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip some row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable & scala.Serializable)x$3 -> x$3.filter("nested.x = 100"));
    }

    public void runLoadAllRowGroupsWhenPredicatePushedDown() {
        this.createAndRunBenchmark("Can skip no row groups", (Function1<Dataset<Row>, Dataset<Row>>)(Function1 & Serializable & scala.Serializable)x$4 -> x$4.filter(new StringBuilder(30).append("nested.x >= 0 and nested.x <= ").append(MODULE$.N()).toString()));
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runLoadNoRowGroupWhenPredicatePushedDown();
        this.runLoadSomeRowGroupWhenPredicatePushedDown();
        this.runLoadAllRowGroupsWhenPredicatePushedDown();
    }

    public static final /* synthetic */ void $anonfun$createAndRunBenchmark$1(String name$1, Function1 withFilter$2, File tempDir) {
        String outputPath = tempDir.getCanonicalPath();
        MODULE$.df().write().mode(SaveMode.Overwrite).parquet(outputPath);
        String x$1 = name$1;
        long x$2 = MODULE$.N();
        int x$3 = MODULE$.NUMBER_OF_ITER();
        Option x$4 = MODULE$.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$3, x$5, x$6, x$7, x$4);
        MODULE$.addCase(benchmark, outputPath, "", "Without nested predicate Pushdown", (Function1<Dataset<Row>, Dataset<Row>>)withFilter$2);
        MODULE$.addCase(benchmark, outputPath, "parquet", "With nested predicate Pushdown", (Function1<Dataset<Row>, Dataset<Row>>)withFilter$2);
        benchmark.run();
    }

    private ParquetNestedPredicatePushDownBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
        this.N = 0x6400000;
        this.NUMBER_OF_ITER = 10;
        this.df = this.spark().range(1L, (long)this.N(), 1L, 4).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "STRUCT(id x, STRUCT(CAST(id AS STRING) z) y) nested"})).sort("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

