/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.benchmark.WideSchemaBenchmark$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple1;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class WideSchemaBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static WideSchemaBenchmark$ MODULE$;
    private final int scaleFactor;
    private final Seq<Object> widthsToTest;
    private final Seq<Object> depthsToTest;
    private List<File> tmpFiles;
    private final SparkSession spark;

    static {
        new WideSchemaBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private int scaleFactor() {
        return this.scaleFactor;
    }

    private Seq<Object> widthsToTest() {
        return this.widthsToTest;
    }

    private Seq<Object> depthsToTest() {
        return this.depthsToTest;
    }

    private List<File> tmpFiles() {
        return this.tmpFiles;
    }

    private void tmpFiles_$eq(List<File> x$1) {
        this.tmpFiles = x$1;
    }

    private void deleteTmpFiles() {
        this.tmpFiles().foreach((Function1 & Serializable & scala.Serializable)file -> {
            Utils$.MODULE$.deleteRecursively(file);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> saveAsParquet(Dataset<Row> df) {
        File tmpFile = File.createTempFile("WideSchemaBenchmark", "tmp");
        this.tmpFiles_$eq((List<File>)this.tmpFiles().$colon$colon((Object)tmpFile));
        tmpFile.delete();
        df.write().parquet(tmpFile.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tmpFile.isDirectory(), "tmpFile.isDirectory()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        return this.spark().read().parquet(tmpFile.getAbsolutePath());
    }

    private void addCases(Benchmark benchmark, Dataset<Row> df, String desc, String selector) {
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (read in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.DatasetToBenchmark(df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString()}))).noop());
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (exec in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.DatasetToBenchmark(df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*", new StringBuilder(11).append("hash(").append(selector).append(") as f").toString()})).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString(), "sum(f)"}))).noop());
        Dataset<Row> parquet = this.saveAsParquet(df);
        benchmark.addCase(new StringBuilder(15).append(desc).append(" (read parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.DatasetToBenchmark(parquet.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()}))).noop());
        benchmark.addCase(new StringBuilder(16).append(desc).append(" (write parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.saveAsParquet((Dataset<Row>)df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()}))));
    }

    public void parsingLargeSelectExpressions() {
        String x$1 = "parsing large select";
        long x$2 = 1L;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark$.$anonfun$parsingLargeSelectExpressions$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            benchmark.addCase(new StringBuilder(19).append(width).append(" select expressions").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> MODULE$.spark().range(1L).toDF().selectExpr((Seq)selectExpr));
        });
        benchmark.run();
    }

    public void manyColumnFieldReadAndWrite() {
        String x$1 = "many column field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark$.$anonfun$manyColumnFieldReadAndWrite$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            Dataset df = MODULE$.spark().range((long)numRows).toDF().selectExpr((Seq)selectExpr).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" cols x ").append(numRows).append(" rows").toString(), "a_1");
        });
        benchmark.run();
    }

    public void wideShallowlyNestedStructFieldReadAndWrite() {
        String x$1 = "wide shallowly nested struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            ObjectRef datum = ObjectRef.create((Object)"{");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                datum$1.elem = i == 1 ? new StringBuilder(11).append((String)datum$1.elem).append("\"value_").append(i).append("\": 1").toString() : new StringBuilder(13).append((String)datum$1.elem).append(", \"value_").append(i).append("\": 1").toString();
            });
            datum.elem = new StringBuilder(1).append((String)datum.elem).append("}").toString();
            datum.elem = new StringBuilder(35).append("{\"a\": {\"b\": {\"c\": ").append((String)datum.elem).append(", \"d\": ").append((String)datum.elem).append("}, \"e\": ").append((String)datum.elem).append("}}").toString();
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)datum$1.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "a.b.c.value_1");
        });
        benchmark.run();
    }

    public void deeplyNestedStructFieldReadAndWrite() {
        String x$1 = "deeply nested struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.depthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)depth -> {
            int numRows = MODULE$.scaleFactor() / depth;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
            ObjectRef selector = ObjectRef.create((Object)"value");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                datum$2.elem = new StringBuilder(11).append("{\"value\": ").append((String)datum$2.elem).append("}").toString();
                selector$2.elem = new StringBuilder(6).append((String)selector$2.elem).append(".value").toString();
            });
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)datum$2.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(depth).append(" deep x ").append(numRows).append(" rows").toString(), (String)selector.elem);
        });
        benchmark.run();
    }

    public void bushyStructFieldReadAndWrite() {
        String x$1 = "bushy struct field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 1000}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            int numNodes = 1;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
            String selector = "value";
            int depth = 1;
            while (numNodes < width) {
                numNodes *= 2;
                datum.elem = new StringBuilder(23).append("{\"left_").append(depth).append("\": ").append((String)datum.elem).append(", \"right_").append(depth).append("\": ").append((String)datum.elem).append("}").toString();
                selector = new StringBuilder(6).append("left_").append(depth).append(".").append(selector).toString();
                ++depth;
            }
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)datum$3.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(16).append(numNodes).append(" x ").append(depth).append(" deep x ").append(numRows).append(" rows").toString(), selector);
        });
        benchmark.run();
    }

    public void wideArrayFieldReadAndWrite() {
        String x$1 = "wide array field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            ObjectRef datum = ObjectRef.create((Object)"{\"value\": [");
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                datum$4.elem = i == 1 ? new StringBuilder(1).append((String)datum$4.elem).append("1").toString() : new StringBuilder(3).append((String)datum$4.elem).append(", 1").toString();
            });
            datum.elem = new StringBuilder(2).append((String)datum.elem).append("]}").toString();
            Dataset df = MODULE$.spark().read().json(MODULE$.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)datum$4.elem, MODULE$.spark().implicits().newStringEncoder())).cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "value[0]");
        });
        benchmark.run();
    }

    public void wideMapFieldReadAndWrite() {
        String x$1 = "wide map field r/w";
        long x$2 = this.scaleFactor();
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
            int numRows = MODULE$.scaleFactor() / width;
            Tuple1 datum = new Tuple1((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(6).append("value_").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)BoxesRunTime.boxToInteger((int)1)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                }

                public Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator4$1() {
                }
            }
            Dataset df = MODULE$.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$5 -> datum, MODULE$.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_WideSchemaBenchmark$$typecreator4$1()))).toDF().cache();
            df.count();
            MODULE$.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "_1[\"value_1\"]");
        });
        benchmark.run();
    }

    public void runBenchmarkWithDeleteTmpFiles(String benchmarkName, Function0<Object> func) {
        this.runBenchmark(benchmarkName, func);
        this.deleteTmpFiles();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmarkWithDeleteTmpFiles("parsing large select expressions", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.parsingLargeSelectExpressions());
        this.runBenchmarkWithDeleteTmpFiles("many column field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.manyColumnFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide shallowly nested struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.wideShallowlyNestedStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("deeply nested struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.deeplyNestedStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("bushy struct field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.bushyStructFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide array field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.wideArrayFieldReadAndWrite());
        this.runBenchmarkWithDeleteTmpFiles("wide map field read and write", (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.wideMapFieldReadAndWrite());
    }

    public static final /* synthetic */ String $anonfun$parsingLargeSelectExpressions$2(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$manyColumnFieldReadAndWrite$2(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    private WideSchemaBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
        this.scaleFactor = 100000;
        this.widthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 2500}));
        this.depthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 250}));
        int $org_scalatest_assert_macro_left = this.scaleFactor();
        int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)this.widthsToTest().max((Ordering)Ordering.Int$.MODULE$));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.tmpFiles = Nil$.MODULE$;
    }
}

