/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.columnar.ARRAY;
import org.apache.spark.sql.execution.columnar.BINARY$;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.CALENDAR_INTERVAL$;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LARGE_DECIMAL;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.MAP;
import org.apache.spark.sql.execution.columnar.NULL$;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.STRUCT;
import org.apache.spark.sql.execution.columnar.TestNullableColumnAccessor;
import org.apache.spark.sql.execution.columnar.TestNullableColumnAccessor$;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder;
import org.apache.spark.sql.execution.columnar.TestNullableColumnBuilder$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017\tYb*\u001e7mC\ndWmQ8mk6t\u0017iY2fgN|'oU;ji\u0016T!!\u0002\u0004\u0002\u0011\r|G.^7oCJT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003a\u0001\"!\u0007\u0001\u000e\u0003\u0011\t!\u0004^3ti:+H\u000e\\1cY\u0016\u001cu\u000e\\;n]\u0006\u001b7-Z:t_J,\"\u0001\b\u0016\u0015\u0005u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"\u0001B+oSRDQ\u0001\n\u0002A\u0002\u0015\n!bY8mk6tG+\u001f9f!\rIb\u0005K\u0005\u0003O\u0011\u0011!bQ8mk6tG+\u001f9f!\tI#\u0006\u0004\u0001\u0005\u000b-\u0012!\u0019\u0001\u0017\u0003\u000f)3X\u000eV=qKF\u0011Q\u0006\r\t\u0003=9J!aL\u0010\u0003\u000f9{G\u000f[5oOB\u0011a$M\u0005\u0003e}\u00111!\u00118z\u0001")
public class NullableColumnAccessorSuite
extends SparkFunSuite {
    public <JvmType> void testNullableColumnAccessor(ColumnType<JvmType> columnType) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        GenericInternalRow nullRow = ColumnarTestUtils$.MODULE$.makeNullRow(1);
        this.test(new StringBuilder(39).append("Nullable ").append(typeName).append(" column accessor: empty column").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestNullableColumnBuilder builder = TestNullableColumnBuilder$.MODULE$.apply(columnType, TestNullableColumnBuilder$.MODULE$.apply$default$2());
            TestNullableColumnAccessor accessor = TestNullableColumnAccessor$.MODULE$.apply(builder.build(), columnType);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(accessor.hasNext(), "accessor.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test(new StringBuilder(45).append("Nullable ").append(typeName).append(" column accessor: access null values").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TestNullableColumnBuilder builder = TestNullableColumnBuilder$.MODULE$.apply(columnType, TestNullableColumnBuilder$.MODULE$.apply$default$2());
            InternalRow randomRow = ColumnarTestUtils$.MODULE$.makeRandomRow(columnType, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0]));
            UnsafeProjection proj = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{columnType.dataType()}));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                builder.appendFrom((InternalRow)proj.apply(randomRow), 0);
                builder.appendFrom((InternalRow)proj.apply((InternalRow)nullRow), 0);
            });
            TestNullableColumnAccessor accessor = TestNullableColumnAccessor$.MODULE$.apply(builder.build(), columnType);
            GenericInternalRow row = new GenericInternalRow(1);
            Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter(columnType.dataType());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach((Function1 & Serializable & scala.Serializable)x$4 -> NullableColumnAccessorSuite.$anonfun$testNullableColumnAccessor$4(this, accessor, row, converter, columnType, randomRow, BoxesRunTime.unboxToInt((Object)x$4)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(accessor.hasNext(), "accessor.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
    }

    public static final /* synthetic */ Assertion $anonfun$testNullableColumnAccessor$4(NullableColumnAccessorSuite $this, TestNullableColumnAccessor accessor$1, GenericInternalRow row$1, Function1 converter$1, ColumnType columnType$1, InternalRow randomRow$1, int x$4) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(accessor$1.hasNext(), "accessor.hasNext", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        accessor$1.extractTo((InternalRow)row$1, 0);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(converter$1.apply(row$1.get(0, columnType$1.dataType())));
        Object $org_scalatest_assert_macro_right = converter$1.apply(randomRow$1.get(0, columnType$1.dataType()));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(accessor$1.hasNext(), "accessor.hasNext", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
        accessor$1.extractTo((InternalRow)row$1, 0);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(row$1.isNullAt(0), "row.isNullAt(0)", Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("NullableColumnAccessorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public NullableColumnAccessorSuite() {
        ColumnType[] columnTypeArray = new ColumnType[16];
        columnTypeArray[0] = NULL$.MODULE$;
        columnTypeArray[1] = BOOLEAN$.MODULE$;
        columnTypeArray[2] = BYTE$.MODULE$;
        columnTypeArray[3] = SHORT$.MODULE$;
        columnTypeArray[4] = INT$.MODULE$;
        columnTypeArray[5] = LONG$.MODULE$;
        columnTypeArray[6] = FLOAT$.MODULE$;
        columnTypeArray[7] = DOUBLE$.MODULE$;
        columnTypeArray[8] = STRING$.MODULE$;
        columnTypeArray[9] = BINARY$.MODULE$;
        columnTypeArray[10] = new COMPACT_DECIMAL(15, 10);
        columnTypeArray[11] = new LARGE_DECIMAL(20, 10);
        StructField structField = new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        columnTypeArray[12] = new STRUCT(StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)));
        columnTypeArray[13] = new ARRAY(ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        columnTypeArray[14] = new MAP(MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)StringType$.MODULE$));
        columnTypeArray[15] = CALENDAR_INTERVAL$.MODULE$;
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])columnTypeArray))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.testNullableColumnAccessor(x$2);
            return BoxedUnit.UNIT;
        });
    }
}

