/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.OrcIndex;
import org.apache.orc.impl.RecordReaderImpl;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.execution.datasources.SchemaMergeUtils$;
import org.apache.spark.sql.execution.datasources.orc.OrcData;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions$;
import org.apache.spark.sql.execution.datasources.orc.OrcSuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcTest;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}b!\u0002\b\u0010\u0003\u0003q\u0002\"B\u0015\u0001\t\u0003Q\u0003b\u0002\u0017\u0001\u0001\u0004%\t!\f\u0005\bm\u0001\u0001\r\u0011\"\u00018\u0011\u0019\u0001\u0005\u0001)Q\u0005]!9\u0011\t\u0001a\u0001\n\u0003i\u0003b\u0002\"\u0001\u0001\u0004%\ta\u0011\u0005\u0007\u000b\u0002\u0001\u000b\u0015\u0002\u0018\t\u000b\u0019\u0003A\u0011K$\t\u000b!\u0003A\u0011C%\t\u000b\u0005\u0004A\u0011\u00032\t\u000f)\u0004\u0011\u0013!C\tW\")a\u000f\u0001C\to\"1a\u000f\u0001C\t\u0003w\u0011\u0001b\u0014:d'VLG/\u001a\u0006\u0003!E\t1a\u001c:d\u0015\t\u00112#A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u000b\u0016\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0017/\u0005\u00191/\u001d7\u000b\u0005aI\u0012!B:qCJ\\'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\r\u0002\"\u0001I\u0011\u000e\u0003=I!AI\b\u0003\u000f=\u00138\rV3tiB\u0011AeJ\u0007\u0002K)\u0011aeG\u0001\ng\u000e\fG.\u0019;fgRL!\u0001K\u0013\u0003#\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0006cG.\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011\u0001\u0005A\u0001\f_J\u001cG+\u00192mK\u0012K'/F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0002j_*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u00111\u0015\u000e\\3\u0002\u001f=\u00148\rV1cY\u0016$\u0015N]0%KF$\"\u0001\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f\r\t\t\u00111\u0001/\u0003\rAH%M\u0001\r_J\u001cG+\u00192mK\u0012K'\u000fI\u0001\u000e_J\u001cG+\u00192mK\u0006\u001bH)\u001b:\u0002#=\u00148\rV1cY\u0016\f5\u000fR5s?\u0012*\u0017\u000f\u0006\u00029\t\"9qHBA\u0001\u0002\u0004q\u0013AD8sGR\u000b'\r\\3Bg\u0012K'\u000fI\u0001\nE\u00164wN]3BY2$\u0012\u0001O\u0001\u0018i\u0016\u001cHO\u00117p_64\u0015\u000e\u001c;fe\u000e\u0013X-\u0019;j_:$\"\u0001\u000f&\t\u000b-K\u0001\u0019\u0001'\u0002\u001f\tdwn\\7GS2$XM]&j]\u0012\u0004\"!\u00140\u000f\u00059[fBA(Y\u001d\t\u0001vK\u0004\u0002R-:\u0011!+V\u0007\u0002'*\u0011A+H\u0001\u0007yI|w\u000e\u001e \n\u0003qI!AG\u000e\n\u0005AI\u0012BA-[\u0003!y%o\u0019)s_R|'B\u0001\t\u001a\u0013\taV,\u0001\u0004TiJ,\u0017-\u001c\u0006\u00033jK!a\u00181\u0003\t-Kg\u000e\u001a\u0006\u00039v\u000bq\u0004^3tiN+G.Z2uSZ,G)[2uS>t\u0017M]=F]\u000e|G-\u001b8h)\rA4\r\u001b\u0005\u0006I*\u0001\r!Z\u0001\fSN\u001cV\r\\3di&4X\r\u0005\u0002:M&\u0011qM\u000f\u0002\b\u0005>|G.Z1o\u0011\u001dI'\u0002%AA\u0002\u0015\f\u0001\"[:ISZ,'gM\u0001*i\u0016\u001cHoU3mK\u000e$\u0018N^3ES\u000e$\u0018n\u001c8bef,enY8eS:<G\u0005Z3gCVdG\u000f\n\u001a\u0016\u00031T#!Z7,\u00039\u0004\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u0013Ut7\r[3dW\u0016$'BA:;\u0003)\tgN\\8uCRLwN\\\u0005\u0003kB\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i!Xm\u001d;NKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)\rA\u0004P\u001f\u0005\u0006s2\u0001\r!Z\u0001\u0013S\u001etwN]3D_J\u0014X\u000f\u001d;GS2,7\u000fC\u0003|\u0019\u0001\u0007A0\u0001\u0007tG\",W.\u0019*fC\u0012,'\u000f\u0005\u0005:{~\f\t#ZA\u0017\u0013\tq(HA\u0005Gk:\u001cG/[8ogA1\u0011\u0011AA\u0006\u0003#qA!a\u0001\u0002\b9\u0019!+!\u0002\n\u0003mJ1!!\u0003;\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\t\u00191+Z9\u000b\u0007\u0005%!\b\u0005\u0003\u0002\u0014\u0005uQBAA\u000b\u0015\u0011\t9\"!\u0007\u0002\u0005\u0019\u001c(bAA\u000e3\u00051\u0001.\u00193p_BLA!a\b\u0002\u0016\tQa)\u001b7f'R\fG/^:\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQA!a\n\u0002\u001a\u0005!1m\u001c8g\u0013\u0011\tY#!\n\u0003\u001b\r{gNZ5hkJ\fG/[8o!\u0019\t\t!a\u0003\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026U\tQ\u0001^=qKNLA!!\u000f\u00024\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0015\u0007a\ni\u0004C\u0003|\u001b\u0001\u0007A\u0010")
public abstract class OrcSuite
extends OrcTest {
    private File orcTableDir = null;
    private File orcTableAsDir = null;

    public File orcTableDir() {
        return this.orcTableDir;
    }

    public void orcTableDir_$eq(File x$1) {
        this.orcTableDir = x$1;
    }

    public File orcTableAsDir() {
        return this.orcTableAsDir;
    }

    public void orcTableAsDir_$eq(File x$1) {
        this.orcTableAsDir = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        String x$1 = "orctests";
        String x$2 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableAsDir_$eq(Utils$.MODULE$.createTempDir(x$2, x$1));
        String x$3 = "orctests";
        String x$4 = Utils$.MODULE$.createTempDir$default$1();
        this.orcTableDir_$eq(Utils$.MODULE$.createTempDir(x$4, x$3));
        SparkContext qual$1 = this.sparkContext();
        Range.Inclusive x$5 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int x$6 = qual$1.makeRDD$default$2();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(OrcSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.orc.OrcData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(OrcSuite $outer) {
            }
        }
        this.testImplicits().rddToDatasetHolder(qual$1.makeRDD((Seq)x$5, x$6, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)i -> OrcSuite.$anonfun$beforeAll$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(OrcData.class)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcSuite$$typecreator5$1(null)))).toDF().createOrReplaceTempView("orc_temp_table");
    }

    public void testBloomFilterCreation(OrcProto.Stream.Kind bloomFilterKind) {
        String tableName = "bloomFilter";
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String string;
                String string2 = $this.orcImp();
                if ("native".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("\n               |CREATE TABLE ").append(tableName$1).append(" (a INT, b STRING)\n               |USING ORC\n               |OPTIONS (\n               |  path '").append(dir.toURI()).append("',\n               |  orc.bloom.filter.columns '*',\n               |  orc.bloom.filter.fpp 0.1\n               |)\n            ").toString())).stripMargin();
                } else if ("hive".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(260).append("\n               |CREATE TABLE ").append(tableName$1).append(" (a INT, b STRING)\n               |STORED AS ORC\n               |LOCATION '").append(dir.toURI()).append("'\n               |TBLPROPERTIES (\n               |  orc.bloom.filter.columns='*',\n               |  orc.bloom.filter.fpp=0.1\n               |)\n            ").toString())).stripMargin();
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(28).append("Unknown ORC implementation: ").append(string2).toString());
                }
                String sqlStatement = string;
                $this.sql().apply((Object)sqlStatement);
                $this.sql().apply((Object)new StringBuilder(30).append("INSERT INTO ").append(tableName$1).append(" VALUES (1, 'str')").toString());
                File[] partFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$3(f)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
                Path orcFilePath = new Path(((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFiles)).head()).getAbsolutePath());
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
                Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions);
                try (RecordReaderImpl recordReader = null;){
                    recordReader = (RecordReaderImpl)reader.rows();
                    boolean[] sargColumns = new boolean[]{true, true, true};
                    OrcIndex orcIndex = recordReader.readRowIndex(0, null, sargColumns);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterKinds())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$4($this, bloomFilterKind$1, x$1))), "scala.Predef.refArrayOps[org.apache.orc.OrcProto.Stream.Kind](orcIndex.getBloomFilterKinds()).forall(((x$1: org.apache.orc.OrcProto.Stream.Kind) => OrcSuite.this.convertToEqualizer[org.apache.orc.OrcProto.Stream.Kind](x$1).===(bloomFilterKind)(scalactic.this.Equality.default[org.apache.orc.OrcProto.Stream.Kind])))", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])orcIndex.getBloomFilterIndex())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testBloomFilterCreation$5(x$2))), "scala.Predef.refArrayOps[org.apache.orc.OrcProto.BloomFilterIndex](orcIndex.getBloomFilterIndex()).forall(((x$2: org.apache.orc.OrcProto.BloomFilterIndex) => x$2.getBloomFilterCount().>(0)))", Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public void testSelectiveDictionaryEncoding(boolean isSelective, boolean isHive23) {
        String tableName = "orcTable";
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String string;
                String string2 = $this.orcImp();
                if ("native".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(302).append("\n               |CREATE TABLE ").append(tableName$2).append(" (zipcode STRING, uniqColumn STRING, value DOUBLE)\n               |USING ORC\n               |OPTIONS (\n               |  path '").append(dir.toURI()).append("',\n               |  orc.dictionary.key.threshold '1.0',\n               |  orc.column.encoding.direct 'uniqColumn'\n               |)\n            ").toString())).stripMargin();
                } else if ("hive".equals(string2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(382).append("\n               |CREATE TABLE ").append(tableName$2).append(" (zipcode STRING, uniqColumn STRING, value DOUBLE)\n               |STORED AS ORC\n               |LOCATION '").append(dir.toURI()).append("'\n               |TBLPROPERTIES (\n               |  orc.dictionary.key.threshold '1.0',\n               |  hive.exec.orc.dictionary.key.size.threshold '1.0',\n               |  orc.column.encoding.direct 'uniqColumn'\n               |)\n            ").toString())).stripMargin();
                } else {
                    throw new UnsupportedOperationException(new StringBuilder(28).append("Unknown ORC implementation: ").append(string2).toString());
                }
                String sqlStatement = string;
                $this.sql().apply((Object)sqlStatement);
                $this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(tableName$2).append(" VALUES ('94086', 'random-uuid-string', 0.0)").toString());
                File[] partFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$testSelectiveDictionaryEncoding$3(f)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                Path orcFilePath = new Path(((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFiles)).head()).getAbsolutePath());
                OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
                Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions);
                try (RecordReaderImpl recordReader = null;){
                    Assertion assertion;
                    recordReader = (RecordReaderImpl)reader.rows();
                    OrcProto.StripeFooter stripe = recordReader.readStripeFooter((StripeInformation)reader.getStripes().get(0));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(stripe.getColumns(1).getKind());
                    OrcProto.ColumnEncoding.Kind $org_scalatest_assert_macro_right2 = OrcProto.ColumnEncoding.Kind.DICTIONARY_V2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                    if (isSelective$1 || isHive23$1) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(stripe.getColumns(2).getKind());
                        OrcProto.ColumnEncoding.Kind $org_scalatest_assert_macro_right3 = OrcProto.ColumnEncoding.Kind.DIRECT_V2;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                    } else {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(stripe.getColumns(2).getKind());
                        OrcProto.ColumnEncoding.Kind $org_scalatest_assert_macro_right4 = OrcProto.ColumnEncoding.Kind.DICTIONARY_V2;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        assertion = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
                    }
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(stripe.getColumns(3).getKind());
                    OrcProto.ColumnEncoding.Kind $org_scalatest_assert_macro_right5 = OrcProto.ColumnEncoding.Kind.DIRECT;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    public boolean testSelectiveDictionaryEncoding$default$2() {
        return false;
    }

    public void testMergeSchemasInParallel(boolean ignoreCorruptFiles, Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>> schemaReader) {
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)ignoreCorruptFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)this.orcImp())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$testMergeSchemasInParallel$2(this, schemaReader, dir);
            return BoxedUnit.UNIT;
        }));
    }

    public void testMergeSchemasInParallel(Function3<Seq<FileStatus>, Configuration, Object, Seq<StructType>> schemaReader) {
        this.testMergeSchemasInParallel(true, schemaReader);
        Throwable exception = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testMergeSchemasInParallel(false, schemaReader), ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231))).getCause();
        String $org_scalatest_assert_macro_left = exception.getCause().getMessage();
        String $org_scalatest_assert_macro_right = "Could not read footer for file";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }

    public static final /* synthetic */ OrcData $anonfun$beforeAll$1(int i) {
        return new OrcData(i, new StringBuilder(5).append("part-").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$3(File f) {
        return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$4(OrcSuite $this, OrcProto.Stream.Kind bloomFilterKind$1, OrcProto.Stream.Kind x$1) {
        return $this.convertToEqualizer(x$1).$eq$eq$eq((Object)bloomFilterKind$1, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ boolean $anonfun$testBloomFilterCreation$5(OrcProto.BloomFilterIndex x$2) {
        return x$2.getBloomFilterCount() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$testSelectiveDictionaryEncoding$3(File f) {
        return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
    }

    public static final /* synthetic */ void $anonfun$testMergeSchemasInParallel$2(OrcSuite $this, Function3 schemaReader$1, File dir) {
        FileSystem fs = FileSystem.get((Configuration)$this.spark().sessionState().newHadoopConf());
        String basePath = dir.getCanonicalPath();
        Path path1 = new Path(basePath, "first");
        Path path2 = new Path(basePath, "second");
        Path path3 = new Path(basePath, "third");
        $this.spark().range(1L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(1).write().orc(path1.toString());
        $this.spark().range(1L, 2L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).coalesce(1).write().orc(path2.toString());
        $this.spark().range(2L, 3L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(1).write().json(path3.toString());
        Seq fileStatuses = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[][]{fs.listStatus(path1), fs.listStatus(path2), fs.listStatus(path3)})).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)));
        Option schema = SchemaMergeUtils$.MODULE$.mergeSchemasInParallel($this.spark(), fileStatuses, schemaReader$1);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(schema.isDefined(), "schema.isDefined", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        StructType $org_scalatest_assert_macro_left = (StructType)schema.get();
        StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    public static final /* synthetic */ Seq $anonfun$new$20(int i) {
        return (Seq)Seq$.MODULE$.fill(2, (Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), new StringBuilder(5).append("part-").append(i).toString()})));
    }

    public static final /* synthetic */ void $anonfun$new$35(OrcSuite $this, Dataset df$1, File path) {
        df$1.write().format("orc").save(path.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path.getCanonicalPath()), (Dataset<Row>)df$1);
    }

    public static final /* synthetic */ void $anonfun$new$38(OrcSuite $this, File path) {
        Timestamp ts = Timestamp.valueOf("1900-05-05 12:34:56.000789");
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Timestamp[]{ts})), $this.testImplicits().newTimeStampEncoder()).toDF().write().orc(path.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path.getCanonicalPath()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ts})));
    }

    public static final /* synthetic */ boolean $anonfun$new$42(File f) {
        return f.isFile() && !f.getName().startsWith(".") && !f.getName().startsWith("_");
    }

    public static final /* synthetic */ void $anonfun$new$41(OrcSuite $this, File path) {
        $this.spark().range(1L).repartition(1).write().orc(path.getCanonicalPath());
        File[] partFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)OrcSuite.$anonfun$new$42(f)));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partFiles.length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
        Path orcFilePath = new Path(((File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partFiles)).head()).getAbsolutePath());
        OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)readerOptions), (Function1 & Serializable & scala.Serializable)reader -> {
            String version = StandardCharsets.UTF_8.decode(reader.getMetadataValue(package$.MODULE$.SPARK_VERSION_METADATA_KEY())).toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(version);
            String $org_scalatest_assert_macro_right = org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        });
    }

    public static final /* synthetic */ void $anonfun$new$49(OrcSuite $this, int expectedColumnNumber$1, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "foo=1").toString());
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).write().orc(new Path(basePath, "foo=2").toString());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.spark().read().orc(basePath).columns().length));
        int $org_scalatest_assert_macro_right = expectedColumnNumber$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.spark().read().option(OrcOptions$.MODULE$.MERGE_SCHEMA(), true).orc(basePath).columns().length));
        int $org_scalatest_assert_macro_right2 = 3;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.spark().read().option(OrcOptions$.MODULE$.MERGE_SCHEMA(), false).orc(basePath).columns().length));
        int $org_scalatest_assert_macro_right3 = 2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 418));
    }

    private final void testSchemaMerging$1(int expectedColumnNumber) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$new$49(this, expectedColumnNumber, dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$53(OrcSuite $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "foo=1").toString());
        $this.spark().range(0L, 10L).map((Function1 & Serializable & scala.Serializable)s -> new StringBuilder(6).append("value_").append(s).toString(), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "foo=2").toString());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String innerMessage;
            String string;
            Throwable exception = ((Throwable)$this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.spark().read().orc(basePath).columns().length, ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441))).getCause();
            String string2 = $this.orcImp();
            if ("native".equals(string2)) {
                string = exception.getMessage();
            } else if ("hive".equals(string2)) {
                string = exception.getCause().getMessage();
            } else {
                throw new UnsupportedOperationException(new StringBuilder(28).append("Unknown ORC implementation: ").append(string2).toString());
            }
            String $org_scalatest_assert_macro_left = innerMessage = string;
            String $org_scalatest_assert_macro_right = "Failed to merge incompatible data types";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.spark().read().orc(basePath).columns().length));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        });
    }

    public static final /* synthetic */ void $anonfun$new$60(OrcSuite $this, File dir) {
        String basePath = dir.getCanonicalPath();
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).write().orc(new Path(basePath, "foo=1").toString());
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).write().orc(new Path(basePath, "foo=2").toString());
        $this.spark().range(0L, 10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})).write().json(new Path(basePath, "foo=3").toString());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)$this.spark().read().orc(basePath).columns().length));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        });
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.IGNORE_CORRUPT_FILES().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Throwable exception = ((Throwable)$this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.spark().read().orc(basePath).columns().length, ClassTag$.MODULE$.apply(SparkException.class), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477))).getCause();
            String $org_scalatest_assert_macro_left = exception.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Could not read footer for file";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 480));
        });
    }

    public static final /* synthetic */ void $anonfun$new$69(OrcSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1001-01-01", "1582-10-10"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dateS"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dateS"}))).$((Seq)Nil$.MODULE$).cast("date").as("date")})).write().orc(path);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)vectorized))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path$3), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Date.valueOf("1001-01-01")})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Date.valueOf("1582-10-15")}))})))));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$78(OrcSuite $this, File dir) {
        String path = dir.getAbsolutePath();
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1001-01-01 01:02:03.123456", "1582-10-10 11:12:13.654321"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tsS"})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tsS"}))).$((Seq)Nil$.MODULE$).cast("timestamp").as("ts")})).write().orc(path);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)vectorized))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().orc(path$4), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Timestamp.valueOf("1001-01-01 01:02:03.123456")})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Timestamp.valueOf("1582-10-15 11:12:13.654321")}))})))));
            return BoxedUnit.UNIT;
        });
    }

    public OrcSuite() {
        this.test("create temporary orc table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_source"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source where intField > 5"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        this.test("create temporary orc table as", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(*) FROM normal_orc_as_source"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10)})));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source WHERE intField > 5"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT COUNT(intField), stringField FROM normal_orc_source GROUP BY stringField"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
        this.test("appending insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"INSERT INTO TABLE normal_orc_source SELECT * FROM orc_temp_table WHERE intField > 5");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_source"), (Seq<Row>)((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> OrcSuite.$anonfun$new$20(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        this.test("overwrite insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("INSERT OVERWRITE TABLE normal_orc_as_source\n        |SELECT * FROM orc_temp_table WHERE intField > 5\n      ")).stripMargin());
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM normal_orc_as_source"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(5).append("part-").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom())));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        this.test("write null values", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
            Dataset df = (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |  CAST(null as TINYINT) as c0,\n        |  CAST(null as SMALLINT) as c1,\n        |  CAST(null as INT) as c2,\n        |  CAST(null as BIGINT) as c3,\n        |  CAST(null as FLOAT) as c4,\n        |  CAST(null as DOUBLE) as c5,\n        |  CAST(null as DECIMAL(7,2)) as c6,\n        |  CAST(null as TIMESTAMP) as c7,\n        |  CAST(null as DATE) as c8,\n        |  CAST(null as STRING) as c9,\n        |  CAST(null as VARCHAR(10)) as c10\n        |FROM orc_temp_table limit 1\n      ")).stripMargin());
            df.write().format("orc").saveAsTable("orcNullValues");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM orcNullValues"), Row$.MODULE$.fromSeq((Seq)Seq$.MODULE$.fill(11, (Function0 & Serializable & scala.Serializable)() -> null)));
            return (Dataset)this.sql().apply((Object)"DROP TABLE IF EXISTS orcNullValues");
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SQLConf conf = this.spark().sessionState().conf();
            OrcOptions option = new OrcOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute().toUpperCase(Locale.ROOT)), (Object)"NONE")})), conf);
            String $org_scalatest_assert_macro_left = option.compressionCodec();
            String $org_scalatest_assert_macro_right = "NONE";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
        this.test("SPARK-21839: Add SQL config for ORC compression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLConf conf = this.spark().sessionState().conf();
            String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).compressionCodec();
            String $org_scalatest_assert_macro_right = "SNAPPY";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)"uncompressed")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).compressionCodec();
                String $org_scalatest_assert_macro_right = "NONE";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
                Map map1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib")}));
                Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcConf.COMPRESS.getAttribute()), (Object)"zlib"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compression"), (Object)"lzo")}));
                String $org_scalatest_assert_macro_left2 = new OrcOptions(map1, conf).compressionCodec();
                String $org_scalatest_assert_macro_right2 = "ZLIB";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
                String $org_scalatest_assert_macro_left3 = new OrcOptions(map2, conf).compressionCodec();
                String $org_scalatest_assert_macro_right3 = "LZO";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
            });
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NONE", "UNCOMPRESSED", "SNAPPY", "ZLIB", "LZO"}))).foreach((Function1 & Serializable & scala.Serializable)c -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COMPRESSION().key()), (Object)c)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String string = c;
                    String string2 = "UNCOMPRESSED";
                    String expected = !(string != null ? !string.equals(string2) : string2 != null) ? "NONE" : c;
                    String $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf$1).compressionCodec();
                    String $org_scalatest_assert_macro_right = expected;
                    String string3 = $org_scalatest_assert_macro_left;
                    String string4 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
                });
                return BoxedUnit.UNIT;
            });
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.ignore("SPARK-23340 Empty float/double array columns raise EOFException", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Dataset[]{this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][]{(float[])Array$.MODULE$.empty(ClassTag$.MODULE$.Float())})), this.testImplicits().newFloatArrayEncoder()).toDF(), this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{(double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double())})), this.testImplicits().newDoubleArrayEncoder()).toDF()}))).foreach((Function1 & Serializable & scala.Serializable)df -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                OrcSuite.$anonfun$new$35($this, df, path);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("SPARK-24322 Fix incorrect workaround for bug in java.sql.Timestamp", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            OrcSuite.$anonfun$new$38(this, path);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("Write Spark version into ORC file metadata", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            OrcSuite.$anonfun$new$41(this, path);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("SPARK-11412 test orc merge schema option", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SQLConf conf = this.spark().sessionState().conf();
            boolean $org_scalatest_assert_macro_left = new OrcOptions(Predef$.MODULE$.Map().empty(), conf).mergeSchema();
            boolean $org_scalatest_assert_macro_right = false;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Map map1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcOptions$.MODULE$.MERGE_SCHEMA()), (Object)"true")}));
                Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcOptions$.MODULE$.MERGE_SCHEMA()), (Object)"false")}));
                boolean $org_scalatest_assert_macro_left = new OrcOptions(map1, conf).mergeSchema();
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
                boolean $org_scalatest_assert_macro_left2 = new OrcOptions(map2, conf).mergeSchema();
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Map map1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcOptions$.MODULE$.MERGE_SCHEMA()), (Object)"true")}));
                Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)OrcOptions$.MODULE$.MERGE_SCHEMA()), (Object)"false")}));
                boolean $org_scalatest_assert_macro_left = new OrcOptions(map1, conf).mergeSchema();
                boolean $org_scalatest_assert_macro_right = true;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 402));
                boolean $org_scalatest_assert_macro_left2 = new OrcOptions(map2, conf).mergeSchema();
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
            });
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        this.test("SPARK-11412 test enabling/disabling schema merging", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testSchemaMerging$1(3));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testSchemaMerging$1(2));
        }, new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        this.test("SPARK-11412 test enabling/disabling schema merging with data type conflicts", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$new$53(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("SPARK-11412 test schema merging with corrupt files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_SCHEMA_MERGING_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$new$60(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 462));
        this.test("SPARK-31238: compatibility with Spark 2.4 in reading dates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)vectorized))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.readResourceOrcFile("test-data/before_1582_date_v2_4.snappy.orc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Date.valueOf("1200-01-01")}))));
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
        this.test("SPARK-31238, SPARK-31423: rebasing dates in write", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$new$69(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 496));
        this.test("SPARK-31284: compatibility with Spark 2.4 in reading timestamps", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)vectorized))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.readResourceOrcFile("test-data/before_1582_ts_v2_4.snappy.orc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Timestamp.valueOf("1001-01-01 01:02:03.123456")}))));
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("SPARK-31284, SPARK-31423: rebasing timestamps in write", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcSuite.$anonfun$new$78(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 524));
    }
}

