/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TestUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000193Q!\u0002\u0004\u0002\u0002UAQ\u0001\t\u0001\u0005\u0002\u0005BQ\u0001\n\u0001\u0005\u0002\u0015BQ!\u000f\u0001\u0005\niBQa\u000f\u0001\u0005\nq\u0012\u0011\u0002V3yiN+\u0018\u000e^3\u000b\u0005\u001dA\u0011\u0001\u0002;fqRT!!\u0003\u0006\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u00171\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00055q\u0011aA:rY*\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#I\ta!\u00199bG\",'\"A\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u00011\"\u0004\u0005\u0002\u001815\tA\"\u0003\u0002\u001a\u0019\tI\u0011+^3ssR+7\u000f\u001e\t\u00037yi\u0011\u0001\b\u0006\u0003;1\tA\u0001^3ti&\u0011q\u0004\b\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\r\u0005\tB/Z:u\u0019&tWmU3qCJ\fGo\u001c:\u0015\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDQ!\f\u0002A\u00029\nq\u0001\\5oKN+\u0007\u000f\u0005\u00020m9\u0011\u0001\u0007\u000e\t\u0003c!j\u0011A\r\u0006\u0003gQ\ta\u0001\u0010:p_Rt\u0014BA\u001b)\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005UB\u0013\u0001\u0003;fgR4\u0015\u000e\\3\u0016\u00039\n1B^3sS\u001aLhI]1nKR\u0011a%\u0010\u0005\u0006}\u0011\u0001\raP\u0001\u0003I\u001a\u0004\"\u0001Q&\u000f\u0005\u0005KeB\u0001\"I\u001d\t\u0019uI\u0004\u0002E\r:\u0011\u0011'R\u0005\u0002'%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u0005)c\u0011a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005)c\u0001")
public abstract class TextSuite
extends QueryTest
implements SharedSparkSession {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calenderIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        FunSuiteLike.test$((FunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calenderIntervalData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calenderIntervalData = SQLTestData.calenderIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calenderIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calenderIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calenderIntervalData$lzycompute() : this.calenderIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public void testLineSeparator(String lineSep) {
        this.test(new StringBuilder(49).append("SPARK-23577: Support line separator - lineSep: '").append(lineSep).append("'").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq values = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "\nc"}));
            String data = values.mkString(lineSep);
            String dataWithTrailingLineSep = new StringBuilder(0).append(data).append(lineSep).toString();
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{data, dataWithTrailingLineSep}))).foreach((Function1 & Serializable & scala.Serializable)lines -> {
                this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                    TextSuite.$anonfun$testLineSeparator$3($this, lines, lineSep$1, path);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                TextSuite.$anonfun$testLineSeparator$5(this, values, lineSep, path);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                TextSuite.$anonfun$testLineSeparator$7(this, values, lineSep, path);
                return BoxedUnit.UNIT;
            });
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    private String testFile() {
        return Thread.currentThread().getContextClassLoader().getResource("test-data/text-suite.txt").toString();
    }

    private void verifyFrame(Dataset<Row> df) {
        StructType $org_scalatest_assert_macro_left = df.schema();
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        StructType structType = $org_scalatest_assert_macro_left;
        StructType structType2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        Row[] data = (Row[])df.collect();
        Row $org_scalatest_assert_macro_left2 = data[0];
        Row $org_scalatest_assert_macro_right2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"This is a test file for the text data source"}));
        Row row = $org_scalatest_assert_macro_left2;
        Row row2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(row != null ? !row.equals(row2) : row2 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        Row $org_scalatest_assert_macro_left3 = data[1];
        Row $org_scalatest_assert_macro_right3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1+1"}));
        Row row3 = $org_scalatest_assert_macro_left3;
        Row row4 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(row3 != null ? !row3.equals(row4) : row4 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        Row $org_scalatest_assert_macro_left4 = data[2];
        Row $org_scalatest_assert_macro_right4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\u6570\u636e\u7816\u5934"}));
        Row row5 = $org_scalatest_assert_macro_left4;
        Row row6 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(row5 != null ? !row5.equals(row6) : row6 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        Row $org_scalatest_assert_macro_left5 = data[3];
        Row $org_scalatest_assert_macro_right5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\"doh\""}));
        Row row7 = $org_scalatest_assert_macro_left5;
        Row row8 = $org_scalatest_assert_macro_right5;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(row7 != null ? !row7.equals(row8) : row8 != null), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        Row[] $org_scalatest_assert_macro_left6 = data;
        int $org_scalatest_assert_macro_right6 = 4;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
    }

    private final void testImplicits$lzycompute$1() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        TextSuite textSuite = this;
        synchronized (textSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$11(String extension$1, File x$1) {
        return x$1.getName().endsWith(new StringBuilder(4).append(".txt").append(extension$1).toString());
    }

    public static final /* synthetic */ void $anonfun$new$10(TextSuite $this, Dataset testDf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String codecName = (String)tuple2._1();
        String extension = (String)tuple2._2();
        File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        String tempDirPath = tempDir.getAbsolutePath();
        testDf$1.write().option("compression", codecName).mode(SaveMode.Overwrite).text(tempDirPath);
        File[] compressedFiles = new File(tempDirPath).listFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedFiles)).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TextSuite.$anonfun$new$11(extension, x$1))), "scala.Predef.refArrayOps[java.io.File](compressedFiles).exists(((x$1: java.io.File) => x$1.getName().endsWith(scala.StringContext.apply(\".txt\", \"\").s(extension))))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        $this.verifyFrame((Dataset<Row>)$this.spark().read().text(tempDirPath));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$15(File x$2) {
        return !x$2.getName().endsWith(".txt.gz");
    }

    public static final /* synthetic */ void $anonfun$new$14(TextSuite $this, scala.collection.immutable.Map extraOptions$1, File dir) {
        Dataset testDf = $this.spark().read().text($this.testFile());
        String tempDirPath = dir.getAbsolutePath();
        testDf.write().option("compression", "none").options((Map)extraOptions$1).mode(SaveMode.Overwrite).text(tempDirPath);
        File[] compressedFiles = new File(tempDirPath).listFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedFiles)).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TextSuite.$anonfun$new$15(x$2))), "scala.Predef.refArrayOps[java.io.File](compressedFiles).exists(((x$2: java.io.File) => x$2.getName().endsWith(\".txt.gz\").unary_!))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        $this.verifyFrame((Dataset<Row>)$this.spark().read().options((Map)extraOptions$1).text(tempDirPath));
    }

    public static final /* synthetic */ boolean $anonfun$new$18(File x$3) {
        return !x$3.getName().endsWith(".txt.gz");
    }

    public static final /* synthetic */ void $anonfun$new$17(TextSuite $this, scala.collection.immutable.Map extraOptions$2, File dir) {
        Dataset testDf = $this.spark().read().text($this.testFile());
        String tempDirPath = dir.getAbsolutePath();
        testDf.write().option("CoMpReSsIoN", "none").options((Map)extraOptions$2).mode(SaveMode.Overwrite).text(tempDirPath);
        File[] compressedFiles = new File(tempDirPath).listFiles();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedFiles)).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TextSuite.$anonfun$new$18(x$3))), "scala.Predef.refArrayOps[java.io.File](compressedFiles).exists(((x$3: java.io.File) => x$3.getName().endsWith(\".txt.gz\").unary_!))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        $this.verifyFrame((Dataset<Row>)$this.spark().read().options((Map)extraOptions$2).text(tempDirPath));
    }

    public static final /* synthetic */ void $anonfun$new$20(TextSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        Dataset ds1 = $this.spark().range(1L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CONCAT('val_', id)"}));
        ds1.write().text(new StringBuilder(7).append(path).append("/part=a").toString());
        ds1.write().text(new StringBuilder(7).append(path).append("/part=b").toString());
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"a"}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"b"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("text").load(path).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"part"}))).$((Seq)Nil$.MODULE$)})), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    public static final /* synthetic */ void $anonfun$new$23(TextSuite $this, File dir) {
        String path = dir.getCanonicalPath();
        Dataset df1 = $this.spark().range(0L, 1000L).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(id AS STRING) AS s"}));
        df1.write().option("compression", "gzip").mode("overwrite").text(path);
        Row[] expected = (Row[])df1.collect();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 100, 1000}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bytes -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILES_MAX_PARTITION_BYTES().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)bytes)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df2 = $this.spark().read().format("text").load(path);
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df2, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])expected));
        }));
    }

    public static final /* synthetic */ void $anonfun$testLineSeparator$3(TextSuite $this, String lines$1, String lineSep$1, File path) {
        Files.write(path.toPath(), lines$1.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Dataset df = $this.spark().read().option("lineSep", lineSep$1).text(path.getAbsolutePath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "\nc"})), $this.testImplicits().newStringEncoder()).toDF());
    }

    public static final /* synthetic */ boolean $anonfun$testLineSeparator$6(File f) {
        return f.getName().startsWith("part-");
    }

    public static final /* synthetic */ void $anonfun$testLineSeparator$5(TextSuite $this, Seq values$1, String lineSep$1, File path) {
        $this.testImplicits().localSeqToDatasetHolder(values$1, $this.testImplicits().newStringEncoder()).toDF().coalesce(1).write().option("lineSep", lineSep$1).text(path.getAbsolutePath());
        File partFile = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(path))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TextSuite.$anonfun$testLineSeparator$6(f))))).head();
        String readBack = new String(Files.readAllBytes(partFile.toPath()), StandardCharsets.UTF_8);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(readBack);
        String $org_scalatest_assert_macro_right = new StringBuilder(4).append("a").append(lineSep$1).append("b").append(lineSep$1).append("\nc").append(lineSep$1).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
    }

    public static final /* synthetic */ void $anonfun$testLineSeparator$7(TextSuite $this, Seq values$1, String lineSep$1, File path) {
        Dataset df = $this.testImplicits().localSeqToDatasetHolder(values$1, $this.testImplicits().newStringEncoder()).toDF();
        df.write().option("lineSep", lineSep$1).text(path.getAbsolutePath());
        Dataset readBack = $this.spark().read().option("lineSep", lineSep$1).text(path.getAbsolutePath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)readBack);
    }

    public TextSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("reading text file", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.verifyFrame((Dataset<Row>)this.spark().read().format("text").load(this.testFile())), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("SQLContext.read.text() API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.verifyFrame((Dataset<Row>)this.spark().read().text(this.testFile())), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("SPARK-12562 verify write.text() can handle column name beyond `value`", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().read().text(this.testFile()).withColumnRenamed("value", "adwrasdf");
            File tempFile = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempFile.delete();
            df.write().text(tempFile.getCanonicalPath());
            this.verifyFrame((Dataset<Row>)this.spark().read().text(tempFile.getCanonicalPath()));
            Utils$.MODULE$.deleteRecursively(tempFile);
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("error handling for invalid schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            File tempFile = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            tempFile.delete();
            Dataset df = this.spark().range(2L);
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().text(tempFile.getCanonicalPath()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            return (AnalysisException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.spark().range(2L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("id"), df.apply("id").$plus((Object)BoxesRunTime.boxToInteger((int)1))})).write().text(tempFile.getCanonicalPath()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("reading partitioned data using read.textFile()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String partitionedData = Thread.currentThread().getContextClassLoader().getResource("test-data/text-partitioned").toString();
            Dataset ds = this.spark().read().textFile(partitionedData);
            String[] data = (String[])ds.collect();
            StructType $org_scalatest_assert_macro_left = ds.schema();
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left;
            StructType structType2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            String[] $org_scalatest_assert_macro_left2 = data;
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("support for partitioned reading using read.text()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String partitionedData = Thread.currentThread().getContextClassLoader().getResource("test-data/text-partitioned").toString();
            Dataset df = this.spark().read().text(partitionedData);
            Row[] data = (Row[])df.filter("year = '2015'").select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect();
            Row $org_scalatest_assert_macro_left = data[0];
            Row $org_scalatest_assert_macro_right = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2015-test"}));
            Row row = $org_scalatest_assert_macro_left;
            Row row2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(row != null ? !row.equals(row2) : row2 != null), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Row[] $org_scalatest_assert_macro_left2 = data;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("SPARK-13503 Support to specify the option for compression codec for TEXT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Dataset testDf = this.spark().read().text(this.testFile());
            scala.collection.immutable.Map extensionNameMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bzip2"), (Object)".bz2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deflate"), (Object)".deflate"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gzip"), (Object)".gz")}));
            extensionNameMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TextSuite.$anonfun$new$10(this, testDf, x0$1);
                return BoxedUnit.UNIT;
            });
            IllegalArgumentException errMsg = (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String tempDirPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath();
                testDf.write().option("compression", "illegal").mode(SaveMode.Overwrite).text(tempDirPath);
            }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            String $org_scalatest_assert_macro_left = errMsg.getMessage();
            String $org_scalatest_assert_macro_right = "Codec [illegal] is not available. Known codecs are";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        this.test("SPARK-13543 Write the output as uncompressed via option()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map extraOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapreduce.output.fileoutputformat.compress"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapreduce.output.fileoutputformat.compress.type"), (Object)SequenceFile.CompressionType.BLOCK.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapreduce.map.output.compress"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapreduce.output.fileoutputformat.compress.codec"), (Object)GzipCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mapreduce.map.output.compress.codec"), (Object)GzipCodec.class.getName())}));
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                TextSuite.$anonfun$new$14(this, extraOptions, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("case insensitive option", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map extraOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mApReDuCe.output.fileoutputformat.compress"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mApReDuCe.output.fileoutputformat.compress.type"), (Object)SequenceFile.CompressionType.BLOCK.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mApReDuCe.map.output.compress"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mApReDuCe.output.fileoutputformat.compress.codec"), (Object)GzipCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mApReDuCe.map.output.compress.codec"), (Object)GzipCodec.class.getName())}));
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                TextSuite.$anonfun$new$17(this, extraOptions, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("SPARK-14343: select partitioning column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            TextSuite.$anonfun$new$20(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("SPARK-15654: should not split gz files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            TextSuite.$anonfun$new$23(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("TextSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|", "^", "::", "!!!@3", ((Object)BoxesRunTime.boxToCharacter((char)((char)30))).toString(), "\uc544"}))).foreach((Function1 & Serializable & scala.Serializable)lineSep -> {
            this.testLineSeparator(lineSep);
            return BoxedUnit.UNIT;
        });
    }
}

