/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.TestUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.metric.SQLMetricsTestUtils$;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.apache.spark.sql.execution.ui.SparkPlanGraph$;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEquals;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005MdaB\b\u0011!\u0003\r\t!\b\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006a\u0001!\t\"\r\u0005\u0006\u0001\u0002!\t\"\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0005J\u0011\u001di\u0005A1A\u0005\u0012%CqA\u0014\u0001C\u0002\u0013E\u0011\nC\u0003P\u0001\u0011%\u0001\u000bC\u0003f\u0001\u0011Ea\rC\u0003l\u0001\u0011EA\u000eC\u0003r\u0001\u0011E!\u000fC\u0005\u00024\u0001\t\n\u0011\"\u0005\u00026!9\u00111\n\u0001\u0005\u0012\u00055\u0003bBA,\u0001\u0011E\u0011\u0011\f\u0005\n\u0003c\u0002\u0011\u0013!C\t\u0003k\u00111cU)M\u001b\u0016$(/[2t)\u0016\u001cH/\u0016;jYNT!!\u0005\n\u0002\r5,GO]5d\u0015\t\u0019B#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0012\u0011\u0005}\u0001S\"\u0001\f\n\u0005\u00052\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002$M5\tAE\u0003\u0002&)\u0005!A/Z:u\u0013\t9CE\u0001\u0007T#2#Vm\u001d;Vi&d7/\u0001\u0004%S:LG\u000f\n\u000b\u0002UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t!QK\\5u\u0003M\u0019WO\u001d:f]R,\u00050Z2vi&|g.\u00133t)\u0005\u0011\u0004cA\u001a;{9\u0011A\u0007\u000f\t\u0003k1j\u0011A\u000e\u0006\u0003oq\ta\u0001\u0010:p_Rt\u0014BA\u001d-\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0004'\u0016$(BA\u001d-!\tYc(\u0003\u0002@Y\t!Aj\u001c8h\u0003-\u0019H/\u0019;vgN#xN]3\u0016\u0003\t\u0003\"a\u0011$\u000e\u0003\u0011S!!\u0012\n\u0002\u0005UL\u0017BA$E\u0005E\u0019\u0016\u000bT!qaN#\u0018\r^;t'R|'/Z\u0001\u0012g&TX-T3ue&\u001c\u0007+\u0019;uKJtW#\u0001&\u0011\u0005MZ\u0015B\u0001'=\u0005\u0019\u0019FO]5oO\u0006\u0019B/[7j]\u001elU\r\u001e:jGB\u000bG\u000f^3s]\u00069\u0012mZ4sK\u001e\fG/Z'fiJL7m\u001d)biR,'O\\\u0001\u0017m\u0016\u0014\u0018NZ=Xe&$X\rR1uC6+GO]5dgR\u0011\u0011k\u0016\u000b\u0003UICaaU\u0004\u0005\u0002\u0004!\u0016\u0001\u00024v]\u000e\u00042aK++\u0013\t1FF\u0001\u0005=Eft\u0017-\\3?\u0011\u0015Av\u00011\u0001Z\u00035iW\r\u001e:jGN4\u0016\r\\;fgB\u0019!l\u00182\u000f\u0005mkfBA\u001b]\u0013\u0005i\u0013B\u00010-\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_YA\u00111fY\u0005\u0003I2\u00121!\u00138u\u0003y!Xm\u001d;NKR\u0014\u0018nY:O_:$\u0015P\\1nS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u0002+O&DQ\u0001\u001b\u0005A\u0002)\u000b!\u0002Z1uC\u001a{'/\\1u\u0011\u0015Q\u0007\u00021\u0001K\u0003%!\u0018M\u00197f\u001d\u0006lW-A\u000euKN$X*\u001a;sS\u000e\u001cH)\u001f8b[&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0005U5|\u0007\u000fC\u0003o\u0013\u0001\u0007!*\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u0015A\u0017\u00021\u0001K\u0011\u0015Q\u0017\u00021\u0001K\u0003M9W\r^*qCJ\\\u0007\u000b\\1o\u001b\u0016$(/[2t)%\u0019\u0018\u0011AA\u0011\u0003K\tI\u0003E\u0002,iZL!!\u001e\u0017\u0003\r=\u0003H/[8o!\u0011\u0019t/P=\n\u0005ad$aA'baB!1F\u001f&}\u0013\tYHF\u0001\u0004UkBdWM\r\t\u0005g]TU\u0010\u0005\u0002,}&\u0011q\u0010\f\u0002\u0004\u0003:L\bbBA\u0002\u0015\u0001\u0007\u0011QA\u0001\u0003I\u001a\u0004B!a\u0002\u0002\u001c9!\u0011\u0011BA\r\u001d\u0011\tY!a\u0006\u000f\t\u00055\u0011Q\u0003\b\u0005\u0003\u001f\t\u0019BD\u00026\u0003#I\u0011aG\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012B\u00010\u0015\u0013\u0011\ti\"a\b\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00010\u0015\u0011\u0019\t\u0019C\u0003a\u0001E\u0006\tR\r\u001f9fGR,GMT;n\u001f\u001aTuNY:\t\r\u0005\u001d\"\u00021\u00013\u0003=)\u0007\u0010]3di\u0016$gj\u001c3f\u0013\u0012\u001c\b\"CA\u0016\u0015A\u0005\t\u0019AA\u0017\u0003A)g.\u00192mK^Cw\u000e\\3Ti\u0006<W\rE\u0002,\u0003_I1!!\r-\u0005\u001d\u0011un\u001c7fC:\fQdZ3u'B\f'o\u001b)mC:lU\r\u001e:jGN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003oQC!!\f\u0002:-\u0012\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003%)hn\u00195fG.,GMC\u0002\u0002F1\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI%a\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000buKN$8\u000b]1sWBc\u0017M\\'fiJL7m\u001d\u000b\bU\u0005=\u0013\u0011KA*\u0011\u001d\t\u0019\u0001\u0004a\u0001\u0003\u000bAa!a\t\r\u0001\u0004\u0011\u0007BBA+\u0019\u0001\u0007a/A\bfqB,7\r^3e\u001b\u0016$(/[2t\u0003\t\"Xm\u001d;Ta\u0006\u00148\u000e\u00157b]6+GO]5dg^KG\u000f\u001b)sK\u0012L7-\u0019;fgRI!&a\u0017\u0002^\u0005}\u0013q\u000e\u0005\b\u0003\u0007i\u0001\u0019AA\u0003\u0011\u0019\t\u0019#\u0004a\u0001E\"9\u0011\u0011M\u0007A\u0002\u0005\r\u0014!G3ya\u0016\u001cG/\u001a3NKR\u0014\u0018nY:Qe\u0016$\u0017nY1uKN\u0004RaM<>\u0003K\u0002Ra\u000b>K\u0003O\u0002RaM<K\u0003S\u0002baKA6{\u00065\u0012bAA7Y\tIa)\u001e8di&|g.\r\u0005\n\u0003Wi\u0001\u0013!a\u0001\u0003[\tA\u0006^3tiN\u0003\u0018M]6QY\u0006tW*\u001a;sS\u000e\u001cx+\u001b;i!J,G-[2bi\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001b")
public interface SQLMetricsTestUtils
extends SQLTestUtils {
    public void org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$sizeMetricPattern_$eq(String var1);

    public void org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$timingMetricPattern_$eq(String var1);

    public void org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$aggregateMetricsPattern_$eq(String var1);

    public static /* synthetic */ Set currentExecutionIds$(SQLMetricsTestUtils $this) {
        return $this.currentExecutionIds();
    }

    default public Set<Object> currentExecutionIds() {
        this.spark().sparkContext().listenerBus().waitUntilEmpty(10000L);
        return ((TraversableOnce)this.statusStore().executionsList().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.executionId()), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public static /* synthetic */ SQLAppStatusStore statusStore$(SQLMetricsTestUtils $this) {
        return $this.statusStore();
    }

    default public SQLAppStatusStore statusStore() {
        return this.spark().sharedState().statusStore();
    }

    public String sizeMetricPattern();

    public String timingMetricPattern();

    public String aggregateMetricsPattern();

    private void verifyWriteDataMetrics(Seq<Object> metricsValues, Function0<BoxedUnit> func) {
        double totalNumBytes;
        Set executionIds;
        Set<Object> previousExecutionIds = this.currentExecutionIds();
        func.apply$mcV$sp();
        this.spark().sparkContext().listenerBus().waitUntilEmpty(10000L);
        Set $org_scalatest_assert_macro_left = executionIds = (Set)this.currentExecutionIds().diff(previousExecutionIds);
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        long executionId = BoxesRunTime.unboxToLong((Object)executionIds.head());
        SparkPlanGraphNode executedNode = (SparkPlanGraphNode)this.statusStore().planGraph(executionId).nodes().head();
        Seq metricsNames = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of written files", "number of dynamic part", "number of output rows"}));
        Map metrics = this.statusStore().executionMetrics(executionId);
        ((IterableLike)metricsNames.zip(metricsValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            int metricValue;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String metricsName = (String)tuple2._1();
            int expected = tuple2._2$mcI$sp();
            Option sqlMetric = executedNode.metrics().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$verifyWriteDataMetrics$2(metricsName, x$2)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sqlMetric.isDefined(), "sqlMetric.isDefined", Prettifier$.MODULE$.default());
            ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            long accumulatorId = ((SQLPlanMetric)sqlMetric.get()).accumulatorId();
            int $org_scalatest_assert_macro_left = metricValue = new StringOps(Predef$.MODULE$.augmentString(((String)metrics.apply((Object)BoxesRunTime.boxToLong((long)accumulatorId))).replaceAll(",", ""))).toInt();
            int $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertion assertion = ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            return assertion;
        });
        SQLPlanMetric totalNumBytesMetric = (SQLPlanMetric)executedNode.metrics().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$verifyWriteDataMetrics$3(x$3))).get();
        double $org_scalatest_assert_macro_left2 = totalNumBytes = new StringOps(Predef$.MODULE$.augmentString(((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)metrics.apply((Object)BoxesRunTime.boxToLong((long)totalNumBytesMetric.accumulatorId()))).replaceAll(",", "").split(" "))).head()).trim())).toDouble();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > (double)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }

    public static /* synthetic */ void testMetricsNonDynamicPartition$(SQLMetricsTestUtils $this, String dataFormat, String tableName) {
        $this.testMetricsNonDynamicPartition(dataFormat, tableName);
    }

    default public void testMetricsNonDynamicPartition(String dataFormat, String tableName) {
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SQLMetricsTestUtils.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator5$1(SQLMetricsTestUtils $outer) {
                }
            }
            this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(1, 2)})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator5$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().format(dataFormat).mode("overwrite").saveAsTable(tableName);
            File tableLocation = new File(this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location());
            this.verifyWriteDataMetrics((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 100}))), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(SQLMetricsTestUtils.class.getClassLoader());
                public final class Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator13$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator13$1(SQLMetricsTestUtils $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).map((Function1 & Serializable & scala.Serializable)i -> SQLMetricsTestUtils.$anonfun$testMetricsNonDynamicPartition$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_metric_SQLMetricsTestUtils$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).repartition(2).write().format(dataFormat).mode("overwrite").insertInto(tableName);
            });
            int $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(tableLocation))).count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$testMetricsNonDynamicPartition$4(x$4)));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        });
    }

    public static /* synthetic */ void testMetricsDynamicPartition$(SQLMetricsTestUtils $this, String provider, String dataFormat, String tableName) {
        $this.testMetricsDynamicPartition(provider, dataFormat, tableName);
    }

    default public void testMetricsDynamicPartition(String provider, String dataFormat, String tableName) {
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            SQLMetricsTestUtils.$anonfun$testMetricsDynamicPartition$2(this, tableName, provider, dataFormat, dir);
            return BoxedUnit.UNIT;
        }));
    }

    public static /* synthetic */ Option getSparkPlanMetrics$(SQLMetricsTestUtils $this, Dataset df, int expectedNumOfJobs, Set expectedNodeIds, boolean enableWholeStage) {
        return $this.getSparkPlanMetrics((Dataset<Row>)df, expectedNumOfJobs, (Set<Object>)expectedNodeIds, enableWholeStage);
    }

    default public Option<Map<Object, Tuple2<String, Map<String, Object>>>> getSparkPlanMetrics(Dataset<Row> df, int expectedNumOfJobs, Set<Object> expectedNodeIds, boolean enableWholeStage) {
        None$ none$;
        Set<Object> previousExecutionIds = this.currentExecutionIds();
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)enableWholeStage)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.collect());
        this.sparkContext().listenerBus().waitUntilEmpty(10000L);
        Set executionIds = (Set)this.currentExecutionIds().diff(previousExecutionIds);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)this).convertToEqualizer((Object)BoxesRunTime.boxToInteger((int)executionIds.size()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        long executionId = BoxesRunTime.unboxToLong((Object)executionIds.head());
        Map jobs = ((SQLExecutionUIData)this.statusStore().execution(executionId).get()).jobs();
        int $org_scalatest_assert_macro_left2 = jobs.size();
        int $org_scalatest_assert_macro_right2 = expectedNumOfJobs;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        if (jobs.size() == expectedNumOfJobs) {
            Map metricValues = this.statusStore().executionMetrics(executionId);
            Map metrics = ((TraversableOnce)((TraversableLike)SparkPlanGraph$.MODULE$.apply(SparkPlanInfo$.MODULE$.fromSparkPlan(df.queryExecution().executedPlan())).allNodes().filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)expectedNodeIds.contains((Object)BoxesRunTime.boxToLong((long)node.id()))))).map((Function1 & Serializable & scala.Serializable)node -> {
                Map nodeMetrics = ((TraversableOnce)node.metrics().map((Function1 & Serializable & scala.Serializable)metric -> {
                    String metricValue = (String)metricValues.apply((Object)BoxesRunTime.boxToLong((long)metric.accumulatorId()));
                    return new Tuple2((Object)metric.name(), (Object)metricValue);
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)node.id()), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)node.name()), (Object)nodeMetrics));
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            none$ = new Some((Object)metrics);
        } else {
            ((Logging)this).logWarning((Function0 & Serializable & scala.Serializable)() -> "Due to a race condition, we miss some jobs and cannot verify the metric values");
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static /* synthetic */ boolean getSparkPlanMetrics$default$4$(SQLMetricsTestUtils $this) {
        return $this.getSparkPlanMetrics$default$4();
    }

    default public boolean getSparkPlanMetrics$default$4() {
        return false;
    }

    public static /* synthetic */ void testSparkPlanMetrics$(SQLMetricsTestUtils $this, Dataset df, int expectedNumOfJobs, Map expectedMetrics) {
        $this.testSparkPlanMetrics((Dataset<Row>)df, expectedNumOfJobs, (Map<Object, Tuple2<String, Map<String, Object>>>)expectedMetrics);
    }

    default public void testSparkPlanMetrics(Dataset<Row> df, int expectedNumOfJobs, Map<Object, Tuple2<String, Map<String, Object>>> expectedMetrics) {
        Map expectedMetricsPredicates = expectedMetrics.mapValues((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String nodeName = (String)tuple2._1();
            Map nodeMetrics = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodeName, (Object)nodeMetrics.mapValues((Function1 & Serializable & scala.Serializable)expectedMetricValue -> (Function1 & Serializable & scala.Serializable)actualMetricValue -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$testSparkPlanMetrics$3(expectedMetricValue, actualMetricValue))));
            return tuple22;
        });
        this.testSparkPlanMetricsWithPredicates(df, expectedNumOfJobs, (Map<Object, Tuple2<String, Map<String, Function1<Object, Object>>>>)expectedMetricsPredicates, this.testSparkPlanMetricsWithPredicates$default$4());
    }

    public static /* synthetic */ void testSparkPlanMetricsWithPredicates$(SQLMetricsTestUtils $this, Dataset df, int expectedNumOfJobs, Map expectedMetricsPredicates, boolean enableWholeStage) {
        $this.testSparkPlanMetricsWithPredicates((Dataset<Row>)df, expectedNumOfJobs, (Map<Object, Tuple2<String, Map<String, Function1<Object, Object>>>>)expectedMetricsPredicates, enableWholeStage);
    }

    default public void testSparkPlanMetricsWithPredicates(Dataset<Row> df, int expectedNumOfJobs, Map<Object, Tuple2<String, Map<String, Function1<Object, Object>>>> expectedMetricsPredicates, boolean enableWholeStage) {
        Option<Map<Object, Tuple2<String, Map<String, Object>>>> optActualMetrics = this.getSparkPlanMetrics(df, expectedNumOfJobs, (Set<Object>)expectedMetricsPredicates.keySet(), enableWholeStage);
        optActualMetrics.foreach((Function1 & Serializable & scala.Serializable)actualMetrics -> {
            SQLMetricsTestUtils.$anonfun$testSparkPlanMetricsWithPredicates$1(this, expectedMetricsPredicates, actualMetrics);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ boolean testSparkPlanMetricsWithPredicates$default$4$(SQLMetricsTestUtils $this) {
        return $this.testSparkPlanMetricsWithPredicates$default$4();
    }

    default public boolean testSparkPlanMetricsWithPredicates$default$4() {
        return false;
    }

    public static /* synthetic */ boolean $anonfun$verifyWriteDataMetrics$2(String metricsName$1, SQLPlanMetric x$2) {
        String string = x$2.name();
        String string2 = metricsName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ boolean $anonfun$verifyWriteDataMetrics$3(SQLPlanMetric x$3) {
        String string = x$3.name();
        String string2 = "written output";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ Tuple2 $anonfun$testMetricsNonDynamicPartition$3(int i) {
        return new Tuple2.mcII.sp(i, i + 1);
    }

    public static /* synthetic */ boolean $anonfun$testMetricsNonDynamicPartition$4(File x$4) {
        return x$4.getName().startsWith("part-");
    }

    public static /* synthetic */ boolean $anonfun$testMetricsDynamicPartition$4(File x$5) {
        return x$5.getName().startsWith("part-");
    }

    public static /* synthetic */ void $anonfun$testMetricsDynamicPartition$2(SQLMetricsTestUtils $this, String tableName$2, String provider$1, String dataFormat$2, File dir) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(133).append("\n             |CREATE TABLE ").append(tableName$2).append("(a int, b int)\n             |USING ").append(provider$1).append("\n             |PARTITIONED BY(a)\n             |LOCATION '").append(dir.toURI()).append("'\n           ").toString())).stripMargin());
        CatalogTable table = $this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName$2));
        URI $org_scalatest_assert_macro_left = table.location();
        URI $org_scalatest_assert_macro_right = $this.makeQualifiedPath(dir.getAbsolutePath());
        URI uRI = $org_scalatest_assert_macro_left;
        URI uRI2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null), Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        Dataset df = $this.spark().range(0L, 40L, 1L, 1).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id a", "id b"}));
        $this.verifyWriteDataMetrics((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{40, 40, 80}))), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.union(df).repartition(2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))).$((Seq)Nil$.MODULE$)})).write().format(dataFormat$2).mode("overwrite").insertInto(tableName$2));
        int $org_scalatest_assert_macro_left2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])TestUtils$.MODULE$.recursiveList(dir))).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$testMetricsDynamicPartition$4(x$5)));
        int $org_scalatest_assert_macro_right2 = 40;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    public static /* synthetic */ boolean $anonfun$testSparkPlanMetrics$3(Object expectedMetricValue$1, Object actualMetricValue) {
        return actualMetricValue.toString().matches(expectedMetricValue$1.toString());
    }

    public static /* synthetic */ boolean $anonfun$testSparkPlanMetricsWithPredicates$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null;
        return bl;
    }

    public static /* synthetic */ boolean $anonfun$testSparkPlanMetricsWithPredicates$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static /* synthetic */ void $anonfun$testSparkPlanMetricsWithPredicates$3(SQLMetricsTestUtils $this, Map actualMetrics$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        long nodeId = tuple2._1$mcJ$sp();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        String expectedNodeName = (String)tuple22._1();
        Map expectedMetricsPredicatesMap = (Map)tuple22._2();
        Tuple2 tuple23 = (Tuple2)actualMetrics$1.apply((Object)BoxesRunTime.boxToLong((long)nodeId));
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        String actualNodeName = (String)tuple23._1();
        Map actualMetricsMap = (Map)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)actualNodeName, (Object)actualMetricsMap);
        Tuple2 tuple25 = tuple24;
        String actualNodeName2 = (String)tuple25._1();
        Map actualMetricsMap2 = (Map)tuple25._2();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)expectedNodeName);
        String $org_scalatest_assert_macro_right = actualNodeName2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        expectedMetricsPredicatesMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$testSparkPlanMetricsWithPredicates$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String metricName = (String)tuple2._1();
            Function1 metricPredicate = (Function1)tuple2._2();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(BoxesRunTime.unboxToBoolean((Object)metricPredicate.apply(actualMetricsMap2.apply((Object)metricName))), "metricPredicate.apply(actualMetricsMap.apply(metricName))", Prettifier$.MODULE$.default());
            Assertion assertion = ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(35).append(nodeId).append(" / '").append(metricName).append("' (= ").append(actualMetricsMap2.apply((Object)metricName)).append(") did not match predicate.").toString(), Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            return assertion;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void $anonfun$testSparkPlanMetricsWithPredicates$1(SQLMetricsTestUtils $this, Map expectedMetricsPredicates$1, Map actualMetrics) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = ((TripleEquals)$this).convertToEqualizer((Object)expectedMetricsPredicates$1.keySet());
        Set $org_scalatest_assert_macro_right = actualMetrics.keySet();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        ((Assertions)$this).assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLMetricsTestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        expectedMetricsPredicates$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SQLMetricsTestUtils.$anonfun$testSparkPlanMetricsWithPredicates$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            SQLMetricsTestUtils.$anonfun$testSparkPlanMetricsWithPredicates$3($this, actualMetrics, x$8);
            return BoxedUnit.UNIT;
        });
    }

    public static void $init$(SQLMetricsTestUtils $this) {
        String bytes = "([0-9]+(\\.[0-9]+)?) (EiB|PiB|TiB|GiB|MiB|KiB|B)";
        String maxMetrics = "\\(stage ([0-9])+\\.([0-9])+\\: task ([0-9])+\\)";
        $this.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$sizeMetricPattern_$eq(new StringBuilder(22).append("(.*\\n").append(bytes).append(" \\(").append(bytes).append(", ").append(bytes).append(", ").append(bytes).append("( ").append(maxMetrics).append(")?\\))|(").append(bytes).append(")").toString());
        String duration = "([0-9]+(\\.[0-9]+)?) (ms|s|m|h)";
        String maxMetrics2 = "\\(stage ([0-9])+\\.([0-9])+\\: task ([0-9])+\\)";
        $this.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$timingMetricPattern_$eq(new StringBuilder(22).append("(.*\\n").append(duration).append(" \\(").append(duration).append(", ").append(duration).append(", ").append(duration).append("( ").append(maxMetrics2).append(")?\\))|(").append(duration).append(")").toString());
        String iters = "([0-9]+(\\.[0-9]+)?)";
        String maxMetrics3 = "\\(stage ([0-9])+\\.([0-9])+\\: task ([0-9])+\\)";
        $this.org$apache$spark$sql$execution$metric$SQLMetricsTestUtils$_setter_$aggregateMetricsPattern_$eq(new StringBuilder(21).append("(.*\\n\\(").append(iters).append(", ").append(iters).append(", ").append(iters).append("( ").append(maxMetrics3).append(")?\\))|(").append(iters).append(")").toString());
    }
}

