/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskState$;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted$;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.scheduler.StageInfo$;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.metric.SQLMetricInfo;
import org.apache.spark.sql.execution.ui.MetricsAggregationBenchmark;
import org.apache.spark.sql.execution.ui.SQLAppStatusListener;
import org.apache.spark.sql.execution.ui.SQLAppStatusStore;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.AccumulatorMetadata;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.InMemoryStore;
import org.apache.spark.util.kvstore.KVStore;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MetricsAggregationBenchmark$
extends BenchmarkBase {
    public static MetricsAggregationBenchmark$ MODULE$;

    static {
        new MetricsAggregationBenchmark$();
    }

    private MetricsAggregationBenchmark.Measurements metricTrackingBenchmark(Benchmark.Timer timer, int numMetrics, int numTasks, int numStages) {
        long aggTime;
        SparkConf conf = new SparkConf().set(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD(), (Object)BoxesRunTime.boxToLong((long)0L)).set(Status$.MODULE$.ASYNC_TRACKING_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        ElementTrackingStore kvstore = new ElementTrackingStore((KVStore)new InMemoryStore(), conf);
        SQLAppStatusListener listener = new SQLAppStatusListener(conf, kvstore, true);
        SQLAppStatusStore store = new SQLAppStatusStore((KVStore)kvstore, (Option)new Some((Object)listener));
        IndexedSeq metrics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMetrics).map((Function1 & Serializable & scala.Serializable)i -> MetricsAggregationBenchmark$.$anonfun$metricTrackingBenchmark$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        SparkPlanInfo planInfo = new SparkPlanInfo(this.getClass().getName(), this.getClass().getName(), (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), (Seq)metrics);
        AtomicInteger idgen = new AtomicInteger();
        int executionId = idgen.incrementAndGet();
        SparkListenerSQLExecutionStart executionStart = new SparkListenerSQLExecutionStart((long)executionId, this.getClass().getName(), this.getClass().getName(), this.getClass().getName(), planInfo, System.currentTimeMillis());
        SparkListenerSQLExecutionEnd executionEnd = new SparkListenerSQLExecutionEnd((long)executionId, System.currentTimeMillis());
        Properties properties = new Properties();
        properties.setProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY(), ((Object)BoxesRunTime.boxToInteger((int)executionId)).toString());
        timer.startTiming();
        listener.onOtherEvent((SparkListenerEvent)executionStart);
        IndexedSeq taskEventsTime = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numStages).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> {
            long _taskEventsTime;
            StageInfo stageInfo = new StageInfo(idgen.incrementAndGet(), 0, MODULE$.getClass().getName(), numTasks, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, MODULE$.getClass().getName(), StageInfo$.MODULE$.$lessinit$greater$default$8(), StageInfo$.MODULE$.$lessinit$greater$default$9(), StageInfo$.MODULE$.$lessinit$greater$default$10());
            int jobId = idgen.incrementAndGet();
            SparkListenerJobStart jobStart = new SparkListenerJobStart(jobId, System.currentTimeMillis(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StageInfo[]{stageInfo})), properties);
            SparkListenerStageSubmitted stageStart = new SparkListenerStageSubmitted(stageInfo, SparkListenerStageSubmitted$.MODULE$.apply$default$2());
            long taskOffset = idgen.incrementAndGet();
            IndexedSeq taskEvents = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTasks).map((Function1 & Serializable & scala.Serializable)i -> MetricsAggregationBenchmark$.$anonfun$metricTrackingBenchmark$3(taskOffset, numMetrics, stageInfo, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            SparkListenerJobEnd jobEnd = new SparkListenerJobEnd(jobId, System.currentTimeMillis(), (JobResult)JobSucceeded$.MODULE$);
            listener.onJobStart(jobStart);
            listener.onStageSubmitted(stageStart);
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> taskEvents.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MetricsAggregationBenchmark$.$anonfun$metricTrackingBenchmark$6(listener, x0$1);
                return BoxedUnit.UNIT;
            }));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long l = _taskEventsTime = tuple2._2$mcJ$sp();
            long _taskEventsTime2 = l;
            listener.onJobEnd(jobEnd);
            return _taskEventsTime2;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            listener.onOtherEvent((SparkListenerEvent)executionEnd);
            Map metrics = store.executionMetrics((long)executionId);
            Predef$.MODULE$.assert(metrics.size() == numMetrics, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append(metrics.size()).append(" != ").append(numMetrics).toString());
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = aggTime = tuple2._2$mcJ$sp();
        long aggTime2 = l;
        timer.stopTiming();
        kvstore.close();
        return new MetricsAggregationBenchmark.Measurements((Seq<Object>)taskEventsTime, aggTime2);
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        int metricCount = 50;
        int taskCount = 100000;
        Seq stageCounts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        String x$1 = new StringBuilder(48).append("metrics aggregation (").append(metricCount).append(" metrics, ").append(taskCount).append(" tasks per stage)").toString();
        long x$2 = 1L;
        FiniteDuration x$3 = new package.DurationInt(package$.MODULE$.DurationInt(0)).seconds();
        Option x$4 = this.output();
        int x$5 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$5, x$3, x$6, x$7, x$4);
        stageCounts.foreach((Function1 & Serializable & scala.Serializable)count -> MetricsAggregationBenchmark$.MODULE$.metricTrackingBenchmark(new Benchmark.Timer(-1), metricCount, taskCount, BoxesRunTime.unboxToInt((Object)count)));
        HashMap measurements = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        stageCounts.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)count -> benchmark.addTimerCase(new StringBuilder(9).append(count).append(" stage(s)").toString(), benchmark.addTimerCase$default$2(), (Function1 & Serializable & scala.Serializable)timer -> {
            MetricsAggregationBenchmark$.$anonfun$runBenchmarkSuite$3(metricCount, taskCount, count, measurements, timer);
            return BoxedUnit.UNIT;
        }));
        benchmark.run();
        benchmark.out().printf("Stage Count    Stage Proc. Time    Aggreg. Time\n", new Object[0]);
        stageCounts.foreach((Function1 & Serializable & scala.Serializable)count -> MetricsAggregationBenchmark$.$anonfun$runBenchmarkSuite$5(measurements, benchmark, BoxesRunTime.unboxToInt((Object)count)));
    }

    public static final /* synthetic */ SQLMetricInfo $anonfun$metricTrackingBenchmark$1(int i) {
        return new SQLMetricInfo(new StringBuilder(6).append("metric").append(i).toString(), (long)i, "average");
    }

    public static final /* synthetic */ AccumulableInfo $anonfun$metricTrackingBenchmark$4(int i$1, int mid) {
        LongAccumulator acc = new LongAccumulator();
        acc.metadata_$eq(new AccumulatorMetadata((long)mid, (Option)None$.MODULE$, false));
        return acc.toInfo((Option)new Some((Object)BoxesRunTime.boxToLong((long)i$1)), (Option)None$.MODULE$);
    }

    public static final /* synthetic */ Tuple2 $anonfun$metricTrackingBenchmark$3(long taskOffset$1, int numMetrics$1, StageInfo stageInfo$1, int i) {
        TaskInfo info = new TaskInfo(taskOffset$1 + (long)i, i, 0, 0L, "", "", null, false);
        info.markFinished(TaskState$.MODULE$.FINISHED(), 1L);
        IndexedSeq accumulables = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMetrics$1).map((Function1 & Serializable & scala.Serializable)mid -> MetricsAggregationBenchmark$.$anonfun$metricTrackingBenchmark$4(i, BoxesRunTime.unboxToInt((Object)mid)), IndexedSeq$.MODULE$.canBuildFrom());
        info.setAccumulables((Seq)accumulables);
        SparkListenerTaskStart start = new SparkListenerTaskStart(stageInfo$1.stageId(), stageInfo$1.attemptNumber(), info);
        SparkListenerTaskEnd end = new SparkListenerTaskEnd(stageInfo$1.stageId(), stageInfo$1.attemptNumber(), "", null, info, new ExecutorMetrics(), null);
        return new Tuple2((Object)start, (Object)end);
    }

    public static final /* synthetic */ void $anonfun$metricTrackingBenchmark$6(SQLAppStatusListener listener$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SparkListenerTaskStart start = (SparkListenerTaskStart)tuple2._1();
        SparkListenerTaskEnd end = (SparkListenerTaskEnd)tuple2._2();
        listener$1.onTaskStart(start);
        listener$1.onTaskEnd(end);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$3(int metricCount$1, int taskCount$1, int count$1, HashMap measurements$1, Benchmark.Timer timer) {
        MetricsAggregationBenchmark.Measurements m = MODULE$.metricTrackingBenchmark(timer, metricCount$1, taskCount$1, count$1);
        Seq all = (Seq)measurements$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)count$1), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        measurements$1.update((Object)BoxesRunTime.boxToInteger((int)count$1), all.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricsAggregationBenchmark.Measurements[]{m})), Seq$.MODULE$.canBuildFrom()));
    }

    public static final /* synthetic */ PrintStream $anonfun$runBenchmarkSuite$5(HashMap measurements$1, Benchmark benchmark$1, int count) {
        Seq data = (Seq)measurements$1.apply((Object)BoxesRunTime.boxToInteger((int)count));
        Seq eventsTimes = (Seq)data.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.taskEventsTimes(), Seq$.MODULE$.canBuildFrom());
        Seq aggTimes = (Seq)data.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.aggregationTime()), Seq$.MODULE$.canBuildFrom());
        String msg = new StringOps(Predef$.MODULE$.augmentString("     %d              %d                %d\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)count), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)eventsTimes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)eventsTimes.size())), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)aggTimes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)aggTimes.size()))}));
        return benchmark$1.out().printf(msg, new Object[0]);
    }

    private MetricsAggregationBenchmark$() {
        MODULE$ = this;
    }
}

