/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.CleanSourceMode$;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.sources.MemorySink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem$;
import org.apache.spark.sql.streaming.FileStreamSourceSuite$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Tag;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.Span$;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEf\u0001B\u0012%\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013\u0005\u0003\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\u0006\u0005\u0002!Ia\u0011\u0005\bQ\u0002\t\n\u0011\"\u0003j\u0011\u0015!\b\u0001\"\u0003v\u0011\u001dQ\b!%A\u0005\n%DQa\u001f\u0001\u0005BqDa!!\u0001\u0001\t\u0003b\bbBA\u0002\u0001\u0011%\u0011Q\u0001\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'B\u0011\"a&\u0001#\u0003%I!!'\t\u0013\u0005u\u0005!%A\u0005\n\u0005}\u0005\"CAR\u0001E\u0005I\u0011BAM\r\u0019\t)\u000b\u0001\u0001\u0002(\"I\u0011\u0011\u0018\t\u0003\u0002\u0003\u0006I!\u0014\u0005\u0007iA!\t!a/\t\u000f\u0005\r\u0007\u0003\"\u0011\u0002F\"9\u0011\u0011\u001b\t\u0005B\u0005M\u0007bBAs!\u0011\u0005\u0013q\u001d\u0005\b\u0003_\u0004B\u0011IAy\u0011\u001d\ty\u0010\u0005C!\u0005\u0003AqA!\u0006\u0011\t\u0003\u00129\u0002C\u0004\u0003NA!\tEa\u0014\t\u000f\t]\u0003\u0003\"\u0011\u0003Z!9!\u0011\r\t\u0005B\t\r\u0004b\u0002B:!\u0011\u0005#Q\u000f\u0005\b\u0005w\u0002B\u0011\tB?\u0011\u001d\u0011y\b\u0005C!\u0005\u0003CqA!\"\u0001\t\u0013\u00119\tC\u0004\u0003\u0012\u0002!IAa%\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c\"9!q\u0015\u0001\u0005\n\t%&!\u0006$jY\u0016\u001cFO]3b[N{WO]2f'VLG/\u001a\u0006\u0003K\u0019\n\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0004CA\u00193\u001b\u0005!\u0013BA\u001a%\u0005Q1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\rV3ti\u00061A(\u001b8jiz\"\u0012A\u000e\t\u0003c\u0001\t\u0001c\u001d;sK\u0006l\u0017N\\4US6,w.\u001e;\u0016\u0003e\u0002\"AO \u000e\u0003mR!\u0001P\u001f\u0002\tQLW.\u001a\u0006\u0003}1\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005\u0001[$\u0001B*qC:\f\u0011c\u001d;sK\u0006l\u0017N\\4US6,w.\u001e;!\u0003Y\u0019'/Z1uK\u001aKG.Z*ue\u0016\fWnU8ve\u000e,G\u0003\u0002#L5r\u0003\"!R%\u000e\u0003\u0019S!!J$\u000b\u0005!3\u0013!C3yK\u000e,H/[8o\u0013\tQeI\u0001\tGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK\")A\n\u0002a\u0001\u001b\u00061am\u001c:nCR\u0004\"AT,\u000f\u0005=+\u0006C\u0001)T\u001b\u0005\t&B\u0001*/\u0003\u0019a$o\\8u})\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t16\u000bC\u0003\\\t\u0001\u0007Q*\u0001\u0003qCRD\u0007bB/\u0005!\u0003\u0005\rAX\u0001\u0007g\u000eDW-\\1\u0011\u0007}\u0003'-D\u0001T\u0013\t\t7K\u0001\u0004PaRLwN\u001c\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u001a\nQ\u0001^=qKNL!a\u001a3\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0011de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2fI\u0011,g-Y;mi\u0012\u001aT#\u00016+\u0005y[7&\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018!C;oG\",7m[3e\u0015\t\t8+\u0001\u0006b]:|G/\u0019;j_:L!a\u001d8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0012de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f\u0003:$w)\u001a;TG\",W.\u0019\u000b\u0005EZD\u0018\u0010C\u0003M\r\u0001\u0007q\u000fE\u0002`A6CQa\u0017\u0004A\u0002]Dq!\u0018\u0004\u0011\u0002\u0003\u0007a,\u0001\u0017de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f\u0003:$w)\u001a;TG\",W.\u0019\u0013eK\u001a\fW\u000f\u001c;%g\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002{B\u0011qL`\u0005\u0003\u007fN\u0013A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG.A\nsK\u0006$Gj\\4Ge>l'+Z:pkJ\u001cW\r\u0006\u0003\u0002\b\u0005}\u0002CBA\u0005\u0003'\tIB\u0004\u0003\u0002\f\u0005=ab\u0001)\u0002\u000e%\tA+C\u0002\u0002\u0012M\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011C*\u0011\t\u0005m\u0011\u0011\b\b\u0005\u0003;\t)D\u0004\u0003\u0002 \u0005Mb\u0002BA\u0011\u0003cqA!a\t\u000209!\u0011QEA\u0017\u001d\u0011\t9#a\u000b\u000f\u0007A\u000bI#C\u0001.\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003\u0011\u001aJ!!J$\n\u0007\u0005]b)\u0001\tGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK&!\u00111HA\u001f\u0005%1\u0015\u000e\\3F]R\u0014\u0018PC\u0002\u00028\u0019Ca!!\u0011\u000b\u0001\u0004i\u0015a\u00013je\u00061\"/Z1e\u001f\u001a47/\u001a;Ge>l'+Z:pkJ\u001cW\r\u0006\u0003\u0002H\u00055\u0003cA#\u0002J%\u0019\u00111\n$\u0003!M+'/[1mSj,Gm\u00144gg\u0016$\bBBA(\u0017\u0001\u0007Q*\u0001\u0003gS2,\u0017!\b:v]R;xNQ1uG\",7/\u00118e-\u0016\u0014\u0018NZ=SKN,H\u000e^:\u0015\u001fu\f)&!\u001b\u0002t\u0005]\u00141PA@\u0003'Cq!a\u0016\r\u0001\u0004\tI&A\u0002te\u000e\u0004B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0002j_*\u0011\u00111M\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002h\u0005u#\u0001\u0002$jY\u0016Dq!a\u001b\r\u0001\u0004\ti'A\u0006mCR,7\u000f\u001e$jeN$\bcA0\u0002p%\u0019\u0011\u0011O*\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u000f\u0007A\u00025\u000b!BZ5sgR\u0014\u0015\r^2i\u0011\u0019\tI\b\u0004a\u0001\u001b\u0006Y1/Z2p]\u0012\u0014\u0015\r^2i\u0011!\ti\b\u0004I\u0001\u0002\u00049\u0018AC7bq\u001aKG.Z!hK\"I\u0011\u0011\u0011\u0007\u0011\u0002\u0003\u0007\u00111Q\u0001\fG2,\u0017M\\*pkJ\u001cW\r\u0005\u0003\u0002\u0006\u0006-ebA#\u0002\b&\u0019\u0011\u0011\u0012$\u0002\u001f\rcW-\u00198T_V\u00148-Z'pI\u0016LA!!$\u0002\u0010\n)a+\u00197vK&\u0019\u0011\u0011S*\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\t\u0003+c\u0001\u0013!a\u0001o\u0006Q\u0011M]2iSZ,G)\u001b:\u0002OI,h\u000eV<p\u0005\u0006$8\r[3t\u0003:$g+\u001a:jMf\u0014Vm];miN$C-\u001a4bk2$H%N\u000b\u0003\u00037S#a^6\u0002OI,h\u000eV<p\u0005\u0006$8\r[3t\u0003:$g+\u001a:jMf\u0014Vm];miN$C-\u001a4bk2$HEN\u000b\u0003\u0003CS3!a!l\u0003\u001d\u0012XO\u001c+x_\n\u000bGo\u00195fg\u0006sGMV3sS\u001aL(+Z:vYR\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0003\u001d\u0019\u000b7.\u001a$jY\u0016\u001c\u0016p\u001d;f[N\u0019\u0001#!+\u0011\t\u0005-\u0016QW\u0007\u0003\u0003[SA!a,\u00022\u0006\u0011am\u001d\u0006\u0004\u0003gS\u0013A\u00025bI>|\u0007/\u0003\u0003\u00028\u00065&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u000611o\u00195f[\u0016$B!!0\u0002BB\u0019\u0011q\u0018\t\u000e\u0003\u0001Aa!!/\u0013\u0001\u0004i\u0015AB3ySN$8\u000f\u0006\u0003\u0002n\u0005\u001d\u0007bBAe'\u0001\u0007\u00111Z\u0001\u0002MB!\u00111VAg\u0013\u0011\ty-!,\u0003\tA\u000bG\u000f[\u0001\u0007[.$\u0017N]:\u0015\r\u00055\u0014Q[Al\u0011\u001d\tI\r\u0006a\u0001\u0003\u0017Dq!!7\u0015\u0001\u0004\tY.\u0001\u0006qKJl\u0017n]:j_:\u0004B!!8\u0002b6\u0011\u0011q\u001c\u0006\u0005\u00033\fi+\u0003\u0003\u0002d\u0006}'\u0001\u0004$t!\u0016\u0014X.[:tS>t\u0017A\u0002:f]\u0006lW\r\u0006\u0004\u0002n\u0005%\u00181\u001e\u0005\b\u0003/*\u0002\u0019AAf\u0011\u001d\ti/\u0006a\u0001\u0003\u0017\f1\u0001Z:u\u0003\u00199W\r^+sSR\u0011\u00111\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A1\u0003\rqW\r^\u0005\u0005\u0003{\f9PA\u0002V%&\u000bAa\u001c9f]R1!1\u0001B\u0005\u0005\u0017\u0001B!a+\u0003\u0006%!!qAAW\u0005E15\u000bR1uC&s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u0013<\u0002\u0019AAf\u0011\u001d\u0011ia\u0006a\u0001\u0005\u001f\t!BY;gM\u0016\u00148+\u001b>f!\ry&\u0011C\u0005\u0004\u0005'\u0019&aA%oi\u000611M]3bi\u0016$\u0002C!\u0007\u0003 \t\u0005\"1\u0005B\u0014\u0005S\u0011\u0019D!\u0010\u0011\t\u0005-&1D\u0005\u0005\u0005;\tiK\u0001\nG'\u0012\u000bG/Y(viB,Ho\u0015;sK\u0006l\u0007bBAe1\u0001\u0007\u00111\u001a\u0005\b\u00033D\u0002\u0019AAn\u0011\u001d\u0011)\u0003\u0007a\u0001\u0003[\n\u0011b\u001c<fe^\u0014\u0018\u000e^3\t\u000f\t5\u0001\u00041\u0001\u0003\u0010!9!1\u0006\rA\u0002\t5\u0012a\u0003:fa2L7-\u0019;j_:\u00042a\u0018B\u0018\u0013\r\u0011\td\u0015\u0002\u0006'\"|'\u000f\u001e\u0005\b\u0005kA\u0002\u0019\u0001B\u001c\u0003%\u0011Gn\\2l'&TX\rE\u0002`\u0005sI1Aa\u000fT\u0005\u0011auN\\4\t\u000f\t}\u0002\u00041\u0001\u0003B\u0005A\u0001O]8he\u0016\u001c8\u000f\u0005\u0003\u0003D\t%SB\u0001B#\u0015\u0011\u00119%!-\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u0017\u0012)E\u0001\u0007Qe><'/Z:tC\ndW-\u0001\u0004baB,g\u000e\u001a\u000b\t\u00053\u0011\tFa\u0015\u0003V!9\u0011\u0011Z\rA\u0002\u0005-\u0007b\u0002B\u00073\u0001\u0007!q\u0002\u0005\b\u0005\u007fI\u0002\u0019\u0001B!\u0003\u0019!W\r\\3uKR1\u0011Q\u000eB.\u0005;Bq!!3\u001b\u0001\u0004\tY\rC\u0004\u0003`i\u0001\r!!\u001c\u0002\u0013I,7-\u001e:tSZ,\u0017A\u00037jgR\u001cF/\u0019;vgR!!Q\rB9!\u0015y&q\rB6\u0013\r\u0011Ig\u0015\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003W\u0013i'\u0003\u0003\u0003p\u00055&A\u0003$jY\u0016\u001cF/\u0019;vg\"9\u0011\u0011Z\u000eA\u0002\u0005-\u0017aE:fi^{'o[5oO\u0012K'/Z2u_JLHcA?\u0003x!9!\u0011\u0010\u000fA\u0002\u0005-\u0017a\u00028fo~#\u0017N]\u0001\u0014O\u0016$xk\u001c:lS:<G)\u001b:fGR|'/\u001f\u000b\u0003\u0003\u0017\fQbZ3u\r&dWm\u0015;biV\u001cH\u0003\u0002B6\u0005\u0007Cq!!3\u001f\u0001\u0004\tY-A\nbgN,'\u000f\u001e$jY\u0016L5OU3n_Z,G\rF\u0003~\u0005\u0013\u0013i\tC\u0004\u0003\f~\u0001\r!!\u0017\u0002\u0013M|WO]2f\t&\u0014\bB\u0002BH?\u0001\u0007Q*\u0001\u0005gS2,g*Y7f\u0003Y\t7o]3si\u001aKG.Z%t\u001d>$(+Z7pm\u0016$G#B?\u0003\u0016\n]\u0005b\u0002BFA\u0001\u0007\u0011\u0011\f\u0005\u0007\u0005\u001f\u0003\u0003\u0019A'\u0002)\u0005\u001c8/\u001a:u\r&dW-S:O_RluN^3e)\u001di(Q\u0014BP\u0005GCqAa#\"\u0001\u0004\tI\u0006C\u0004\u0003\"\u0006\u0002\r!!\u0017\u0002\u0017\u0015D\b/Z2uK\u0012$\u0015N\u001d\u0005\u0007\u0005K\u000b\u0003\u0019A'\u0002\u0015\u0019LG.\u001a)sK\u001aL\u00070A\tbgN,'\u000f\u001e$jY\u0016L5/T8wK\u0012$r! BV\u0005[\u0013y\u000bC\u0004\u0003\f\n\u0002\r!!\u0017\t\u000f\t\u0005&\u00051\u0001\u0002Z!1!Q\u0015\u0012A\u00025\u0003")
public class FileStreamSourceSuite
extends FileStreamSourceTest {
    private final Span streamingTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(80).seconds();

    @Override
    public Span streamingTimeout() {
        return this.streamingTimeout;
    }

    private FileStreamSource createFileStreamSource(String format, String path, Option<StructType> schema) {
        return this.getSourceFromFileStream(this.createFileStream(format, path, schema, this.createFileStream$default$4()));
    }

    private Option<StructType> createFileStreamSource$default$3() {
        return None$.MODULE$;
    }

    private StructType createFileStreamSourceAndGetSchema(Option<String> format, Option<String> path, Option<StructType> schema2) {
        DataStreamReader reader = this.spark().readStream();
        format.foreach((Function1 & Serializable & scala.Serializable)source -> reader.format(source));
        schema2.foreach((Function1 & Serializable & scala.Serializable)schema -> reader.schema(schema));
        Dataset df = path.isDefined() ? reader.load((String)path.get()) : reader.load();
        return (StructType)df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingRelation) {
                    StreamingRelation streamingRelation = (StreamingRelation)A1;
                    object = streamingRelation.schema();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof StreamingRelation;
                return bl;
            }
        }).head();
    }

    private Option<StructType> createFileStreamSourceAndGetSchema$default$3() {
        return None$.MODULE$;
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION(), (Object)"native");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().sessionState().conf().unsetConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
        }
        finally {
            StreamTest.afterAll$(this);
        }
    }

    private Seq<FileStreamSource.FileEntry> readLogFromResource(String dir) {
        URL input = this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(dir).toString());
        FileStreamSourceLog log = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return Predef$.MODULE$.wrapRefArray(log.allFiles());
    }

    private SerializedOffset readOffsetFromResource(String file) {
        String str = Source$.MODULE$.fromFile(this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(file).toString()).toURI(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return new SerializedOffset(str.trim());
    }

    private void runTwoBatchesAndVerifyResults(File src, boolean latestFirst, String firstBatch, String secondBatch, Option<String> maxFileAge, Enumeration.Value cleanSource, Option<String> archiveDir) {
        Map srcOptions = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)latestFirst)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maxFileAge.map((Function1 & Serializable & scala.Serializable)x$30 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), x$30)))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanSource.toString())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(archiveDir.map((Function1 & Serializable & scala.Serializable)x$31 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), x$31))));
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = srcOptions;
        Option<StructType> x$4 = this.createFileStream$default$3();
        Dataset<Row> fileStream = this.createFileStream(x$1, x$2, x$4, (Map<String, String>)x$3);
        StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
        this.testStream(fileStream, this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, Trigger.ProcessingTime((long)10L), (Clock)clock, this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$3(this, clock, x$32)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{firstBatch}), this.testImplicits().newStringEncoder()), new StreamTest.AdvanceManualClock(this, 10L), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$5(this, clock, x$33)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{secondBatch}), this.testImplicits().newStringEncoder())}));
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$5() {
        return None$.MODULE$;
    }

    private Enumeration.Value runTwoBatchesAndVerifyResults$default$6() {
        return CleanSourceMode$.MODULE$.OFF();
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$7() {
        return None$.MODULE$;
    }

    private void assertFileIsRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)x$42.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$42: String) => x$42.startsWith(fileName)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1915));
    }

    private void assertFileIsNotRemoved(File sourceDir, String fileName) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToBoolean((boolean)x$43.startsWith(fileName))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$43: String) => x$43.startsWith(fileName)))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1919));
    }

    private void assertFileIsNotMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1923));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToBoolean((boolean)x$44.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$44: String) => x$44.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1924));
        if (expectedDir.exists()) {
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list())).exists((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToBoolean((boolean)x$45.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$45: String) => x$45.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1928));
        }
    }

    private void assertFileIsMoved(File sourceDir, File expectedDir, String filePrefix) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sourceDir.exists(), "sourceDir.exists()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1933));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceDir.list())).exists((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToBoolean((boolean)x$46.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](sourceDir.list()).exists(((x$46: String) => x$46.startsWith(filePrefix)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1934));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(expectedDir.exists(), "expectedDir.exists()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1935));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedDir.list())).exists((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToBoolean((boolean)x$47.startsWith(filePrefix))), "scala.Predef.refArrayOps[String](expectedDir.list()).exists(((x$47: String) => x$47.startsWith(filePrefix)))", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1936));
    }

    private final void testError$1() {
        IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "path";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
    }

    public static final /* synthetic */ void $anonfun$new$12(FileStreamSourceSuite $this, File src) {
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
    }

    public static final /* synthetic */ void $anonfun$new$14(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
    }

    public static final /* synthetic */ void $anonfun$new$16(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
    }

    public static final /* synthetic */ void $anonfun$new$18(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).orc(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().orc(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
    }

    public static final /* synthetic */ void $anonfun$new$25(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).parquet(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().parquet(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
    }

    public static final /* synthetic */ void $anonfun$new$36(FileStreamSourceSuite $this, File src) {
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c': '3'}");
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("c", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c', '3'}");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
    }

    public static final /* synthetic */ void $anonfun$new$43(FileStreamSourceSuite $this, File x0$1, File x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$45(FileStreamSourceSuite $this, File x0$2, File x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, "text text"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$48(FileStreamSourceSuite $this, String testTableName$1, File x0$3, File x1$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File checkpoint = (File)tuple2._2();
            File output = new File(src, "text text");
            MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            Dataset ds = inputData.toDS();
            StreamingQuery query = ds.writeStream().option("checkpointLocation", checkpoint.getCanonicalPath()).format("text").start(output.getCanonicalPath());
            try {
                inputData.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}));
                $this.failAfter($this.streamingTimeout(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.processAllAvailable(), $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497), Timed$.MODULE$.timed());
            }
            finally {
                query.stop();
            }
            Dataset df2 = $this.spark().readStream().format("text").load(output.getCanonicalPath());
            StreamingQuery query2 = df2.writeStream().format("memory").queryName(testTableName$1).start();
            try {
                query2.processAllAvailable();
                $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$1).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                query2.stop();
            }
        }
        throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$53(FileStreamSourceSuite $this, String testTableName$2, File output) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), $this.testImplicits().newStringEncoder()).toDS().write().text(output.getCanonicalPath());
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar"})), $this.testImplicits().newStringEncoder()).toDS().write().mode("append").orc(output.getCanonicalPath());
        Dataset df = $this.spark().readStream().option("pathGlobFilter", "*.txt").format("text").load(output.getCanonicalPath());
        StreamingQuery query = df.writeStream().format("memory").queryName(testTableName$2).start();
        try {
            query.processAllAvailable();
            $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$2).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
        }
        finally {
            query.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$56(FileStreamSourceSuite $this, File x0$4, File x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset textStream = $this.spark().readStream().textFile(src.getCanonicalPath());
        Dataset filtered = textStream.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("keep")));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$60(StreamExecution x$4) {
        Thread.sleep(1000L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$61(FileStreamSourceSuite $this, StreamExecution streamExecution) {
        FileStreamSource source = (FileStreamSource)$this.getSourcesFromStreamingQuery(streamExecution).head();
        FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = source.seenFiles();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$59(FileStreamSourceSuite $this, File x0$5, File x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), (Object)"5ms")}));
        Option<StructType> x$42 = $this.createFileStream$default$3();
        Dataset<Row> textStream = $this.createFileStream(x$1, x$2, x$42, (Map<String, String>)x$3);
        $this.testStream(textStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "a\nb", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$60(x$4)), $this.AssertOnQuery().apply$default$2()), new FileStreamSourceTest.AddTextFileData($this, "c\nd", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("seen files should contain only one entry", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)streamExecution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$61($this, streamExecution)))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$63(FileStreamSourceSuite $this, File x0$6, File x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}\n{'value': 'keep3'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop4'}\n{'value': 'keep5'}\n{'value': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop7'}\n{'value': 'keep8'}\n{'value': 'keep9'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$65(FileStreamSourceSuite $this, File x0$7, File x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$68(FileStreamSourceSuite $this, File x0$8, File x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)x1$8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File baseSrc = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File src = new File(baseSrc, "type=X");
            src.mkdirs();
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$71(FileStreamSourceSuite $this, File x0$9, File x1$9) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)x1$9);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'k': 'value0'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing2"), "{'k': 'value1', 'v': 'new'}");
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value2'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value3', 'v': 'new'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'v': 'value4'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$74(FileStreamSourceSuite $this, File x0$10, File x1$10) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)x1$10);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$76(FileStreamSourceSuite $this, File x0$11, File x1$11) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)x1$11);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator116$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator116$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator116$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator133$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator133$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator133$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$79(FileStreamSourceSuite $this, File x0$12, File x1$12) {
        Tuple2 tuple2 = new Tuple2((Object)x0$12, (Object)x1$12);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$81(FileStreamSourceSuite $this, File x0$13, File x1$13) {
        Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)x1$13);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator168$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator168$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator168$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator185$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator185$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator185$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$84(FileStreamSourceSuite $this, File x0$14, File x1$14) {
        Tuple2 tuple2 = new Tuple2((Object)x0$14, (Object)x1$14);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        File subDir = new File(dir, "subdir");
        File subSubDir = new File(subDir, "subsubdir");
        File subSubSubDir = new File(subSubDir, "subsubsubdir");
        Predef$.MODULE$.require(!subDir.exists());
        Predef$.MODULE$.require(!subSubDir.exists());
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep4", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep5", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep6", dir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep7", subSubSubDir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep8", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5", "keep8"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$86(FileStreamSourceSuite $this, File x0$15, File x1$15) {
        Tuple2 tuple2 = new Tuple2((Object)x0$15, (Object)x1$15);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        Object nullStr = null;
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator216$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator216$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator216$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator220$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator220$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator220$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator224$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator224$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator224$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator228$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator228$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr), new Tuple2((Object)"keep5", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator228$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$88(FileStreamSourceSuite $this, File x0$16, File x1$16) {
        Tuple2 tuple2 = new Tuple2((Object)x0$16, (Object)x1$16);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator232$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator232$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator232$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator236$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator236$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator236$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator240$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator240$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator240$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator244$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$92(MemoryStream q1Source$1, Seq data$1, StreamingQuery q1$1, StreamExecution x$5) {
        q1Source$1.addData((TraversableOnce)data$1);
        q1$1.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$1(Seq data, MemoryStream q1Source$1, StreamingQuery q1$1) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            FileStreamSourceSuite.$anonfun$new$92(q1Source$1, data, q1$1, x$5);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$1() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$91(FileStreamSourceSuite $this, File x0$17, File x1$17) {
        Tuple2 tuple2 = new Tuple2((Object)x0$17, (Object)x1$17);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            File shouldNotKeep = new File(outputDir, "should_not_keep.txt");
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(shouldNotKeep, "should_not_keep!!!");
            return shouldNotKeep.exists();
        }, $this.Assert().apply$default$2()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(outputDir, new StringBuilder(10).append(FileStreamSink$.MODULE$.metadataDir()).append("/2.compact").toString()).exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$99(FileStreamSourceSuite $this, StreamExecution q2) {
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)None$.MODULE$, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$100(ObjectRef q1$2, DataStreamWriter q1Write$1, File outputDir$2, MemoryStream q1Source$2, StreamExecution x$7) {
        q1$2.elem = q1Write$1.start(outputDir$2.getCanonicalPath());
        q1Source$2.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}));
        ((StreamingQuery)q1$2.elem).processAllAvailable();
    }

    public static final /* synthetic */ boolean $anonfun$new$101(FileStreamSourceSuite $this, StreamExecution q2) {
        q2.processAllAvailable();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$102(ObjectRef q1$2, StreamExecution x$8) {
        ((StreamingQuery)q1$2.elem).stop();
    }

    public static final /* synthetic */ void $anonfun$new$98(FileStreamSourceSuite $this, File x0$18, File x1$18) {
        Tuple2 tuple2 = new Tuple2((Object)x0$18, (Object)x1$18);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        DataStreamWriter q1Write = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text");
        ObjectRef q1 = ObjectRef.create(null);
        Dataset q22 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q22, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$99($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> {
            FileStreamSourceSuite.$anonfun$new$100(q1, q1Write, outputDir, q1Source, x$7);
            return BoxedUnit.UNIT;
        }), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$101($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$8 -> {
            FileStreamSourceSuite.$anonfun$new$102(q1, x$8);
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void createFile$1(String content, File src, File tmp) {
        File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
        File finalFile = new File(src, tempFile.getName());
        Predef$.MODULE$.require(!src.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(src).append(" exists, dir: ").append(src.isDirectory()).append(", file: ").append(src.isFile()).toString());
        Predef$.MODULE$.require(src.mkdirs(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Cannot create ").append(src).toString());
        Predef$.MODULE$.require(src.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(src).append(" is not a directory").toString());
        Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, content).renameTo(finalFile));
    }

    public static final /* synthetic */ void $anonfun$new$108(FileStreamSourceSuite $this, File x0$19, File x1$19) {
        Tuple2 tuple2 = new Tuple2((Object)x0$19, (Object)x1$19);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        FileStreamSourceSuite.createFile$1("{'value': 'drop0'}", partitionFooSubDir, tmp);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[10];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator266$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator266$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator266$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator270$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator270$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator270$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator274$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator274$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator274$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator278$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator278$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator278$1(null))));
        streamActionArray[8] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep6'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator282$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator282$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[9] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar"), new Tuple2((Object)"keep6", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator282$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$110(FileStreamSourceSuite $this, File x0$20, File x1$20) {
        Tuple2 tuple2 = new Tuple2((Object)x0$20, (Object)x1$20);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$2(int data, File x1$1, ObjectRef lastFileModTime$1) {
        void var3_3;
        File file = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(x1$1, new StringBuilder(4).append(data).append(".txt").toString()), ((Object)BoxesRunTime.boxToInteger((int)data)).toString());
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$new$114(int x$9) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
    }

    private final void checkLastBatchData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.latestBatchData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$9 -> FileStreamSourceSuite.$anonfun$new$114(BoxesRunTime.unboxToInt((Object)x$9)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    public static final /* synthetic */ String $anonfun$new$116(int x$10) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$10)).toString();
    }

    private final void checkAllData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.allData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$10 -> FileStreamSourceSuite.$anonfun$new$116(BoxesRunTime.unboxToInt((Object)x$10)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    private final void checkNumBatchesSinceLastCheck$1(int numBatches, LongRef lastBatchId$1, MemorySink memorySink$1) {
        Predef$.MODULE$.require(lastBatchId$1.elem >= 0L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(memorySink$1.latestBatchId().get());
        long $org_scalatest_assert_macro_right = lastBatchId$1.elem + (long)numBatches;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1113));
        lastBatchId$1.elem = BoxesRunTime.unboxToLong((Object)memorySink$1.latestBatchId().get());
    }

    public static final /* synthetic */ void $anonfun$new$112(FileStreamSourceSuite $this, File x0$21) {
        File file = x0$21;
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$2(1, file, lastFileModTime);
        FileStreamSourceSuite.createFile$2(2, file, lastFileModTime);
        FileStreamSourceSuite.createFile$2(3, file, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 2L).text(file.getCanonicalPath());
        StreamExecution q = ((StreamingQueryWrapper)df.writeStream().format("memory").queryName("file_data").start()).streamingQuery();
        q.processAllAvailable();
        MemorySink memorySink = (MemorySink)q.sink();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q).head();
        LongRef lastBatchId = LongRef.create((long)-1L);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3), memorySink);
        lastBatchId.elem = BoxesRunTime.unboxToLong((Object)memorySink.latestBatchId().get());
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(4, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(5, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(6, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$2(7, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(2, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7), memorySink);
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(8, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(9, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(10, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(11, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$2(12, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(3, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 12), memorySink);
        q.stop();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void testMaxFilePerTriggerValue$1(String value, File x1$2, String testTable$1) {
        Dataset df = this.spark().readStream().option("maxFilesPerTrigger", value).text(x1$2.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$1).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1154));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1163));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerTrigger", value, "positive integer"}))).foreach((Function1 & Serializable & scala.Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1165));
        });
    }

    public static final /* synthetic */ void $anonfun$new$121(FileStreamSourceSuite $this, String testTable$1, File x0$22) {
        File file = x0$22;
        $this.testMaxFilePerTriggerValue$1("not-a-integer", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("-1", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("0", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("10.1", file, testTable$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$3(int data, File src$12, ObjectRef lastFileModTime$2) {
        void var3_3;
        File file = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src$12, new StringBuilder(4).append(data).append(".txt").toString()), ((Object)BoxesRunTime.boxToInteger((int)data)).toString());
        Object object = ((Option)lastFileModTime$2.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$2.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$2.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    private static final StreamingQuery startQuery$1(Dataset df$4, String checkpoint$1, String targetDir$1) {
        return df$4.writeStream().format("parquet").trigger(Trigger.Once()).option("checkpointLocation", checkpoint$1).start(targetDir$1);
    }

    public static final /* synthetic */ boolean $anonfun$new$126(StreamingQueryProgress x$11) {
        return x$11.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$new$128(int x$12) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$12)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$new$129(StreamingQueryProgress x$13) {
        return x$13.numInputRows() != 0L;
    }

    public static final /* synthetic */ String $anonfun$new$131(int x$14) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$14)).toString();
    }

    public static final /* synthetic */ void $anonfun$new$125(FileStreamSourceSuite $this, File src, File target) {
        String checkpoint = new File(target, "chk").getCanonicalPath();
        String targetDir = new File(target, "data").getCanonicalPath();
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$3(1, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(2, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(3, src, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 1L).text(src.getCanonicalPath());
        StreamingQuery q = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1211));
            int $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])q.recentProgress())).count((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$126(x$11)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1212));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("SELECT * from parquet.`").append(targetDir).append("`").toString()), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$12 -> FileStreamSourceSuite.$anonfun$new$128(BoxesRunTime.unboxToInt((Object)x$12)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q.stop();
        }
        FileStreamSourceSuite.createFile$3(4, src, lastFileModTime);
        FileStreamSourceSuite.createFile$3(5, src, lastFileModTime);
        StreamingQuery q2 = FileStreamSourceSuite.startQuery$1(df, checkpoint, targetDir);
        try {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q2.awaitTermination(Span$.MODULE$.convertSpanToDuration($this.streamingTimeout()).toMillis()), "q2.awaitTermination(time.this.Span.convertSpanToDuration(FileStreamSourceSuite.this.streamingTimeout).toMillis)", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1224));
            int $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])q2.recentProgress())).count((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$129(x$13)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1225));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(24).append("SELECT * from parquet.`").append(targetDir).append("`").toString()), (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)x$14 -> FileStreamSourceSuite.$anonfun$new$131(BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newStringEncoder()).toDF());
        }
        finally {
            q2.stop();
        }
    }

    public static final /* synthetic */ void $anonfun$new$133(FileStreamSourceSuite $this, File x0$23, File x1$21) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$23, (Object)x1$21);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            src.mkdirs();
            Dataset df = $this.spark().readStream().format("text").load(src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$15 -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x$15), "-x"), $this.testImplicits().newStringEncoder());
            df.explain();
            StreamExecution q = ((StreamingQueryWrapper)df.writeStream().queryName("file_explain").format("memory").start()).streamingQuery();
            try {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right = q.explainInternal(false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1245));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right2 = q.explainInternal(true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1246));
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, "foo").renameTo(finalFile));
                q.processAllAvailable();
                String explainWithoutExtended = q.explainInternal(false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1256));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1257));
                String explainWithExtended = q.explainInternal(true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1262));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1263));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$new$137(int x$16) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$16)).toString();
    }

    public static final /* synthetic */ void $anonfun$new$136(FileStreamSourceSuite $this, int numFiles$1, File x0$24, File x1$22) {
        Tuple2 tuple2 = new Tuple2((Object)x0$24, (Object)x1$22);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File root = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File src = new File(root, "a=1");
        src.mkdirs();
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFiles$1).map((Function1 & Serializable & scala.Serializable)x$16 -> FileStreamSourceSuite.$anonfun$new$137(BoxesRunTime.unboxToInt((Object)x$16)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)i -> {
            File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
            File finalFile = new File(src, tempFile.getName());
            return org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(finalFile, i);
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])src.listFiles())).size()));
        int $org_scalatest_assert_macro_right = numFiles$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1291));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1(FileStreamSourceSuite $outer) {
            }
        }
        Dataset files = $this.spark().readStream().text(root.getCanonicalPath()).as($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator310$1(null))));
        Dataset df = files.filter("1 == 0").groupBy((Seq)Nil$.MODULE$).count();
        $this.testStream(df, OutputMode.Complete(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "0", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), $this.testImplicits().newIntEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean verify$1(StreamExecution execution, long batchId, int expectedBatches, int expectedCompactInterval, PrivateMethodTester.PrivateMethod _metadataLog$1) {
        BoxedUnit boxedUnit;
        FileStreamSource fileSource = (FileStreamSource)this.getSourcesFromStreamingQuery(execution).head();
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)this.anyRefToInvoker(fileSource).invokePrivate(_metadataLog$1.apply((Seq)Nil$.MODULE$));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, expectedCompactInterval)) {
            Path path = metadataLog.batchIdToPath(batchId);
            String $org_scalatest_assert_macro_left = path.getName();
            String $org_scalatest_assert_macro_right = CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path does not end with compact file suffix", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1324));
            Option entries = metadataLog.get(batchId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(entries.isDefined(), "entries.isDefined", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Entries not defined", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1329));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])entries.get()).length));
            int $org_scalatest_assert_macro_right2 = ((FileStreamSource.FileEntry[])metadataLog.allFiles()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"clean up check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$17._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length));
            int $org_scalatest_assert_macro_right3 = ((FileStreamSource.FileEntry[])entries.get()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Length check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metadataLog.allFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18.batchId()), (Ordering)Ordering.Long$.MODULE$));
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = (FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$19._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)x$20.batchId()), (Ordering)Ordering.Long$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch id mismatch", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1335));
        return this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$21 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$21._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expectedBatches), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$145(FileStreamSourceSuite $this, PrivateMethodTester.PrivateMethod _metadataLog$1, File x0$25, File x1$23) {
        Tuple2 tuple2 = new Tuple2((Object)x0$25, (Object)x1$23);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            Map updateConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[18];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[2] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$22, 0L, 1, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[3] = new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[4] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder());
            streamActionArray[5] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$23, 1L, 2, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder());
            streamActionArray[8] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$24, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[9] = $this.StopStream();
            Map x$5 = updateConf;
            Trigger x$6 = $this.StartStream().apply$default$1();
            Clock x$7 = $this.StartStream().apply$default$2();
            String x$8 = $this.StartStream().apply$default$4();
            streamActionArray[10] = new StreamTest.StartStream($this, x$6, x$7, (Map<String, String>)x$5, x$8);
            streamActionArray[11] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$25, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[12] = new FileStreamSourceTest.AddTextFileData($this, "drop10\nkeep11", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[13] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11"}), $this.testImplicits().newStringEncoder());
            streamActionArray[14] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$26, 3L, 4, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[15] = new FileStreamSourceTest.AddTextFileData($this, "drop12\nkeep13", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[16] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11", "keep13"}), $this.testImplicits().newStringEncoder());
            streamActionArray[17] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$27, 4L, 5, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ FileStreamSourceOffset $anonfun$new$157(int x$28) {
        return new FileStreamSourceOffset((long)x$28);
    }

    private final void verify$2(Option startId, int endId, Seq expected, FileStreamSource fileSource$1) {
        Option start = startId.map((Function1 & Serializable & scala.Serializable)x$28 -> FileStreamSourceSuite.$anonfun$new$157(BoxesRunTime.unboxToInt((Object)x$28)));
        FileStreamSourceOffset end = new FileStreamSourceOffset((long)endId);
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.UNSUPPORTED_OPERATION_CHECK_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSource$1.getBatch(start, (Offset)end).as(this.testImplicits().newStringEncoder()).collect())).toSeq());
            Seq $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1400));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$156(FileStreamSourceSuite $this, StreamExecution execution) {
        PrivateMethodTester.PrivateMethod _sources = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(execution).head();
        $this.verify$2((Option)None$.MODULE$, 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), fileSource);
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$154(FileStreamSourceSuite $this, File x0$26, File x1$24) {
        Tuple2 tuple2 = new Tuple2((Object)x0$26, (Object)x1$24);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("check getBatch", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)execution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$156($this, execution)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$162(StreamingQueryProgress x$29) {
        return x$29.numInputRows() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$161(FileStreamSourceSuite $this, StreamExecution query) {
        StreamingQueryProgress actualProgress = (StreamingQueryProgress)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).find((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$162(x$29))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Could not find records with data."));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actualProgress.numInputRows()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1425));
        double $org_scalatest_assert_macro_left2 = actualProgress.sources()[0].processedRowsPerSecond();
        double $org_scalatest_assert_macro_right2 = 0.0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1426));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$160(FileStreamSourceSuite $this, File x0$27, File x1$25) {
        Tuple2 tuple2 = new Tuple2((Object)x0$27, (Object)x1$25);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset input = $this.spark().readStream().format("text").load(src.getCanonicalPath());
        $this.testStream(input, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "100", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)query -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$161($this, query)), $this.AssertOnQuery().apply$default$2())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$3(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$32) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1492));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1491));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$5(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$33) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(10L), "clock.isStreamWaitingAt(10L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1501));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1500));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$169(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 1000L);
        $this.runTwoBatchesAndVerifyResults(src, false, "1", "2", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", $this.runTwoBatchesAndVerifyResults$default$5(), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
    }

    public static final /* synthetic */ void $anonfun$new$171(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", (Option<String>)new Some((Object)"1m"), $this.runTwoBatchesAndVerifyResults$default$6(), $this.runTwoBatchesAndVerifyResults$default$7());
    }

    public static final /* synthetic */ void $anonfun$new$176(FileStreamSourceSuite $this, File temp) {
        $this.spark().conf().set(new StringBuilder(8).append("fs.").append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(".impl").toString(), ExistsThrowsExceptionFileSystem.class.getName());
        File dir = new File(temp, "dir");
        FileStreamSourceLog metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), dir.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadataLog.add(0L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file1").toString(), 100L, 0L)})), "metadataLog.add(0L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file1\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 100L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1613));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadataLog.add(1L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file2").toString(), 200L, 0L)})), "metadataLog.add(1L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file2\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 200L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614));
        FileStreamSource newSource = new FileStreamSource($this.spark(), new StringBuilder(4).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///").toString(), "parquet", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, dir.getAbsolutePath(), Predef$.MODULE$.Map().empty());
        newSource.getBatch((Option)None$.MODULE$, (Offset)new FileStreamSourceOffset(1L));
    }

    public static final /* synthetic */ boolean $anonfun$new$179(FileStreamSourceTest.AddTextFileData x$34) {
        return x$34.content() != null;
    }

    private final StreamTest.StreamAction addMultiTextFileData$1(String source1Content, String source2Content, File sourceDir1$1, File tmp$9, File sourceDir2$1) {
        Seq actions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStreamSourceTest.AddTextFileData[]{new FileStreamSourceTest.AddTextFileData(this, source1Content, sourceDir1$1, tmp$9, this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData(this, source2Content, sourceDir2$1, tmp$9, this.AddTextFileData().apply$default$4())}))).filter((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$179(x$34)));
        return new StreamTest.StreamProgressLockedActions(this, (Seq<StreamTest.StreamAction>)actions, actions.mkString("[ ", " | ", " ]"));
    }

    public static final /* synthetic */ void $anonfun$new$178(FileStreamSourceSuite $this, File x0$28, File x1$26) {
        Tuple2 tuple2 = new Tuple2((Object)x0$28, (Object)x1$26);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File sourceDir1 = new File(dir, "source1");
        File sourceDir2 = new File(dir, "source2");
        sourceDir1.mkdirs();
        sourceDir2.mkdirs();
        Dataset<Row> source1 = $this.createFileStream("text", String.valueOf(sourceDir1.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset<Row> source2 = $this.createFileStream("text", String.valueOf(sourceDir2.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset unioned = source1.union(source2);
        $this.testStream(unioned, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_0", "source2_0", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_0", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_0"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_1", null, sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_1", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1(null, "source2_2", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source2_2", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_3", "source2_3", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_3", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_3"}), $this.testImplicits().newStringEncoder()), $this.StopStream()}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$181(FileStreamSourceSuite $this, File temp) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("foo", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
        StructType nullableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("foo", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(nullableSchema);
        StructType $org_scalatest_assert_macro_right = streamingSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1676));
        StructType batchSchema = $this.spark().read().schema(schema).json(temp.getCanonicalPath()).schema();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(batchSchema);
        StructType $org_scalatest_assert_macro_right2 = streamingSchema;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1680));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_SCHEMA_FORCE_NULLABLE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType streamingSchema = $this.spark().readStream().schema(schema).json(temp.getCanonicalPath()).schema();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = streamingSchema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1685));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$186(FileStreamSourceSuite $this, File src$16, StreamExecution x$35) {
        $this.assertFileIsNotRemoved(src$16, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$187(FileStreamSourceSuite $this, File src$16, StreamExecution x$36) {
        $this.assertFileIsRemoved(src$16, "keep1");
        $this.assertFileIsNotRemoved(src$16, "ke ep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$188(FileStreamSourceSuite $this, File src$16, StreamExecution x$37) {
        $this.assertFileIsRemoved(src$16, "ke ep2 %");
        $this.assertFileIsNotRemoved(src$16, "keep3");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$184(FileStreamSourceSuite $this, File x0$29, File x1$27) {
        Tuple2 tuple2 = new Tuple2((Object)x0$29, (Object)x1$27);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"delete")}));
            String x$9 = "text";
            String x$10 = src.getCanonicalPath();
            Map x$11 = option;
            Option<StructType> x$12 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$9, x$10, x$12, (Map<String, String>)x$11);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$186($this, src, x$35))), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, "ke ep2 %"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file removed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$187($this, src, x$36))), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, "keep3"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file renamed", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$188($this, src, x$37)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$192(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, StreamExecution x$38) {
        $this.assertFileIsNotMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$193(FileStreamSourceSuite $this, File dirForKeep1$1, File expectedMovedDir1$1, File dirForKeep2$1, File expectedMovedDir2$1, StreamExecution x$39) {
        $this.assertFileIsMoved(dirForKeep1$1, expectedMovedDir1$1, "keep1");
        $this.assertFileIsNotMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$194(FileStreamSourceSuite $this, File dirForKeep2$1, File expectedMovedDir2$1, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$40) {
        $this.assertFileIsMoved(dirForKeep2$1, expectedMovedDir2$1, "keep2 %");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$195(FileStreamSourceSuite $this, File dirForKeep3$1, File expectedMovedDir3$1, StreamExecution x$41) {
        $this.assertFileIsMoved(dirForKeep3$1, expectedMovedDir3$1, "keep3");
        $this.assertFileIsNotMoved(dirForKeep3$1, expectedMovedDir3$1, "keep4");
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$190(FileStreamSourceSuite $this, File x0$30, File x1$28, File x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)x0$30, (Object)x1$28, (Object)x2$1);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File tmp = (File)tuple3._2();
        File archiveDir = (File)tuple3._3();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)"archive"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
            String x$13 = "text";
            String x$14 = new StringBuilder(4).append(src.getCanonicalPath()).append("/*/*").toString();
            Map x$15 = option;
            Option<StructType> x$16 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$13, x$14, x$16, (Map<String, String>)x$15);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            File dirForKeep1 = new File(src, "k %1");
            File dirForKeep2 = new File(dirForKeep1, "k 2");
            File dirForKeep3 = new File(src, "k3");
            File expectedMovedDir1 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep1.toURI().getPath()).toString());
            File expectedMovedDir2 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep2.toURI().getPath()).toString());
            File expectedMovedDir3 = new File(new StringBuilder(0).append(archiveDir.getAbsolutePath()).append(dirForKeep3.toURI().getPath()).toString());
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", dirForKeep1, tmp, "keep1"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$192($this, dirForKeep1, expectedMovedDir1, x$38))), new FileStreamSourceTest.AddTextFileData($this, "keep2", dirForKeep2, tmp, "keep2 %"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$193($this, dirForKeep1, expectedMovedDir1, dirForKeep2, expectedMovedDir2, x$39))), new FileStreamSourceTest.AddTextFileData($this, "keep3", dirForKeep3, tmp, "keep3"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$194($this, dirForKeep2, expectedMovedDir2, dirForKeep3, expectedMovedDir3, x$40))), new FileStreamSourceTest.AddTextFileData($this, "keep4", dirForKeep3, tmp, "keep4"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("input file archived", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$195($this, dirForKeep3, expectedMovedDir3, x$41)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$200(Path path) {
        return path.getName().startsWith("keep1");
    }

    public static final /* synthetic */ void $anonfun$new$201(FileStreamSourceSuite $this, Throwable t) {
        String $org_scalatest_assert_macro_left = t.getMessage();
        String $org_scalatest_assert_macro_right = "Clean up source files is not supported";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1834));
    }

    public static final /* synthetic */ void $anonfun$new$198(FileStreamSourceSuite $this, String cleanOption$1, File x0$31, File x1$29, File x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)x0$31, (Object)x1$29, (Object)x2$2);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        File src = (File)tuple3._1();
        File tmp = (File)tuple3._2();
        File archiveDir = (File)tuple3._3();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_CLEANER_NUM_THREADS().key()), (Object)"0")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Map option = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cleanSource"), (Object)cleanOption$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sourceArchiveDir"), (Object)archiveDir.getAbsolutePath())}));
            String x$17 = "text";
            String x$18 = src.getCanonicalPath();
            Map x$19 = option;
            Option<StructType> x$20 = $this.createFileStream$default$3();
            Dataset<Row> fileStream = $this.createFileStream(x$17, x$18, x$20, (Map<String, String>)x$19);
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            FileStreamSinkLog sinkLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), $this.spark(), new File(src, FileStreamSink$.MODULE$.metadataDir()).getCanonicalPath());
            Configuration hadoopConf = SparkHadoopUtil$.MODULE$.newConfiguration($this.sparkConf());
            Path srcPath = new Path(src.getCanonicalPath());
            FileSystem fileSystem = srcPath.getFileSystem(hadoopConf);
            $this.testStream(filtered, $this.testStream$default$2(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, "keep1"), new FileStreamSourceTest.AddFilesToFileStreamSinkLog($this, fileSystem, srcPath, sinkLog, 0, (Function1<Path, Object>)(Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$200(path))), new StreamTest.ExpectFailure($this, (Function1<Throwable, BoxedUnit>)(Function1 & Serializable & scala.Serializable)t -> {
                FileStreamSourceSuite.$anonfun$new$201($this, t);
                return BoxedUnit.UNIT;
            }, false, ClassTag$.MODULE$.apply(UnsupportedOperationException.class))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void assertThrowIllegalArgumentException$1(Path sourcePatttern, Path baseArchivePath, FakeFileSystem fakeFileSystem$1) {
        this.intercept((Function0 & Serializable & scala.Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem$1, sourcePatttern, (FileSystem)fakeFileSystem$1, baseArchivePath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1880));
    }

    public FileStreamSourceSuite() {
        this.test("FileStreamSource schema: no path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
        this.test("FileStreamSource schema: path doesn't exist (without schema) should throw exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)None$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("FileStreamSource schema: path doesn't exist (with schema) should throw exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)new Some((Object)userSchema));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
        this.test("FileStreamSource schema: text, no existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$12(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        this.test("FileStreamSource schema: text, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$14(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("FileStreamSource schema: text, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$16(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("FileStreamSource schema: orc, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$18(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("FileStreamSource schema: orc, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$23(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("FileStreamSource schema: parquet, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$25(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
        this.test("FileStreamSource schema: parquet, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$30(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("FileStreamSource schema: json, no existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("Unable to infer schema for JSON. It must be specified manually.;");
                String $org_scalatest_assert_macro_right = e.getMessage();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("FileStreamSource schema: json, existing files, no schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$36(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.test("FileStreamSource schema: json, existing files, schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$41(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
        this.test("read from text files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            FileStreamSourceSuite.$anonfun$new$43(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
        this.test("SPARK-21996 read from text files -- file name has space", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            FileStreamSourceSuite.$anonfun$new$45(this, x0$2, x1$2);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 470));
        this.test("SPARK-21996 read from text files generated by file sink -- file name has space", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                FileStreamSourceSuite.$anonfun$new$48(this, testTableName, x0$3, x1$3);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        this.test("Option pathGlobFilter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
                FileStreamSourceSuite.$anonfun$new$53(this, testTableName, output);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        this.test("read from textfile", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
            FileStreamSourceSuite.$anonfun$new$56(this, x0$4, x1$4);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
        this.test("SPARK-17165 should not track the list of seen files indefinitely", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
            FileStreamSourceSuite.$anonfun$new$59(this, x0$5, x1$5);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553));
        this.test("read from json files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
            FileStreamSourceSuite.$anonfun$new$63(this, x0$6, x1$6);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 589));
        this.test("read from json files with inferring schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$7, x1$7) -> {
            FileStreamSourceSuite.$anonfun$new$65(this, x0$7, x1$7);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
        this.test("reading from json files inside partitioned directory", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$8, x1$8) -> {
            FileStreamSourceSuite.$anonfun$new$68(this, x0$8, x1$8);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
        this.test("reading from json files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$9, x1$9) -> {
            FileStreamSourceSuite.$anonfun$new$71(this, x0$9, x1$9);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        this.test("read from orc files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$10, x1$10) -> {
            FileStreamSourceSuite.$anonfun$new$74(this, x0$10, x1$10);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        this.test("read from orc files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$11, x1$11) -> {
            FileStreamSourceSuite.$anonfun$new$76(this, x0$11, x1$11);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        this.test("read from parquet files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$12, x1$12) -> {
            FileStreamSourceSuite.$anonfun$new$79(this, x0$12, x1$12);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.test("read from parquet files with changing schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$13, x1$13) -> {
            FileStreamSourceSuite.$anonfun$new$81(this, x0$13, x1$13);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765));
        this.test("read new files in nested directories with globbing", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$14, x1$14) -> {
            FileStreamSourceSuite.$anonfun$new$84(this, x0$14, x1$14);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
        this.test("read new files in partitioned table with globbing, should not read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$15, x1$15) -> {
            FileStreamSourceSuite.$anonfun$new$86(this, x0$15, x1$15);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        this.test("read new files in partitioned table without globbing, should read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$16, x1$16) -> {
            FileStreamSourceSuite.$anonfun$new$88(this, x0$16, x1$16);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876));
        this.test("read data from outputs of another streaming query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$17, x1$17) -> {
            FileStreamSourceSuite.$anonfun$new$91(this, x0$17, x1$17);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
        this.test("start before another streaming query, and read its output", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$18, x1$18) -> {
            FileStreamSourceSuite.$anonfun$new$98(this, x0$18, x1$18);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
        this.test("when schema inference is turned on, should read partition data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$19, x1$19) -> {
            FileStreamSourceSuite.$anonfun$new$108(this, x0$19, x1$19);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 999));
        this.test("fault tolerance", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$20, x1$20) -> {
            FileStreamSourceSuite.$anonfun$new$110(this, x0$20, x1$20);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1044));
        this.test("max files per trigger", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$21 -> {
            FileStreamSourceSuite.$anonfun$new$112(this, x0$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1062));
        this.testQuietly("max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTable = "maxFilesPerTrigger_test";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$22 -> {
                FileStreamSourceSuite.$anonfun$new$121(this, testTable, x0$22);
                return BoxedUnit.UNIT;
            }));
        });
        this.test("SPARK-30669: maxFilesPerTrigger - ignored when using Trigger.Once", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(src, target) -> {
            FileStreamSourceSuite.$anonfun$new$125(this, src, target);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1177));
        this.test("explain", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$23, x1$21) -> {
            FileStreamSourceSuite.$anonfun$new$133(this, x0$23, x1$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1233));
        this.test("SPARK-17372 - write file names to WAL as Array[String]", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numFiles = 10000;
            this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)(numFiles * 2)));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$24, x1$22) -> {
                FileStreamSourceSuite.$anonfun$new$136(this, numFiles, x0$24, x1$22);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1270));
        this.test("compact interval metadata log", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.PrivateMethod _sources = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
            PrivateMethodTester.PrivateMethod _metadataLog = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$25, x1$23) -> {
                FileStreamSourceSuite.$anonfun$new$145(this, _metadataLog, x0$25, x1$23);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
        this.test("get arbitrary batch from FileStreamSource", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$26, x1$24) -> {
            FileStreamSourceSuite.$anonfun$new$154(this, x0$26, x1$24);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
        this.test("input row metrics", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$27, x1$25) -> {
            FileStreamSourceSuite.$anonfun$new$160(this, x0$27, x1$25);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1415));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamOptions options = new FileStreamOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxfilespertrigger"), (Object)"1")})));
            Option $org_scalatest_assert_macro_left = options.maxFilesPerTrigger();
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1435));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1433));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset json format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-json.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1440));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1438));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset long format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-long.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1445));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1443));
        this.test("FileStreamSourceLog - read Spark 2.1.0 log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readLogFromResource("file-source-log-version-2.1.0"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry("/a/b/0", 1480730949000L, 0L), new FileStreamSource.FileEntry("/a/b/1", 1480730950000L, 1L), new FileStreamSource.FileEntry("/a/b/2", 1480730950000L, 2L), new FileStreamSource.FileEntry("/a/b/3", 1480730950000L, 3L), new FileStreamSource.FileEntry("/a/b/4", 1480730951000L, 4L)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1449));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1448));
        this.test("FileStreamSource - latestFirst", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$169(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1509));
        this.test("SPARK-19813: Ignore maxFileAge when maxFilesPerTrigger and latestFirst is used", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$171(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1524));
        this.test("SeenFilesMap", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 5L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1540));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left2 = map;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1542));
            map.add("b", 15L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left3 = map;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1546));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left4 = map;
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1548));
            map.add("c", 16L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left5 = map;
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1552));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left6 = map;
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1554));
            map.add("c", 25L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left7 = map;
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1558));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("c", 20L), "map.isNewFile(\"c\", 20L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1561));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1564));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("e", 20L), "map.isNewFile(\"e\", 20L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1567));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1536));
        this.test("SeenFilesMap with fileNameOnly = true", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, true);
            map.add("file:///a/b/c/d", 5L);
            map.add("file:///a/b/c/e", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1575));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1577));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///d", 5L), "map.isNewFile(\"file:///d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1578));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/d", 5L), "map.isNewFile(\"file:///x/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1579));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/y/d", 5L), "map.isNewFile(\"file:///x/y/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1580));
            map.add("s3:///bucket/d", 5L);
            map.add("s3n:///bucket/d", 5L);
            map.add("s3a:///bucket/d", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1585));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1570));
        this.test("SeenFilesMap should only consider a file old if it is earlier than last purge time", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 20L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1592));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1595));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1596));
            map.purge();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1600));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1601));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1588));
        this.test("do not recheck that files exist during getBatch", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$176(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1604));
        this.test("SPARK-26629: multiple file sources work with restarts when a source does not have data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$28, x1$26) -> {
            FileStreamSourceSuite.$anonfun$new$178(this, x0$28, x1$26);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1623));
        this.test("SPARK-28651: force streaming file source to be nullable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$181(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1671));
        this.test("remove completed files when remove option is enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$29, x1$27) -> {
            FileStreamSourceSuite.$anonfun$new$184(this, x0$29, x1$27);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1690));
        this.test("move completed files to archive directory when archive option is enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$30, x1$28, x2$1) -> {
            FileStreamSourceSuite.$anonfun$new$190(this, x0$30, x1$28, x2$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1735));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete", "archive"}))).foreach((Function1 & Serializable & scala.Serializable)cleanOption -> {
            this.test(new StringBuilder(108).append("Throw UnsupportedOperationException on configuring ").append(cleanOption).append(" when source path").append(" refers the output dir of FileStreamSink").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withThreeTempDirs((Function3<File, File, File, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x0$31, x1$29, x2$2) -> {
                FileStreamSourceSuite.$anonfun$new$198($this, cleanOption, x0$31, x1$29, x2$2);
                return BoxedUnit.UNIT;
            }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1805));
            return BoxedUnit.UNIT;
        });
        this.test("SourceFileArchiver - fail when base archive path matches source pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            Path sourcePatternPath = new Path("/hello*/spar?");
            Path baseArchiveDirPath = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath, baseArchiveDirPath, fakeFileSystem);
            Path sourcePatternPath2 = new Path("/hello*/spar?/structured/streaming");
            Path baseArchiveDirPath2 = new Path("/hello/spark/structured");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath2, baseArchiveDirPath2, fakeFileSystem);
            Path sourcePatternPath3 = new Path("/hello*/spar?/structured/*");
            Path baseArchiveDirPath3 = new Path("/hello/spark/structured/streaming");
            this.assertThrowIllegalArgumentException$1(sourcePatternPath3, baseArchiveDirPath3, fakeFileSystem);
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1876));
        this.test("SourceFileArchiver - different filesystems between source and archive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            FakeFileSystem fakeFileSystem = new FakeFileSystem(this, "fake");
            FakeFileSystem fakeFileSystem2 = new FakeFileSystem(this, "fake2");
            Path sourcePatternPath = new Path("/hello*/h{e,f}ll?");
            Path baseArchiveDirPath = new Path("/hello");
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> new FileStreamSource.SourceFileArchiver((FileSystem)fakeFileSystem, sourcePatternPath, (FileSystem)fakeFileSystem2, baseArchiveDirPath), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1901));
    }

    public class FakeFileSystem
    extends FileSystem {
        private final String scheme;
        public final /* synthetic */ FileStreamSourceSuite $outer;

        public boolean exists(Path f) {
            return true;
        }

        public boolean mkdirs(Path f, FsPermission permission) {
            return true;
        }

        public boolean rename(Path src, Path dst) {
            return true;
        }

        public URI getUri() {
            return URI.create(new StringBuilder(4).append(this.scheme).append(":///").toString());
        }

        public FSDataInputStream open(Path f, int bufferSize) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
            throw new NotImplementedError();
        }

        public boolean delete(Path f, boolean recursive) {
            throw new NotImplementedError();
        }

        public FileStatus[] listStatus(Path f) {
            throw new NotImplementedError();
        }

        public void setWorkingDirectory(Path new_dir) {
            throw new NotImplementedError();
        }

        public Path getWorkingDirectory() {
            return new Path("/somewhere");
        }

        public FileStatus getFileStatus(Path f) {
            throw new NotImplementedError();
        }

        public /* synthetic */ FileStreamSourceSuite org$apache$spark$sql$streaming$FileStreamSourceSuite$FakeFileSystem$$$outer() {
            return this.$outer;
        }

        public FakeFileSystem(FileStreamSourceSuite $outer, String scheme) {
            this.scheme = scheme;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

