/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.CoGroupFunction;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.FlatMapGroupsFunction;
import org.apache.spark.api.java.function.FlatMapGroupsWithStateFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.api.java.function.MapGroupsWithStateFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.catalyst.encoders.OuterScopes;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.LongAccumulator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;

public class JavaDatasetSuite
implements Serializable {
    private transient TestSparkSession spark;
    private transient JavaSparkContext jsc;
    @Rule
    public transient ExpectedException nullabilityCheck = ExpectedException.none();

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
        this.jsc = new JavaSparkContext(this.spark.sparkContext());
        this.spark.loadTestData();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    private <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }

    @Test
    public void testCollect() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        List collected = ds.collectAsList();
        Assert.assertEquals(Arrays.asList("hello", "world"), (Object)collected);
    }

    @Test
    public void testTake() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        List collected = ds.takeAsList(1);
        Assert.assertEquals(Arrays.asList("hello"), (Object)collected);
    }

    @Test
    public void testToLocalIterator() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        Iterator iter = ds.toLocalIterator();
        Assert.assertEquals((Object)"hello", iter.next());
        Assert.assertEquals((Object)"world", iter.next());
        Assert.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void testTypedFilterPreservingSchema() {
        Dataset ds = this.spark.range(10L);
        Dataset ds2 = ds.filter((FilterFunction & Serializable)value -> value > 3L);
        Assert.assertEquals((Object)ds.schema(), (Object)ds2.schema());
    }

    @Test
    public void testCommonOperation() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        Assert.assertEquals((Object)"hello", (Object)ds.first());
        Dataset filtered = ds.filter((FilterFunction & Serializable)v -> v.startsWith("h"));
        Assert.assertEquals(Arrays.asList("hello"), (Object)filtered.collectAsList());
        Dataset mapped = ds.map(String::length, Encoders.INT());
        Assert.assertEquals(Arrays.asList(5, 5), (Object)mapped.collectAsList());
        Dataset parMapped = ds.mapPartitions((MapPartitionsFunction & Serializable)it -> {
            LinkedList<String> ls = new LinkedList<String>();
            while (it.hasNext()) {
                ls.add(((String)it.next()).toUpperCase(Locale.ROOT));
            }
            return ls.iterator();
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("HELLO", "WORLD"), (Object)parMapped.collectAsList());
        Dataset flatMapped = ds.flatMap((FlatMapFunction & Serializable)s -> {
            LinkedList<String> ls = new LinkedList<String>();
            for (char c : s.toCharArray()) {
                ls.add(String.valueOf(c));
            }
            return ls.iterator();
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("h", "e", "l", "l", "o", "w", "o", "r", "l", "d"), (Object)flatMapped.collectAsList());
    }

    @Test
    public void testForeach() {
        LongAccumulator accum = this.jsc.sc().longAccumulator();
        List<String> data = Arrays.asList("a", "b", "c");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        ds.foreach((ForeachFunction & Serializable)s -> accum.add(1L));
        Assert.assertEquals((long)3L, (long)accum.value().intValue());
    }

    @Test
    public void testReduce() {
        List<Integer> data = Arrays.asList(1, 2, 3);
        Dataset ds = this.spark.createDataset(data, Encoders.INT());
        int reduced = (Integer)ds.reduce((ReduceFunction & Serializable)(v1, v2) -> v1 + v2);
        Assert.assertEquals((long)6L, (long)reduced);
    }

    @Test
    public void testGroupBy() {
        List<String> data = Arrays.asList("a", "foo", "bar");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        KeyValueGroupedDataset grouped = ds.groupByKey(String::length, Encoders.INT());
        Dataset mapped = grouped.mapGroups((MapGroupsFunction & Serializable)(key, values) -> {
            StringBuilder sb = new StringBuilder(key.toString());
            while (values.hasNext()) {
                sb.append((String)values.next());
            }
            return sb.toString();
        }, Encoders.STRING());
        Assert.assertEquals(JavaDatasetSuite.asSet("1a", "3foobar"), JavaDatasetSuite.toSet(mapped.collectAsList()));
        Dataset flatMapped = grouped.flatMapGroups((FlatMapGroupsFunction & Serializable)(key, values) -> {
            StringBuilder sb = new StringBuilder(key.toString());
            while (values.hasNext()) {
                sb.append((String)values.next());
            }
            return Collections.singletonList(sb.toString()).iterator();
        }, Encoders.STRING());
        Assert.assertEquals(JavaDatasetSuite.asSet("1a", "3foobar"), JavaDatasetSuite.toSet(flatMapped.collectAsList()));
        Dataset mapped2 = grouped.mapGroupsWithState((MapGroupsWithStateFunction & Serializable)(key, values, s) -> {
            StringBuilder sb = new StringBuilder(key.toString());
            while (values.hasNext()) {
                sb.append((String)values.next());
            }
            return sb.toString();
        }, Encoders.LONG(), Encoders.STRING());
        Assert.assertEquals(JavaDatasetSuite.asSet("1a", "3foobar"), JavaDatasetSuite.toSet(mapped2.collectAsList()));
        Dataset flatMapped2 = grouped.flatMapGroupsWithState((FlatMapGroupsWithStateFunction & Serializable)(key, values, s) -> {
            StringBuilder sb = new StringBuilder(key.toString());
            while (values.hasNext()) {
                sb.append((String)values.next());
            }
            return Collections.singletonList(sb.toString()).iterator();
        }, OutputMode.Append(), Encoders.LONG(), Encoders.STRING(), GroupStateTimeout.NoTimeout());
        Assert.assertEquals(JavaDatasetSuite.asSet("1a", "3foobar"), JavaDatasetSuite.toSet(flatMapped2.collectAsList()));
        Dataset reduced = grouped.reduceGroups((ReduceFunction & Serializable)(v1, v2) -> v1 + v2);
        Assert.assertEquals(JavaDatasetSuite.asSet(this.tuple2(1, "a"), this.tuple2(3, "foobar")), JavaDatasetSuite.toSet(reduced.collectAsList()));
        List<Integer> data2 = Arrays.asList(2, 6, 10);
        Dataset ds2 = this.spark.createDataset(data2, Encoders.INT());
        KeyValueGroupedDataset grouped2 = ds2.groupByKey((MapFunction & Serializable)v -> v / 2, Encoders.INT());
        Dataset cogrouped = grouped.cogroup(grouped2, (CoGroupFunction & Serializable)(key, left, right) -> {
            StringBuilder sb = new StringBuilder(key.toString());
            while (left.hasNext()) {
                sb.append((String)left.next());
            }
            sb.append("#");
            while (right.hasNext()) {
                sb.append(right.next());
            }
            return Collections.singletonList(sb.toString()).iterator();
        }, Encoders.STRING());
        Assert.assertEquals(JavaDatasetSuite.asSet("1a#2", "3foobar#6", "5#10"), JavaDatasetSuite.toSet(cogrouped.collectAsList()));
    }

    @Test
    public void testSelect() {
        List<Integer> data = Arrays.asList(2, 6);
        Dataset ds = this.spark.createDataset(data, Encoders.INT());
        Dataset selected = ds.select(new Column[]{functions.expr((String)"value + 1"), functions.col((String)"value").cast("string")}).as(Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING()));
        Assert.assertEquals(Arrays.asList(this.tuple2(3, "2"), this.tuple2(7, "6")), (Object)selected.collectAsList());
    }

    @Test
    public void testSetOperation() {
        List<String> data = Arrays.asList("abc", "abc", "xyz");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        Assert.assertEquals(JavaDatasetSuite.asSet("abc", "xyz"), JavaDatasetSuite.toSet(ds.distinct().collectAsList()));
        List<String> data2 = Arrays.asList("xyz", "foo", "foo");
        Dataset ds2 = this.spark.createDataset(data2, Encoders.STRING());
        Dataset intersected = ds.intersect(ds2);
        Assert.assertEquals(Arrays.asList("xyz"), (Object)intersected.collectAsList());
        Dataset unioned = ds.union(ds2).union(ds);
        Assert.assertEquals(Arrays.asList("abc", "abc", "xyz", "xyz", "foo", "foo", "abc", "abc", "xyz"), (Object)unioned.collectAsList());
        Dataset subtracted = ds.except(ds2);
        Assert.assertEquals(Arrays.asList("abc"), (Object)subtracted.collectAsList());
    }

    private static <T> Set<T> toSet(List<T> records) {
        return new HashSet<T>(records);
    }

    @SafeVarargs
    private static <T> Set<T> asSet(T ... records) {
        return JavaDatasetSuite.toSet(Arrays.asList(records));
    }

    @Test
    public void testJoin() {
        List<Integer> data = Arrays.asList(1, 2, 3);
        Dataset ds = this.spark.createDataset(data, Encoders.INT()).as("a");
        List<Integer> data2 = Arrays.asList(2, 3, 4);
        Dataset ds2 = this.spark.createDataset(data2, Encoders.INT()).as("b");
        Dataset joined = ds.joinWith(ds2, functions.col((String)"a.value").equalTo((Object)functions.col((String)"b.value")));
        Assert.assertEquals(Arrays.asList(this.tuple2(2, 2), this.tuple2(3, 3)), (Object)joined.collectAsList());
    }

    @Test
    public void testTupleEncoder() {
        Encoder encoder2 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING());
        List<Tuple2> data2 = Arrays.asList(this.tuple2(1, "a"), this.tuple2(2, "b"));
        Dataset ds2 = this.spark.createDataset(data2, encoder2);
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        Encoder encoder3 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING());
        List<Tuple3> data3 = Arrays.asList(new Tuple3((Object)1, (Object)2L, (Object)"a"));
        Dataset ds3 = this.spark.createDataset(data3, encoder3);
        Assert.assertEquals(data3, (Object)ds3.collectAsList());
        Encoder encoder4 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING());
        List<Tuple4> data4 = Arrays.asList(new Tuple4((Object)1, (Object)"b", (Object)2L, (Object)"a"));
        Dataset ds4 = this.spark.createDataset(data4, encoder4);
        Assert.assertEquals(data4, (Object)ds4.collectAsList());
        Encoder encoder5 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING(), (Encoder)Encoders.BOOLEAN());
        List<Tuple5> data5 = Arrays.asList(new Tuple5((Object)1, (Object)"b", (Object)2L, (Object)"a", (Object)true));
        Dataset ds5 = this.spark.createDataset(data5, encoder5);
        Assert.assertEquals(data5, (Object)ds5.collectAsList());
    }

    @Test
    public void testTupleEncoderSchema() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING()));
        List<Tuple2> data = Arrays.asList(this.tuple2("1", this.tuple2("a", "b")), this.tuple2("2", this.tuple2("c", "d")));
        Dataset ds1 = this.spark.createDataset(data, encoder).toDF(new String[]{"value1", "value2"});
        JavaPairRDD pairRDD = this.jsc.parallelizePairs(data);
        Dataset ds2 = this.spark.createDataset(JavaPairRDD.toRDD((JavaPairRDD)pairRDD), encoder).toDF(new String[]{"value1", "value2"});
        Assert.assertEquals((Object)ds1.schema(), (Object)ds2.schema());
        Assert.assertEquals((Object)ds1.select(new Column[]{functions.expr((String)"value2._1")}).collectAsList(), (Object)ds2.select(new Column[]{functions.expr((String)"value2._1")}).collectAsList());
    }

    @Test
    public void testNestedTupleEncoder() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING()), (Encoder)Encoders.STRING());
        List<Tuple2> data = Arrays.asList(this.tuple2(this.tuple2(1, "a"), "a"), this.tuple2(this.tuple2(2, "b"), "b"));
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
        Encoder encoder2 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG()));
        List<Tuple2> data2 = Arrays.asList(this.tuple2(1, new Tuple3((Object)"a", (Object)"b", (Object)3L)));
        Dataset ds2 = this.spark.createDataset(data2, encoder2);
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        Encoder encoder3 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.tuple((Encoder)Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.LONG()), (Encoder)Encoders.STRING()));
        List<Tuple2> data3 = Arrays.asList(this.tuple2(1, this.tuple2(this.tuple2("a", 2L), "b")));
        Dataset ds3 = this.spark.createDataset(data3, encoder3);
        Assert.assertEquals(data3, (Object)ds3.collectAsList());
    }

    @Test
    public void testPrimitiveEncoder() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.DOUBLE(), (Encoder)Encoders.DECIMAL(), (Encoder)Encoders.DATE(), (Encoder)Encoders.TIMESTAMP(), (Encoder)Encoders.FLOAT());
        List<Tuple5> data = Arrays.asList(new Tuple5((Object)Double.MAX_VALUE, (Object)new BigDecimal("0.922337203685477589"), (Object)Date.valueOf("1970-01-01"), (Object)new Timestamp(System.currentTimeMillis()), (Object)Float.valueOf(Float.MAX_VALUE)));
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testLocalDateAndInstantEncoders() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.LOCALDATE(), (Encoder)Encoders.INSTANT());
        List<Tuple2> data = Arrays.asList(new Tuple2((Object)LocalDate.ofEpochDay(0L), (Object)Instant.ofEpochSecond(0L)));
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testKryoEncoder() {
        Encoder encoder = Encoders.kryo(KryoSerializable.class);
        List<KryoSerializable> data = Arrays.asList(new KryoSerializable("hello"), new KryoSerializable("world"));
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testJavaEncoder() {
        Encoder encoder = Encoders.javaSerialization(JavaSerializable.class);
        List<JavaSerializable> data = Arrays.asList(new JavaSerializable("hello"), new JavaSerializable("world"));
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testRandomSplit() {
        List<String> data = Arrays.asList("hello", "world", "from", "spark");
        Dataset ds = this.spark.createDataset(data, Encoders.STRING());
        double[] arraySplit = new double[]{1.0, 2.0, 3.0};
        List randomSplit = ds.randomSplitAsList(arraySplit, 1L);
        Assert.assertEquals((String)"wrong number of splits", (long)randomSplit.size(), (long)3L);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testJavaEncoderErrorMessageForPrivateClass() {
        Encoders.javaSerialization(PrivateClassTest.class);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testKryoEncoderErrorMessageForPrivateClass() {
        Encoders.kryo(PrivateClassTest.class);
    }

    @Test
    public void testJavaBeanEncoder() {
        OuterScopes.addOuterScope((Object)this);
        SimpleJavaBean obj1 = new SimpleJavaBean();
        obj1.setA(true);
        obj1.setB(3);
        obj1.setC(new byte[]{1, 2});
        obj1.setD(new String[]{"hello", null});
        obj1.setE(Arrays.asList("a", "b"));
        obj1.setF(Arrays.asList(100L, null, 200L));
        HashMap<Integer, String> map1 = new HashMap<Integer, String>();
        map1.put(1, "a");
        map1.put(2, "b");
        obj1.setG(map1);
        HashMap<String, String> nestedMap1 = new HashMap<String, String>();
        nestedMap1.put("x", "1");
        nestedMap1.put("y", "2");
        HashMap<List<Long>, Map<String, String>> complexMap1 = new HashMap<List<Long>, Map<String, String>>();
        complexMap1.put(Arrays.asList(1L, 2L), nestedMap1);
        obj1.setH(complexMap1);
        SimpleJavaBean obj2 = new SimpleJavaBean();
        obj2.setA(false);
        obj2.setB(30);
        obj2.setC(new byte[]{3, 4});
        obj2.setD(new String[]{null, "world"});
        obj2.setE(Arrays.asList("x", "y"));
        obj2.setF(Arrays.asList(300L, null, 400L));
        HashMap<Integer, String> map2 = new HashMap<Integer, String>();
        map2.put(3, "c");
        map2.put(4, "d");
        obj2.setG(map2);
        HashMap<String, String> nestedMap2 = new HashMap<String, String>();
        nestedMap2.put("q", "1");
        nestedMap2.put("w", "2");
        HashMap<List<Long>, Map<String, String>> complexMap2 = new HashMap<List<Long>, Map<String, String>>();
        complexMap2.put(Arrays.asList(3L, 4L), nestedMap2);
        obj2.setH(complexMap2);
        List<SimpleJavaBean> data = Arrays.asList(obj1, obj2);
        Dataset ds = this.spark.createDataset(data, Encoders.bean(SimpleJavaBean.class));
        Assert.assertEquals(data, (Object)ds.collectAsList());
        NestedJavaBean obj3 = new NestedJavaBean();
        obj3.setA(obj1);
        List<NestedJavaBean> data2 = Arrays.asList(obj3);
        Dataset ds2 = this.spark.createDataset(data2, Encoders.bean(NestedJavaBean.class));
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        GenericRow row1 = new GenericRow(new Object[]{true, 3, new byte[]{1, 2}, new String[]{"hello", null}, Arrays.asList("a", "b"), Arrays.asList(100L, null, 200L), map1, complexMap1});
        GenericRow row2 = new GenericRow(new Object[]{false, 30, new byte[]{3, 4}, new String[]{null, "world"}, Arrays.asList("x", "y"), Arrays.asList(300L, null, 400L), map2, complexMap2});
        StructType schema = new StructType().add("a", DataTypes.BooleanType, false).add("b", DataTypes.IntegerType, false).add("c", DataTypes.BinaryType).add("d", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType)).add("e", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType)).add("f", (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType)).add("g", (DataType)DataTypes.createMapType((DataType)DataTypes.IntegerType, (DataType)DataTypes.StringType)).add("h", (DataType)DataTypes.createMapType((DataType)DataTypes.createArrayType((DataType)DataTypes.LongType), (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType)));
        Dataset ds3 = this.spark.createDataFrame(Arrays.asList(row1, row2), schema).as(Encoders.bean(SimpleJavaBean.class));
        Assert.assertEquals(data, (Object)ds3.collectAsList());
    }

    @Test
    public void testJavaBeanEncoder2() {
        OuterScopes.addOuterScope((Object)this);
        SimpleJavaBean2 obj = new SimpleJavaBean2();
        obj.setA(new Timestamp(0L));
        obj.setB(new Date(0L));
        obj.setC(BigDecimal.valueOf(1L));
        Dataset ds = this.spark.createDataset(Arrays.asList(obj), Encoders.bean(SimpleJavaBean2.class));
        ds.collect();
    }

    @Test
    public void testRuntimeNullabilityCheck() {
        OuterScopes.addOuterScope((Object)this);
        StructType schema = new StructType().add("f", (DataType)new StructType().add("a", DataTypes.StringType, true).add("b", DataTypes.IntegerType, true), true);
        GenericRow row = new GenericRow(new Object[]{new GenericRow(new Object[]{"hello", 1})});
        Dataset df = this.spark.createDataFrame(Collections.singletonList(row), schema);
        Dataset ds = df.as(Encoders.bean(NestedSmallBean.class));
        SmallBean smallBean = new SmallBean();
        smallBean.setA("hello");
        smallBean.setB(1);
        NestedSmallBean nestedSmallBean = new NestedSmallBean();
        nestedSmallBean.setF(smallBean);
        Assert.assertEquals(Collections.singletonList(nestedSmallBean), (Object)ds.collectAsList());
        row = new GenericRow(new Object[]{null});
        df = this.spark.createDataFrame(Collections.singletonList(row), schema);
        ds = df.as(Encoders.bean(NestedSmallBean.class));
        NestedSmallBean nestedSmallBean2 = new NestedSmallBean();
        Assert.assertEquals(Collections.singletonList(nestedSmallBean2), (Object)ds.collectAsList());
        this.nullabilityCheck.expect(RuntimeException.class);
        this.nullabilityCheck.expectMessage("Null value appeared in non-nullable field");
        row = new GenericRow(new Object[]{new GenericRow(new Object[]{"hello", null})});
        df = this.spark.createDataFrame(Collections.singletonList(row), schema);
        ds = df.as(Encoders.bean(NestedSmallBean.class));
        ds.collect();
    }

    @Test
    public void test() {
        ArrayList<NestedComplicatedJavaBean> data = new ArrayList<NestedComplicatedJavaBean>();
        data.add(NestedComplicatedJavaBean.newBuilder().build());
        NestedComplicatedJavaBean obj3 = new NestedComplicatedJavaBean();
        Dataset ds = this.spark.createDataset(data, Encoders.bean(NestedComplicatedJavaBean.class));
        ds.collectAsList();
    }

    @Test
    public void testBeanWithEnum() {
        List<BeanWithEnum> data = Arrays.asList(new BeanWithEnum(MyEnum.A, "mira avenue"), new BeanWithEnum(MyEnum.B, "flower boulevard"));
        Encoder encoder = Encoders.bean(BeanWithEnum.class);
        Dataset ds = this.spark.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testEmptyBean() {
        EmptyBean bean = new EmptyBean();
        List<EmptyBean> data = Arrays.asList(bean);
        Dataset df = this.spark.createDataset(data, Encoders.bean(EmptyBean.class));
        Assert.assertEquals((long)0L, (long)df.schema().length());
        Assert.assertEquals((long)1L, (long)df.collectAsList().size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCircularReferenceBean1() {
        CircularReference1Bean bean = new CircularReference1Bean();
        this.spark.createDataset(Arrays.asList(bean), Encoders.bean(CircularReference1Bean.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCircularReferenceBean2() {
        CircularReference3Bean bean = new CircularReference3Bean();
        this.spark.createDataset(Arrays.asList(bean), Encoders.bean(CircularReference3Bean.class));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCircularReferenceBean3() {
        CircularReference4Bean bean = new CircularReference4Bean();
        this.spark.createDataset(Arrays.asList(bean), Encoders.bean(CircularReference4Bean.class));
    }

    @Test(expected=RuntimeException.class)
    public void testNullInTopLevelBean() {
        NestedSmallBean bean = new NestedSmallBean();
        this.spark.createDataset(Arrays.asList(bean, null), Encoders.bean(NestedSmallBean.class));
    }

    @Test
    public void testSerializeNull() {
        NestedSmallBean bean = new NestedSmallBean();
        Encoder encoder = Encoders.bean(NestedSmallBean.class);
        List<NestedSmallBean> beans = Arrays.asList(bean);
        Dataset ds1 = this.spark.createDataset(beans, encoder);
        Assert.assertEquals(beans, (Object)ds1.collectAsList());
        Dataset ds2 = ds1.map((MapFunction & Serializable)b -> b, encoder);
        Assert.assertEquals(beans, (Object)ds2.collectAsList());
    }

    @Test
    public void testSpecificLists() {
        SpecificListsBean bean = new SpecificListsBean();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        bean.setArrayList(arrayList);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        linkedList.add(1);
        bean.setLinkedList(linkedList);
        bean.setList(Collections.singletonList(1));
        List<SpecificListsBean> beans = Collections.singletonList(bean);
        Dataset dataset = this.spark.createDataset(beans, Encoders.bean(SpecificListsBean.class));
        Assert.assertEquals(beans, (Object)dataset.collectAsList());
    }

    public static class SpecificListsBean
    implements Serializable {
        private ArrayList<Integer> arrayList;
        private LinkedList<Integer> linkedList;
        private List<Integer> list;

        public ArrayList<Integer> getArrayList() {
            return this.arrayList;
        }

        public void setArrayList(ArrayList<Integer> arrayList) {
            this.arrayList = arrayList;
        }

        public LinkedList<Integer> getLinkedList() {
            return this.linkedList;
        }

        public void setLinkedList(LinkedList<Integer> linkedList) {
            this.linkedList = linkedList;
        }

        public List<Integer> getList() {
            return this.list;
        }

        public void setList(List<Integer> list) {
            this.list = list;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecificListsBean that = (SpecificListsBean)o;
            return Objects.equal(this.arrayList, that.arrayList) && Objects.equal(this.linkedList, that.linkedList) && Objects.equal(this.list, that.list);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.arrayList, this.linkedList, this.list});
        }
    }

    public class CircularReference5Bean
    implements Serializable {
        private String id;
        private List<CircularReference4Bean> child;

        public String getId() {
            return this.id;
        }

        public List<CircularReference4Bean> getChild() {
            return this.child;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setChild(List<CircularReference4Bean> child) {
            this.child = child;
        }
    }

    public class CircularReference4Bean
    implements Serializable {
        private Map<String, CircularReference5Bean> child;

        public Map<String, CircularReference5Bean> getChild() {
            return this.child;
        }

        public void setChild(Map<String, CircularReference5Bean> child) {
            this.child = child;
        }
    }

    public class CircularReference3Bean
    implements Serializable {
        private CircularReference3Bean[] child;

        public CircularReference3Bean[] getChild() {
            return this.child;
        }

        public void setChild(CircularReference3Bean[] child) {
            this.child = child;
        }
    }

    public class CircularReference2Bean
    implements Serializable {
        private CircularReference1Bean child;

        public CircularReference1Bean getChild() {
            return this.child;
        }

        public void setChild(CircularReference1Bean child) {
            this.child = child;
        }
    }

    public class CircularReference1Bean
    implements Serializable {
        private CircularReference2Bean child;

        public CircularReference2Bean getChild() {
            return this.child;
        }

        public void setChild(CircularReference2Bean child) {
            this.child = child;
        }
    }

    public static class EmptyBean
    implements Serializable {
    }

    public static class BeanWithEnum {
        MyEnum enumField;
        String regularField;

        public String getRegularField() {
            return this.regularField;
        }

        public void setRegularField(String regularField) {
            this.regularField = regularField;
        }

        public MyEnum getEnumField() {
            return this.enumField;
        }

        public void setEnumField(MyEnum field) {
            this.enumField = field;
        }

        public BeanWithEnum(MyEnum enumField, String regularField) {
            this.enumField = enumField;
            this.regularField = regularField;
        }

        public BeanWithEnum() {
        }

        public String toString() {
            return "BeanWithEnum(" + (Object)((Object)this.enumField) + ", " + this.regularField + ")";
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.enumField, this.regularField});
        }

        public boolean equals(Object other) {
            if (other instanceof BeanWithEnum) {
                BeanWithEnum beanWithEnum = (BeanWithEnum)other;
                return beanWithEnum.regularField.equals(this.regularField) && beanWithEnum.enumField.equals((Object)this.enumField);
            }
            return false;
        }
    }

    public static enum MyEnum {
        A("www.elgoog.com"),
        B("www.google.com");

        private String url;

        private MyEnum(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class NestedComplicatedJavaBean
    implements Serializable {
        private Nesting1 field1;
        private Nesting1 field2;
        private Nesting1 field3;
        private Nesting1 field4;
        private Nesting1 field5;
        private Nesting1 field6;
        private Nesting1 field7;
        private Nesting1 field8;
        private Nesting1 field9;
        private Nesting1 field10;

        public NestedComplicatedJavaBean() {
        }

        private NestedComplicatedJavaBean(Builder builder) {
            this.setField1(builder.field1);
            this.setField2(builder.field2);
            this.setField3(builder.field3);
            this.setField4(builder.field4);
            this.setField5(builder.field5);
            this.setField6(builder.field6);
            this.setField7(builder.field7);
            this.setField8(builder.field8);
            this.setField9(builder.field9);
            this.setField10(builder.field10);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Nesting1 getField1() {
            return this.field1;
        }

        public void setField1(Nesting1 field1) {
            this.field1 = field1;
        }

        public Nesting1 getField2() {
            return this.field2;
        }

        public void setField2(Nesting1 field2) {
            this.field2 = field2;
        }

        public Nesting1 getField3() {
            return this.field3;
        }

        public void setField3(Nesting1 field3) {
            this.field3 = field3;
        }

        public Nesting1 getField4() {
            return this.field4;
        }

        public void setField4(Nesting1 field4) {
            this.field4 = field4;
        }

        public Nesting1 getField5() {
            return this.field5;
        }

        public void setField5(Nesting1 field5) {
            this.field5 = field5;
        }

        public Nesting1 getField6() {
            return this.field6;
        }

        public void setField6(Nesting1 field6) {
            this.field6 = field6;
        }

        public Nesting1 getField7() {
            return this.field7;
        }

        public void setField7(Nesting1 field7) {
            this.field7 = field7;
        }

        public Nesting1 getField8() {
            return this.field8;
        }

        public void setField8(Nesting1 field8) {
            this.field8 = field8;
        }

        public Nesting1 getField9() {
            return this.field9;
        }

        public void setField9(Nesting1 field9) {
            this.field9 = field9;
        }

        public Nesting1 getField10() {
            return this.field10;
        }

        public void setField10(Nesting1 field10) {
            this.field10 = field10;
        }

        public static final class Builder {
            private Nesting1 field1 = Nesting1.newBuilder().build();
            private Nesting1 field2 = Nesting1.newBuilder().build();
            private Nesting1 field3 = Nesting1.newBuilder().build();
            private Nesting1 field4 = Nesting1.newBuilder().build();
            private Nesting1 field5 = Nesting1.newBuilder().build();
            private Nesting1 field6 = Nesting1.newBuilder().build();
            private Nesting1 field7 = Nesting1.newBuilder().build();
            private Nesting1 field8 = Nesting1.newBuilder().build();
            private Nesting1 field9 = Nesting1.newBuilder().build();
            private Nesting1 field10 = Nesting1.newBuilder().build();

            private Builder() {
            }

            public Builder field1(Nesting1 field1) {
                this.field1 = field1;
                return this;
            }

            public Builder field2(Nesting1 field2) {
                this.field2 = field2;
                return this;
            }

            public Builder field3(Nesting1 field3) {
                this.field3 = field3;
                return this;
            }

            public Builder field4(Nesting1 field4) {
                this.field4 = field4;
                return this;
            }

            public Builder field5(Nesting1 field5) {
                this.field5 = field5;
                return this;
            }

            public Builder field6(Nesting1 field6) {
                this.field6 = field6;
                return this;
            }

            public Builder field7(Nesting1 field7) {
                this.field7 = field7;
                return this;
            }

            public Builder field8(Nesting1 field8) {
                this.field8 = field8;
                return this;
            }

            public Builder field9(Nesting1 field9) {
                this.field9 = field9;
                return this;
            }

            public Builder field10(Nesting1 field10) {
                this.field10 = field10;
                return this;
            }

            public NestedComplicatedJavaBean build() {
                return new NestedComplicatedJavaBean(this);
            }
        }
    }

    public static class Nesting1
    implements Serializable {
        private Nesting2 field1_1;
        private Nesting2 field1_2;
        private Nesting2 field1_3;

        public Nesting1() {
        }

        public Nesting1(Nesting2 field1_1, Nesting2 field1_2, Nesting2 field1_3) {
            this.field1_1 = field1_1;
            this.field1_2 = field1_2;
            this.field1_3 = field1_3;
        }

        private Nesting1(Builder builder) {
            this.setField1_1(builder.field1_1);
            this.setField1_2(builder.field1_2);
            this.setField1_3(builder.field1_3);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Nesting2 getField1_1() {
            return this.field1_1;
        }

        public void setField1_1(Nesting2 field1_1) {
            this.field1_1 = field1_1;
        }

        public Nesting2 getField1_2() {
            return this.field1_2;
        }

        public void setField1_2(Nesting2 field1_2) {
            this.field1_2 = field1_2;
        }

        public Nesting2 getField1_3() {
            return this.field1_3;
        }

        public void setField1_3(Nesting2 field1_3) {
            this.field1_3 = field1_3;
        }

        public static final class Builder {
            private Nesting2 field1_1 = Nesting2.newBuilder().build();
            private Nesting2 field1_2 = Nesting2.newBuilder().build();
            private Nesting2 field1_3 = Nesting2.newBuilder().build();

            private Builder() {
            }

            public Builder field1_1(Nesting2 field1_1) {
                this.field1_1 = field1_1;
                return this;
            }

            public Builder field1_2(Nesting2 field1_2) {
                this.field1_2 = field1_2;
                return this;
            }

            public Builder field1_3(Nesting2 field1_3) {
                this.field1_3 = field1_3;
                return this;
            }

            public Nesting1 build() {
                return new Nesting1(this);
            }
        }
    }

    public static class Nesting2
    implements Serializable {
        private Nesting3 field2_1;
        private Nesting3 field2_2;
        private Nesting3 field2_3;

        public Nesting2() {
        }

        public Nesting2(Nesting3 field2_1, Nesting3 field2_2, Nesting3 field2_3) {
            this.field2_1 = field2_1;
            this.field2_2 = field2_2;
            this.field2_3 = field2_3;
        }

        private Nesting2(Builder builder) {
            this.setField2_1(builder.field2_1);
            this.setField2_2(builder.field2_2);
            this.setField2_3(builder.field2_3);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Nesting3 getField2_1() {
            return this.field2_1;
        }

        public void setField2_1(Nesting3 field2_1) {
            this.field2_1 = field2_1;
        }

        public Nesting3 getField2_2() {
            return this.field2_2;
        }

        public void setField2_2(Nesting3 field2_2) {
            this.field2_2 = field2_2;
        }

        public Nesting3 getField2_3() {
            return this.field2_3;
        }

        public void setField2_3(Nesting3 field2_3) {
            this.field2_3 = field2_3;
        }

        public static final class Builder {
            private Nesting3 field2_1 = Nesting3.newBuilder().build();
            private Nesting3 field2_2 = Nesting3.newBuilder().build();
            private Nesting3 field2_3 = Nesting3.newBuilder().build();

            private Builder() {
            }

            public Builder field2_1(Nesting3 field2_1) {
                this.field2_1 = field2_1;
                return this;
            }

            public Builder field2_2(Nesting3 field2_2) {
                this.field2_2 = field2_2;
                return this;
            }

            public Builder field2_3(Nesting3 field2_3) {
                this.field2_3 = field2_3;
                return this;
            }

            public Nesting2 build() {
                return new Nesting2(this);
            }
        }
    }

    public static class Nesting3
    implements Serializable {
        private Integer field3_1;
        private Double field3_2;
        private String field3_3;

        public Nesting3() {
        }

        public Nesting3(Integer field3_1, Double field3_2, String field3_3) {
            this.field3_1 = field3_1;
            this.field3_2 = field3_2;
            this.field3_3 = field3_3;
        }

        private Nesting3(Builder builder) {
            this.setField3_1(builder.field3_1);
            this.setField3_2(builder.field3_2);
            this.setField3_3(builder.field3_3);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Integer getField3_1() {
            return this.field3_1;
        }

        public void setField3_1(Integer field3_1) {
            this.field3_1 = field3_1;
        }

        public Double getField3_2() {
            return this.field3_2;
        }

        public void setField3_2(Double field3_2) {
            this.field3_2 = field3_2;
        }

        public String getField3_3() {
            return this.field3_3;
        }

        public void setField3_3(String field3_3) {
            this.field3_3 = field3_3;
        }

        public static final class Builder {
            private Integer field3_1 = 0;
            private Double field3_2 = 0.0;
            private String field3_3 = "value";

            private Builder() {
            }

            public Builder field3_1(Integer field3_1) {
                this.field3_1 = field3_1;
                return this;
            }

            public Builder field3_2(Double field3_2) {
                this.field3_2 = field3_2;
                return this;
            }

            public Builder field3_3(String field3_3) {
                this.field3_3 = field3_3;
                return this;
            }

            public Nesting3 build() {
                return new Nesting3(this);
            }
        }
    }

    public static class NestedSmallBean
    implements Serializable {
        private SmallBean f;

        public SmallBean getF() {
            return this.f;
        }

        public void setF(SmallBean f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedSmallBean that = (NestedSmallBean)o;
            return Objects.equal((Object)this.f, (Object)that.f);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.f});
        }
    }

    public static class SmallBean
    implements Serializable {
        private String a;
        private int b;

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SmallBean smallBean = (SmallBean)o;
            return this.b == smallBean.b && Objects.equal((Object)this.a, (Object)smallBean.a);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.a, this.b});
        }
    }

    public static class NestedJavaBean
    implements Serializable {
        private SimpleJavaBean a;

        public SimpleJavaBean getA() {
            return this.a;
        }

        public void setA(SimpleJavaBean a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedJavaBean that = (NestedJavaBean)o;
            return this.a.equals(that.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }
    }

    public static class SimpleJavaBean2
    implements Serializable {
        private Timestamp a;
        private Date b;
        private BigDecimal c;

        public Timestamp getA() {
            return this.a;
        }

        public void setA(Timestamp a) {
            this.a = a;
        }

        public Date getB() {
            return this.b;
        }

        public void setB(Date b) {
            this.b = b;
        }

        public BigDecimal getC() {
            return this.c;
        }

        public void setC(BigDecimal c) {
            this.c = c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleJavaBean2 that = (SimpleJavaBean2)o;
            if (!this.a.equals(that.a)) {
                return false;
            }
            if (!this.b.equals(that.b)) {
                return false;
            }
            return this.c.equals(that.c);
        }

        public int hashCode() {
            int result = this.a.hashCode();
            result = 31 * result + this.b.hashCode();
            result = 31 * result + this.c.hashCode();
            return result;
        }
    }

    public static class SimpleJavaBean
    implements Serializable {
        private boolean a;
        private int b;
        private byte[] c;
        private String[] d;
        private List<String> e;
        private List<Long> f;
        private Map<Integer, String> g;
        private Map<List<Long>, Map<String, String>> h;

        public boolean isA() {
            return this.a;
        }

        public void setA(boolean a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public byte[] getC() {
            return this.c;
        }

        public void setC(byte[] c) {
            this.c = c;
        }

        public String[] getD() {
            return this.d;
        }

        public void setD(String[] d) {
            this.d = d;
        }

        public List<String> getE() {
            return this.e;
        }

        public void setE(List<String> e) {
            this.e = e;
        }

        public List<Long> getF() {
            return this.f;
        }

        public void setF(List<Long> f) {
            this.f = f;
        }

        public Map<Integer, String> getG() {
            return this.g;
        }

        public void setG(Map<Integer, String> g) {
            this.g = g;
        }

        public Map<List<Long>, Map<String, String>> getH() {
            return this.h;
        }

        public void setH(Map<List<Long>, Map<String, String>> h) {
            this.h = h;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleJavaBean that = (SimpleJavaBean)o;
            if (this.a != that.a) {
                return false;
            }
            if (this.b != that.b) {
                return false;
            }
            if (!Arrays.equals(this.c, that.c)) {
                return false;
            }
            if (!Arrays.equals(this.d, that.d)) {
                return false;
            }
            if (!this.e.equals(that.e)) {
                return false;
            }
            if (!this.f.equals(that.f)) {
                return false;
            }
            if (!this.g.equals(that.g)) {
                return false;
            }
            return this.h.equals(that.h);
        }

        public int hashCode() {
            int result = this.a ? 1 : 0;
            result = 31 * result + this.b;
            result = 31 * result + Arrays.hashCode(this.c);
            result = 31 * result + Arrays.hashCode(this.d);
            result = 31 * result + this.e.hashCode();
            result = 31 * result + this.f.hashCode();
            result = 31 * result + this.g.hashCode();
            result = 31 * result + this.h.hashCode();
            return result;
        }
    }

    private static class PrivateClassTest {
        private PrivateClassTest() {
        }
    }

    public static class JavaSerializable
    implements Serializable {
        String value;

        JavaSerializable(String value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.value.equals(((JavaSerializable)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class KryoSerializable {
        String value;

        KryoSerializable(String value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.value.equals(((KryoSerializable)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

