/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF0;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaUDFSuite
implements Serializable {
    private transient SparkSession spark;

    @Before
    public void setUp() {
        this.spark = SparkSession.builder().master("local[*]").appName("testing").getOrCreate();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void udf1Test() {
        this.spark.udf().register("stringLengthTest", (UDF1 & Serializable)str -> str.length(), DataTypes.IntegerType);
        Row result = (Row)this.spark.sql("SELECT stringLengthTest('test')").head();
        Assert.assertEquals((long)4L, (long)result.getInt(0));
    }

    @Test
    public void udf2Test() {
        this.spark.udf().register("stringLengthTest", (UDF2 & Serializable)(str1, str2) -> str1.length() + str2.length(), DataTypes.IntegerType);
        Row result = (Row)this.spark.sql("SELECT stringLengthTest('test', 'test2')").head();
        Assert.assertEquals((long)9L, (long)result.getInt(0));
    }

    @Test
    public void udf3Test() {
        this.spark.udf().registerJava("stringLengthTest", StringLengthTest.class.getName(), DataTypes.IntegerType);
        Row result = (Row)this.spark.sql("SELECT stringLengthTest('test', 'test2')").head();
        Assert.assertEquals((long)9L, (long)result.getInt(0));
        this.spark.udf().registerJava("stringLengthTest2", StringLengthTest.class.getName(), null);
        result = (Row)this.spark.sql("SELECT stringLengthTest('test', 'test2')").head();
        Assert.assertEquals((long)9L, (long)result.getInt(0));
    }

    @Test
    public void udf4Test() {
        this.spark.udf().register("inc", (UDF1 & Serializable)i -> i + 1L, DataTypes.LongType);
        this.spark.range(10L).toDF(new String[]{"x"}).createOrReplaceTempView("tmp");
        List results = this.spark.sql("SELECT inc(x) FROM tmp GROUP BY inc(x)").collectAsList();
        Assert.assertEquals((long)10L, (long)results.size());
        long sum = 0L;
        for (Row result : results) {
            sum += result.getLong(0);
        }
        Assert.assertEquals((long)55L, (long)sum);
    }

    @Test(expected=AnalysisException.class)
    public void udf5Test() {
        this.spark.udf().register("inc", (UDF1 & Serializable)i -> i + 1L, DataTypes.LongType);
        List results = this.spark.sql("SELECT inc(1, 5)").collectAsList();
    }

    @Test
    public void udf6Test() {
        this.spark.udf().register("returnOne", (UDF0 & Serializable)() -> 1, DataTypes.IntegerType);
        Row result = (Row)this.spark.sql("SELECT returnOne()").head();
        Assert.assertEquals((long)1L, (long)result.getInt(0));
    }

    @Test
    public void udf7Test() {
        String originConf = this.spark.conf().get(SQLConf.DATETIME_JAVA8API_ENABLED().key());
        try {
            this.spark.conf().set(SQLConf.DATETIME_JAVA8API_ENABLED().key(), "true");
            this.spark.udf().register("plusDay", (UDF1 & Serializable)ld -> ld.plusDays(1L), DataTypes.DateType);
            Row result = (Row)this.spark.sql("SELECT plusDay(DATE '2019-02-26')").head();
            Assert.assertEquals((Object)LocalDate.parse("2019-02-27"), (Object)result.get(0));
        }
        finally {
            this.spark.conf().set(SQLConf.DATETIME_JAVA8API_ENABLED().key(), originConf);
        }
    }

    public static class StringLengthTest
    implements UDF2<String, String, Integer> {
        public Integer call(String str1, String str2) {
            return str1.length() + str2.length();
        }
    }
}

